/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.compile;

import java.io.StringReader;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.sql.compile.CompilerContext;
import org.apache.derby.iapi.sql.compile.Parser;
import org.apache.derby.iapi.sql.compile.Visitable;
import org.apache.derby.impl.sql.compile.CharStream;
import org.apache.derby.impl.sql.compile.ParseException;
import org.apache.derby.impl.sql.compile.SQLParser;
import org.apache.derby.impl.sql.compile.SQLParserTokenManager;
import org.apache.derby.impl.sql.compile.TokenMgrError;
import org.apache.derby.impl.sql.compile.UCode_CharStream;

public class ParserImpl
implements Parser {
    static final int LARGE_TOKEN_SIZE = 128;
    private SQLParser cachedParser;
    private Object cachedTokenManager;
    private CharStream charStream;
    protected String SQLtext;
    private final CompilerContext cc;

    public ParserImpl(CompilerContext compilerContext) {
        this.cc = compilerContext;
    }

    @Override
    public Visitable parseStatement(String string) throws StandardException {
        return this.parseStatement(string, null);
    }

    protected Object getTokenManager() {
        SQLParserTokenManager sQLParserTokenManager = (SQLParserTokenManager)this.cachedTokenManager;
        if (sQLParserTokenManager == null) {
            sQLParserTokenManager = new SQLParserTokenManager(this.charStream);
            this.cachedTokenManager = sQLParserTokenManager;
        } else {
            sQLParserTokenManager.ReInit(this.charStream);
        }
        return sQLParserTokenManager;
    }

    private SQLParser getParser() {
        SQLParserTokenManager sQLParserTokenManager = (SQLParserTokenManager)this.getTokenManager();
        SQLParser sQLParser = this.cachedParser;
        if (sQLParser == null) {
            sQLParser = new SQLParser(sQLParserTokenManager);
            sQLParser.setCompilerContext(this.cc);
            this.cachedParser = sQLParser;
        } else {
            sQLParser.ReInit(sQLParserTokenManager);
        }
        return sQLParser;
    }

    @Override
    public Visitable parseStatement(String string, Object[] objectArray) throws StandardException {
        return this.parseStatementOrSearchCondition(string, objectArray, true);
    }

    private Visitable parseStatementOrSearchCondition(String string, Object[] objectArray, boolean bl) throws StandardException {
        StringReader stringReader = new StringReader(string);
        if (this.charStream == null) {
            this.charStream = new UCode_CharStream(stringReader, 1, 1, 128);
        } else {
            this.charStream.ReInit(stringReader, 1, 1, 128);
        }
        this.SQLtext = string;
        try {
            SQLParser sQLParser = this.getParser();
            return bl ? sQLParser.Statement(string, objectArray) : sQLParser.SearchCondition(string);
        }
        catch (ParseException parseException) {
            throw StandardException.newException("42X01", parseException.getMessage());
        }
        catch (TokenMgrError tokenMgrError) {
            this.cachedParser = null;
            throw StandardException.newException("42X02", tokenMgrError.getMessage());
        }
    }

    @Override
    public Visitable parseSearchCondition(String string) throws StandardException {
        return this.parseStatementOrSearchCondition(string, null, false);
    }

    @Override
    public String getSQLtext() {
        return this.SQLtext;
    }
}

