/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.license.service;

import com.xebialabs.license.AmountOfCisExceededException;
import com.xebialabs.license.License;
import com.xebialabs.license.LicenseEditionException;
import com.xebialabs.license.LicensePeriodExpiredException;
import com.xebialabs.license.LicenseProperty;
import com.xebialabs.license.LicenseReader;
import com.xebialabs.license.LicenseRepositoryIdException;
import com.xebialabs.license.LicenseUtils;
import com.xebialabs.license.LicenseVersion3;
import com.xebialabs.license.LicenseVersionException;
import com.xebialabs.license.LicenseViolationException;
import com.xebialabs.license.UnregisteredLicenseExpiredException;
import com.xebialabs.license.service.LicenseInstallService;
import com.xebialabs.license.service.LicenseInstallationFailedException;
import com.xebialabs.license.service.LicenseService;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LicenseInstallServiceImpl
implements LicenseInstallService {
    private final File licenseFile;
    private final LicenseService licenseService;
    private static final Logger logger = LoggerFactory.getLogger(LicenseInstallServiceImpl.class);
    private static final String LICENSE_STATUS = "License status: ";
    private static final String LICENSE_OLD_VERSION = "Your license is of an old version.";
    private static final String LICENSE_EXPIRED = "Your license has expired.";
    private static final String LICENSE_CI_EXCEEDS_LIMIT = "The number of configuration items in your repository exceeds the limit on this license.";
    private static final String LICENSE_ENTER_NEW = "Enter a new license key to renew your license.";
    private static final String LICENSE_CONTINUE_TRIAL = "Enter your license key to extend your trial.";
    private static final String LICENSE_UNREGISTERED_EXPIRED = "Your unregistered license for %s has expired.";
    private static final String LICENSE_NOT_VALID = "The current license is not valid (%s).";
    private static final String LICENSE_COMMUNITY_MIX = "This edition of %s cannot be used with a Community Edition license.";
    private static final String LICENSE_ENTERPRISE_OR_TRIAL = "This edition of %s requires a Trial Edition license or an Enterprise Edition license.";
    private static final String COMMUNITY = "Community";
    private static final String CANNOT_BE_WRITTEN = "Could not install license because the license file could not be written to the file system.";
    private static final String REPO_IS_LOCKED = "Could not install license because the repository is locked to another license";
    private static final String INVALID = "Could not install license because it is invalid";
    private static final String FS_ERROR = "Could not install license due to problems with the file system";

    public LicenseInstallServiceImpl(String licensePath, LicenseService licenseService) {
        this.licenseFile = new File(licensePath);
        this.licenseService = licenseService;
    }

    boolean canInstallNewLicense() {
        if (!this.licenseFile.exists()) {
            return this.licenseFile.getParentFile().canWrite();
        }
        return this.licenseFile.canWrite();
    }

    @Override
    public License installNewLicense(String licenseText) throws LicenseInstallationFailedException {
        if (!this.canInstallNewLicense()) {
            logger.info(CANNOT_BE_WRITTEN);
            throw new LicenseInstallationFailedException(CANNOT_BE_WRITTEN);
        }
        try {
            License tmpLicense = this.readLicense(licenseText);
            this.licenseService.validate(tmpLicense);
            String plainText = LicenseUtils.decodeIfNecessary(licenseText);
            Files.write(this.licenseFile.toPath(), plainText.getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
            this.licenseService.reload();
            return tmpLicense;
        }
        catch (LicenseRepositoryIdException e) {
            logger.info(REPO_IS_LOCKED);
            throw new LicenseInstallationFailedException(REPO_IS_LOCKED, e);
        }
        catch (LicenseViolationException e) {
            logger.info(INVALID);
            throw new LicenseInstallationFailedException(INVALID, e);
        }
        catch (IOException e) {
            logger.info(FS_ERROR);
            throw new LicenseInstallationFailedException(FS_ERROR, e);
        }
    }

    @Override
    public String getLicenseRenewalMessage() {
        if (!this.licenseFile.exists()) {
            return null;
        }
        try {
            this.licenseService.validate();
        }
        catch (LicenseVersionException e) {
            logger.info(LICENSE_STATUS, (Object)e.getMessage());
            logger.info(LICENSE_OLD_VERSION);
            return LICENSE_OLD_VERSION;
        }
        catch (LicensePeriodExpiredException e) {
            logger.info(LICENSE_STATUS, (Object)e.getMessage());
            logger.info(LICENSE_EXPIRED);
            return LICENSE_EXPIRED;
        }
        catch (LicenseEditionException e) {
            logger.info(LICENSE_STATUS, (Object)e.getMessage());
            License license = this.licenseService.getLicense();
            if (license != null && COMMUNITY.equals(license.getStringValue(LicenseProperty.EDITION))) {
                String message = String.format(LICENSE_COMMUNITY_MIX, this.licenseService.getProduct());
                logger.info(message);
                return message;
            }
            String message = String.format(LICENSE_ENTERPRISE_OR_TRIAL, this.licenseService.getProduct());
            logger.info(message);
            return message;
        }
        catch (AmountOfCisExceededException e) {
            logger.info(LICENSE_STATUS, (Object)e.getMessage());
            logger.info(LICENSE_CI_EXCEEDS_LIMIT);
            return LICENSE_CI_EXCEEDS_LIMIT;
        }
        catch (UnregisteredLicenseExpiredException e) {
            logger.info(LICENSE_STATUS, (Object)e.getMessage());
            String message = String.format(LICENSE_UNREGISTERED_EXPIRED, this.licenseService.getProduct());
            logger.info(message);
            return message;
        }
        catch (LicenseViolationException e) {
            logger.info(LICENSE_STATUS, (Object)e.getMessage());
            String message = String.format(LICENSE_NOT_VALID, e.getMessage());
            logger.info(message);
            return message;
        }
        License license = this.licenseService.getLicense();
        if (license != null && !license.isDummyLicense() && license.getStringValue(LicenseProperty.EDITION).equals(LicenseVersion3.Edition.Unregistered.name())) {
            logger.info(LICENSE_CONTINUE_TRIAL);
            return LICENSE_CONTINUE_TRIAL;
        }
        logger.info(LICENSE_ENTER_NEW);
        return LICENSE_ENTER_NEW;
    }

    private License readLicense(String licenseText) throws IOException {
        File tempFile = File.createTempFile("license", "tmp");
        Files.write(tempFile.toPath(), licenseText.getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
        LicenseReader licenseReader = new LicenseReader();
        return licenseReader.readLicense(tempFile);
    }
}

