/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.html;

import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import javax.annotation.Nullable;
import org.owasp.html.Trie;

final class CssTokens
implements Iterable<String> {
    public final String normalizedCss;
    public final Brackets brackets;
    private final int[] tokenBreaks;
    private final TokenType[] tokenTypes;
    private static final int[] ZERO_INTS;
    private static final TokenType[] ZERO_TYPES;
    private static final Brackets EMPTY_BRACKETS;
    private static final CssTokens EMPTY;
    private static final boolean[] IDENT_PART_ASCII;
    private static final int LINE_TERMINATOR_BITMASK = 13312;
    private static final int LENGTH_UNIT_TYPE = 0;
    private static final int ANGLE_UNIT_TYPE = 1;
    private static final int TIME_UNIT_TYPE = 2;
    private static final int FREQUENCY_UNIT_TYPE = 3;
    private static final int RESOLUTION_UNIT_TYPE = 4;
    private static final Trie UNIT_TRIE;
    private static final boolean[] URL_SAFE;
    private static final char[] HEX_DIGITS;

    public TokenIterator start() {
        return new TokenIterator(this.tokenTypes.length);
    }

    public TokenIterator iterator() {
        return this.start();
    }

    public static CssTokens lex(String css) {
        Lexer lexer = new Lexer(css);
        lexer.lex();
        return lexer.build();
    }

    private CssTokens(String normalizedCss, Brackets brackets, int[] tokenBreaks, TokenType[] tokenTypes) {
        this.normalizedCss = normalizedCss;
        this.brackets = brackets;
        this.tokenBreaks = tokenBreaks;
        this.tokenTypes = tokenTypes;
    }

    private static final boolean isIdentPart(int cp) {
        return cp >= 128 ? Character.isDefined(cp) && cp != 65279 : IDENT_PART_ASCII[cp];
    }

    private static final boolean isDecimal(char ch) {
        return '0' <= ch && ch <= '9';
    }

    private static boolean isLineTerminator(char ch) {
        return ch < ' ' && 0 != (0x3400 & '\u0001' << ch);
    }

    private static int[] expandIfNecessary(int[] arr, int limit, int needed) {
        int length = arr.length;
        int neededLength = limit + needed;
        if (length >= neededLength) {
            return arr;
        }
        int[] newArr = new int[Math.max(16, Math.max(neededLength, length * 2))];
        System.arraycopy(arr, 0, newArr, 0, limit);
        return newArr;
    }

    private static int[] truncateOrShare(int[] arr, int limit) {
        if (limit == 0) {
            return ZERO_INTS;
        }
        if (limit == arr.length) {
            return arr;
        }
        int[] trunc = new int[limit];
        System.arraycopy(arr, 0, trunc, 0, limit);
        return trunc;
    }

    static boolean isWellKnownUnit(CharSequence s, int start, int end) {
        if (start == end) {
            return false;
        }
        Trie t = UNIT_TRIE;
        for (int i = start; i < end; ++i) {
            char ch = s.charAt(i);
            if ((t = t.lookup('A' <= ch && ch <= 'Z' ? (char)(ch | 0x20) : ch)) != null) continue;
            return false;
        }
        return t.isTerminal();
    }

    static boolean isWellKnownUnit(CharSequence s) {
        return CssTokens.isWellKnownUnit(s, 0, s.length());
    }

    static /* synthetic */ int[] access$200() {
        return ZERO_INTS;
    }

    static {
        int i;
        ZERO_INTS = new int[0];
        ZERO_TYPES = new TokenType[0];
        EMPTY_BRACKETS = new Brackets(ZERO_INTS);
        EMPTY = new CssTokens("", EMPTY_BRACKETS, ZERO_INTS, ZERO_TYPES);
        IDENT_PART_ASCII = new boolean[128];
        for (i = 48; i <= 57; ++i) {
            CssTokens.IDENT_PART_ASCII[i] = true;
        }
        for (i = 65; i <= 90; ++i) {
            CssTokens.IDENT_PART_ASCII[i] = true;
        }
        for (i = 97; i <= 122; ++i) {
            CssTokens.IDENT_PART_ASCII[i] = true;
        }
        CssTokens.IDENT_PART_ASCII[95] = true;
        CssTokens.IDENT_PART_ASCII[45] = true;
        UNIT_TRIE = new Trie((Map<String, Integer>)ImmutableMap.builder().put((Object)"em", (Object)0).put((Object)"ex", (Object)0).put((Object)"ch", (Object)0).put((Object)"rem", (Object)0).put((Object)"vh", (Object)0).put((Object)"vw", (Object)0).put((Object)"vmin", (Object)0).put((Object)"vmax", (Object)0).put((Object)"px", (Object)0).put((Object)"mm", (Object)0).put((Object)"cm", (Object)0).put((Object)"in", (Object)0).put((Object)"pt", (Object)0).put((Object)"pc", (Object)0).put((Object)"deg", (Object)1).put((Object)"rad", (Object)1).put((Object)"grad", (Object)1).put((Object)"turn", (Object)1).put((Object)"s", (Object)2).put((Object)"ms", (Object)2).put((Object)"hz", (Object)3).put((Object)"khz", (Object)3).put((Object)"dpi", (Object)4).put((Object)"dpcm", (Object)4).put((Object)"dppx", (Object)4).build());
        URL_SAFE = new boolean[128];
        for (i = 65; i <= 90; ++i) {
            CssTokens.URL_SAFE[i] = true;
        }
        for (i = 97; i <= 122; ++i) {
            CssTokens.URL_SAFE[i] = true;
        }
        for (i = 48; i <= 57; ++i) {
            CssTokens.URL_SAFE[i] = true;
        }
        CssTokens.URL_SAFE[45] = true;
        CssTokens.URL_SAFE[46] = true;
        CssTokens.URL_SAFE[95] = true;
        CssTokens.URL_SAFE[126] = true;
        CssTokens.URL_SAFE[58] = true;
        CssTokens.URL_SAFE[47] = true;
        CssTokens.URL_SAFE[63] = true;
        CssTokens.URL_SAFE[35] = true;
        CssTokens.URL_SAFE[91] = true;
        CssTokens.URL_SAFE[93] = true;
        CssTokens.URL_SAFE[64] = true;
        CssTokens.URL_SAFE[33] = true;
        CssTokens.URL_SAFE[36] = true;
        CssTokens.URL_SAFE[38] = true;
        CssTokens.URL_SAFE[43] = true;
        CssTokens.URL_SAFE[44] = true;
        CssTokens.URL_SAFE[59] = true;
        CssTokens.URL_SAFE[61] = true;
        CssTokens.URL_SAFE[37] = true;
        HEX_DIGITS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
    }

    private static final class Lexer {
        private final String css;
        private final StringBuilder sb;
        private int pos = 0;
        private final int cssLimit;
        private List<TokenType> tokenTypes = null;
        private int[] tokenBreaks = new int[128];
        private int tokenBreaksLimit = 0;
        private int[] brackets = CssTokens.access$200();
        private int bracketsLimit = 0;
        private int[] open = CssTokens.access$200();
        private int openLimit = 0;
        private static final long HEX_ENCODED_BITMASK = 5764608364847838209L;

        Lexer(String css) {
            this.css = css;
            this.sb = new StringBuilder();
            this.cssLimit = css.length();
        }

        TokenType openBracket(char bracketChar) {
            TokenType type;
            int close;
            switch (bracketChar) {
                case '(': {
                    close = 41;
                    type = TokenType.LEFT_PAREN;
                    break;
                }
                case '[': {
                    close = 93;
                    type = TokenType.LEFT_SQUARE;
                    break;
                }
                case '{': {
                    close = 125;
                    type = TokenType.LEFT_CURLY;
                    break;
                }
                default: {
                    throw new AssertionError((Object)("Invalid open bracket " + bracketChar));
                }
            }
            this.brackets = CssTokens.expandIfNecessary(this.brackets, this.bracketsLimit, 2);
            this.open = CssTokens.expandIfNecessary(this.open, this.openLimit, 2);
            this.open[this.openLimit++] = this.bracketsLimit;
            this.open[this.openLimit++] = close;
            this.brackets[this.bracketsLimit++] = this.tokenBreaksLimit;
            this.brackets[this.bracketsLimit++] = -1;
            this.sb.append(bracketChar);
            return type;
        }

        void closeBracket(char bracketChar) {
            int openLimitAfterClose = this.openLimit;
            do {
                if (openLimitAfterClose != 0) continue;
                this.breakOutput();
                return;
            } while (bracketChar != this.open[(openLimitAfterClose -= 2) + 1]);
            this.closeBrackets(openLimitAfterClose);
        }

        private void closeBrackets(int openLimitAfterClose) {
            int spaceNeeded = this.openLimit - openLimitAfterClose;
            this.brackets = CssTokens.expandIfNecessary(this.brackets, this.bracketsLimit, spaceNeeded);
            int closeTokenIndex = this.tokenBreaksLimit;
            while (this.openLimit > openLimitAfterClose) {
                int closeBracket = this.open[--this.openLimit];
                int openBracketIndex = this.open[--this.openLimit];
                int openTokenIndex = this.brackets[openBracketIndex];
                this.brackets[openBracketIndex + 1] = closeTokenIndex;
                this.brackets[this.bracketsLimit++] = closeTokenIndex++;
                this.brackets[this.bracketsLimit++] = openTokenIndex;
                this.sb.appendCodePoint(closeBracket);
            }
        }

        CssTokens build() {
            int startOfCloseBrackets = this.sb.length();
            this.closeBrackets(0);
            this.emitMergedTokens(startOfCloseBrackets, this.sb.length());
            if (this.tokenTypes == null) {
                return EMPTY;
            }
            int[] bracketsTrunc = CssTokens.truncateOrShare(this.brackets, this.bracketsLimit);
            int cssEnd = this.sb.length();
            if (cssEnd > 0 && this.sb.charAt(cssEnd - 1) == ' ') {
                --cssEnd;
                this.tokenTypes.remove(--this.tokenBreaksLimit);
            }
            String normalizedCss = this.sb.substring(0, cssEnd);
            this.tokenBreaks = CssTokens.expandIfNecessary(this.tokenBreaks, this.tokenBreaksLimit, 1);
            this.tokenBreaks[this.tokenBreaksLimit++] = normalizedCss.length();
            int[] tokenBreaksTrunc = CssTokens.truncateOrShare(this.tokenBreaks, this.tokenBreaksLimit);
            TokenType[] tokenTypesArr = this.tokenTypes.toArray(ZERO_TYPES);
            return new CssTokens(normalizedCss, new Brackets(bracketsTrunc), tokenBreaksTrunc, tokenTypesArr);
        }

        void lex() {
            this.consumeIgnorable();
            this.sb.setLength(0);
            if (this.pos == this.cssLimit) {
                return;
            }
            this.tokenTypes = new ArrayList<TokenType>();
            String css = this.css;
            int cssLimit = this.cssLimit;
            while (this.pos < cssLimit) {
                int sbLen;
                TokenType type;
                assert (this.tokenBreaksLimit == this.tokenTypes.size()) : "token and types out of sync at " + this.tokenBreaksLimit + " in `" + css + "`";
                char ch = css.charAt(this.pos);
                int startOfToken = this.pos++;
                int startOfOutputToken = this.sb.length();
                switch (ch) {
                    case '\t': 
                    case '\n': 
                    case '\f': 
                    case '\r': 
                    case ' ': 
                    case '\ufeff': {
                        this.consumeIgnorable();
                        type = TokenType.WHITESPACE;
                        break;
                    }
                    case '/': {
                        char lookahead;
                        char c = lookahead = this.pos + 1 < cssLimit ? css.charAt(this.pos + 1) : (char)'\u0000';
                        if (lookahead == '/' || lookahead == '*') {
                            this.consumeIgnorable();
                            type = TokenType.WHITESPACE;
                            break;
                        }
                        this.consumeDelim(ch);
                        type = TokenType.DELIM;
                        break;
                    }
                    case '<': {
                        if (this.consumeIgnorable()) {
                            type = TokenType.WHITESPACE;
                            break;
                        }
                        this.consumeDelim('<');
                        type = TokenType.DELIM;
                        break;
                    }
                    case '>': {
                        this.breakOutput();
                        this.sb.append('>');
                        type = TokenType.DELIM;
                        break;
                    }
                    case '@': {
                        if (this.consumeAtKeyword()) {
                            type = TokenType.AT;
                            break;
                        }
                        this.consumeDelim(ch);
                        type = TokenType.DELIM;
                        break;
                    }
                    case '#': {
                        this.sb.append('#');
                        TokenType hashType = this.consumeHash();
                        if (hashType != null) {
                            type = hashType;
                            break;
                        }
                        ++this.pos;
                        this.sb.append(' ');
                        type = TokenType.DELIM;
                        break;
                    }
                    case '\"': 
                    case '\'': {
                        type = this.consumeString();
                        break;
                    }
                    case 'U': 
                    case 'u': {
                        if (this.consumeUnicodeRange()) {
                            type = TokenType.UNICODE_RANGE;
                            break;
                        }
                        type = this.consumeIdentOrUrlOrFunction();
                        break;
                    }
                    case '0': 
                    case '1': 
                    case '2': 
                    case '3': 
                    case '4': 
                    case '5': 
                    case '6': 
                    case '7': 
                    case '8': 
                    case '9': {
                        type = this.consumeNumberOrPercentageOrDimension();
                        break;
                    }
                    case '+': 
                    case '-': 
                    case '.': {
                        char lookahead;
                        char c = lookahead = this.pos + 1 < cssLimit ? css.charAt(this.pos + 1) : (char)'\u0000';
                        if (CssTokens.isDecimal(lookahead) || lookahead == '.' && this.pos + 2 < cssLimit && CssTokens.isDecimal(css.charAt(this.pos + 2))) {
                            type = this.consumeNumberOrPercentageOrDimension();
                            break;
                        }
                        if (ch == '+') {
                            this.consumeDelim(ch);
                            type = TokenType.DELIM;
                            break;
                        }
                        if (ch == '-') {
                            if (this.consumeIgnorable()) {
                                type = TokenType.WHITESPACE;
                                break;
                            }
                            type = this.consumeIdentOrUrlOrFunction();
                            break;
                        }
                        if (CssTokens.isIdentPart(lookahead)) {
                            this.sb.append('.');
                            ++this.pos;
                            this.consumeIdent(false);
                            if (this.pos != startOfToken + 1) {
                                char next;
                                type = TokenType.DOT_IDENT;
                                if (this.pos >= cssLimit || '(' != (next = css.charAt(this.pos))) break;
                                this.sb.append(' ');
                                break;
                            }
                            type = TokenType.DELIM;
                            this.sb.append(' ');
                            break;
                        }
                        this.consumeDelim('.');
                        type = TokenType.DELIM;
                        break;
                    }
                    case ':': {
                        this.consumeDelim(ch);
                        type = TokenType.COLON;
                        break;
                    }
                    case ';': {
                        this.consumeDelim(ch);
                        type = TokenType.SEMICOLON;
                        break;
                    }
                    case ',': {
                        this.consumeDelim(ch);
                        type = TokenType.COMMA;
                        break;
                    }
                    case '(': 
                    case '[': 
                    case '{': {
                        type = this.openBracket(ch);
                        ++this.pos;
                        break;
                    }
                    case ')': 
                    case ']': 
                    case '}': {
                        this.closeBracket(ch);
                        ++this.pos;
                        type = TokenType.DELIM;
                        break;
                    }
                    case '$': 
                    case '*': 
                    case '^': 
                    case '|': 
                    case '~': {
                        char lookahead;
                        char c = lookahead = this.pos + 1 < cssLimit ? css.charAt(this.pos + 1) : (char)'\u0000';
                        if (lookahead == '=') {
                            this.consumeMatch(ch);
                            type = TokenType.MATCH;
                            break;
                        }
                        if (ch == '|' && lookahead == '|') {
                            this.consumeColumn();
                            type = TokenType.COLUMN;
                            break;
                        }
                        this.consumeDelim(ch);
                        type = TokenType.DELIM;
                        break;
                    }
                    case '_': {
                        type = this.consumeIdentOrUrlOrFunction();
                        break;
                    }
                    case '\\': {
                        TokenType identType = this.consumeIdentOrUrlOrFunction();
                        if (identType == null) {
                            ++this.pos;
                            this.breakOutput();
                            type = TokenType.WHITESPACE;
                            break;
                        }
                        type = identType;
                        break;
                    }
                    default: {
                        int chlower = ch | 0x20;
                        if (97 <= chlower && chlower <= 122 || ch >= '\u0080') {
                            TokenType identType = this.consumeIdentOrUrlOrFunction();
                            if (identType != null) {
                                type = identType;
                                break;
                            }
                            ++this.pos;
                            this.breakOutput();
                            type = TokenType.WHITESPACE;
                            break;
                        }
                        if (ch > ' ') {
                            this.consumeDelim(ch);
                            type = TokenType.DELIM;
                            break;
                        }
                        this.consumeIgnorable();
                        type = TokenType.WHITESPACE;
                    }
                }
                assert (this.pos > startOfToken) : "empty token at " + this.pos + ", ch0=" + css.charAt(startOfToken) + ":U+" + Integer.toHexString(css.charAt(startOfToken));
                int endOfOutputToken = this.sb.length();
                if (endOfOutputToken <= startOfOutputToken) continue;
                if (type == TokenType.DELIM) {
                    this.emitMergedTokens(startOfOutputToken, endOfOutputToken);
                    continue;
                }
                if (type != TokenType.WHITESPACE && this.sb.charAt(startOfOutputToken) == ' ') {
                    this.emitToken(TokenType.WHITESPACE, startOfOutputToken);
                    assert (++startOfOutputToken != endOfOutputToken);
                }
                this.emitToken(type, startOfOutputToken);
                if (type == TokenType.WHITESPACE || startOfOutputToken + 1 >= (sbLen = this.sb.length()) || this.sb.charAt(sbLen - 1) != ' ') continue;
                this.emitToken(TokenType.WHITESPACE, sbLen - 1);
            }
        }

        private void emitMergedTokens(int start, int end) {
            for (int e = start; e < end; ++e) {
                TokenType delimType;
                switch (this.sb.charAt(e)) {
                    case ' ': {
                        delimType = TokenType.WHITESPACE;
                        break;
                    }
                    case '}': {
                        delimType = TokenType.RIGHT_CURLY;
                        break;
                    }
                    case ')': {
                        delimType = TokenType.RIGHT_PAREN;
                        break;
                    }
                    case ']': {
                        delimType = TokenType.RIGHT_SQUARE;
                        break;
                    }
                    default: {
                        delimType = TokenType.DELIM;
                    }
                }
                this.emitToken(delimType, e);
            }
        }

        private void emitToken(TokenType type, int startOfOutputToken) {
            if (this.tokenBreaksLimit == 0 || this.tokenBreaks[this.tokenBreaksLimit - 1] != startOfOutputToken) {
                this.tokenBreaks = CssTokens.expandIfNecessary(this.tokenBreaks, this.tokenBreaksLimit, 1);
                this.tokenBreaks[this.tokenBreaksLimit++] = startOfOutputToken;
                this.tokenTypes.add(type);
            }
        }

        private void consumeDelim(char ch) {
            this.sb.append(ch);
            switch (ch) {
                case '$': 
                case '+': 
                case '-': 
                case '.': 
                case '/': 
                case '<': 
                case '@': 
                case '\\': 
                case '^': 
                case '|': 
                case '~': {
                    this.sb.append(' ');
                    break;
                }
            }
            ++this.pos;
        }

        private boolean consumeIgnorable() {
            String css = this.css;
            int cssLimit = this.cssLimit;
            int posBefore = this.pos;
            block0: while (this.pos < cssLimit) {
                char ch = css.charAt(this.pos);
                if (ch <= ' ' || ch == '\ufeff') {
                    ++this.pos;
                    continue;
                }
                if (this.pos + 1 == cssLimit) break;
                if (ch == '/') {
                    char next = css.charAt(this.pos + 1);
                    if (next == '*') {
                        this.pos += 2;
                        while (this.pos < cssLimit) {
                            int ast = css.indexOf(42, this.pos);
                            if (ast < 0) {
                                this.pos = cssLimit;
                                continue block0;
                            }
                            this.pos = ast + 1;
                            while (this.pos < cssLimit && css.charAt(this.pos) == '*') {
                                ++this.pos;
                            }
                            if (this.pos >= cssLimit || css.charAt(this.pos) != '/') continue;
                            ++this.pos;
                            continue block0;
                        }
                        continue;
                    }
                    if (next != '/') break;
                    while (++this.pos < cssLimit && !CssTokens.isLineTerminator(css.charAt(this.pos))) {
                    }
                    continue;
                }
                if (ch == '<') {
                    if (this.pos + 3 >= cssLimit || '!' != css.charAt(this.pos + 1) || '-' != css.charAt(this.pos + 2) || '-' != css.charAt(this.pos + 3)) break;
                    this.pos += 4;
                    continue;
                }
                if (ch != '-' || this.pos + 2 >= cssLimit || '-' != css.charAt(this.pos + 1) || '>' != css.charAt(this.pos + 2)) break;
                this.pos += 3;
            }
            if (this.pos == posBefore) {
                return false;
            }
            this.breakOutput();
            return true;
        }

        private void breakOutput() {
            int last = this.sb.length() - 1;
            if (last >= 0 && this.sb.charAt(last) != ' ') {
                this.sb.append(' ');
            }
        }

        private void consumeColumn() {
            this.pos += 2;
            this.sb.append("||");
        }

        private void consumeMatch(char ch) {
            this.pos += 2;
            this.sb.append(ch).append('=');
        }

        private void consumeIdent(boolean allowFirstDigit) {
            int cssLimit = this.cssLimit;
            int last = -1;
            int nCodepoints = 0;
            int sbAtStart = this.sb.length();
            int posAtStart = this.pos;
            while (this.pos < cssLimit) {
                int posBefore = this.pos++;
                int decoded = this.readCodepoint();
                if (decoded == 92) {
                    decoded = this.consumeAndDecodeEscapeSequence();
                }
                if (decoded >= 0 && CssTokens.isIdentPart(decoded)) {
                    if (!(allowFirstDigit || nCodepoints >= 2 || 48 > decoded || decoded > 57 || last != 45 && last != -1)) {
                        this.pos = posAtStart;
                        this.sb.setLength(sbAtStart);
                        return;
                    }
                    this.sb.appendCodePoint(decoded);
                    last = decoded;
                    ++nCodepoints;
                    continue;
                }
                this.pos = posBefore;
                return;
            }
        }

        private boolean consumeAtKeyword() {
            assert (this.css.charAt(this.pos) == '@');
            int bufferLengthBeforeWrite = this.sb.length();
            this.sb.append('@');
            int posBeforeKeyword = ++this.pos;
            this.consumeIdent(false);
            if (this.pos == posBeforeKeyword) {
                --this.pos;
                this.sb.setLength(bufferLengthBeforeWrite);
                return false;
            }
            return true;
        }

        private int consumeAndDecodeEscapeSequence() {
            String css = this.css;
            int cssLimit = this.cssLimit;
            assert (css.charAt(this.pos) == '\\');
            if (this.pos + 1 >= cssLimit) {
                return -1;
            }
            char esc = css.charAt(this.pos + 1);
            if (CssTokens.isLineTerminator(esc)) {
                return -1;
            }
            int escLower = esc | 0x20;
            if ('0' <= esc && esc <= '9' || 97 <= escLower && escLower <= 102) {
                char next;
                int hexValue = 0;
                int hexStart = this.pos + 1;
                int hexLimit = Math.min(this.pos + 7, cssLimit);
                int hexEnd = hexStart;
                do {
                    hexValue = hexValue << 4 | (esc <= '9' ? esc - 48 : escLower - 87);
                    if (++hexEnd == hexLimit) break;
                    esc = css.charAt(hexEnd);
                    escLower = esc | 0x20;
                } while ('0' <= esc && esc <= '9' || 97 <= escLower && escLower <= 102);
                if (!Character.isDefined(hexValue)) {
                    hexValue = 65533;
                }
                this.pos = hexEnd;
                if (this.pos < cssLimit && ((next = css.charAt(this.pos)) == ' ' || next == '\t' || CssTokens.isLineTerminator(next))) {
                    ++this.pos;
                }
                return hexValue;
            }
            this.pos += 2;
            return esc;
        }

        private static boolean isHexEncoded(int codepoint) {
            return 0 <= codepoint && codepoint < 63 && 0L != (1L << codepoint & 0x500000C400003401L);
        }

        private void encodeCharOntoOutput(int codepoint, int last) {
            switch (codepoint) {
                case 92: {
                    this.sb.append("\\\\");
                    break;
                }
                case 0: {
                    this.sb.append("\\0");
                    break;
                }
                case 10: {
                    this.sb.append("\\a");
                    break;
                }
                case 12: {
                    this.sb.append("\\c");
                    break;
                }
                case 13: {
                    this.sb.append("\\d");
                    break;
                }
                case 34: {
                    this.sb.append("\\22");
                    break;
                }
                case 38: {
                    this.sb.append("\\26");
                    break;
                }
                case 39: {
                    this.sb.append("\\27");
                    break;
                }
                case 60: {
                    this.sb.append("\\3c");
                    break;
                }
                case 62: {
                    this.sb.append("\\3e");
                    break;
                }
                case 45: {
                    this.sb.append('-');
                    break;
                }
                default: {
                    if (Lexer.isHexEncoded(last) && (codepoint == 32 || codepoint == 9 || 48 <= codepoint && codepoint <= 57 || 97 <= (codepoint | 0x20) && (codepoint | 0x20) <= 102)) {
                        this.sb.append(' ');
                    }
                    this.sb.appendCodePoint(codepoint);
                }
            }
        }

        private TokenType consumeNumberOrPercentageOrDimension() {
            TokenType type;
            int unitEnd;
            char ch;
            int unitStart;
            int exponentStart;
            char ch2;
            int intEnd;
            char ch3;
            String css = this.css;
            int cssLimit = this.cssLimit;
            boolean isZero = true;
            int intStart = this.pos;
            if (intStart < cssLimit && ((ch3 = css.charAt(intStart)) == '-' || ch3 == '+')) {
                ++intStart;
            }
            for (intEnd = intStart; intEnd < cssLimit && '0' <= (ch2 = css.charAt(intEnd)) && ch2 <= '9'; ++intEnd) {
                if (ch2 == '0') continue;
                isZero = false;
            }
            int fractionStart = intEnd;
            int fractionEnd = fractionStart;
            if (fractionEnd < cssLimit && '.' == css.charAt(fractionEnd)) {
                char ch4;
                ++fractionEnd;
                while (fractionEnd < cssLimit && '0' <= (ch4 = css.charAt(fractionEnd)) && ch4 <= '9') {
                    if (ch4 != '0') {
                        isZero = false;
                    }
                    ++fractionEnd;
                }
            }
            int exponentIntStart = exponentStart = fractionEnd;
            int exponentEnd = exponentStart;
            boolean isExponentZero = true;
            if (exponentStart < cssLimit && 101 == (css.charAt(exponentStart) | 0x20)) {
                char ch5;
                exponentEnd = exponentStart + 1;
                if (exponentEnd < cssLimit && ((ch5 = css.charAt(exponentEnd)) == '+' || ch5 == '-')) {
                    ++exponentEnd;
                }
                exponentIntStart = exponentEnd;
                while (exponentEnd < cssLimit && '0' <= (ch5 = css.charAt(exponentEnd)) && ch5 <= '9') {
                    if (ch5 != '0') {
                        isExponentZero = false;
                    }
                    ++exponentEnd;
                }
                if (exponentEnd == exponentIntStart) {
                    exponentIntStart = exponentEnd = exponentStart;
                    isExponentZero = true;
                }
            }
            for (unitStart = exponentEnd; unitStart < cssLimit && ((ch = css.charAt(unitStart)) == ' ' || CssTokens.isLineTerminator(ch)); ++unitStart) {
            }
            if (this.sb.length() != 0 && CssTokens.isIdentPart(this.sb.charAt(this.sb.length() - 1))) {
                this.sb.append(' ');
            }
            if (intStart != this.pos && '-' == css.charAt(this.pos) && !isZero) {
                this.sb.append('-');
            }
            if (isZero) {
                this.sb.append('0');
            } else {
                while (intStart < intEnd && css.charAt(intStart) == '0') {
                    ++intStart;
                }
                while (fractionEnd > fractionStart && css.charAt(fractionEnd - 1) == '0') {
                    --fractionEnd;
                }
                if (intStart == intEnd) {
                    this.sb.append('0');
                } else {
                    this.sb.append(css, intStart, intEnd);
                }
                if (fractionEnd > fractionStart + 1) {
                    this.sb.append(css, fractionStart, fractionEnd);
                }
                if (!isExponentZero) {
                    this.sb.append('e');
                    if ('-' == css.charAt(exponentIntStart - 1)) {
                        this.sb.append('-');
                    }
                    while (exponentIntStart < exponentEnd && css.charAt(exponentIntStart) == '0') {
                        ++exponentIntStart;
                    }
                    this.sb.append(css, exponentIntStart, exponentEnd);
                }
            }
            if (unitStart < cssLimit && '%' == css.charAt(unitStart)) {
                unitEnd = unitStart + 1;
                type = TokenType.PERCENTAGE;
                this.sb.append('%');
            } else {
                int bufferBeforeUnit = this.sb.length();
                this.pos = unitStart;
                this.consumeIdent(false);
                int bufferAfterUnit = this.sb.length();
                boolean knownUnit = CssTokens.isWellKnownUnit(this.sb, bufferBeforeUnit, bufferAfterUnit);
                if (unitStart == exponentEnd || knownUnit) {
                    unitEnd = this.pos;
                    for (int i = bufferBeforeUnit; i < bufferAfterUnit; ++i) {
                        char ch6 = this.sb.charAt(i);
                        if ('A' > ch6 || ch6 > 'Z') continue;
                        this.sb.setCharAt(i, (char)(ch6 | 0x20));
                    }
                } else {
                    unitEnd = unitStart = exponentEnd;
                    this.sb.setLength(bufferBeforeUnit);
                }
                type = unitStart == unitEnd ? TokenType.NUMBER : (knownUnit ? TokenType.DIMENSION : TokenType.BAD_DIMENSION);
            }
            this.pos = unitEnd;
            if (type != TokenType.PERCENTAGE && this.pos < cssLimit && css.charAt(this.pos) == '.') {
                this.sb.append(' ');
            }
            return type;
        }

        private TokenType consumeString() {
            String css = this.css;
            int cssLimit = this.cssLimit;
            char delim = css.charAt(this.pos);
            assert (delim == '\"' || delim == '\'');
            ++this.pos;
            int startOfStringOnOutput = this.sb.length();
            this.sb.append('\'');
            int n = -1;
            boolean closed = false;
            while (this.pos < cssLimit) {
                int n2;
                int ch = css.charAt(this.pos);
                if (ch == delim) {
                    ++this.pos;
                    closed = true;
                    break;
                }
                if (CssTokens.isLineTerminator((char)ch)) break;
                int decoded = ch;
                if (ch == 92) {
                    if (this.pos + 1 < cssLimit && CssTokens.isLineTerminator(css.charAt(this.pos + 1))) {
                        if (this.pos + 2 < cssLimit && css.charAt(this.pos + 1) == '\r' && css.charAt(this.pos + 2) == '\n') {
                            this.pos += 3;
                            continue;
                        }
                        this.pos += 2;
                        continue;
                    }
                    decoded = this.consumeAndDecodeEscapeSequence();
                    if (decoded < 0) {
                        break;
                    }
                } else {
                    ++this.pos;
                }
                this.encodeCharOntoOutput(decoded, n2);
                n2 = decoded;
            }
            if (closed) {
                this.sb.append('\'');
                return TokenType.STRING;
            }
            this.sb.setLength(startOfStringOnOutput);
            this.breakOutput();
            return TokenType.WHITESPACE;
        }

        @Nullable
        private TokenType consumeHash() {
            assert (this.css.charAt(this.pos) == '#');
            ++this.pos;
            int beforeIdent = this.pos;
            this.consumeIdent(true);
            if (this.pos == beforeIdent) {
                this.pos = beforeIdent - 1;
                return null;
            }
            for (int i = beforeIdent; i < this.pos; ++i) {
                char chLower = (char)(this.css.charAt(i) | 0x20);
                if ('0' <= chLower && chLower <= '9' || 'a' <= chLower && chLower <= 'f') continue;
                return TokenType.HASH_ID;
            }
            return TokenType.HASH_UNRESTRICTED;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean consumeUnicodeRange() {
            String css = this.css;
            int cssLimit = this.cssLimit;
            assert (this.pos < cssLimit && (css.charAt(this.pos) | 0x20) == 117);
            int start = this.pos++;
            int startOfOutput = this.sb.length();
            boolean ok = false;
            try {
                if (this.pos != cssLimit && css.charAt(this.pos) == '+') {
                    char chLower;
                    ++this.pos;
                    this.sb.append("U+");
                    int numStartDigits = 0;
                    while (this.pos < cssLimit && numStartDigits < 6 && ('0' <= (chLower = (char)(css.charAt(this.pos) | 0x20)) && chLower <= '9' || 'a' <= chLower && chLower <= 'f')) {
                        this.sb.append(chLower);
                        ++numStartDigits;
                        ++this.pos;
                    }
                    if (numStartDigits != 0) {
                        boolean hasQmark = false;
                        while (this.pos < cssLimit && numStartDigits < 6 && css.charAt(this.pos) == '?') {
                            hasQmark = true;
                            this.sb.append('?');
                            ++numStartDigits;
                            ++this.pos;
                        }
                        if (numStartDigits != 0) {
                            if (this.pos < cssLimit && css.charAt(this.pos) == '-') {
                                if (!hasQmark) {
                                    char chLower2;
                                    ++this.pos;
                                    this.sb.append('-');
                                    int numEndDigits = 0;
                                    while (this.pos < cssLimit && numEndDigits < 6 && ('0' <= (chLower2 = (char)(css.charAt(this.pos) | 0x20)) && chLower2 <= '9' || 'a' <= chLower2 && chLower2 <= 'f')) {
                                        ++numEndDigits;
                                        ++this.pos;
                                        this.sb.append(chLower2);
                                    }
                                    if (numEndDigits == 0) {
                                        --this.pos;
                                        this.sb.append(' ');
                                    }
                                } else {
                                    this.sb.append(' ');
                                }
                            }
                            ok = true;
                        }
                    }
                }
            }
            finally {
                if (!ok) {
                    this.pos = start;
                    this.sb.setLength(startOfOutput);
                }
            }
            return ok;
        }

        @Nullable
        private TokenType consumeIdentOrUrlOrFunction() {
            char next;
            boolean parenAfter;
            int bufferStart = this.sb.length();
            int posBefore = this.pos;
            this.consumeIdent(false);
            if (this.pos == posBefore) {
                return null;
            }
            boolean bl = parenAfter = this.pos < this.cssLimit && this.css.charAt(this.pos) == '(';
            if (this.sb.length() - bufferStart == 3 && 117 == (this.sb.charAt(bufferStart) | 0x20) && 114 == (this.sb.charAt(bufferStart + 1) | 0x20) && 108 == (this.sb.charAt(bufferStart + 2) | 0x20)) {
                if (parenAfter && this.consumeUrlValue()) {
                    this.sb.setCharAt(bufferStart, 'u');
                    this.sb.setCharAt(bufferStart + 1, 'r');
                    this.sb.setCharAt(bufferStart + 2, 'l');
                    return TokenType.URL;
                }
                this.sb.setLength(bufferStart);
                this.breakOutput();
                return TokenType.WHITESPACE;
            }
            if (parenAfter) {
                this.openBracket('(');
                ++this.pos;
                return TokenType.FUNCTION;
            }
            if (this.pos + 1 < this.cssLimit && '.' == this.css.charAt(this.pos) && '0' <= (next = this.css.charAt(this.pos + 1)) && next <= '9') {
                this.sb.append(' ');
            }
            return TokenType.IDENT;
        }

        private boolean consumeUrlValue() {
            char delim;
            char ch;
            char ch2;
            String css = this.css;
            int cssLimit = this.cssLimit;
            if (this.pos == cssLimit || css.charAt(this.pos) != '(') {
                return false;
            }
            ++this.pos;
            while (this.pos < cssLimit && ((ch2 = css.charAt(this.pos)) == ' ' || CssTokens.isLineTerminator(ch2))) {
                ++this.pos;
            }
            if (this.pos < cssLimit) {
                char c = ch = this.pos < cssLimit ? css.charAt(this.pos) : (char)'\u0000';
                if (ch == '\"' || ch == '\'') {
                    delim = ch;
                    ++this.pos;
                } else {
                    delim = '\u0000';
                }
            } else {
                return false;
            }
            this.sb.append("('");
            while (this.pos < cssLimit) {
                int octet2;
                int octet1;
                int octet0;
                int decoded = this.readCodepoint();
                if (delim != '\u0000') {
                    if (decoded == delim) {
                        ++this.pos;
                        break;
                    }
                } else if (decoded <= 32 || decoded == 41) break;
                if (decoded == 92) {
                    decoded = this.consumeAndDecodeEscapeSequence();
                    if (decoded < 0) {
                        return false;
                    }
                } else {
                    ++this.pos;
                }
                if (decoded < URL_SAFE.length && URL_SAFE[decoded]) {
                    this.sb.appendCodePoint(decoded);
                    continue;
                }
                if (decoded < 128) {
                    this.sb.append('%').append(HEX_DIGITS[decoded >>> 4 & 0xF]).append(HEX_DIGITS[decoded >>> 0 & 0xF]);
                    continue;
                }
                if (decoded < 2048) {
                    octet0 = 0xC0 | decoded >>> 6 & 0x1F;
                    octet1 = 0x80 | decoded & 0x3F;
                    this.sb.append('%').append(HEX_DIGITS[octet0 >>> 4 & 0xF]).append(HEX_DIGITS[octet0 >>> 0 & 0xF]).append('%').append(HEX_DIGITS[octet1 >>> 4 & 0xF]).append(HEX_DIGITS[octet1 >>> 0 & 0xF]);
                    continue;
                }
                if (decoded < 65536) {
                    octet0 = 0xE0 | decoded >>> 12 & 0xF;
                    octet1 = 0x80 | decoded >>> 6 & 0x3F;
                    octet2 = 0x80 | decoded & 0x3F;
                    this.sb.append('%').append(HEX_DIGITS[octet0 >>> 4 & 0xF]).append(HEX_DIGITS[octet0 >>> 0 & 0xF]).append('%').append(HEX_DIGITS[octet1 >>> 4 & 0xF]).append(HEX_DIGITS[octet1 >>> 0 & 0xF]).append('%').append(HEX_DIGITS[octet2 >>> 4 & 0xF]).append(HEX_DIGITS[octet2 >>> 0 & 0xF]);
                    continue;
                }
                octet0 = 0xF0 | decoded >>> 18 & 7;
                octet1 = 0x80 | decoded >>> 12 & 0x3F;
                octet2 = 0x80 | decoded >>> 6 & 0x3F;
                int octet3 = 0x80 | decoded & 0x3F;
                this.sb.append('%').append(HEX_DIGITS[octet0 >>> 4 & 0xF]).append(HEX_DIGITS[octet0 >>> 0 & 0xF]).append('%').append(HEX_DIGITS[octet1 >>> 4 & 0xF]).append(HEX_DIGITS[octet1 >>> 0 & 0xF]).append('%').append(HEX_DIGITS[octet2 >>> 4 & 0xF]).append(HEX_DIGITS[octet2 >>> 0 & 0xF]).append('%').append(HEX_DIGITS[octet3 >>> 4 & 0xF]).append(HEX_DIGITS[octet3 >>> 0 & 0xF]);
            }
            while (this.pos < cssLimit && ((ch = css.charAt(this.pos)) == ' ' || CssTokens.isLineTerminator(ch))) {
                ++this.pos;
            }
            if (this.pos < cssLimit && css.charAt(this.pos) == ')') {
                ++this.pos;
            }
            this.sb.append("')");
            return true;
        }

        private int readCodepoint() {
            char next;
            String css = this.css;
            char ch = css.charAt(this.pos);
            if (Character.isHighSurrogate(ch) && this.pos + 1 < this.cssLimit && Character.isLowSurrogate(next = css.charAt(this.pos + 1))) {
                ++this.pos;
                return 65536 + (ch - 55296 << 10 | next - 56320);
            }
            return ch;
        }
    }

    static final class Brackets {
        private final int[] brackets;

        Brackets(int[] brackets) {
            this.brackets = brackets;
        }

        int partner(int tokenIndex) {
            int bracketIndex = this.bracketIndexForToken(tokenIndex);
            if (bracketIndex < 0) {
                return -1;
            }
            return this.brackets[(bracketIndex << 1) + 1];
        }

        int bracketIndexForToken(int target) {
            int left = 0;
            int right = this.brackets.length >> 1;
            while (left < right) {
                int mid = left + (right - left >> 1);
                int value = this.brackets[mid << 1];
                if (value == target) {
                    return mid;
                }
                if (value < target) {
                    left = mid + 1;
                    continue;
                }
                right = mid;
            }
            return -1;
        }
    }

    public static enum TokenType {
        IDENT,
        DOT_IDENT,
        FUNCTION,
        AT,
        HASH_ID,
        HASH_UNRESTRICTED,
        STRING,
        URL,
        DELIM,
        NUMBER,
        PERCENTAGE,
        DIMENSION,
        BAD_DIMENSION,
        UNICODE_RANGE,
        MATCH,
        COLUMN,
        WHITESPACE,
        COLON,
        SEMICOLON,
        COMMA,
        LEFT_SQUARE,
        RIGHT_SQUARE,
        LEFT_PAREN,
        RIGHT_PAREN,
        LEFT_CURLY,
        RIGHT_CURLY;

    }

    public final class TokenIterator
    implements Iterator<String> {
        private int tokenIndex = 0;
        private final int limit;

        TokenIterator(int limit) {
            this.limit = limit;
        }

        @Override
        public boolean hasNext() {
            return this.hasToken();
        }

        @Override
        public String next() {
            if (!this.hasToken()) {
                throw new NoSuchElementException();
            }
            String token = this.token();
            this.advance();
            return token;
        }

        @Nullable
        public TokenIterator spliceToEnd() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            int end = CssTokens.this.brackets.partner(this.tokenIndex);
            if (end < 0) {
                return null;
            }
            TokenIterator between = new TokenIterator(end);
            between.tokenIndex = this.tokenIndex + 1;
            this.tokenIndex = end + 1;
            return between;
        }

        public int tokenIndex() {
            return this.tokenIndex;
        }

        public int startOffset() {
            return CssTokens.this.tokenBreaks[this.tokenIndex];
        }

        public int endOffset() {
            return CssTokens.this.tokenBreaks[this.tokenIndex + 1];
        }

        public String token() {
            return CssTokens.this.normalizedCss.substring(this.startOffset(), this.endOffset());
        }

        public boolean hasToken() {
            return this.tokenIndex < this.limit;
        }

        public boolean hasTokenAfterSpace() {
            while (this.hasToken()) {
                if (this.type() != TokenType.WHITESPACE) {
                    return true;
                }
                this.advance();
            }
            return false;
        }

        public TokenType type() {
            return CssTokens.this.tokenTypes[this.tokenIndex];
        }

        public void seek(int newTokenIndex) {
            this.tokenIndex = newTokenIndex;
        }

        public void advance() {
            if (!this.hasToken()) {
                throw new NoSuchElementException();
            }
            ++this.tokenIndex;
        }

        public void backup() {
            if (this.tokenIndex == 0) {
                throw new NoSuchElementException();
            }
            --this.tokenIndex;
        }

        @Override
        public void remove() throws UnsupportedOperationException {
            throw new UnsupportedOperationException();
        }
    }
}

