/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.repository;

import com.xebialabs.deployit.engine.api.dto.ConfigurationItemId;
import com.xebialabs.deployit.engine.api.dto.DeploymentInfo;
import com.xebialabs.deployit.engine.api.dto.Ordering;
import com.xebialabs.deployit.engine.api.dto.Paging;
import com.xebialabs.deployit.repository.sql.EnvironmentRepository;
import com.xebialabs.deployit.repository.sql.SqlDeployedApplicationsRepository;
import com.xebialabs.deployit.repository.sql.SqlHostRepository;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import scala.collection.immutable.List;
import scala.reflect.ScalaSignature;

@Component
@ScalaSignature(bytes="\u0006\u0001\u0005%b\u0001B\u0001\u0003\u0001-\u0011QcU9m\u000b:4\u0018N]8o[\u0016tGoU3sm&\u001cWM\u0003\u0002\u0004\t\u0005Q!/\u001a9pg&$xN]=\u000b\u0005\u00151\u0011\u0001\u00033fa2|\u00170\u001b;\u000b\u0005\u001dA\u0011!\u0003=fE&\fG.\u00192t\u0015\u0005I\u0011aA2p[\u000e\u00011C\u0001\u0001\r!\ti\u0001#D\u0001\u000f\u0015\u0005y\u0011!B:dC2\f\u0017BA\t\u000f\u0005\u0019\te.\u001f*fM\"A1\u0003\u0001BC\u0002\u0013\u0005A#A\u000bf]ZL'o\u001c8nK:$(+\u001a9pg&$xN]=\u0016\u0003U\u0001\"AF\r\u000e\u0003]Q!\u0001\u0007\u0002\u0002\u0007M\fH.\u0003\u0002\u001b/\t)RI\u001c<je>tW.\u001a8u%\u0016\u0004xn]5u_JL\b\u0002\u0003\u000f\u0001\u0005\u0003\u0005\u000b\u0011B\u000b\u0002-\u0015tg/\u001b:p]6,g\u000e\u001e*fa>\u001c\u0018\u000e^8ss\u0002B\u0001B\b\u0001\u0003\u0006\u0004%\taH\u0001\u001fI\u0016\u0004Hn\\=fI\u0006\u0003\b\u000f\\5dCRLwN\\:SKB|7/\u001b;pef,\u0012\u0001\t\t\u0003-\u0005J!AI\f\u0003CM\u000bH\u000eR3qY>LX\rZ!qa2L7-\u0019;j_:\u001c(+\u001a9pg&$xN]=\t\u0011\u0011\u0002!\u0011!Q\u0001\n\u0001\nq\u0004Z3qY>LX\rZ!qa2L7-\u0019;j_:\u001c(+\u001a9pg&$xN]=!\u0011!1\u0003A!b\u0001\n\u00039\u0013A\u00045pgR\u0014V\r]8tSR|'/_\u000b\u0002QA\u0011a#K\u0005\u0003U]\u0011\u0011cU9m\u0011>\u001cHOU3q_NLGo\u001c:z\u0011!a\u0003A!A!\u0002\u0013A\u0013a\u00045pgR\u0014V\r]8tSR|'/\u001f\u0011\t\u000b9\u0002A\u0011A\u0018\u0002\rqJg.\u001b;?)\u0011\u0001$G\u0011#\u0011\u0005E\u0002Q\"\u0001\u0002\t\u000bMi\u0003\u0019A\u000b)\u0005I\"\u0004CA\u001bA\u001b\u00051$BA\u001c9\u0003)\tgN\\8uCRLwN\u001c\u0006\u0003si\nqAZ1di>\u0014\u0018P\u0003\u0002<y\u0005)!-Z1og*\u0011QHP\u0001\u0010gB\u0014\u0018N\\4ge\u0006lWm^8sW*\tq(A\u0002pe\u001eL!!\u0011\u001c\u0003\u0013\u0005+Ho\\<je\u0016$\u0007\"\u0002\u0010.\u0001\u0004\u0001\u0003F\u0001\"5\u0011\u00151S\u00061\u0001)Q\t!E\u0007C\u0003H\u0001\u0011\u0005\u0001*\u0001\rgS:$G)\u001a9m_f,G-\u00119qY&\u001c\u0017\r^5p]N$R!S0jWB\u00042A\u0013*V\u001d\tY\u0005K\u0004\u0002M\u001f6\tQJ\u0003\u0002O\u0015\u00051AH]8pizJ\u0011aD\u0005\u0003#:\tq\u0001]1dW\u0006<W-\u0003\u0002T)\n!A*[:u\u0015\t\tf\u0002\u0005\u0002W;6\tqK\u0003\u0002Y3\u0006\u0019A\r^8\u000b\u0005i[\u0016aA1qS*\u0011A\fB\u0001\u0007K:<\u0017N\\3\n\u0005y;&aE\"p]\u001aLw-\u001e:bi&|g.\u0013;f[&#\u0007\"\u00021G\u0001\u0004\t\u0017!B3om&#\u0007C\u00012g\u001d\t\u0019G\r\u0005\u0002M\u001d%\u0011QMD\u0001\u0007!J,G-\u001a4\n\u0005\u001dD'AB*ue&twM\u0003\u0002f\u001d!)!N\u0012a\u0001C\u00069\u0001/\u0019;uKJt\u0007\"\u00027G\u0001\u0004i\u0017A\u00029bO&tw\r\u0005\u0002W]&\u0011qn\u0016\u0002\u0007!\u0006<\u0017N\\4\t\u000bE4\u0005\u0019\u0001:\u0002\u000b=\u0014H-\u001a:\u0011\u0005Y\u001b\u0018B\u0001;X\u0005!y%\u000fZ3sS:<\u0007\"\u0002<\u0001\t\u00039\u0018!G2pk:$H)\u001a9m_f,G-\u00119qY&\u001c\u0017\r^5p]N$2\u0001_>}!\ti\u00110\u0003\u0002{\u001d\t\u0019\u0011J\u001c;\t\u000b\u0001,\b\u0019A1\t\u000b),\b\u0019A1\t\u000by\u0004A\u0011A@\u0002\u0013\u0019Lg\u000e\u001a%pgR\u001cHCCA\u0001\u0003\u0013\tY!!\u0004\u0002\u0010A!!JUA\u0002!\r1\u0016QA\u0005\u0004\u0003\u000f9&A\u0004#fa2|\u00170\\3oi&sgm\u001c\u0005\u0006Av\u0004\r!\u0019\u0005\u0006Uv\u0004\r!\u0019\u0005\u0006Yv\u0004\r!\u001c\u0005\u0006cv\u0004\rA\u001d\u0005\b\u0003'\u0001A\u0011AA\u000b\u0003)\u0019w.\u001e8u\u0011>\u001cHo\u001d\u000b\u0006q\u0006]\u0011\u0011\u0004\u0005\u0007A\u0006E\u0001\u0019A1\t\r)\f\t\u00021\u0001bQ\r\u0001\u0011Q\u0004\t\u0005\u0003?\t)#\u0004\u0002\u0002\")\u0019\u00111\u0005\u001f\u0002\u0015M$XM]3pif\u0004X-\u0003\u0003\u0002(\u0005\u0005\"!C\"p[B|g.\u001a8u\u0001")
public class SqlEnvironmentService {
    private final EnvironmentRepository environmentRepository;
    private final SqlDeployedApplicationsRepository deployedApplicationsRepository;
    private final SqlHostRepository hostRepository;

    public EnvironmentRepository environmentRepository() {
        return this.environmentRepository;
    }

    public SqlDeployedApplicationsRepository deployedApplicationsRepository() {
        return this.deployedApplicationsRepository;
    }

    public SqlHostRepository hostRepository() {
        return this.hostRepository;
    }

    public List<ConfigurationItemId> findDeployedApplications(String envId, String pattern, Paging paging, Ordering order) {
        return this.deployedApplicationsRepository().findByEnvironment(envId, pattern, paging, order);
    }

    public int countDeployedApplications(String envId, String pattern) {
        return this.deployedApplicationsRepository().countByEnvironment(envId, pattern);
    }

    public List<DeploymentInfo> findHosts(String envId, String pattern, Paging paging, Ordering order) {
        return this.hostRepository().findByEnvironment(envId, pattern, paging, order);
    }

    public int countHosts(String envId, String pattern) {
        return this.hostRepository().countByEnvironment(envId, pattern);
    }

    public SqlEnvironmentService(@Autowired EnvironmentRepository environmentRepository, @Autowired SqlDeployedApplicationsRepository deployedApplicationsRepository, @Autowired SqlHostRepository hostRepository) {
        this.environmentRepository = environmentRepository;
        this.deployedApplicationsRepository = deployedApplicationsRepository;
        this.hostRepository = hostRepository;
    }
}

