/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.core.rest.websockets;

import com.typesafe.config.Config;
import com.typesafe.config.ConfigFactory;
import com.xebialabs.deployit.ServerConfiguration;
import com.xebialabs.deployit.core.rest.converters.CiMessageConverter;
import com.xebialabs.deployit.core.rest.converters.CisMessageConverter;
import com.xebialabs.deployit.core.rest.json.CiJsonMessageBodyReaderWriter;
import com.xebialabs.deployit.core.rest.json.CisJsonMessageBodyReaderWriter;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.eclipse.jetty.websocket.api.WebSocketBehavior;
import org.eclipse.jetty.websocket.api.WebSocketPolicy;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.messaging.converter.MessageConverter;
import org.springframework.messaging.simp.config.MessageBrokerRegistry;
import org.springframework.scheduling.TaskScheduler;
import org.springframework.web.socket.config.annotation.AbstractWebSocketMessageBrokerConfigurer;
import org.springframework.web.socket.config.annotation.EnableWebSocketMessageBroker;
import org.springframework.web.socket.config.annotation.StompEndpointRegistry;
import org.springframework.web.socket.server.HandshakeHandler;
import org.springframework.web.socket.server.RequestUpgradeStrategy;
import org.springframework.web.socket.server.jetty.JettyRequestUpgradeStrategy;
import org.springframework.web.socket.server.support.DefaultHandshakeHandler;
import scala.reflect.ScalaSignature;

@Configuration
@EnableWebSocketMessageBroker
@ScalaSignature(bytes="\u0006\u0001\u0005=d\u0001B\u0001\u0003\u0001=\u0011AdV3c'>\u001c7.\u001a;NKN\u001c\u0018mZ3Ce>\\WM]\"p]\u001aLwM\u0003\u0002\u0004\t\u0005Qq/\u001a2t_\u000e\\W\r^:\u000b\u0005\u00151\u0011\u0001\u0002:fgRT!a\u0002\u0005\u0002\t\r|'/\u001a\u0006\u0003\u0013)\t\u0001\u0002Z3qY>L\u0018\u000e\u001e\u0006\u0003\u00171\t\u0011\u0002_3cS\u0006d\u0017MY:\u000b\u00035\t1aY8n\u0007\u0001\u0019\"\u0001\u0001\t\u0011\u0005EqR\"\u0001\n\u000b\u0005M!\u0012AC1o]>$\u0018\r^5p]*\u0011QCF\u0001\u0007G>tg-[4\u000b\u0005]A\u0012AB:pG.,GO\u0003\u0002\u001a5\u0005\u0019q/\u001a2\u000b\u0005ma\u0012aD:qe&twM\u001a:b[\u0016<xN]6\u000b\u0003u\t1a\u001c:h\u0013\ty\"C\u0001\u0015BEN$(/Y2u/\u0016\u00147k\\2lKRlUm]:bO\u0016\u0014%o\\6fe\u000e{gNZ5hkJ,'\u000f\u0003\u0005\"\u0001\t\u0005\t\u0015!\u0003#\u0003u\u0019\u0017NS:p]6+7o]1hK\n{G-\u001f*fC\u0012,'o\u0016:ji\u0016\u0014\bCA\u0012'\u001b\u0005!#BA\u0013\u0005\u0003\u0011Q7o\u001c8\n\u0005\u001d\"#!H\"j\u0015N|g.T3tg\u0006<WMQ8esJ+\u0017\rZ3s/JLG/\u001a:)\u0005\u0001J\u0003C\u0001\u00161\u001b\u0005Y#BA\n-\u0015\tic&A\u0004gC\u000e$xN]=\u000b\u0005=R\u0012!\u00022fC:\u001c\u0018BA\u0019,\u0005%\tU\u000f^8xSJ,G\r\u0003\u00054\u0001\t\u0005\t\u0015!\u00035\u0003y\u0019\u0017n\u001d&t_:lUm]:bO\u0016\u0014u\u000eZ=SK\u0006$WM],sSR,'\u000f\u0005\u0002$k%\u0011a\u0007\n\u0002\u001f\u0007&\u001c(j]8o\u001b\u0016\u001c8/Y4f\u0005>$\u0017PU3bI\u0016\u0014xK]5uKJD#AM\u0015\t\u0011e\u0002!\u0011!Q\u0001\ni\nQ\u0002^1tWN\u001b\u0007.\u001a3vY\u0016\u0014\bCA\u001e?\u001b\u0005a$BA\u001f\u001b\u0003)\u00198\r[3ek2LgnZ\u0005\u0003\u007fq\u0012Q\u0002V1tWN\u001b\u0007.\u001a3vY\u0016\u0014\b\u0006\u0002\u001dB\t\u0016\u0003\"A\u000b\"\n\u0005\r[#!C)vC2Lg-[3s\u0003\u00151\u0018\r\\;fC\u00051\u0015aE<fEN|7m[3ugN\u001b\u0007.\u001a3vY\u0016\u0014\bF\u0001\u001d*\u0011\u0015I\u0005\u0001\"\u0001K\u0003\u0019a\u0014N\\5u}Q!1*T(R!\ta\u0005!D\u0001\u0003\u0011\u0015\t\u0003\n1\u0001#Q\ti\u0015\u0006C\u00034\u0011\u0002\u0007A\u0007\u000b\u0002PS!)\u0011\b\u0013a\u0001u!\"\u0011+\u0011#FQ\t\t\u0016\u0006C\u0004V\u0001\t\u0007I\u0011\u0002,\u000295+5kU!H\u000b~\u0013%kT&F%~\u001buJ\u0014$J\u000f~\u0003&+\u0012$J1V\tq\u000b\u0005\u0002Y;6\t\u0011L\u0003\u0002[7\u0006!A.\u00198h\u0015\u0005a\u0016\u0001\u00026bm\u0006L!AX-\u0003\rM#(/\u001b8h\u0011\u0019\u0001\u0007\u0001)A\u0005/\u0006iR*R*T\u0003\u001e+uL\u0011*P\u0017\u0016\u0013vlQ(O\r&;u\f\u0015*F\r&C\u0006\u0005C\u0004c\u0001\t\u0007I\u0011B2\u0002\u0019ML8\u000f^3n\u0007>tg-[4\u0016\u0003\u0011\u0004\"!Z5\u000e\u0003\u0019T!!F4\u000b\u0005!d\u0011\u0001\u0003;za\u0016\u001c\u0018MZ3\n\u0005)4'AB\"p]\u001aLw\r\u0003\u0004m\u0001\u0001\u0006I\u0001Z\u0001\u000egf\u001cH/Z7D_:4\u0017n\u001a\u0011\t\u000b9\u0004A\u0011I8\u0002-\r|gNZ5hkJ,W*Z:tC\u001e,'I]8lKJ$\"\u0001\u001d<\u0011\u0005E$X\"\u0001:\u000b\u0003M\fQa]2bY\u0006L!!\u001e:\u0003\tUs\u0017\u000e\u001e\u0005\u0006o6\u0004\r\u0001_\u0001\te\u0016<\u0017n\u001d;ssB\u0011\u0011p`\u0007\u0002u*\u0011Qc\u001f\u0006\u0003yv\fAa]5na*\u0011aPG\u0001\n[\u0016\u001c8/Y4j]\u001eL1!!\u0001{\u0005UiUm]:bO\u0016\u0014%o\\6feJ+w-[:uefDq!!\u0002\u0001\t\u0003\t9!\u0001\tiC:$7\u000f[1lK\"\u000bg\u000e\u001a7feR\u0011\u0011\u0011\u0002\t\u0005\u0003\u0017\t)\"\u0004\u0002\u0002\u000e)!\u0011qBA\t\u0003\u001d\u0019X\u000f\u001d9peRT1!a\u0005\u0017\u0003\u0019\u0019XM\u001d<fe&!\u0011qCA\u0007\u0005]!UMZ1vYRD\u0015M\u001c3tQ\u0006\\W\rS1oI2,'\u000f\u000b\u0003\u0002\u0004\u0005m\u0001\u0003BA\u000f\u0003Ki!!a\b\u000b\u0007M\t\tCC\u0002\u0002$i\tqaY8oi\u0016DH/\u0003\u0003\u0002(\u0005}!\u0001\u0002\"fC:Dq!a\u000b\u0001\t\u0003\ni#\u0001\fsK\u001eL7\u000f^3s'R|W\u000e]#oIB|\u0017N\u001c;t)\r\u0001\u0018q\u0006\u0005\bo\u0006%\u0002\u0019AA\u0019!\r\t\u00121G\u0005\u0004\u0003k\u0011\"!F*u_6\u0004XI\u001c3q_&tGOU3hSN$(/\u001f\u0005\b\u0003s\u0001A\u0011IA\u001e\u0003i\u0019wN\u001c4jOV\u0014X-T3tg\u0006<WmQ8om\u0016\u0014H/\u001a:t)\u0011\ti$a\u0011\u0011\u0007E\fy$C\u0002\u0002BI\u0014qAQ8pY\u0016\fg\u000e\u0003\u0005\u0002F\u0005]\u0002\u0019AA$\u0003EiWm]:bO\u0016\u001cuN\u001c<feR,'o\u001d\t\u0007\u0003\u0013\ny%a\u0015\u000e\u0005\u0005-#bAA'7\u0006!Q\u000f^5m\u0013\u0011\t\t&a\u0013\u0003\t1K7\u000f\u001e\t\u0005\u0003+\nY&\u0004\u0002\u0002X)\u0019\u0011\u0011L?\u0002\u0013\r|gN^3si\u0016\u0014\u0018\u0002BA/\u0003/\u0012\u0001#T3tg\u0006<WmQ8om\u0016\u0014H/\u001a:)\u0007\u0001\t\t\u0007E\u0002\u0012\u0003GJ1!!\u001a\u0013\u0005q)e.\u00192mK^+'mU8dW\u0016$X*Z:tC\u001e,'I]8lKJD3\u0001AA5!\u0011\ti\"a\u001b\n\t\u00055\u0014q\u0004\u0002\u000e\u0007>tg-[4ve\u0006$\u0018n\u001c8")
public class WebSocketMessageBrokerConfig
extends AbstractWebSocketMessageBrokerConfigurer {
    @Autowired
    private final CiJsonMessageBodyReaderWriter ciJsonMessageBodyReaderWriter;
    @Autowired
    private final CisJsonMessageBodyReaderWriter cisJsonMessageBodyReaderWriter;
    @Autowired
    @Qualifier(value="websocketsScheduler")
    private final TaskScheduler taskScheduler;
    private final String MESSAGE_BROKER_CONFIG_PREFIX;
    private final Config systemConfig;

    private String MESSAGE_BROKER_CONFIG_PREFIX() {
        return this.MESSAGE_BROKER_CONFIG_PREFIX;
    }

    private Config systemConfig() {
        return this.systemConfig;
    }

    public void configureMessageBroker(MessageBrokerRegistry registry) {
        registry.setApplicationDestinationPrefixes(new String[]{"/app"});
        registry.enableSimpleBroker(new String[]{"/topic"}).setTaskScheduler(this.taskScheduler);
    }

    @Bean
    public DefaultHandshakeHandler handshakeHandler() {
        WebSocketPolicy policy = new WebSocketPolicy(WebSocketBehavior.SERVER);
        policy.setInputBufferSize(this.systemConfig().getInt(this.MESSAGE_BROKER_CONFIG_PREFIX() + "input-buffer-size"));
        long idleTimeout = TimeUnit.MINUTES.toMillis(ServerConfiguration.getInstance().getClientSessionTimeoutMinutes());
        policy.setIdleTimeout(idleTimeout);
        return new DefaultHandshakeHandler((RequestUpgradeStrategy)new JettyRequestUpgradeStrategy(policy));
    }

    public void registerStompEndpoints(StompEndpointRegistry registry) {
        registry.addEndpoint(new String[]{"/ws"}).setAllowedOrigins(new String[]{"*"}).setHandshakeHandler((HandshakeHandler)this.handshakeHandler()).withSockJS();
    }

    public boolean configureMessageConverters(List<MessageConverter> messageConverters) {
        messageConverters.add((MessageConverter)new CiMessageConverter(this.ciJsonMessageBodyReaderWriter));
        messageConverters.add((MessageConverter)new CisMessageConverter(this.cisJsonMessageBodyReaderWriter));
        return true;
    }

    public WebSocketMessageBrokerConfig(@Autowired CiJsonMessageBodyReaderWriter ciJsonMessageBodyReaderWriter, @Autowired CisJsonMessageBodyReaderWriter cisJsonMessageBodyReaderWriter, @Autowired @Qualifier(value="websocketsScheduler") TaskScheduler taskScheduler) {
        this.ciJsonMessageBodyReaderWriter = ciJsonMessageBodyReaderWriter;
        this.cisJsonMessageBodyReaderWriter = cisJsonMessageBodyReaderWriter;
        this.taskScheduler = taskScheduler;
        this.MESSAGE_BROKER_CONFIG_PREFIX = "xl.deploy.websockets.message-broker.";
        this.systemConfig = ConfigFactory.load((String)"xl-deploy.conf");
    }
}

