/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.core.rest.api;

import akka.actor.ActorRef;
import akka.actor.AddressFromURIString$;
import akka.pattern.AskableActorRef$;
import akka.util.Timeout;
import com.xebialabs.deployit.core.api.WorkersService;
import com.xebialabs.deployit.core.api.dto.WorkerInfo;
import com.xebialabs.deployit.core.config.XldConfig;
import com.xebialabs.deployit.core.rest.api.WorkerState$;
import com.xebialabs.deployit.core.rest.api.WorkersSorting$;
import com.xebialabs.deployit.core.rest.api.support.PaginationSupport$;
import com.xebialabs.deployit.core.rest.secured.AbstractSecuredResource;
import com.xebialabs.deployit.engine.api.distribution.TaskExecutionWorkerRepository;
import com.xebialabs.deployit.engine.api.dto.Paging;
import com.xebialabs.deployit.engine.api.dto.Worker;
import com.xebialabs.deployit.engine.tasker.distribution.WorkerManager;
import com.xebialabs.deployit.security.permission.PlatformPermissions;
import com.xebialabs.xlplatform.settings.CommonSettings;
import grizzled.slf4j.Logger;
import grizzled.slf4j.Logging;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.stream.Collectors;
import javax.ws.rs.NotFoundException;
import javax.ws.rs.core.Context;
import org.jboss.resteasy.spi.HttpResponse;
import org.slf4j.Marker;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Controller;
import scala.Enumeration;
import scala.Function$;
import scala.Function0;
import scala.Function1;
import scala.Function3;
import scala.Predef$;
import scala.StringContext;
import scala.collection.GenTraversableOnce;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.convert.ImplicitConversions$;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.concurrent.Await$;
import scala.concurrent.Awaitable;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.package;
import scala.concurrent.duration.package$;
import scala.math.Ordering;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;

@Controller
@ScalaSignature(bytes="\u0006\u0001\u0005\u0015g\u0001B\u0001\u0003\u0001=\u0011qbV8sW\u0016\u00148OU3t_V\u00148-\u001a\u0006\u0003\u0007\u0011\t1!\u00199j\u0015\t)a!\u0001\u0003sKN$(BA\u0004\t\u0003\u0011\u0019wN]3\u000b\u0005%Q\u0011\u0001\u00033fa2|\u00170\u001b;\u000b\u0005-a\u0011!\u0003=fE&\fG.\u00192t\u0015\u0005i\u0011aA2p[\u000e\u00011\u0003\u0002\u0001\u0011-m\u0001\"!\u0005\u000b\u000e\u0003IQ!a\u0005\u0003\u0002\u000fM,7-\u001e:fI&\u0011QC\u0005\u0002\u0018\u0003\n\u001cHO]1diN+7-\u001e:fIJ+7o\\;sG\u0016\u0004\"aF\r\u000e\u0003aQ!a\u0001\u0004\n\u0005iA\"AD,pe.,'o]*feZL7-\u001a\t\u00039\u0005j\u0011!\b\u0006\u0003=}\tQa\u001d7gi)T\u0011\u0001I\u0001\tOJL'P\u001f7fI&\u0011!%\b\u0002\b\u0019><w-\u001b8h\u0011!!\u0003A!A!\u0002\u0013)\u0013!D<pe.,'/T1oC\u001e,'\u000f\u0005\u0002'W5\tqE\u0003\u0002)S\u0005)\u0011m\u0019;pe*\t!&\u0001\u0003bW.\f\u0017B\u0001\u0017(\u0005!\t5\r^8s%\u00164\u0007\u0006B\u0012/yu\u0002\"a\f\u001e\u000e\u0003AR!!\r\u001a\u0002\u0015\u0005tgn\u001c;bi&|gN\u0003\u00024i\u00059a-Y2u_JL(BA\u001b7\u0003\u0015\u0011W-\u00198t\u0015\t9\u0004(A\btaJLgn\u001a4sC6,wo\u001c:l\u0015\u0005I\u0014aA8sO&\u00111\b\r\u0002\n#V\fG.\u001b4jKJ\fQA^1mk\u0016\f\u0013\u0001\n\u0015\u0003G}\u0002\"a\f!\n\u0005\u0005\u0003$!C!vi><\u0018N]3e\u0011!\u0019\u0005A!A!\u0002\u0013!\u0015\u0001E<pe.,'OU3q_NLGo\u001c:z!\t)5*D\u0001G\u0015\t9\u0005*\u0001\u0007eSN$(/\u001b2vi&|gN\u0003\u0002\u0004\u0013*\u0011!\nC\u0001\u0007K:<\u0017N\\3\n\u000513%!\b+bg.,\u00050Z2vi&|gnV8sW\u0016\u0014(+\u001a9pg&$xN]=)\u0005\t{\u0004\u0002C(\u0001\u0005\u0003\u0005\u000b\u0011\u0002)\u0002\u0013adGmQ8oM&<\u0007CA)U\u001b\u0005\u0011&BA*\u0007\u0003\u0019\u0019wN\u001c4jO&\u0011QK\u0015\u0002\n12$7i\u001c8gS\u001eD#AT \t\u000ba\u0003A\u0011A-\u0002\rqJg.\u001b;?)\u0011QFlX1\u0011\u0005m\u0003Q\"\u0001\u0002\t\u000b\u0011:\u0006\u0019A\u0013)\tqsC(\u0010\u0015\u00039~BQaQ,A\u0002\u0011C#aX \t\u000b=;\u0006\u0019\u0001))\u0005\u0005|\u0004b\u00023\u0001\u0005\u0004%Y!Z\u0001\bi&lWm\\;u+\u00051\u0007CA4k\u001b\u0005A'BA5*\u0003\u0011)H/\u001b7\n\u0005-D'a\u0002+j[\u0016|W\u000f\u001e\u0005\u0007[\u0002\u0001\u000b\u0011\u00024\u0002\u0011QLW.Z8vi\u0002Bqa\u001c\u0001C\u0002\u0013\u0005\u0001/\u0001\u0007iiR\u0004(+Z:q_:\u001cX-F\u0001r!\t\u0011\u00180D\u0001t\u0015\t!X/A\u0002ta&T!A^<\u0002\u0011I,7\u000f^3bgfT!\u0001\u001f\u001d\u0002\u000b)\u0014wn]:\n\u0005i\u001c(\u0001\u0004%uiB\u0014Vm\u001d9p]N,\u0007B\u0002?\u0001A\u0003%\u0011/A\u0007iiR\u0004(+Z:q_:\u001cX\r\t\u0015\u0003wz\u00042a`A\b\u001b\t\t\tAC\u0002\b\u0003\u0007QA!!\u0002\u0002\b\u0005\u0011!o\u001d\u0006\u0005\u0003\u0013\tY!\u0001\u0002xg*\u0011\u0011QB\u0001\u0006U\u00064\u0018\r_\u0005\u0005\u0003#\t\tAA\u0004D_:$X\r\u001f;\t\u000f\u0005U\u0001\u0001\"\u0011\u0002\u0018\u0005y1\u000f[;uI><hnV8sW\u0016\u00148\u000f\u0006\u0003\u0002\u001a\u0005\u0015\u0002\u0003BA\u000e\u0003Ci!!!\b\u000b\u0005\u0005}\u0011!B:dC2\f\u0017\u0002BA\u0012\u0003;\u0011A!\u00168ji\"A\u0011qEA\n\u0001\u0004\tI#A\u0004x_J\\WM]:\u0011\r\u0005-\u00121GA\u001c\u001b\t\tiCC\u0002j\u0003_Q!!!\r\u0002\t)\fg/Y\u0005\u0005\u0003k\tiC\u0001\u0003MSN$\b\u0003BA\u001d\u0003\u000frA!a\u000f\u0002DA!\u0011QHA\u000f\u001b\t\tyDC\u0002\u0002B9\ta\u0001\u0010:p_Rt\u0014\u0002BA#\u0003;\ta\u0001\u0015:fI\u00164\u0017\u0002BA%\u0003\u0017\u0012aa\u0015;sS:<'\u0002BA#\u0003;Aq!a\u0014\u0001\t\u0003\n\t&\u0001\btQV$Hm\\<o/>\u00148.\u001a:\u0015\t\u0005e\u00111\u000b\u0005\t\u0003+\ni\u00051\u0001\u0002X\u0005Aqo\u001c:lKJLE\r\u0005\u0003\u0002Z\u0005}SBAA.\u0015\u0011\ti&a\f\u0002\t1\fgnZ\u0005\u0005\u0003C\nYFA\u0004J]R,w-\u001a:\t\u000f\u0005\u0015\u0004\u0001\"\u0003\u0002h\u0005i\u0011n\u001d'pG\u0006dwk\u001c:lKJ$B!!\u001b\u0002pA!\u00111DA6\u0013\u0011\ti'!\b\u0003\u000f\t{w\u000e\\3b]\"A\u0011\u0011OA2\u0001\u0004\t9$A\u0004bI\u0012\u0014Xm]:\t\u000f\u0005U\u0004\u0001\"\u0003\u0002x\u0005)B\u000f\u001b:po2{7-\u00197X_J\\WM]#se>\u0014H\u0003BA=\u0003\u007f\u0002B!a\u0007\u0002|%!\u0011QPA\u000f\u0005\u001dqu\u000e\u001e5j]\u001eD\u0001\"!!\u0002t\u0001\u0007\u0011qG\u0001\u0002g\"9\u0011Q\u0011\u0001\u0005B\u0005\u001d\u0015\u0001\u0004:f[>4XmV8sW\u0016\u0014H\u0003BA\r\u0003\u0013C\u0001\"!\u0016\u0002\u0004\u0002\u0007\u0011q\u000b\u0005\b\u0003\u001b\u0003A\u0011IAH\u0003-a\u0017n\u001d;X_J\\WM]:\u0015\r\u0005E\u0015qTAW!\u0019\tY#a\r\u0002\u0014B!\u0011QSAN\u001b\t\t9JC\u0002\u0002\u001ab\t1\u0001\u001a;p\u0013\u0011\ti*a&\u0003\u0015]{'o[3s\u0013:4w\u000e\u0003\u0005\u0002\"\u0006-\u0005\u0019AAR\u0003\u0019\u0001\u0018mZ5oOB!\u0011QUAU\u001b\t\t9KC\u0002\u0002\u001a\"KA!a+\u0002(\n1\u0001+Y4j]\u001eD\u0001\"a,\u0002\f\u0002\u0007\u0011\u0011W\u0001\u0006_J$WM\u001d\t\u0005\u0003K\u000b\u0019,\u0003\u0003\u00026\u0006\u001d&\u0001C(sI\u0016\u0014\u0018N\\4)\u0007\u0001\tI\f\u0005\u0003\u0002<\u0006\u0005WBAA_\u0015\r\tyLN\u0001\u000bgR,'/Z8usB,\u0017\u0002BAb\u0003{\u0013!bQ8oiJ|G\u000e\\3s\u0001")
public class WorkersResource
extends AbstractSecuredResource
implements WorkersService,
Logging {
    @Autowired
    @Qualifier(value="workerManager")
    private final ActorRef workerManager;
    @Autowired
    private final TaskExecutionWorkerRepository workerRepository;
    private final Timeout timeout;
    @Context
    private final HttpResponse httpResponse;
    private Logger grizzled$slf4j$Logging$$_logger;
    private volatile boolean bitmap$0;

    public Logger logger() {
        return Logging.logger$((Logging)this);
    }

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void trace(Function0<Object> msg) {
        Logging.trace$((Logging)this, msg);
    }

    public void trace(Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, msg, t);
    }

    public void trace(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$((Logging)this);
    }

    public void debug(Function0<Object> msg) {
        Logging.debug$((Logging)this, msg);
    }

    public void debug(Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, msg, t);
    }

    public void debug(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isErrorEnabled() {
        return Logging.isErrorEnabled$((Logging)this);
    }

    public void error(Function0<Object> msg) {
        Logging.error$((Logging)this, msg);
    }

    public void error(Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, msg, t);
    }

    public void error(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isInfoEnabled() {
        return Logging.isInfoEnabled$((Logging)this);
    }

    public void info(Function0<Object> msg) {
        Logging.info$((Logging)this, msg);
    }

    public void info(Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, msg, t);
    }

    public void info(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isWarnEnabled() {
        return Logging.isWarnEnabled$((Logging)this);
    }

    public void warn(Function0<Object> msg) {
        Logging.warn$((Logging)this, msg);
    }

    public void warn(Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, msg, t);
    }

    public void warn(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, (Marker)mkr, msg, t);
    }

    private Logger grizzled$slf4j$Logging$$_logger$lzycompute() {
        WorkersResource workersResource = this;
        synchronized (workersResource) {
            if (!this.bitmap$0) {
                this.grizzled$slf4j$Logging$$_logger = Logging.grizzled$slf4j$Logging$$_logger$((Logging)this);
                this.bitmap$0 = true;
            }
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    public Logger grizzled$slf4j$Logging$$_logger() {
        return !this.bitmap$0 ? this.grizzled$slf4j$Logging$$_logger$lzycompute() : this.grizzled$slf4j$Logging$$_logger;
    }

    private Timeout timeout() {
        return this.timeout;
    }

    public HttpResponse httpResponse() {
        return this.httpResponse;
    }

    public void shutdownWorkers(java.util.List<String> workers) {
        this.checkPermission(PlatformPermissions.ADMIN);
        if (workers.isEmpty()) {
            this.logger().info((Function0 & Serializable & scala.Serializable)() -> "Shutting down all workers.");
        } else {
            this.logger().info((Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Shutting down workers ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{workers})));
        }
        ImplicitConversions$.MODULE$.list$u0020asScalaBuffer(workers).find((Function1 & Serializable & scala.Serializable)address -> BoxesRunTime.boxToBoolean((boolean)this.isLocalWorker(address))).foreach((Function1 & Serializable & scala.Serializable)s -> this.throwLocalWorkerError((String)s));
        ((List)this.workerRepository.listWorkers().map((Function1 & Serializable & scala.Serializable)x$1 -> (Worker)x$1._1(), List$.MODULE$.canBuildFrom())).foreach((Function1 & Serializable & scala.Serializable)worker -> {
            WorkersResource.$anonfun$shutdownWorkers$6(this, workers, worker);
            return BoxedUnit.UNIT;
        });
        ActorRef qual$1 = akka.pattern.package$.MODULE$.ask(this.workerManager);
        WorkerManager.messages$.ShutdownWorker x$6 = new WorkerManager.messages$.ShutdownWorker(((TraversableOnce)JavaConverters$.MODULE$.asScalaBufferConverter(workers).asScala()).toList(), true);
        Timeout x$7 = this.timeout();
        ActorRef x$8 = AskableActorRef$.MODULE$.$qmark$default$3$extension(qual$1, (Object)x$6);
        WorkerManager.messages$.WorkerShutdownStarted response = (WorkerManager.messages$.WorkerShutdownStarted)Await$.MODULE$.result((Awaitable)AskableActorRef$.MODULE$.$qmark$extension1(qual$1, (Object)x$6, x$7, x$8), (Duration)this.timeout().duration());
        if (!workers.isEmpty()) {
            List shutdownWorkers = response.workers();
            this.logger().info((Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Workers ", " shutdown."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{shutdownWorkers.mkString("[", ", ", "]")})));
            ArrayList<String> notFound = new ArrayList<String>(workers);
            notFound.removeAll((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)shutdownWorkers).asJava());
            if (!notFound.isEmpty()) {
                throw new NotFoundException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Workers ", " not found. (Workers ", " shutdown.)"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{ImplicitConversions$.MODULE$.list$u0020asScalaBuffer(notFound).mkString("[", ", ", "]"), shutdownWorkers.mkString("[", ", ", "]")})));
            }
        }
    }

    public void shutdownWorker(Integer workerId) {
        this.checkPermission(PlatformPermissions.ADMIN);
        this.workerRepository.getWorker(workerId).orElse((Function0 & Serializable & scala.Serializable)() -> {
            throw new NotFoundException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Worker for id ", " not found."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{workerId})));
        }).foreach((Function1 & Serializable & scala.Serializable)worker -> {
            WorkersResource.$anonfun$shutdownWorker$2(this, worker);
            return BoxedUnit.UNIT;
        });
    }

    private boolean isLocalWorker(String address) {
        return AddressFromURIString$.MODULE$.apply(address).hasLocalScope();
    }

    private Nothing$ throwLocalWorkerError(String s) {
        throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Local worker (", ") cannot be shutdown."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{s})));
    }

    public void removeWorker(Integer workerId) {
        this.checkPermission(PlatformPermissions.ADMIN);
        this.workerRepository.getWorker(workerId).orElse((Function0 & Serializable & scala.Serializable)() -> {
            throw new NotFoundException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Worker for id ", " not found."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{workerId})));
        }).foreach((Function1 & Serializable & scala.Serializable)worker -> {
            WorkersResource.$anonfun$removeWorker$2(this, workerId, worker);
            return BoxedUnit.UNIT;
        });
    }

    public java.util.List<WorkerInfo> listWorkers(Paging paging, com.xebialabs.deployit.engine.api.dto.Ordering order) {
        java.util.List list;
        this.checkPermission(PlatformPermissions.ADMIN);
        Timeout timeout = new Timeout(new package.DurationInt(package$.MODULE$.DurationInt(10)).seconds());
        ActorRef qual$4 = akka.pattern.package$.MODULE$.ask(this.workerManager);
        WorkerManager.messages$.FetchWorkers x$15 = new WorkerManager.messages$.FetchWorkers();
        Timeout x$16 = timeout;
        ActorRef x$17 = AskableActorRef$.MODULE$.$qmark$default$3$extension(qual$4, (Object)x$15);
        WorkerManager.messages.WorkersFetched response = (WorkerManager.messages.WorkersFetched)Await$.MODULE$.result((Awaitable)AskableActorRef$.MODULE$.$qmark$extension1(qual$4, (Object)x$15, x$16, x$17), (Duration)timeout.duration());
        List workers = (List)this.workerRepository.listWorkers().map(Function$.MODULE$.tupled((Function3 & Serializable & scala.Serializable)(w, deploymentTasks, controlTasks) -> new WorkerInfo(Predef$.MODULE$.Integer2int(w.id()), w.name(), w.address(), WorkersResource.calculateState$1(w, response.healthy(), response.incompatible(), response.draining()).toString(), Predef$.MODULE$.Integer2int(deploymentTasks), Predef$.MODULE$.Integer2int(controlTasks))), List$.MODULE$.canBuildFrom());
        if ((paging == null || paging.resultsPerPage() == -1) && order == null) {
            list = ((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)workers.sortBy((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToInteger((int)x$2.getId()), (Ordering)Ordering.Int$.MODULE$)).asJava()).stream().collect(Collectors.toList());
        } else {
            PaginationSupport$.MODULE$.addTotalCountHeader((long)workers.size(), this.httpResponse());
            int from = (paging.page() - 1) * paging.resultsPerPage();
            int to = from + paging.resultsPerPage() <= ImplicitConversions$.MODULE$.seq$u0020AsJavaList((Seq)workers).size() ? from + paging.resultsPerPage() : ImplicitConversions$.MODULE$.seq$u0020AsJavaList((Seq)workers).size();
            list = ImplicitConversions$.MODULE$.seq$u0020AsJavaList((Seq)WorkersSorting$.MODULE$.sort((List<WorkerInfo>)workers, order).slice(from, to));
        }
        return list;
    }

    public static final /* synthetic */ void $anonfun$shutdownWorkers$6(WorkersResource $this, java.util.List workers$1, Worker worker) {
        block0: {
            if (!workers$1.isEmpty() && !workers$1.contains(worker.address())) break block0;
            $this.workerRepository.removeTasks(worker.id());
        }
    }

    public static final /* synthetic */ void $anonfun$shutdownWorker$2(WorkersResource $this, Worker worker) {
        String address = worker.address();
        if ($this.isLocalWorker(address)) {
            throw $this.throwLocalWorkerError(address);
        }
        ActorRef qual$2 = akka.pattern.package$.MODULE$.ask($this.workerManager);
        WorkerManager.messages$.ShutdownWorker x$9 = new WorkerManager.messages$.ShutdownWorker(List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{address})), false);
        Timeout x$10 = $this.timeout();
        ActorRef x$11 = AskableActorRef$.MODULE$.$qmark$default$3$extension(qual$2, (Object)x$9);
        WorkerManager.messages$.WorkerShutdownStarted response = (WorkerManager.messages$.WorkerShutdownStarted)Await$.MODULE$.result((Awaitable)AskableActorRef$.MODULE$.$qmark$extension1(qual$2, (Object)x$9, x$10, x$11), (Duration)$this.timeout().duration());
        List shutdownWorkers = response.workers();
        $this.logger().info((Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Workers ", " shutdown."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{shutdownWorkers.mkString("[", ", ", "]")})));
        if (!response.workers().contains((Object)address)) {
            throw new NotFoundException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Worker ", " not found."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{address})));
        }
    }

    public static final /* synthetic */ void $anonfun$removeWorker$2(WorkersResource $this, Integer workerId$2, Worker worker) {
        ActorRef x$14;
        Timeout x$13;
        WorkerManager.messages$.FetchWorkers x$12;
        ActorRef qual$3 = akka.pattern.package$.MODULE$.ask($this.workerManager);
        WorkerManager.messages.WorkersFetched response = (WorkerManager.messages.WorkersFetched)Await$.MODULE$.result((Awaitable)AskableActorRef$.MODULE$.$qmark$extension1(qual$3, (Object)(x$12 = new WorkerManager.messages$.FetchWorkers()), x$13 = $this.timeout(), x$14 = AskableActorRef$.MODULE$.$qmark$default$3$extension(qual$3, (Object)x$12)), (Duration)$this.timeout().duration());
        List active = (List)response.draining().$plus$plus((GenTraversableOnce)response.healthy(), List$.MODULE$.canBuildFrom());
        if (active.contains((Object)worker.address())) {
            throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Worker for id ", " is still active, cannot be removed."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{workerId$2})));
        }
        $this.workerRepository.removeTasks(workerId$2);
        $this.workerRepository.removeWorker(workerId$2);
    }

    private static final Enumeration.Value calculateState$1(Worker w, List healthy, List incompatible, List draining) {
        return healthy.contains((Object)w.address()) ? WorkerState$.MODULE$.CONNECTED() : (incompatible.contains((Object)w.address()) ? WorkerState$.MODULE$.INCOMPATIBLE() : (draining.contains((Object)w.address()) ? WorkerState$.MODULE$.DRAINING() : WorkerState$.MODULE$.DISCONNECTED()));
    }

    public WorkersResource(@Autowired @Qualifier(value="workerManager") ActorRef workerManager, @Autowired TaskExecutionWorkerRepository workerRepository, @Autowired XldConfig xldConfig) {
        this.workerManager = workerManager;
        this.workerRepository = workerRepository;
        Logging.$init$((Logging)this);
        this.timeout = new CommonSettings(xldConfig.rootConfig()).tasker().askTimeout();
        this.httpResponse = null;
    }
}

