/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.core.rest.api;

import akka.actor.ActorRef;
import akka.actor.ActorSystem;
import akka.pattern.AskableActorRef$;
import akka.util.Timeout;
import com.xebialabs.deployit.core.rest.secured.AbstractSecuredResource;
import com.xebialabs.deployit.engine.api.SatelliteService;
import com.xebialabs.deployit.engine.api.dto.ConfigurationItemId;
import com.xebialabs.deployit.engine.api.dto.Ordering;
import com.xebialabs.deployit.engine.api.dto.Paging;
import com.xebialabs.deployit.engine.api.dto.Paging$;
import com.xebialabs.deployit.engine.api.dto.SatelliteInfo;
import com.xebialabs.deployit.engine.tasker.satellite.ActorLocator;
import com.xebialabs.deployit.engine.tasker.satellite.ActorLocator$;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.plugin.satellite.ExtensionsDelta$;
import com.xebialabs.deployit.plugin.satellite.InstalledExtensionsDelta;
import com.xebialabs.deployit.plugin.satellite.SatelliteInfoChecker;
import com.xebialabs.deployit.plugin.satellite.SatelliteInfoChecker$;
import com.xebialabs.deployit.plugin.satellite.extension.ExtensionsLocator;
import com.xebialabs.deployit.plugin.satellite.extension.FileSystemExtensionsLocator$;
import com.xebialabs.deployit.repository.RepositoryService;
import com.xebialabs.deployit.repository.SqlSatelliteService;
import com.xebialabs.deployit.security.permission.PlatformPermissions;
import com.xebialabs.deployit.tasksystem.TaskActorSystem$;
import com.xebialabs.satellite.protocol.Paths$;
import com.xebialabs.xlplatform.satellite.Satellite;
import com.xebialabs.xlplatform.settings.CommonSettings;
import com.xebialabs.xlplatform.settings.CommonSettings$;
import grizzled.slf4j.Logger;
import grizzled.slf4j.Logging;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.util.List;
import javax.ws.rs.core.Context;
import org.jboss.resteasy.spi.HttpResponse;
import org.slf4j.Marker;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.PartialFunction;
import scala.Predef$;
import scala.Some;
import scala.StringContext;
import scala.collection.Seq;
import scala.concurrent.Await$;
import scala.concurrent.Awaitable;
import scala.concurrent.ExecutionContext;
import scala.concurrent.ExecutionContextExecutor;
import scala.concurrent.Future;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.FiniteDuration;
import scala.concurrent.duration.package;
import scala.concurrent.duration.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;

@Service
@ScalaSignature(bytes="\u0006\u0001\u00055f\u0001B\u0001\u0003\u0001=\u0011AcU1uK2d\u0017\u000e^3TKJ4\u0018nY3J[Bd'BA\u0002\u0005\u0003\r\t\u0007/\u001b\u0006\u0003\u000b\u0019\tAA]3ti*\u0011q\u0001C\u0001\u0005G>\u0014XM\u0003\u0002\n\u0015\u0005AA-\u001a9m_fLGO\u0003\u0002\f\u0019\u0005I\u00010\u001a2jC2\f'm\u001d\u0006\u0002\u001b\u0005\u00191m\\7\u0004\u0001M!\u0001\u0001\u0005\f\u001e!\t\tB#D\u0001\u0013\u0015\t\u0019B!A\u0004tK\u000e,(/\u001a3\n\u0005U\u0011\"aF!cgR\u0014\u0018m\u0019;TK\u000e,(/\u001a3SKN|WO]2f!\t92$D\u0001\u0019\u0015\t\u0019\u0011D\u0003\u0002\u001b\u0011\u00051QM\\4j]\u0016L!\u0001\b\r\u0003!M\u000bG/\u001a7mSR,7+\u001a:wS\u000e,\u0007C\u0001\u0010$\u001b\u0005y\"B\u0001\u0011\"\u0003\u0015\u0019HN\u001a\u001bk\u0015\u0005\u0011\u0013\u0001C4sSjTH.\u001a3\n\u0005\u0011z\"a\u0002'pO\u001eLgn\u001a\u0005\tM\u0001\u0011\t\u0011)A\u0005O\u0005\t\"/\u001a9pg&$xN]=TKJ4\u0018nY3\u0011\u0005!ZS\"A\u0015\u000b\u0005)B\u0011A\u0003:fa>\u001c\u0018\u000e^8ss&\u0011A&\u000b\u0002\u0012%\u0016\u0004xn]5u_JL8+\u001a:wS\u000e,\u0007\u0002\u0003\u0018\u0001\u0005\u0003\u0005\u000b\u0011B\u0018\u0002'M\fHnU1uK2d\u0017\u000e^3TKJ4\u0018nY3\u0011\u0005!\u0002\u0014BA\u0019*\u0005M\u0019\u0016\u000f\\*bi\u0016dG.\u001b;f'\u0016\u0014h/[2f\u0011\u0015\u0019\u0004\u0001\"\u00015\u0003\u0019a\u0014N\\5u}Q\u0019Qg\u000e\u001d\u0011\u0005Y\u0002Q\"\u0001\u0002\t\u000b\u0019\u0012\u0004\u0019A\u0014\t\u000b9\u0012\u0004\u0019A\u0018)\u0005IR\u0004CA\u001eG\u001b\u0005a$BA\u001f?\u0003)\tgN\\8uCRLwN\u001c\u0006\u0003\u007f\u0001\u000bqAZ1di>\u0014\u0018P\u0003\u0002B\u0005\u0006)!-Z1og*\u00111\tR\u0001\u0010gB\u0014\u0018N\\4ge\u0006lWm^8sW*\tQ)A\u0002pe\u001eL!a\u0012\u001f\u0003\u0013\u0005+Ho\\<je\u0016$\u0007bB%\u0001\u0005\u0004%\tAS\u0001\te\u0016\u001c\bo\u001c8tKV\t1\n\u0005\u0002M'6\tQJ\u0003\u0002O\u001f\u0006\u00191\u000f]5\u000b\u0005A\u000b\u0016\u0001\u0003:fgR,\u0017m]=\u000b\u0005I#\u0015!\u00026c_N\u001c\u0018B\u0001+N\u00051AE\u000f\u001e9SKN\u0004xN\\:f\u0011\u00191\u0006\u0001)A\u0005\u0017\u0006I!/Z:q_:\u001cX\r\t\u0015\u0003+b\u0003\"!W1\u000e\u0003iS!aB.\u000b\u0005qk\u0016A\u0001:t\u0015\tqv,\u0001\u0002xg*\t\u0001-A\u0003kCZ\f\u00070\u0003\u0002c5\n91i\u001c8uKb$\b\"\u00023\u0001\t\u0003)\u0017A\u00053fM\u0006,H\u000e\u001e)j]\u001e$\u0016.\\3pkR$\"A\u001a9\u0011\u0005\u001dtW\"\u00015\u000b\u0005%T\u0017\u0001\u00033ve\u0006$\u0018n\u001c8\u000b\u0005-d\u0017AC2p]\u000e,(O]3oi*\tQ.A\u0003tG\u0006d\u0017-\u0003\u0002pQ\nqa)\u001b8ji\u0016$UO]1uS>t\u0007\"B9d\u0001\u0004\u0011\u0018a\u0004;bg.\f5\r^8s'f\u001cH/Z7\u0011\u0005MDX\"\u0001;\u000b\u0005U4\u0018!B1di>\u0014(\"A<\u0002\t\u0005\\7.Y\u0005\u0003sR\u00141\"Q2u_J\u001c\u0016p\u001d;f[\"91\u0010\u0001b\u0001\n\u0007a\u0018aC1di>\u00148+_:uK6,\u0012A\u001d\u0005\u0007}\u0002\u0001\u000b\u0011\u0002:\u0002\u0019\u0005\u001cGo\u001c:TsN$X-\u001c\u0011\t\u0013\u0005\u0005\u0001A1A\u0005\u0004\u0005\r\u0011A\u00033jgB\fGo\u00195feV\u0011\u0011Q\u0001\t\u0005\u0003\u000f\tI!D\u0001k\u0013\r\tYA\u001b\u0002\u0019\u000bb,7-\u001e;j_:\u001cuN\u001c;fqR,\u00050Z2vi>\u0014\b\u0002CA\b\u0001\u0001\u0006I!!\u0002\u0002\u0017\u0011L7\u000f]1uG\",'\u000f\t\u0005\b\u0003'\u0001A\u0011AA\u000b\u0003\u001d9W\r^%oM>$B!a\u0006\u0002$A!\u0011\u0011DA\u0010\u001b\t\tYBC\u0002\u0002\u001ea\t1\u0001\u001a;p\u0013\u0011\t\t#a\u0007\u0003\u001bM\u000bG/\u001a7mSR,\u0017J\u001c4p\u0011!\t)#!\u0005A\u0002\u0005\u001d\u0012\u0001B2j\u0013\u0012\u0004B!!\u000b\u000289!\u00111FA\u001a!\r\ti\u0003\\\u0007\u0003\u0003_Q1!!\r\u000f\u0003\u0019a$o\\8u}%\u0019\u0011Q\u00077\u0002\rA\u0013X\rZ3g\u0013\u0011\tI$a\u000f\u0003\rM#(/\u001b8h\u0015\r\t)\u0004\u001c\u0005\b\u0003\u007f\u0001A\u0011BA!\u0003A\t'/\u001a)mk\u001eLgn]*z]\u000e,G\r\u0006\u0003\u0002D\u0005E\u0003CBA#\u0003\u000f\nY%D\u0001m\u0013\r\tI\u0005\u001c\u0002\u0007\u001fB$\u0018n\u001c8\u0011\t\u0005\u0015\u0013QJ\u0005\u0004\u0003\u001fb'a\u0002\"p_2,\u0017M\u001c\u0005\t\u0003K\ti\u00041\u0001\u0002(!9\u0011Q\u000b\u0001\u0005B\u0005]\u0013!\u00037jgRDun\u001d;t))\tI&a\u001c\u0002r\u0005U\u0014q\u0010\t\u0007\u00037\n)'!\u001b\u000e\u0005\u0005u#\u0002BA0\u0003C\nA!\u001e;jY*\u0011\u00111M\u0001\u0005U\u00064\u0018-\u0003\u0003\u0002h\u0005u#\u0001\u0002'jgR\u0004B!!\u0007\u0002l%!\u0011QNA\u000e\u0005M\u0019uN\u001c4jOV\u0014\u0018\r^5p]&#X-\\%e\u0011!\t)#a\u0015A\u0002\u0005\u001d\u0002\u0002CA:\u0003'\u0002\r!a\n\u0002\t9\fW.\u001a\u0005\t\u0003o\n\u0019\u00061\u0001\u0002z\u00051\u0001/Y4j]\u001e\u0004B!!\u0007\u0002|%!\u0011QPA\u000e\u0005\u0019\u0001\u0016mZ5oO\"A\u0011\u0011QA*\u0001\u0004\t\u0019)A\u0003pe\u0012,'\u000f\u0005\u0003\u0002\u001a\u0005\u0015\u0015\u0002BAD\u00037\u0011\u0001b\u0014:eKJLgn\u001a\u0005\b\u0003\u0017\u0003A\u0011IAG\u0003)\u0019w.\u001e8u\u0011>\u001cHo\u001d\u000b\u0007\u0003\u001f\u000bY*!(\u0011\t\u0005E\u0015qS\u0007\u0003\u0003'SA!!&\u0002b\u0005!A.\u00198h\u0013\u0011\tI*a%\u0003\u000f%sG/Z4fe\"A\u0011QEAE\u0001\u0004\t9\u0003\u0003\u0005\u0002t\u0005%\u0005\u0019AA\u0014Q\r\u0001\u0011\u0011\u0015\t\u0005\u0003G\u000bI+\u0004\u0002\u0002&*\u0019\u0011q\u0015\"\u0002\u0015M$XM]3pif\u0004X-\u0003\u0003\u0002,\u0006\u0015&aB*feZL7-\u001a")
public class SatelliteServiceImpl
extends AbstractSecuredResource
implements SatelliteService,
Logging {
    private final RepositoryService repositoryService;
    private final SqlSatelliteService sqlSatelliteService;
    @Context
    private final HttpResponse response;
    private final ActorSystem actorSystem;
    private final ExecutionContextExecutor dispatcher;
    private Logger grizzled$slf4j$Logging$$_logger;
    private volatile boolean bitmap$0;

    public Logger logger() {
        return Logging.logger$((Logging)this);
    }

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void trace(Function0<Object> msg) {
        Logging.trace$((Logging)this, msg);
    }

    public void trace(Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, msg, t);
    }

    public void trace(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$((Logging)this);
    }

    public void debug(Function0<Object> msg) {
        Logging.debug$((Logging)this, msg);
    }

    public void debug(Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, msg, t);
    }

    public void debug(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isErrorEnabled() {
        return Logging.isErrorEnabled$((Logging)this);
    }

    public void error(Function0<Object> msg) {
        Logging.error$((Logging)this, msg);
    }

    public void error(Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, msg, t);
    }

    public void error(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isInfoEnabled() {
        return Logging.isInfoEnabled$((Logging)this);
    }

    public void info(Function0<Object> msg) {
        Logging.info$((Logging)this, msg);
    }

    public void info(Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, msg, t);
    }

    public void info(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isWarnEnabled() {
        return Logging.isWarnEnabled$((Logging)this);
    }

    public void warn(Function0<Object> msg) {
        Logging.warn$((Logging)this, msg);
    }

    public void warn(Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, msg, t);
    }

    public void warn(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, (Marker)mkr, msg, t);
    }

    private Logger grizzled$slf4j$Logging$$_logger$lzycompute() {
        SatelliteServiceImpl satelliteServiceImpl = this;
        synchronized (satelliteServiceImpl) {
            if (!this.bitmap$0) {
                this.grizzled$slf4j$Logging$$_logger = Logging.grizzled$slf4j$Logging$$_logger$((Logging)this);
                this.bitmap$0 = true;
            }
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    public Logger grizzled$slf4j$Logging$$_logger() {
        return !this.bitmap$0 ? this.grizzled$slf4j$Logging$$_logger$lzycompute() : this.grizzled$slf4j$Logging$$_logger;
    }

    public HttpResponse response() {
        return this.response;
    }

    public FiniteDuration defaultPingTimeout(ActorSystem taskActorSystem) {
        return ((CommonSettings)CommonSettings$.MODULE$.apply(taskActorSystem)).satellite().infoTimeout().duration();
    }

    public ActorSystem actorSystem() {
        return this.actorSystem;
    }

    public ExecutionContextExecutor dispatcher() {
        return this.dispatcher;
    }

    public SatelliteInfo getInfo(String ciId) {
        Timeout timeout = new Timeout(this.defaultPingTimeout(this.actorSystem()));
        ConfigurationItem ci = this.repositoryService.read(ciId);
        if (!ci.getType().instanceOf(Type.valueOf((String)"xl.Satellite"))) {
            return null;
        }
        Satellite satellite = (Satellite)ci;
        ActorLocator actorLocator = ActorLocator$.MODULE$.apply(satellite);
        ActorRef checker = TaskActorSystem$.MODULE$.actorSystem().actorOf(SatelliteInfoChecker$.MODULE$.props(satellite.getAddress()));
        ActorRef qual$1 = akka.pattern.package$.MODULE$.ask(checker);
        SatelliteInfoChecker.Get x$1 = new SatelliteInfoChecker.Get(actorLocator.locate(Paths$.MODULE$.info(), this.actorSystem()));
        Timeout x$2 = timeout;
        ActorRef x$3 = AskableActorRef$.MODULE$.$qmark$default$3$extension(qual$1, (Object)x$1);
        Future future = AskableActorRef$.MODULE$.$qmark$extension1(qual$1, (Object)x$1, x$2, x$3).recover((PartialFunction)new scala.Serializable(this, satellite){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SatelliteServiceImpl $outer;
            private final Satellite satellite$1;

            public final <A1 extends Throwable, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                A1 A1 = x1;
                this.$outer.logger().debug((Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Operation failed on satellite ", " (", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{$this.satellite$1.getAddress(), A1.getMessage()})));
                SatelliteInfo satelliteInfo = new SatelliteInfo();
                return (B1)satelliteInfo;
            }

            public final boolean isDefinedAt(Throwable x1) {
                Throwable throwable = x1;
                boolean bl = true;
                return bl;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.satellite$1 = satellite$1;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$applyOrElse$1(com.xebialabs.deployit.core.rest.api.SatelliteServiceImpl$$anonfun$1 java.lang.Throwable )}, serializedLambda);
            }
        }, (ExecutionContext)this.dispatcher());
        SatelliteInfo satelliteInfo = (SatelliteInfo)Await$.MODULE$.result((Awaitable)future, package.DoubleMult$.MODULE$.$times$extension(package$.MODULE$.DoubleMult(1.5), (Duration)this.defaultPingTimeout(this.actorSystem())));
        Option<Object> option = this.arePluginsSynced(ci.getId());
        if (option instanceof Some) {
            BoxedUnit boxedUnit;
            Some some = (Some)option;
            boolean pluginSync = BoxesRunTime.unboxToBoolean((Object)some.value());
            if (Predef$.MODULE$.Boolean2boolean(satelliteInfo.isAvailable())) {
                satelliteInfo.setPluginsSynced(Predef$.MODULE$.boolean2Boolean(pluginSync));
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            BoxedUnit boxedUnit2 = boxedUnit;
        } else if (None$.MODULE$.equals(option)) {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            throw new MatchError(option);
        }
        satelliteInfo.setSatelliteId(ciId);
        return satelliteInfo;
    }

    private Option<Object> arePluginsSynced(String ciId) {
        Option option;
        Timeout timeout = new Timeout(this.defaultPingTimeout(this.actorSystem()));
        ConfigurationItem ci = this.repositoryService.read(ciId);
        if (!ci.getType().instanceOf(Type.valueOf((String)"xl.Satellite"))) {
            return None$.MODULE$;
        }
        Satellite satellite = (Satellite)ci;
        ActorLocator actorLocator = ActorLocator$.MODULE$.apply(satellite);
        try {
            InstalledExtensionsDelta deltas = ExtensionsDelta$.MODULE$.calculateExtensionsDelta((ExtensionsLocator)FileSystemExtensionsLocator$.MODULE$, actorLocator, this.actorSystem());
            option = new Some((Object)BoxesRunTime.boxToBoolean((boolean)deltas.empty()));
        }
        catch (Exception exception) {
            option = Option$.MODULE$.empty();
        }
        return option;
    }

    public List<ConfigurationItemId> listHosts(String ciId, String name, Paging paging, Ordering order) {
        this.checkPermission(PlatformPermissions.READ, ciId);
        Integer totalCount = this.countHosts(ciId, name);
        this.response().getOutputHeaders().putSingle((Object)Paging$.MODULE$.X_TOTAL_COUNT_HEADER(), (Object)totalCount);
        return this.sqlSatelliteService.listHosts(ciId, name, paging, order);
    }

    public Integer countHosts(String ciId, String name) {
        this.checkPermission(PlatformPermissions.READ, ciId);
        return Predef$.MODULE$.int2Integer(this.sqlSatelliteService.countHosts(ciId, name));
    }

    @Autowired
    public SatelliteServiceImpl(RepositoryService repositoryService, SqlSatelliteService sqlSatelliteService) {
        this.repositoryService = repositoryService;
        this.sqlSatelliteService = sqlSatelliteService;
        Logging.$init$((Logging)this);
        this.response = null;
        this.actorSystem = TaskActorSystem$.MODULE$.actorSystem();
        this.dispatcher = this.actorSystem().dispatcher();
    }
}

