/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit;

import java.io.OutputStream;
import java.io.PrintStream;
import org.kohsuke.args4j.CmdLineException;
import org.kohsuke.args4j.CmdLineParser;
import org.kohsuke.args4j.Option;

public class ServerLaunchOptions {
    @Option(name="-setup", usage="(Re-)run the setup", required=false)
    private boolean doSetup = false;
    @Option(name="-reinitialize", usage="Reinitialize the repository, only useful with -setup", required=false)
    private boolean reinitialize = false;
    @Option(name="-force", required=false)
    private boolean force;
    @Option(name="-force-upgrades", required=false, usage="Force execution of upgrades at startup")
    private boolean forceUpgrades;
    @Option(name="-setup-defaults", required=false, usage="Use the given file for defaults during setup")
    private String defaultsFile;
    @Option(name="-repository-keystore-password", required=false, usage="The password to open the repository-keystore.jceks file, if not given, the server will prompt you.")
    private String repositoryKeystorePassword;
    @Option(name="-help", required=false, usage="Prints this usage message")
    private boolean printUsage = false;
    private static volatile ServerLaunchOptions instance;

    public boolean isDoSetup() {
        return this.doSetup;
    }

    public void setDoSetup(boolean doSetup) {
        this.doSetup = doSetup;
    }

    public boolean isReinitialize() {
        return this.reinitialize;
    }

    public void setReinitialize(boolean reinitialize) {
        this.reinitialize = reinitialize;
    }

    public boolean isForce() {
        return this.force;
    }

    public void setForce(boolean force) {
        this.force = force;
    }

    public boolean isForceUpgrades() {
        return this.forceUpgrades;
    }

    public void setForceUpgrades(boolean forceUpgrades) {
        this.forceUpgrades = forceUpgrades;
    }

    public boolean isPrintUsage() {
        return this.printUsage;
    }

    public void setPrintUsage(boolean printUsage) {
        this.printUsage = printUsage;
    }

    public String getDefaultsFile() {
        return this.defaultsFile;
    }

    public void setDefaultsFile(String defaultsFile) {
        this.defaultsFile = defaultsFile;
    }

    public String getRepositoryKeystorePassword() {
        return this.repositoryKeystorePassword;
    }

    public void setRepositoryKeystorePassword(String repositoryKeystorePassword) {
        this.repositoryKeystorePassword = repositoryKeystorePassword;
    }

    public static ServerLaunchOptions parseCommandLine(String[] args) {
        ServerLaunchOptions options = new ServerLaunchOptions();
        CmdLineParser parser = new CmdLineParser((Object)options);
        try {
            parser.parseArgument(args);
            if (options.isPrintUsage()) {
                ServerLaunchOptions.printUsage(parser, System.out);
                return null;
            }
        }
        catch (CmdLineException e) {
            System.err.println(e.getMessage());
            ServerLaunchOptions.printUsage(parser, System.err);
            return null;
        }
        return options;
    }

    private static void printUsage(CmdLineParser parser, PrintStream stream) {
        stream.println("Supported options:");
        parser.printUsage((OutputStream)stream);
    }

    public static ServerLaunchOptions getInstance() {
        return instance;
    }

    public static void setInstance(ServerLaunchOptions launchOptions) {
        instance = launchOptions;
    }
}

