/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.provision.steps;

import com.xebialabs.deployit.plugin.api.deployment.specification.Operation;
import com.xebialabs.deployit.plugin.api.flow.ExecutionContext;
import com.xebialabs.deployit.plugin.api.flow.Preview;
import com.xebialabs.deployit.plugin.api.flow.PreviewStep;
import com.xebialabs.deployit.plugin.api.flow.StepExitCode;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.plugin.api.rules.RulePostConstruct;
import com.xebialabs.deployit.plugin.api.rules.Scope;
import com.xebialabs.deployit.plugin.api.rules.StepMetadata;
import com.xebialabs.deployit.plugin.api.rules.StepParameter;
import com.xebialabs.deployit.plugin.api.rules.StepPostConstructContext;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.plugin.api.udm.Container;
import com.xebialabs.deployit.plugin.api.udm.DeployableArtifact;
import com.xebialabs.deployit.plugin.api.udm.Dictionary;
import com.xebialabs.deployit.plugin.api.udm.Environment;
import com.xebialabs.deployit.plugin.api.udm.base.BaseDeployedInfrastructureAsCode;
import com.xebialabs.deployit.provision.ProvisionHelper$;
import com.xebialabs.deployit.provision.steps.BaseStep;
import com.xebialabs.deployit.provision.steps.ScopeValidator;
import com.xebialabs.deployit.repository.RepositoryService;
import com.xebialabs.deployit.repository.RepositoryServiceHolder;
import java.io.Serializable;
import scala.Function1;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.StringContext;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.SeqLike;
import scala.collection.TraversableLike;
import scala.collection.mutable.Buffer$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@StepMetadata(name="create-dictionary")
@ScalaSignature(bytes="\u0006\u0001\u0005\u001dd\u0001B\u0001\u0003\u00015\u0011Ac\u0011:fCR,G)[2uS>t\u0017M]=Ti\u0016\u0004(BA\u0002\u0005\u0003\u0015\u0019H/\u001a9t\u0015\t)a!A\u0005qe>4\u0018n]5p]*\u0011q\u0001C\u0001\tI\u0016\u0004Hn\\=ji*\u0011\u0011BC\u0001\nq\u0016\u0014\u0017.\u00197bENT\u0011aC\u0001\u0004G>l7\u0001A\n\u0006\u000191\"\u0004\n\t\u0003\u001fQi\u0011\u0001\u0005\u0006\u0003#I\tA\u0001\\1oO*\t1#\u0001\u0003kCZ\f\u0017BA\u000b\u0011\u0005\u0019y%M[3diB\u0011q\u0003G\u0007\u0002\u0005%\u0011\u0011D\u0001\u0002\t\u0005\u0006\u001cXm\u0015;faB\u00111DI\u0007\u00029)\u0011QDH\u0001\u0005M2|wO\u0003\u0002 A\u0005\u0019\u0011\r]5\u000b\u0005\u00052\u0011A\u00029mk\u001eLg.\u0003\u0002$9\tY\u0001K]3wS\u0016<8\u000b^3q!\t9R%\u0003\u0002'\u0005\tq1kY8qKZ\u000bG.\u001b3bi>\u0014\b\"\u0002\u0015\u0001\t\u0003I\u0013A\u0002\u001fj]&$h\bF\u0001+!\t9\u0002\u0001C\u0005-\u0001\u0001\u0007\t\u0019!C\u0005[\u0005iQM\u001c<je>tW.\u001a8u\u0013\u0012,\u0012A\f\t\u0003_ar!\u0001\r\u001c\u0011\u0005E\"T\"\u0001\u001a\u000b\u0005Mb\u0011A\u0002\u001fs_>$hHC\u00016\u0003\u0015\u00198-\u00197b\u0013\t9D'\u0001\u0004Qe\u0016$WMZ\u0005\u0003si\u0012aa\u0015;sS:<'BA\u001c5\u0011%a\u0004\u00011AA\u0002\u0013%Q(A\tf]ZL'o\u001c8nK:$\u0018\nZ0%KF$\"A\u0010\"\u0011\u0005}\u0002U\"\u0001\u001b\n\u0005\u0005#$\u0001B+oSRDqaQ\u001e\u0002\u0002\u0003\u0007a&A\u0002yIEBa!\u0012\u0001!B\u0013q\u0013AD3om&\u0014xN\\7f]RLE\r\t\u0005\n\u000f\u0002\u0001\r\u00111A\u0005\n!\u000b\u0001\u0002Z3qY>LX\rZ\u000b\u0002\u0013B\u0011!*\u0016\b\u0003\u0017Ns!\u0001\u0014*\u000f\u00055\u000bfB\u0001(Q\u001d\t\tt*C\u0001\f\u0013\tI!\"\u0003\u0002\b\u0011%\u0011QAB\u0005\u0003)\u0012\tq\u0001]1dW\u0006<W-\u0003\u0002W/\n!#)Y:f\t\u0016\u0004Hn\\=fI&sgM]1tiJ,8\r^;sK\u0006\u001b8i\u001c3f)f\u0004XM\u0003\u0002U\t!I\u0011\f\u0001a\u0001\u0002\u0004%IAW\u0001\rI\u0016\u0004Hn\\=fI~#S-\u001d\u000b\u0003}mCqa\u0011-\u0002\u0002\u0003\u0007\u0011\n\u0003\u0004^\u0001\u0001\u0006K!S\u0001\nI\u0016\u0004Hn\\=fI\u0002Bqa\u0018\u0001A\u0002\u0013%\u0001-\u0001\rbI\u0012,eN^5s_:lWM\u001c;U_\n{WO\u001c3D\u0013N,\u0012!\u0019\t\u0003\u007f\tL!a\u0019\u001b\u0003\u000f\t{w\u000e\\3b]\"9Q\r\u0001a\u0001\n\u00131\u0017\u0001H1eI\u0016sg/\u001b:p]6,g\u000e\u001e+p\u0005>,h\u000eZ\"Jg~#S-\u001d\u000b\u0003}\u001dDqa\u00113\u0002\u0002\u0003\u0007\u0011\r\u0003\u0004j\u0001\u0001\u0006K!Y\u0001\u001aC\u0012$WI\u001c<je>tW.\u001a8u)>\u0014u.\u001e8e\u0007&\u001b\b\u0005C\u0003l\u0001\u0011\u0005C.\u0001\u0006hKR\u0004&/\u001a<jK^$\u0012!\u001c\t\u000379L!a\u001c\u000f\u0003\u000fA\u0013XM^5fo\")\u0011\u000f\u0001C\u0001e\u0006Ab/\u00197jI\u0006$X-\u00118e'\u0016$\b+\u0019:b[\u0016$XM]:\u0015\u0005y\u001a\b\"\u0002;q\u0001\u0004)\u0018aA2uqB\u0011a/_\u0007\u0002o*\u0011\u0001PH\u0001\u0006eVdWm]\u0005\u0003u^\u0014\u0001d\u0015;faB{7\u000f^\"p]N$(/^2u\u0007>tG/\u001a=uQ\t\u0001H\u0010\u0005\u0002w{&\u0011ap\u001e\u0002\u0012%VdW\rU8ti\u000e{gn\u001d;sk\u000e$\bbBA\u0001\u0001\u0011%\u00111A\u0001\tm\u0006d\u0017\u000eZ1uKR\u0019a(!\u0002\t\u000bQ|\b\u0019A;\t\u000f\u0005%\u0001\u0001\"\u0005\u0002\f\u0005Q!/\u001a9pg&$xN]=\u0016\u0005\u00055\u0001\u0003BA\b\u0003'i!!!\u0005\u000b\u0007\u0005%a!\u0003\u0003\u0002\u0016\u0005E!!\u0005*fa>\u001c\u0018\u000e^8ssN+'O^5dK\"9\u0011\u0011\u0004\u0001\u0005B\u0005m\u0011aB3yK\u000e,H/\u001a\u000b\u0005\u0003;\t\u0019\u0003E\u0002\u001c\u0003?I1!!\t\u001d\u00051\u0019F/\u001a9Fq&$8i\u001c3f\u0011\u001d!\u0018q\u0003a\u0001\u0003K\u00012aGA\u0014\u0013\r\tI\u0003\b\u0002\u0011\u000bb,7-\u001e;j_:\u001cuN\u001c;fqRDq!!\f\u0001\t\u0013\ty#A\u0007hKR$\u0015n\u0019;j_:\f'/\u001f\u000b\u0005\u0003c\t\u0019\u0005\u0006\u0003\u00024\u0005}\u0002\u0003BA\u001b\u0003wi!!a\u000e\u000b\u0007\u0005eb$A\u0002vI6LA!!\u0010\u00028\tQA)[2uS>t\u0017M]=\t\u0011\u0005\u0005\u00131\u0006a\u0002\u0003K\tqaY8oi\u0016DH\u000fC\u0004\u0002F\u0005-\u0002\u0019\u0001\u0018\u0002\u0019\u0011L7\r^5p]\u0006\u0014\u00180\u00133\t\r\u0005%\u0003\u0001\"\u0003.\u0003=9W\r\u001e#jGRLwN\\1ss&#\u0007bBA'\u0001\u0011%\u0011qJ\u0001\u000fO\u0016$XI\u001c<je>tW.\u001a8u)\u0011\t\t&a\u0016\u0011\t\u0005U\u00121K\u0005\u0005\u0003+\n9DA\u0006F]ZL'o\u001c8nK:$\b\u0002CA!\u0003\u0017\u0002\u001d!!\n)\u000f\u0001\tY&!\u0019\u0002dA\u0019a/!\u0018\n\u0007\u0005}sO\u0001\u0007Ti\u0016\u0004X*\u001a;bI\u0006$\u0018-\u0001\u0003oC6,\u0017EAA3\u0003E\u0019'/Z1uK6\"\u0017n\u0019;j_:\f'/\u001f")
public class CreateDictionaryStep
implements BaseStep,
PreviewStep,
ScopeValidator {
    private String environmentId;
    private BaseDeployedInfrastructureAsCode<? extends DeployableArtifact, ? extends Container> deployed;
    private boolean addEnvironmentToBoundCIs;
    @StepParameter(description="Description of this step, as it should appear in generated deployment plans", calculated=false)
    private String description;
    @StepParameter(description="Execution order of the step", calculated=false)
    private Integer order;

    @Override
    public void validateScope(Scope scope, Scope requiredScope) {
        ScopeValidator.validateScope$(this, scope, requiredScope);
    }

    @Override
    public int getOrder() {
        return BaseStep.getOrder$(this);
    }

    @Override
    public String getDescription() {
        return BaseStep.getDescription$(this);
    }

    @Override
    public String description() {
        return this.description;
    }

    @Override
    public void description_$eq(String x$1) {
        this.description = x$1;
    }

    @Override
    public Integer order() {
        return this.order;
    }

    @Override
    public void order_$eq(Integer x$1) {
        this.order = x$1;
    }

    private String environmentId() {
        return this.environmentId;
    }

    private void environmentId_$eq(String x$1) {
        this.environmentId = x$1;
    }

    private BaseDeployedInfrastructureAsCode<? extends DeployableArtifact, ? extends Container> deployed() {
        return this.deployed;
    }

    private void deployed_$eq(BaseDeployedInfrastructureAsCode<? extends DeployableArtifact, ? extends Container> x$1) {
        this.deployed = x$1;
    }

    private boolean addEnvironmentToBoundCIs() {
        return this.addEnvironmentToBoundCIs;
    }

    private void addEnvironmentToBoundCIs_$eq(boolean x$1) {
        this.addEnvironmentToBoundCIs = x$1;
    }

    public Preview getPreview() {
        return Preview.withContents((String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Create dictionary '", "'"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.getDictionaryId()})));
    }

    @RulePostConstruct
    public void validateAndSetParameters(StepPostConstructContext ctx) {
        block0: {
            this.validate(ctx);
            this.order_$eq(this.order() != null ? this.order() : Predef$.MODULE$.int2Integer(80));
            this.deployed_$eq((BaseDeployedInfrastructureAsCode<? extends DeployableArtifact, ? extends Container>)((BaseDeployedInfrastructureAsCode)ctx.getDelta().getDeployed()));
            this.environmentId_$eq(ProvisionHelper$.MODULE$.getProvisionEnvironmentId(this.deployed().getEnvironmentPath(), ctx.getDeployedApplication().getEnvironment().getId()));
            String string = this.environmentId();
            String string2 = ctx.getDeployedApplication().getEnvironment().getId();
            this.addEnvironmentToBoundCIs_$eq(string == null ? string2 != null : !string.equals(string2));
            if (this.description() != null && !this.description().isEmpty()) break block0;
            this.description_$eq(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Create dictionary for ", " from output"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.deployed().getName()})));
        }
    }

    private void validate(StepPostConstructContext ctx) {
        this.validateScope(ctx.getScope(), Scope.DEPLOYED);
        if (!(ctx.getDelta().getDeployed() instanceof BaseDeployedInfrastructureAsCode)) {
            throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"This step can only be applied to '", "' Configuration Items"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{Type.valueOf(BaseDeployedInfrastructureAsCode.class).toString()})));
        }
        Operation operation = ctx.getDelta().getOperation();
        Operation operation2 = Operation.CREATE;
        if (operation == null ? operation2 != null : !operation.equals(operation2)) {
            Operation operation3 = ctx.getDelta().getOperation();
            Operation operation4 = Operation.MODIFY;
            if (operation3 == null ? operation4 != null : !operation3.equals(operation4)) {
                throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"This step can only be applied to '", "' or '", "' operations"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{Operation.CREATE, Operation.MODIFY})));
            }
        }
    }

    public RepositoryService repository() {
        return RepositoryServiceHolder.getRepositoryService();
    }

    public StepExitCode execute(ExecutionContext ctx) {
        ExecutionContext context = ctx;
        String dictionaryId = this.getDictionaryId();
        Dictionary dictionary = this.getDictionary(dictionaryId, context);
        dictionary.setEntries(this.deployed().getOutputVariables());
        this.repository().createOrUpdate((ConfigurationItem[])new Dictionary[]{dictionary});
        context.logOutput(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Dictionary created: '", "'"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{dictionaryId})));
        Environment environment = this.getEnvironment(context);
        if (!((SeqLike)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(environment.getDictionaries()).asScala()).map((Function1 & Serializable & scala.Serializable)x$1 -> x$1.getId(), Buffer$.MODULE$.canBuildFrom())).contains((Object)dictionaryId)) {
            environment.getDictionaries().add(dictionary);
            this.repository().update((ConfigurationItem[])new Environment[]{environment});
            context.logOutput(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Dictionary added to Environment '", "'"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.environmentId()})));
        }
        this.deployed().getBoundConfigurationItems().add(dictionary);
        Object object = this.addEnvironmentToBoundCIs() ? BoxesRunTime.boxToBoolean((boolean)this.deployed().getBoundConfigurationItems().add(environment)) : BoxedUnit.UNIT;
        return StepExitCode.SUCCESS;
    }

    private Dictionary getDictionary(String dictionaryId, ExecutionContext context) {
        Dictionary dictionary;
        if (this.repository().exists(dictionaryId)) {
            ConfigurationItem ci = this.repository().read(dictionaryId);
            if (!(ci instanceof Dictionary)) {
                throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"'", "' is not a dictionary"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{dictionaryId})));
            }
            dictionary = (Dictionary)ci;
        } else {
            ProvisionHelper$.MODULE$.createDirectories(dictionaryId, context);
            Dictionary dict = new Dictionary();
            dict.setId(dictionaryId);
            dictionary = dict;
        }
        return dictionary;
    }

    private String getDictionaryId() {
        Some some;
        String s;
        Option option = Option$.MODULE$.apply((Object)this.deployed().getDictionaryPath());
        String string = option instanceof Some && !(s = (String)(some = (Some)option).value()).isEmpty() ? ProvisionHelper$.MODULE$.generateId(this.deployed().getDictionaryPath(), this.environmentId()) : this.environmentId().substring(0, this.environmentId().lastIndexOf("/") + 1) + this.deployed().getName() + "-dictionary";
        return string;
    }

    private Environment getEnvironment(ExecutionContext context) {
        return ProvisionHelper$.MODULE$.getOrCreateEnvironment(this.environmentId(), context);
    }

    public CreateDictionaryStep() {
        BaseStep.$init$(this);
        ScopeValidator.$init$(this);
        this.addEnvironmentToBoundCIs = false;
    }
}

