/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.engine.tasker;

import akka.actor.ActorNotFound;
import akka.actor.ActorPath;
import akka.actor.ActorPath$;
import akka.actor.ActorRef;
import akka.actor.ActorSelection;
import akka.actor.ActorSelection$;
import akka.actor.ActorSystem;
import akka.actor.Address;
import akka.actor.Props$;
import akka.actor.ScalaActorSelection;
import akka.pattern.AskableActorRef$;
import akka.pattern.AskableActorSelection$;
import akka.util.Timeout;
import com.github.nscala_time.time.Imports$;
import com.github.nscala_time.time.RichDateTime$;
import com.github.nscala_time.time.RichReadableInstant$;
import com.github.nscala_time.time.RichReadableInterval$;
import com.xebialabs.deployit.engine.api.execution.FetchMode;
import com.xebialabs.deployit.engine.api.execution.TaskWithBlock;
import com.xebialabs.deployit.engine.tasker.BlockPath;
import com.xebialabs.deployit.engine.tasker.BlockPath$Root$;
import com.xebialabs.deployit.engine.tasker.IEngine;
import com.xebialabs.deployit.engine.tasker.Task;
import com.xebialabs.deployit.engine.tasker.TaskFinalizer;
import com.xebialabs.deployit.engine.tasker.TaskManagingActor;
import com.xebialabs.deployit.engine.tasker.TaskNotFoundException;
import com.xebialabs.deployit.engine.tasker.TaskSpecification;
import com.xebialabs.deployit.engine.tasker.TaskerException;
import com.xebialabs.deployit.engine.tasker.distribution.ChunkReceivingForwarder;
import com.xebialabs.deployit.engine.tasker.distribution.ChunkSendingForwarder;
import com.xebialabs.deployit.engine.tasker.distribution.NoWorkersException;
import com.xebialabs.deployit.engine.tasker.distribution.TaskDistributor;
import com.xebialabs.deployit.engine.tasker.distribution.TaskDistributor$;
import com.xebialabs.deployit.engine.tasker.distribution.TaskDistributor$messages$CreateTaskActor$;
import com.xebialabs.deployit.engine.tasker.distribution.TasksManager$;
import com.xebialabs.deployit.engine.tasker.distribution.WorkerManager$messages$NoWorkersError$;
import com.xebialabs.deployit.engine.tasker.messages.Abort;
import com.xebialabs.deployit.engine.tasker.messages.AddPauseStep;
import com.xebialabs.deployit.engine.tasker.messages.Enqueue;
import com.xebialabs.deployit.engine.tasker.messages.ModifySteps;
import com.xebialabs.deployit.engine.tasker.messages.PathsNotFound;
import com.xebialabs.deployit.engine.tasker.messages.Registered;
import com.xebialabs.deployit.engine.tasker.messages.RunMode$;
import com.xebialabs.deployit.engine.tasker.messages.SkipSteps;
import com.xebialabs.deployit.engine.tasker.messages.StepModificationError;
import com.xebialabs.deployit.engine.tasker.messages.Stop;
import com.xebialabs.deployit.engine.tasker.messages.UnSkipSteps;
import com.xebialabs.deployit.engine.tasker.repository.ActiveTask;
import com.xebialabs.deployit.engine.tasker.repository.ActiveTaskRepository;
import com.xebialabs.xlplatform.settings.CommonSettings;
import com.xebialabs.xlplatform.settings.CommonSettings$;
import com.xebialabs.xlplatform.settings.TaskerSettings;
import grizzled.slf4j.Logger;
import grizzled.slf4j.Logging;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.TimeoutException;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;
import org.joda.time.ReadableInterval;
import org.slf4j.Marker;
import org.springframework.security.core.Authentication;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.PartialFunction;
import scala.Predef$;
import scala.StringContext;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Map;
import scala.collection.mutable.Buffer$;
import scala.concurrent.Await$;
import scala.concurrent.Awaitable;
import scala.concurrent.Future;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.package;
import scala.concurrent.duration.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.util.Failure;
import scala.util.Try;
import scala.util.Try$;

@ScalaSignature(bytes="\u0006\u0001\r\u001df\u0001B\u0001\u0003\u00015\u00111\u0003V1tW\u0016CXmY;uS>tWI\\4j]\u0016T!a\u0001\u0003\u0002\rQ\f7o[3s\u0015\t)a!\u0001\u0004f]\u001eLg.\u001a\u0006\u0003\u000f!\t\u0001\u0002Z3qY>L\u0018\u000e\u001e\u0006\u0003\u0013)\t\u0011\u0002_3cS\u0006d\u0017MY:\u000b\u0003-\t1aY8n\u0007\u0001\u0019B\u0001\u0001\b\u00175A\u0011q\u0002F\u0007\u0002!)\u0011\u0011CE\u0001\u0005Y\u0006twMC\u0001\u0014\u0003\u0011Q\u0017M^1\n\u0005U\u0001\"AB(cU\u0016\u001cG\u000f\u0005\u0002\u001815\t!!\u0003\u0002\u001a\u0005\t9\u0011*\u00128hS:,\u0007CA\u000e!\u001b\u0005a\"BA\u000f\u001f\u0003\u0015\u0019HN\u001a\u001bk\u0015\u0005y\u0012\u0001C4sSjTH.\u001a3\n\u0005\u0005b\"a\u0002'pO\u001eLgn\u001a\u0005\tG\u0001\u0011\t\u0011)A\u0005I\u0005qA/Y:l%\u0016\u0004xn]5u_JL\bCA\u0013)\u001b\u00051#BA\u0014\u0003\u0003)\u0011X\r]8tSR|'/_\u0005\u0003S\u0019\u0012A#Q2uSZ,G+Y:l%\u0016\u0004xn]5u_JL\b\u0002C\u0016\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u0017\u0002\rML8\u000f^3n!\ti#'D\u0001/\u0015\ty\u0003'A\u0003bGR|'OC\u00012\u0003\u0011\t7n[1\n\u0005Mr#aC!di>\u00148+_:uK6D\u0001\"\u000e\u0001\u0003\u0002\u0003\u0006IAN\u0001\u000eo>\u00148.\u001a:NC:\fw-\u001a:\u0011\u00055:\u0014B\u0001\u001d/\u0005!\t5\r^8s%\u00164\u0007\u0002\u0003\u001e\u0001\u0005\u0003\u0005\u000b\u0011B\u001e\u0002\u001bQ\f7o\u001b$j]\u0006d\u0017N_3s!\t9B(\u0003\u0002>\u0005\tiA+Y:l\r&t\u0017\r\\5{KJDQa\u0010\u0001\u0005\u0002\u0001\u000ba\u0001P5oSRtD#B!C\u0007\u0012+\u0005CA\f\u0001\u0011\u0015\u0019c\b1\u0001%\u0011\u0015Yc\b1\u0001-\u0011\u0015)d\b1\u00017\u0011\u0015Qd\b1\u0001<\u0011\u001d9\u0005A1A\u0005\n!\u000babY8n[>t7+\u001a;uS:<7/F\u0001J!\tQu*D\u0001L\u0015\taU*\u0001\u0005tKR$\u0018N\\4t\u0015\tq\u0005\"\u0001\u0006yYBd\u0017\r\u001e4pe6L!\u0001U&\u0003\u001d\r{W.\\8o'\u0016$H/\u001b8hg\"1!\u000b\u0001Q\u0001\n%\u000bqbY8n[>t7+\u001a;uS:<7\u000f\t\u0005\b)\u0002\u0011\r\u0011\"\u0003V\u00039!\u0018m]6feN+G\u000f^5oON,\u0012A\u0016\t\u0003\u0015^K!\u0001W&\u0003\u001dQ\u000b7o[3s'\u0016$H/\u001b8hg\"1!\f\u0001Q\u0001\nY\u000bq\u0002^1tW\u0016\u00148+\u001a;uS:<7\u000f\t\u0005\b9\u0002\u0011\r\u0011\"\u0003^\u0003-!\u0017n\u001d;sS\n,Ho\u001c:\u0016\u0003YBaa\u0018\u0001!\u0002\u00131\u0014\u0001\u00043jgR\u0014\u0018NY;u_J\u0004\u0003\"B1\u0001\t\u0003\u0012\u0017AB2b]\u000e,G\u000eF\u0002dSZ\u0004\"\u0001Z4\u000e\u0003\u0015T\u0011AZ\u0001\u0006g\u000e\fG.Y\u0005\u0003Q\u0016\u0014A!\u00168ji\")!\u000e\u0019a\u0001W\u00061A/Y:lS\u0012\u0004\"\u0001\\:\u000f\u00055\f\bC\u00018f\u001b\u0005y'B\u00019\r\u0003\u0019a$o\\8u}%\u0011!/Z\u0001\u0007!J,G-\u001a4\n\u0005Q,(AB*ue&twM\u0003\u0002sK\"9q\u000f\u0019I\u0001\u0002\u0004A\u0018!\u00024pe\u000e,\u0007C\u00013z\u0013\tQXMA\u0004C_>dW-\u00198\t\u000bq\u0004A\u0011I?\u0002\u000f\u0005\u00148\r[5wKR\u00111M \u0005\u0006Un\u0004\ra\u001b\u0005\b\u0003\u0003\u0001A\u0011IA\u0002\u0003%\u00198.\u001b9Ti\u0016\u00048\u000fF\u0003d\u0003\u000b\t9\u0001C\u0003k\u007f\u0002\u00071\u000eC\u0004\u0002\n}\u0004\r!a\u0003\u0002\u000fM$X\r\u001d(sgB1\u0011QBA\n\u0003/i!!a\u0004\u000b\u0007\u0005E!#\u0001\u0003vi&d\u0017\u0002BA\u000b\u0003\u001f\u0011A\u0001T5tiB\u0019q\"!\u0007\n\u0007\u0005m\u0001CA\u0004J]R,w-\u001a:\t\u0011\u0005}\u0001\u0001)C\u0005\u0003C\tQb]6jaN#X\r\u001d)bi\"\u001cH#B2\u0002$\u0005\u0015\u0002B\u00026\u0002\u001e\u0001\u00071\u000e\u0003\u0005\u0002\n\u0005u\u0001\u0019AA\u0014!\u0019\tI#a\r\u0002:9!\u00111FA\u0018\u001d\rq\u0017QF\u0005\u0002M&\u0019\u0011\u0011G3\u0002\u000fA\f7m[1hK&!\u0011QGA\u001c\u0005\r\u0019V-\u001d\u0006\u0004\u0003c)\u0007cA\f\u0002<%\u0019\u0011Q\b\u0002\u0003\u0013\tcwnY6QCRD\u0007bBA!\u0001\u0011%\u00111I\u0001\u000b[\u0006t\u0017mZ3Ti\u0016\u0004H#B2\u0002F\u0005\u001d\u0003B\u00026\u0002@\u0001\u00071\u000e\u0003\u0005\u0002J\u0005}\u0002\u0019AA&\u0003\u001diWm]:bO\u0016\u0004B!!\u0014\u0002T5\u0011\u0011q\n\u0006\u0004\u0003#\u0012\u0011\u0001C7fgN\fw-Z:\n\t\u0005U\u0013q\n\u0002\f\u001b>$\u0017NZ=Ti\u0016\u00048\u000f\u0003\u0005\u0002Z\u0001\u0001K\u0011BA.\u00035Ig\u000e\u001e\u001aCY>\u001c7\u000eU1uQR!\u0011\u0011HA/\u0011!\ty&a\u0016A\u0002\u0005]\u0011aC8mIB{7/\u001b;j_:Dq!a\u0019\u0001\t\u0003\n)'A\u0006v]N\\\u0017\u000e]*uKB\u001cH#B2\u0002h\u0005%\u0004B\u00026\u0002b\u0001\u00071\u000e\u0003\u0005\u0002\n\u0005\u0005\u0004\u0019AA\u0006\u0011!\ti\u0007\u0001Q\u0005\n\u0005=\u0014aD;og.L\u0007o\u0015;faB\u000bG\u000f[:\u0015\u000b\r\f\t(a\u001d\t\r)\fY\u00071\u0001l\u0011!\tI!a\u001bA\u0002\u0005\u001d\u0002bBA<\u0001\u0011\u0005\u0013\u0011P\u0001\rC\u0012$\u0007+Y;tKN#X\r\u001d\u000b\u0006G\u0006m\u0014Q\u0010\u0005\u0007U\u0006U\u0004\u0019A6\t\u0011\u0005}\u0014Q\u000fa\u0001\u0003/\t\u0001\u0002]8tSRLwN\u001c\u0005\b\u0003o\u0002A\u0011IAB)\u0015\u0019\u0017QQAD\u0011\u0019Q\u0017\u0011\u0011a\u0001W\"A\u0011qPAA\u0001\u0004\tI\u0004C\u0004\u0002n\u0001!\t%a#\u0015\u000b\r\fi)a$\t\r)\fI\t1\u0001l\u0011!\tI!!#A\u0002\u0005E\u0005CBA\u0007\u0003'\tI\u0004C\u0004\u0002 \u0001!\t%!&\u0015\u000b\r\f9*!'\t\r)\f\u0019\n1\u0001l\u0011!\tI!a%A\u0002\u0005E\u0005bBAO\u0001\u0011\u0005\u0013qT\u0001\u0005gR|\u0007\u000fF\u0002d\u0003CCaA[AN\u0001\u0004Y\u0007bBAS\u0001\u0011\u0005\u0013qU\u0001\u0006C\n|'\u000f\u001e\u000b\u0004G\u0006%\u0006B\u00026\u0002$\u0002\u00071\u000eC\u0004\u0002.\u0002!\t%a,\u0002\u000f\u0015DXmY;uKR\u00191-!-\t\r)\fY\u000b1\u0001l\u0011\u001d\t)\f\u0001C!\u0003o\u000b\u0001B]3ue&,g/\u001a\u000b\u0005\u0003s\u000by\fE\u0002\u0018\u0003wK1!!0\u0003\u0005\u0011!\u0016m]6\t\r)\f\u0019\f1\u0001l\u0011\u001d\t\u0019\r\u0001C!\u0003\u000b\fa!Y:tS\u001etGCBA]\u0003\u000f\fI\r\u0003\u0004k\u0003\u0003\u0004\ra\u001b\u0005\t\u0003\u0017\f\t\r1\u0001\u0002N\u0006)qn\u001e8feB!\u0011qZAq\u001b\t\t\tN\u0003\u0003\u0002T\u0006U\u0017\u0001B2pe\u0016TA!a6\u0002Z\u0006A1/Z2ve&$\u0018P\u0003\u0003\u0002\\\u0006u\u0017aD:qe&twM\u001a:b[\u0016<xN]6\u000b\u0005\u0005}\u0017aA8sO&!\u00111]Ai\u00059\tU\u000f\u001e5f]RL7-\u0019;j_:Dq!a:\u0001\t\u0013\tI/A\u0007dQVt7NU3dK&4XM\u001d\u000b\u0004m\u0005-\b\u0002CAw\u0003K\u0004\r!a<\u0002\rA\f'/\u001a8u!\ri\u0013\u0011_\u0005\u0004\u0003gt#AD!di>\u00148+\u001a7fGRLwN\u001c\u0005\t\u0003o\u0004A\u0011\u0001\u0002\u0002z\u0006yAn\\8lkB$\u0016m]6BGR|'\u000f\u0006\u0003\u0002p\u0006m\bB\u00026\u0002v\u0002\u00071\u000e\u0003\u0005\u0002\u0000\u0002!\tA\u0001B\u0001\u0003Uawn\\6vaR\u000b7o[!di>\u0014\b+\u0019:f]R$B!a<\u0003\u0004!1!.!@A\u0002-DqAa\u0002\u0001\t\u0013\u0011I!\u0001\u000ehKR\f5\r^8s!\u0006$\bN\u0012:p[J+\u0007o\\:ji>\u0014\u0018\u0010\u0006\u0003\u0003\f\t]\u0001#\u00023\u0003\u000e\tE\u0011b\u0001B\bK\n1q\n\u001d;j_:\u00042!\fB\n\u0013\r\u0011)B\f\u0002\n\u0003\u000e$xN\u001d)bi\"DqA!\u0007\u0003\u0006\u0001\u00071.\u0001\u0004uCN\\\u0017\n\u001a\u0005\b\u0005;\u0001A\u0011\u0002B\u0010\u0003M!\u0018m]6O_R4u.\u001e8e\u001f:,%O]8s+\u0011\u0011\tCa\r\u0015\t\t\r\"Q\t\t\bI\n\u0015\"\u0011\u0006B\u0018\u0013\r\u00119#\u001a\u0002\u0010!\u0006\u0014H/[1m\rVt7\r^5p]B!\u0011\u0011\u0006B\u0016\u0013\u0011\u0011i#a\u000e\u0003\u0013QC'o\\<bE2,\u0007\u0003\u0002B\u0019\u0005ga\u0001\u0001\u0002\u0005\u00036\tm!\u0019\u0001B\u001c\u0005\u0005!\u0016\u0003\u0002B\u001d\u0005\u007f\u00012\u0001\u001aB\u001e\u0013\r\u0011i$\u001a\u0002\b\u001d>$\b.\u001b8h!\r!'\u0011I\u0005\u0004\u0005\u0007*'aA!os\"A!\u0011\u0004B\u000e\u0001\u0004\u00119\u0005\u0005\u0003\u0003J\t5cbA\f\u0003L%\u0019\u0011\u0011\u0007\u0002\n\t\t=#\u0011\u000b\u0002\u0007)\u0006\u001c8.\u00133\u000b\u0007\u0005E\"\u0001C\u0004\u0003V\u0001!IAa\u0016\u0002+Q\f7o\u001b(pi\u001a{WO\u001c3Fq\u000e,\u0007\u000f^5p]V!!\u0011\fB2)\u0011\u0011YF!\u0019\u0011\u0007]\u0011i&C\u0002\u0003`\t\u0011Q\u0003V1tW:{GOR8v]\u0012,\u0005pY3qi&|g\u000e\u0003\u0005\u0003\u001a\tM\u0003\u0019\u0001B$\t!\u0011)Da\u0015C\u0002\t]\u0002b\u0002B4\u0001\u0011\u0005!\u0011N\u0001\tg\u000eDW\rZ;mKR)1Ma\u001b\u0003n!1!N!\u001aA\u0002-D\u0001Ba\u001c\u0003f\u0001\u0007!\u0011O\u0001\u000bg\u000eDW\rZ;mK\u0006#\b\u0003\u0002B:\u0005+sAA!\u001e\u0003\u0010:!!q\u000fBE\u001d\u0011\u0011IHa!\u000f\t\tm$q\u0010\b\u0004]\nu\u0014\"A\u0006\n\u0007\t\u0005%\"\u0001\u0004hSRDWOY\u0005\u0005\u0005\u000b\u00139)A\u0006og\u000e\fG.Y0uS6,'b\u0001BA\u0015%!!1\u0012BG\u0003\u0011!\u0018.\\3\u000b\t\t\u0015%qQ\u0005\u0005\u0005#\u0013\u0019*A\u0004J[B|'\u000f^:\u000b\t\t-%QR\u0005\u0005\u0005/\u0013IJ\u0001\u0005ECR,G+[7f\u0013\u0011\u0011YJa%\u0003\u0017QK\b/Z%na>\u0014Ho\u001d\u0005\b\u0005?\u0003A\u0011\tBQ\u0003!\u0011XmZ5ti\u0016\u0014HcA6\u0003$\"A!Q\u0015BO\u0001\u0004\u00119+\u0001\u0003ta\u0016\u001c\u0007cA\f\u0003*&\u0019!1\u0016\u0002\u0003#Q\u000b7o[*qK\u000eLg-[2bi&|g\u000eC\u0004\u00030\u0002!\tE!-\u00025A\u0014X\r]1sKJ{G\u000e\u001c2bG.\fe\u000e\u001a*fO&\u001cH/\u001a:\u0015\u000b-\u0014\u0019L!.\t\r)\u0014i\u000b1\u0001l\u0011!\u00119L!,A\u0002\t\u001d\u0016\u0001\u0004:pY2\u0014\u0017mY6Ta\u0016\u001c\u0007b\u0002B^\u0001\u0011%!QX\u0001\u000bI>\u0014VmZ5ti\u0016\u0014H#B6\u0003@\n\r\u0007b\u0002Ba\u0005s\u0003\rAN\u0001\ni\u0006\u001c8.Q2u_JD\u0001B!*\u0003:\u0002\u0007!q\u0015\u0005\t\u0005\u000f\u0004\u0001\u0015\"\u0003\u0003J\u0006y1M]3bi\u0016$\u0016m]6BGR|'\u000fF\u00037\u0005\u0017\u0014y\r\u0003\u0005\u0003N\n\u0015\u0007\u0019\u0001BT\u00035\u0019\b/Z2jM&\u001c\u0017\r^5p]\"Q!\u0011\u001bBc!\u0003\u0005\rAa5\u0002\u001bM$\u0018nY6z\u0003\u0012$'/Z:t!\ri#Q[\u0005\u0004\u0005/t#aB!eIJ,7o\u001d\u0005\b\u00057\u0004A\u0011\tBo\u0003U9W\r^!mY&s7m\\7qY\u0016$X\rV1tWN$BAa8\u0003rB1\u0011QBA\n\u0005C\u0004BAa9\u0003n6\u0011!Q\u001d\u0006\u0005\u0005O\u0014I/A\u0005fq\u0016\u001cW\u000f^5p]*\u0019!1\u001e\u0003\u0002\u0007\u0005\u0004\u0018.\u0003\u0003\u0003p\n\u0015(!\u0004+bg.<\u0016\u000e\u001e5CY>\u001c7\u000e\u0003\u0006\u0003t\ne\u0007\u0013!a\u0001\u0005k\f\u0011BZ3uG\"lu\u000eZ3\u0011\t\t\r(q_\u0005\u0005\u0005s\u0014)OA\u0005GKR\u001c\u0007.T8eK\"A!Q \u0001!\n\u0013\u0011y0\u0001\bbg.$\u0015n\u001d;sS\n,Ho\u001c:\u0016\t\r\u00051q\u0001\u000b\u0005\u0007\u0007\u0019y\u0001\u0006\u0003\u0004\u0006\r%\u0001\u0003\u0002B\u0019\u0007\u000f!\u0001B!\u000e\u0003|\n\u0007!q\u0007\u0005\t\u0007\u0017\u0011Y\u00101\u0001\u0004\u000e\u0005IqN\u001c+j[\u0016|W\u000f\u001e\t\bI\n\u0015\"\u0011FB\u0003\u0011!\u0019\tBa?A\u0002\t}\u0012aA7tO\"A1Q\u0003\u0001!\n\u0013\u00199\"\u0001\u0005bg.\f5\r^8s+\u0011\u0019Iba\b\u0015\r\rm1QEB\u0014)\u0011\u0019ib!\t\u0011\t\tE2q\u0004\u0003\t\u0005k\u0019\u0019B1\u0001\u00038!A11BB\n\u0001\u0004\u0019\u0019\u0003E\u0004e\u0005K\u0011Ic!\b\t\r=\u001a\u0019\u00021\u00017\u0011!\u0019\tba\u0005A\u0002\t}\u0002\u0002CB\u000b\u0001\u0001&Iaa\u000b\u0016\t\r521\u0007\u000b\u0007\u0007_\u0019Ida\u000f\u0015\t\rE2Q\u0007\t\u0005\u0005c\u0019\u0019\u0004\u0002\u0005\u00036\r%\"\u0019\u0001B\u001c\u0011!\u0019Ya!\u000bA\u0002\r]\u0002c\u00023\u0003&\t%2\u0011\u0007\u0005\b_\r%\u0002\u0019AAx\u0011!\u0019\tb!\u000bA\u0002\t}\u0002\u0002CB \u0001\u0001&Ia!\u0011\u0002\u000b\u0011|\u0017i]6\u0016\t\r\r3\u0011\n\u000b\u0005\u0007\u000b\u001ay\u0005\u0006\u0003\u0004H\r-\u0003\u0003\u0002B\u0019\u0007\u0013\"\u0001B!\u000e\u0004>\t\u0007!q\u0007\u0005\t\u0007\u0017\u0019i\u00041\u0001\u0004NA9AM!\n\u0003*\r\u001d\u0003\u0002CB)\u0007{\u0001\raa\u0015\u0002\tM,g\u000e\u001a\t\bI\u000eU3\u0011LB2\u0013\r\u00199&\u001a\u0002\n\rVt7\r^5p]F\u0002Baa\u0017\u0004`5\u00111Q\f\u0006\u0004\u0003#\u0001\u0014\u0002BB1\u0007;\u0012q\u0001V5nK>,H\u000f\u0005\u0004\u0004f\r-$qH\u0007\u0003\u0007OR1a!\u001bf\u0003)\u0019wN\\2veJ,g\u000e^\u0005\u0005\u0007[\u001a9GA\u0005Bo\u0006LG/\u00192mK\"91\u0011\u000f\u0001\u0005\u0002\rM\u0014A\u0004:fi\"\u0014xn^(o\u000bJ\u0014xN]\u000b\u0005\u0007k\u001aY(\u0006\u0002\u0004xA9AM!\n\u0003*\re\u0004\u0003\u0002B\u0019\u0007w\"\u0001B!\u000e\u0004p\t\u0007!q\u0007\u0005\n\u0007\u007f\u0002\u0011\u0013!C\u0001\u0007\u0003\u000b\u0001cY1oG\u0016dG\u0005Z3gCVdG\u000f\n\u001a\u0016\u0005\r\r%f\u0001=\u0004\u0006.\u00121q\u0011\t\u0005\u0007\u0013\u001b\u0019*\u0004\u0002\u0004\f*!1QRBH\u0003%)hn\u00195fG.,GMC\u0002\u0004\u0012\u0016\f!\"\u00198o_R\fG/[8o\u0013\u0011\u0019)ja#\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW\rC\u0005\u0004\u001a\u0002\t\n\u0011\"\u0003\u0004\u001c\u0006I2M]3bi\u0016$\u0016m]6BGR|'\u000f\n3fM\u0006,H\u000e\u001e\u00133+\t\u0019iJ\u000b\u0003\u0003T\u000e\u0015\u0005\"CBQ\u0001E\u0005I\u0011ABR\u0003}9W\r^!mY&s7m\\7qY\u0016$X\rV1tWN$C-\u001a4bk2$H%M\u000b\u0003\u0007KSCA!>\u0004\u0006\u0002")
public class TaskExecutionEngine
implements IEngine,
Logging {
    private final ActiveTaskRepository taskRepository;
    private final ActorSystem system;
    private final TaskFinalizer taskFinalizer;
    private final CommonSettings commonSettings;
    private final TaskerSettings taskerSettings;
    private final ActorRef distributor;
    private Logger grizzled$slf4j$Logging$$_logger;
    private volatile boolean bitmap$0;

    public Logger logger() {
        return Logging.logger$((Logging)this);
    }

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void trace(Function0<Object> msg) {
        Logging.trace$((Logging)this, msg);
    }

    public void trace(Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, msg, t);
    }

    public void trace(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$((Logging)this);
    }

    public void debug(Function0<Object> msg) {
        Logging.debug$((Logging)this, msg);
    }

    public void debug(Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, msg, t);
    }

    public void debug(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isErrorEnabled() {
        return Logging.isErrorEnabled$((Logging)this);
    }

    public void error(Function0<Object> msg) {
        Logging.error$((Logging)this, msg);
    }

    public void error(Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, msg, t);
    }

    public void error(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isInfoEnabled() {
        return Logging.isInfoEnabled$((Logging)this);
    }

    public void info(Function0<Object> msg) {
        Logging.info$((Logging)this, msg);
    }

    public void info(Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, msg, t);
    }

    public void info(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isWarnEnabled() {
        return Logging.isWarnEnabled$((Logging)this);
    }

    public void warn(Function0<Object> msg) {
        Logging.warn$((Logging)this, msg);
    }

    public void warn(Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, msg, t);
    }

    public void warn(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, (Marker)mkr, msg, t);
    }

    @Override
    public void cancel(String taskid) {
        IEngine.super.cancel(taskid);
    }

    private Logger grizzled$slf4j$Logging$$_logger$lzycompute() {
        TaskExecutionEngine taskExecutionEngine = this;
        synchronized (taskExecutionEngine) {
            if (!this.bitmap$0) {
                this.grizzled$slf4j$Logging$$_logger = Logging.grizzled$slf4j$Logging$$_logger$((Logging)this);
                this.bitmap$0 = true;
            }
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    public Logger grizzled$slf4j$Logging$$_logger() {
        return !this.bitmap$0 ? this.grizzled$slf4j$Logging$$_logger$lzycompute() : this.grizzled$slf4j$Logging$$_logger;
    }

    private CommonSettings commonSettings() {
        return this.commonSettings;
    }

    private TaskerSettings taskerSettings() {
        return this.taskerSettings;
    }

    private ActorRef distributor() {
        return this.distributor;
    }

    @Override
    public void cancel(String taskid, boolean force) {
        this.taskFinalizer.cancel(this.lookupTaskActor(taskid), taskid, RunMode$.MODULE$.withForce(force));
    }

    public boolean cancel$default$2() {
        return false;
    }

    @Override
    public void archive(String taskid) {
        this.taskFinalizer.archive(this.lookupTaskActor(taskid), taskid);
    }

    @Override
    public void skipSteps(String taskid, java.util.List<Integer> stepNrs) {
        this.skipStepPaths(taskid, (Seq<BlockPath>)((Seq)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(stepNrs).asScala()).map((Function1 & Serializable & scala.Serializable)oldPosition -> this.int2BlockPath((Integer)oldPosition), Buffer$.MODULE$.canBuildFrom())));
    }

    private void skipStepPaths(String taskid, Seq<BlockPath> stepNrs) {
        this.manageStep(taskid, new SkipSteps(taskid, stepNrs));
    }

    private void manageStep(String taskid, ModifySteps message) {
        ActorRef x$8;
        Timeout x$7;
        ModifySteps x$6;
        Timeout timeout = this.taskerSettings().askTimeout();
        ActorSelection qual$1 = akka.pattern.package$.MODULE$.ask(this.lookupTaskActor(taskid));
        Object object = Await$.MODULE$.result((Awaitable)AskableActorSelection$.MODULE$.$qmark$extension1(qual$1, (Object)(x$6 = message), x$7 = timeout, x$8 = AskableActorSelection$.MODULE$.$qmark$default$3$extension(qual$1, (Object)x$6)), (Duration)timeout.duration());
        if (object instanceof StepModificationError) {
            StepModificationError stepModificationError = (StepModificationError)object;
            throw new TaskerException(stepModificationError.msg());
        }
        if (object instanceof PathsNotFound) {
            PathsNotFound pathsNotFound = (PathsNotFound)object;
            Seq<BlockPath> paths = pathsNotFound.paths();
            throw new TaskerException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Cannot find a path to add a pause step at the position ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{paths})));
        }
        if (object instanceof ActorNotFound) {
            throw new RuntimeException("Probably connection to satellite is lost");
        }
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    private BlockPath int2BlockPath(Integer oldPosition) {
        return BlockPath$Root$.MODULE$.$div(1).$div(1).$div(Predef$.MODULE$.Integer2int(oldPosition));
    }

    @Override
    public void unskipSteps(String taskid, java.util.List<Integer> stepNrs) {
        this.unskipStepPaths(taskid, (Seq<BlockPath>)((Seq)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(stepNrs).asScala()).map((Function1 & Serializable & scala.Serializable)oldPosition -> this.int2BlockPath((Integer)oldPosition), Buffer$.MODULE$.canBuildFrom())));
    }

    private void unskipStepPaths(String taskid, Seq<BlockPath> stepNrs) {
        this.manageStep(taskid, new UnSkipSteps(taskid, stepNrs));
    }

    @Override
    public void addPauseStep(String taskid, Integer position) {
        this.addPauseStep(taskid, this.int2BlockPath(position));
    }

    @Override
    public void addPauseStep(String taskid, BlockPath position) {
        this.manageStep(taskid, new AddPauseStep(taskid, position));
    }

    @Override
    public void unskipStepPaths(String taskid, java.util.List<BlockPath> stepNrs) {
        this.unskipStepPaths(taskid, (Seq<BlockPath>)((Seq)JavaConverters$.MODULE$.asScalaBufferConverter(stepNrs).asScala()));
    }

    @Override
    public void skipStepPaths(String taskid, java.util.List<BlockPath> stepNrs) {
        this.skipStepPaths(taskid, (Seq<BlockPath>)((Seq)JavaConverters$.MODULE$.asScalaBufferConverter(stepNrs).asScala()));
    }

    @Override
    public void stop(String taskid) {
        ScalaActorSelection qual$2 = ActorSelection$.MODULE$.toScala(this.lookupTaskActor(taskid));
        Stop x$9 = new Stop(taskid);
        ActorRef x$10 = qual$2.$bang$default$2((Object)x$9);
        qual$2.$bang((Object)x$9, x$10);
    }

    @Override
    public void abort(String taskid) {
        ScalaActorSelection qual$3 = ActorSelection$.MODULE$.toScala(this.lookupTaskActor(taskid));
        Abort x$11 = new Abort(taskid);
        ActorRef x$12 = qual$3.$bang$default$2((Object)x$11);
        qual$3.$bang((Object)x$11, x$12);
    }

    @Override
    public void execute(String taskid) {
        Timeout askTimeout = this.taskerSettings().askTimeout();
        Try try_ = Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> {
            ActorSelection qual$4 = akka.pattern.package$.MODULE$.ask(this.lookupTaskActor(taskid));
            Enqueue x$13 = new Enqueue(taskid);
            Timeout x$14 = askTimeout;
            ActorRef x$15 = AskableActorSelection$.MODULE$.$qmark$default$3$extension(qual$4, (Object)x$13);
            return (Future)Await$.MODULE$.ready((Awaitable)AskableActorSelection$.MODULE$.$qmark$extension1(qual$4, (Object)x$13, x$14, x$15), (Duration)askTimeout.duration().$plus(new package.DurationInt(package$.MODULE$.DurationInt(100)).millis()));
        });
        if (try_ instanceof Failure) {
            Failure failure = (Failure)try_;
            Throwable cause = failure.exception();
            this.warn((Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Enqueue task ", " failed due the ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{taskid, cause.getMessage()})));
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            this.debug((Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Task ", " enqued"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{taskid})));
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
    }

    @Override
    public Task retrieve(String taskid) {
        return (Task)((TaskDistributor.messages.TaskFound)this.askActor(this.chunkReceiver(this.lookupTaskActorParent(taskid)), (Object)new TaskDistributor.messages.RetrieveTask(taskid), this.taskNotFoundOnError(taskid))).task().getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            throw this.com$xebialabs$deployit$engine$tasker$TaskExecutionEngine$$taskNotFoundException(taskid);
        });
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Task assign(String taskid, Authentication owner) {
        void var3_3;
        Task task = (Task)((TaskDistributor.messages.TaskFound)this.askActor(this.chunkReceiver(this.lookupTaskActorParent(taskid)), (Object)new TaskDistributor.messages.AssignTask(taskid, owner), this.taskNotFoundOnError(taskid))).task().getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            throw this.com$xebialabs$deployit$engine$tasker$TaskExecutionEngine$$taskNotFoundException(taskid);
        });
        this.taskRepository.changeOwner(taskid, task.getOwner());
        return var3_3;
    }

    private ActorRef chunkReceiver(ActorSelection parent) {
        return this.system.actorOf(Props$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> new ChunkReceivingForwarder(parent), ClassTag$.MODULE$.apply(ChunkReceivingForwarder.class)));
    }

    public ActorSelection lookupTaskActor(String taskid) {
        return (ActorSelection)this.getActorPathFromRepository(taskid).map((Function1 & Serializable & scala.Serializable)path -> $this.system.actorSelection(path)).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            throw this.com$xebialabs$deployit$engine$tasker$TaskExecutionEngine$$taskNotFoundException(taskid);
        });
    }

    public ActorSelection lookupTaskActorParent(String taskid) {
        return (ActorSelection)this.getActorPathFromRepository(taskid).map((Function1 & Serializable & scala.Serializable)x$1 -> x$1.$div("..")).map((Function1 & Serializable & scala.Serializable)path -> $this.system.actorSelection(path)).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            throw this.com$xebialabs$deployit$engine$tasker$TaskExecutionEngine$$taskNotFoundException(taskid);
        });
    }

    private Option<ActorPath> getActorPathFromRepository(String taskId) {
        return this.taskRepository.workerAddress(taskId).map((Function1 & Serializable & scala.Serializable)wa -> ActorPath$.MODULE$.fromString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "/user/", "/", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{wa, TasksManager$.MODULE$.name(), taskId}))));
    }

    private <T> PartialFunction<Throwable, T> taskNotFoundOnError(String taskId) {
        return new scala.Serializable(this, taskId){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ TaskExecutionEngine $outer;
            private final String taskId$1;

            public final <A1 extends Throwable, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                A1 A1 = x1;
                if (A1 instanceof TimeoutException) {
                    throw this.$outer.com$xebialabs$deployit$engine$tasker$TaskExecutionEngine$$taskNotFoundException(this.taskId$1);
                }
                if (A1 != null) {
                    A1 A12 = A1;
                    throw A12;
                }
                Object object = function1.apply(x1);
                return (B1)object;
            }

            public final boolean isDefinedAt(Throwable x1) {
                Throwable throwable = x1;
                boolean bl = throwable instanceof TimeoutException ? true : throwable != null;
                return bl;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.taskId$1 = taskId$1;
            }
        };
    }

    public <T> TaskNotFoundException com$xebialabs$deployit$engine$tasker$TaskExecutionEngine$$taskNotFoundException(String taskId) {
        return new TaskNotFoundException("registry", taskId);
    }

    @Override
    public void schedule(String taskid, DateTime scheduleAt) {
        long tickMillis;
        if (scheduleAt.isBeforeNow()) {
            throw new TaskerException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Cannot schedule a task for the past, date entered was [", ", now is [", "]"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{TaskExecutionEngine.p$1(scheduleAt), TaskExecutionEngine.p$1(Imports$.MODULE$.DateTime().now())})));
        }
        long delayMillis = RichReadableInterval$.MODULE$.millis$extension(Imports$.MODULE$.richReadableInterval((ReadableInterval)RichReadableInstant$.MODULE$.to$extension(Imports$.MODULE$.richReadableInstant((ReadableInstant)Imports$.MODULE$.DateTime().now()), (ReadableInstant)scheduleAt)));
        if (delayMillis > (long)Integer.MAX_VALUE * (tickMillis = this.taskerSettings().tickDuration().toMillis())) {
            DateTime time = new DateTime((Object)RichDateTime$.MODULE$.millis$extension(Imports$.MODULE$.richDateTime(Imports$.MODULE$.DateTime().now())).addToCopy(tickMillis * Integer.MAX_VALUE));
            throw new TaskerException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Cannot schedule task [", "] at [", "], because it is too far into the future. Can only schedule to [", "]"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{taskid, TaskExecutionEngine.p$1(scheduleAt), TaskExecutionEngine.p$1(time)})));
        }
        ScalaActorSelection qual$5 = ActorSelection$.MODULE$.toScala(this.lookupTaskActor(taskid));
        TaskManagingActor.messages.Schedule x$16 = new TaskManagingActor.messages.Schedule(taskid, scheduleAt);
        ActorRef x$17 = qual$5.$bang$default$2((Object)x$16);
        qual$5.$bang((Object)x$16, x$17);
    }

    @Override
    public String register(TaskSpecification spec) {
        return this.doRegister(this.createTaskActor(spec, this.createTaskActor$default$2()), spec);
    }

    @Override
    public String prepareRollbackAndRegister(String taskid, TaskSpecification rollbackSpec) {
        ActorSelection parent = this.lookupTaskActorParent(taskid);
        this.askActor(parent, (Object)new TaskDistributor.messages.PrepareRollbackTask(taskid), this.rethrowOnError());
        ActorRef forwarder = this.system.actorOf(Props$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> new ChunkSendingForwarder(parent, this.commonSettings().inProcessTaskEngine()), ClassTag$.MODULE$.apply(ChunkSendingForwarder.class)));
        return this.doRegister(((TaskDistributor.messages.TaskActorCreated)this.askActor(forwarder, (Object)new TaskDistributor.messages.CreateTaskActor(rollbackSpec, TaskDistributor$messages$CreateTaskActor$.MODULE$.apply$default$2()), this.rethrowOnError())).taskActor(), rollbackSpec);
    }

    /*
     * WARNING - void declaration
     */
    private String doRegister(ActorRef taskActor, TaskSpecification spec) {
        void var3_3;
        String taskId = ((Registered)this.askActor(taskActor, (Object)new TaskManagingActor.messages.Register(), this.rethrowOnError())).taskId();
        this.taskRepository.store(taskId, spec, taskActor.path());
        return var3_3;
    }

    private ActorRef createTaskActor(TaskSpecification specification, Address stickyAddress) {
        return ((TaskDistributor.messages.TaskActorCreated)this.askDistributor(new TaskDistributor.messages.CreateTaskActor(specification, TaskDistributor$messages$CreateTaskActor$.MODULE$.apply$default$2()), this.rethrowOnError())).taskActor();
    }

    private Address createTaskActor$default$2() {
        return null;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public java.util.List<TaskWithBlock> getAllIncompleteTasks(FetchMode fetchMode) {
        void var3_3;
        List<ActiveTask> tasks = this.taskRepository.tasks();
        ArrayList result = new ArrayList((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter(tasks).asJava());
        Map idxs = ((TraversableOnce)((IterableLike)tasks.map((Function1 & Serializable & scala.Serializable)x$2 -> x$2.getId(), List$.MODULE$.canBuildFrom())).zipWithIndex(List$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
        Seq<TaskWithBlock> details = ((TaskDistributor.messages.TasksFound)this.askDistributor(new TaskDistributor.messages.RetrieveAllTasks(fetchMode), this.rethrowOnError())).tasks();
        details.foreach((Function1 & Serializable & scala.Serializable)t -> {
            TaskExecutionEngine.$anonfun$getAllIncompleteTasks$2(result, idxs, t);
            return BoxedUnit.UNIT;
        });
        return var3_3;
    }

    public FetchMode getAllIncompleteTasks$default$1() {
        return FetchMode.FULL;
    }

    private <T> T askDistributor(Object msg, PartialFunction<Throwable, T> onTimeout) {
        Object object;
        Timeout timeout = this.taskerSettings().askTimeout();
        try {
            Object object2;
            ActorRef qual$6 = akka.pattern.package$.MODULE$.ask(this.distributor());
            Object x$18 = msg;
            Timeout x$19 = timeout;
            ActorRef x$20 = AskableActorRef$.MODULE$.$qmark$default$3$extension(qual$6, x$18);
            Object object3 = Await$.MODULE$.result((Awaitable)AskableActorRef$.MODULE$.$qmark$extension1(qual$6, x$18, x$19, x$20), (Duration)timeout.duration());
            if (WorkerManager$messages$NoWorkersError$.MODULE$.equals(object3)) {
                throw new NoWorkersException("There are currently no workers available, tasks cannot be executed. Please contact your system administrator to correct the system.");
            }
            object = object2 = object3;
        }
        catch (Throwable x$4) {
            PartialFunction<Throwable, T> catchExpr$1 = onTimeout;
            if (catchExpr$1.isDefinedAt((Object)x$4)) {
                object = catchExpr$1.apply((Object)x$4);
            }
            throw x$4;
        }
        return (T)object;
    }

    private <T> T askActor(ActorRef actor, Object msg, PartialFunction<Throwable, T> onTimeout) {
        return this.doAsk((Function1<Timeout, Awaitable<Object>>)(Function1 & Serializable & scala.Serializable)t -> {
            ActorRef qual$7 = akka.pattern.package$.MODULE$.ask(actor);
            Object x$21 = msg;
            Timeout x$22 = t;
            ActorRef x$23 = AskableActorRef$.MODULE$.$qmark$default$3$extension(qual$7, x$21);
            return AskableActorRef$.MODULE$.$qmark$extension1(qual$7, x$21, x$22, x$23);
        }, onTimeout);
    }

    private <T> T askActor(ActorSelection actor, Object msg, PartialFunction<Throwable, T> onTimeout) {
        return this.doAsk((Function1<Timeout, Awaitable<Object>>)(Function1 & Serializable & scala.Serializable)t -> {
            ActorSelection qual$8 = akka.pattern.package$.MODULE$.ask(actor);
            Object x$24 = msg;
            Timeout x$25 = t;
            ActorRef x$26 = AskableActorSelection$.MODULE$.$qmark$default$3$extension(qual$8, x$24);
            return AskableActorSelection$.MODULE$.$qmark$extension1(qual$8, x$24, x$25, x$26);
        }, onTimeout);
    }

    private <T> T doAsk(Function1<Timeout, Awaitable<Object>> send, PartialFunction<Throwable, T> onTimeout) {
        Object object;
        Timeout timeout = this.taskerSettings().askTimeout();
        try {
            object = Await$.MODULE$.result((Awaitable)send.apply((Object)timeout), (Duration)timeout.duration());
        }
        catch (Throwable x$5) {
            PartialFunction<Throwable, T> catchExpr$2 = onTimeout;
            if (catchExpr$2.isDefinedAt((Object)x$5)) {
                object = catchExpr$2.apply((Object)x$5);
            }
            throw x$5;
        }
        return (T)object;
    }

    public <T> PartialFunction<Throwable, T> rethrowOnError() {
        return new scala.Serializable(null){
            public static final long serialVersionUID = 0L;

            public final <A1 extends Throwable, B1> B1 applyOrElse(A1 x2, Function1<A1, B1> function1) {
                A1 A1 = x2;
                if (A1 != null) {
                    A1 A12 = A1;
                    throw A12;
                }
                Object object = function1.apply(x2);
                return (B1)object;
            }

            public final boolean isDefinedAt(Throwable x2) {
                Throwable throwable = x2;
                boolean bl = throwable != null;
                return bl;
            }
        };
    }

    private static final String p$1(DateTime d) {
        return d.toString("yyyy-MM-dd HH:mm:ss Z");
    }

    public static final /* synthetic */ void $anonfun$getAllIncompleteTasks$2(ArrayList result$1, Map idxs$1, TaskWithBlock t) {
        idxs$1.get((Object)t.getId()).foreach((Function1 & Serializable & scala.Serializable)x$3 -> result$1.set(BoxesRunTime.unboxToInt((Object)x$3), t));
    }

    public TaskExecutionEngine(ActiveTaskRepository taskRepository, ActorSystem system, ActorRef workerManager, TaskFinalizer taskFinalizer) {
        this.taskRepository = taskRepository;
        this.system = system;
        this.taskFinalizer = taskFinalizer;
        Logging.$init$((Logging)this);
        this.commonSettings = (CommonSettings)CommonSettings$.MODULE$.apply(system);
        this.taskerSettings = this.commonSettings().tasker();
        this.distributor = system.actorOf(TaskDistributor$.MODULE$.props(workerManager, this.commonSettings().inProcessTaskEngine()), TaskDistributor$.MODULE$.name());
    }
}

