/*
 * Decompiled with CFR 0.152.
 */
package kamon.jmx.extension;

import akka.actor.ActorRef;
import akka.actor.ExtendedActorSystem;
import akka.actor.Props$;
import com.typesafe.config.Config;
import com.typesafe.config.ConfigObject;
import com.typesafe.config.ConfigValue;
import com.typesafe.config.ConfigValueType;
import java.io.Serializable;
import java.lang.management.ManagementFactory;
import java.util.HashMap;
import java.util.List;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.management.QueryExp;
import kamon.jmx.extension.AcceptAllPredicate;
import kamon.jmx.extension.ExportedMBeanQuery;
import kamon.metric.MetricsModule;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.collection.IterableLike;
import scala.collection.JavaConversions$;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.TraversableLike;
import scala.collection.immutable.Map;
import scala.collection.mutable.Buffer$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

public final class ExportedMBeanQuery$ {
    public static ExportedMBeanQuery$ MODULE$;
    private final MBeanServer server;
    private final QueryExp pred;

    static {
        new ExportedMBeanQuery$();
    }

    public MBeanServer server() {
        return this.server;
    }

    public QueryExp pred() {
        return this.pred;
    }

    public void register(ExtendedActorSystem system, MetricsModule metricsExtension, Config config) {
        Predef$.MODULE$.println((Object)"registering jmx exporter");
        Thread.currentThread().setName("JMX exporting thread");
        long identifyDelayInterval = config.getLong("identify-delay-interval-ms");
        long identifyInterval = config.getLong("identify-interval-ms");
        long checkInterval = config.getLong("value-check-interval-ms");
        ((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(config.getObjectList("mbeans")).asScala()).foreach((Function1 & Serializable & scala.Serializable)confObj -> {
            ExportedMBeanQuery$.$anonfun$register$1(system, metricsExtension, identifyDelayInterval, identifyInterval, checkInterval, confObj);
            return BoxedUnit.UNIT;
        });
    }

    public ExportedMBeanQuery apply(ExtendedActorSystem system, ObjectName jmxQuery, Seq<Map<String, Object>> attributeConfigs, long identifyDelayInterval, long identifyInterval, long checkInterval) {
        return new ExportedMBeanQuery(system, jmxQuery, attributeConfigs, identifyDelayInterval, identifyInterval, checkInterval);
    }

    public static final /* synthetic */ void $anonfun$register$1(ExtendedActorSystem system$1, MetricsModule metricsExtension$1, long identifyDelayInterval$1, long identifyInterval$1, long checkInterval$1, ConfigObject confObj) {
        block0: {
            ConfigValue nameObj = confObj.get((Object)"name");
            ConfigValue queryObj = confObj.get((Object)"jmxQuery");
            ConfigValue attrListObj = confObj.get((Object)"attributes");
            ConfigValueType configValueType = nameObj.valueType();
            ConfigValueType configValueType2 = ConfigValueType.STRING;
            Predef$.MODULE$.require(!(configValueType != null ? !configValueType.equals(configValueType2) : configValueType2 != null), (Function0 & Serializable & scala.Serializable)() -> "name must be a string");
            ConfigValueType configValueType3 = queryObj.valueType();
            ConfigValueType configValueType4 = ConfigValueType.STRING;
            Predef$.MODULE$.require(!(configValueType3 != null ? !configValueType3.equals(configValueType4) : configValueType4 != null), (Function0 & Serializable & scala.Serializable)() -> "jmxQuery must be a string");
            ConfigValueType configValueType5 = attrListObj.valueType();
            ConfigValueType configValueType6 = ConfigValueType.LIST;
            Predef$.MODULE$.require(!(configValueType5 != null ? !configValueType5.equals(configValueType6) : configValueType6 != null), (Function0 & Serializable & scala.Serializable)() -> "mbeans must be an array");
            String name = (String)nameObj.unwrapped();
            String query = (String)queryObj.unwrapped();
            Seq attrList = (Seq)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter((List)attrListObj.unwrapped()).asScala()).map((Function1 & Serializable & scala.Serializable)attr -> JavaConversions$.MODULE$.deprecated$u0020mapAsScalaMap((java.util.Map)((HashMap)attr)).toMap(Predef$.MODULE$.$conforms()), Buffer$.MODULE$.canBuildFrom());
            ObjectName jmxQuery = new ObjectName(query);
            if (!metricsExtension$1.shouldTrack(name, "kamon-mxbeans")) break block0;
            ActorRef subscriber = system$1.actorOf(Props$.MODULE$.apply(ExportedMBeanQuery.class, (Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{system$1, jmxQuery, attrList, BoxesRunTime.boxToLong((long)identifyDelayInterval$1), BoxesRunTime.boxToLong((long)identifyInterval$1), BoxesRunTime.boxToLong((long)checkInterval$1)})), name);
        }
    }

    private ExportedMBeanQuery$() {
        MODULE$ = this;
        this.server = ManagementFactory.getPlatformMBeanServer();
        this.pred = new AcceptAllPredicate();
    }
}

