/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.LoggerContext;
import com.typesafe.config.Config;
import com.typesafe.config.ConfigFactory;
import com.xebialabs.deployit.ReleaseInfo;
import com.xebialabs.deployit.Server;
import com.xebialabs.deployit.ServerConfigFile;
import com.xebialabs.deployit.ServerConfiguration;
import com.xebialabs.deployit.ServerLaunchOptions;
import com.xebialabs.deployit.XldServerPaths;
import com.xebialabs.deployit.log.LogbackHelper;
import com.xebialabs.deployit.setup.Setup;
import com.xebialabs.deployit.tasksystem.TaskActorSystem;
import com.xebialabs.deployit.util.DeployitKeyStoreException;
import com.xebialabs.deployit.util.DeployitKeys;
import com.xebialabs.deployit.util.PasswordEncrypter;
import com.xebialabs.platform.script.jython.EngineInstance;
import com.xebialabs.plugin.Xlp;
import com.xebialabs.xlplatform.jmx.JMXAgent;
import com.xebialabs.xlplatform.jmx.JMXSettings;
import java.io.File;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import javax.crypto.SecretKey;
import kamon.Kamon;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DeployitBootstrapper {
    static final String JAVAX_NET_SSL_TRUST_STORE_PASSWORD = "javax.net.ssl.trustStorePassword";
    private static final List<File> DEPRECATED_SYSTEM_CONFIG_FILES = Arrays.asList(new File("conf", "system.conf"), new File("conf", "maven.conf"), new File("conf", "extensions.conf"), new File("conf", "planner.conf"), new File("conf", "scheduler.conf"));
    private final ServerLaunchOptions launchOptions;
    private final ServerConfigFile serverConfigFile;
    private boolean isConfigAndPasswordInitDone = false;
    private static final Logger logger = LoggerFactory.getLogger(DeployitBootstrapper.class);

    public static void main(String[] args) {
        LogbackHelper.disableConsoleLoggerIfNeeded((String)"STDOUT");
        LogbackHelper.enableJavaUtilLoggingBridge();
        DeployitBootstrapper.setUpDefaultLogLevels();
        XldServerPaths.XL_HOTFIX_PLUGINS_FOLDER.mkdirs();
        Xlp.init((String)"xldp", Arrays.asList(XldServerPaths.XL_HOTFIX_PLUGINS_FOLDER, XldServerPaths.XL_PLUGINS_FOLDER), Arrays.asList(XldServerPaths.EXT_FOLDER));
        ServerLaunchOptions launchOptions = ServerLaunchOptions.parseCommandLine((String[])args);
        if (launchOptions == null) {
            return;
        }
        ReleaseInfo releaseInfo = ReleaseInfo.getReleaseInfo();
        logger.info("XL Deploy version {} (built at {})", (Object)releaseInfo.getVersion(), (Object)releaseInfo.getDate());
        logger.info("(c) 2008-{} XebiaLabs", (Object)new SimpleDateFormat("yyyy").format(new Date()));
        DeployitBootstrapper.initialiseJython();
        ServerConfigFile serverConfigFile = new ServerConfigFile(XldServerPaths.DEFAULT_CONFIGURATION_FILE);
        try {
            new DeployitBootstrapper(launchOptions, serverConfigFile).start();
            DeployitBootstrapper.setUpTrustStorePassword();
        }
        catch (Exception e) {
            logger.error("Could not start {}", (Object)"XL Deploy", (Object)e);
            System.err.println(e.getMessage());
            System.exit(1);
        }
    }

    static void setUpTrustStorePassword() {
        if (Objects.isNull(System.getProperty(JAVAX_NET_SSL_TRUST_STORE_PASSWORD)) && Objects.nonNull(ServerConfiguration.getInstance()) && Objects.nonNull(ServerConfiguration.getInstance().getTrustStorePassword())) {
            System.setProperty(JAVAX_NET_SSL_TRUST_STORE_PASSWORD, ServerConfiguration.getInstance().getTrustStorePassword());
        }
    }

    private static void setUpDefaultLogLevels() {
        LoggerContext lc = (LoggerContext)LoggerFactory.getILoggerFactory();
        lc.getLogger("org.eclipse.jetty.server.session").setLevel(Level.WARN);
    }

    public DeployitBootstrapper(ServerLaunchOptions launchOptions, ServerConfigFile serverConfigFile) {
        this.launchOptions = launchOptions;
        this.serverConfigFile = serverConfigFile;
    }

    private void start() {
        this.checkDeprecatedSystemConf();
        if (this.launchOptions.isDoSetup()) {
            DeployitBootstrapper.startSetup(this.launchOptions, this.serverConfigFile);
        } else {
            if (!this.serverConfigFile.exists()) {
                logger.warn("Configuration not found...");
                DeployitBootstrapper.startSetup(this.launchOptions, this.serverConfigFile);
            } else if (this.launchOptions.isReinitialize()) {
                logger.warn("Not re-initializing as the -setup flag is missing.");
            }
            DeployitBootstrapper.startServer(this.launchOptions, this.serverConfigFile);
        }
        if (!this.isConfigAndPasswordInitDone) {
            this.loadConfigAndInitPasswordEncryptionKey();
        }
        this.initializeJMXAgent();
    }

    private void checkDeprecatedSystemConf() {
        DEPRECATED_SYSTEM_CONFIG_FILES.forEach(configFile -> {
            if (configFile.exists()) {
                throw new RuntimeException("You are not allowed to have a " + configFile.getName() + " file on the 'conf' folder. Please merge it into 'conf/xl-deploy.conf', remove the file and restart the server.");
            }
        });
    }

    private void initializeJMXAgent() {
        Config config = TaskActorSystem.loadConfig((Config)ConfigFactory.parseResources((String)"xl-deploy.conf"));
        JMXSettings jmxSettings = new JMXSettings(config);
        new JMXAgent().start(jmxSettings);
        if (jmxSettings.enabled()) {
            Kamon.start((Config)config.getConfig("xl.jmx").withOnlyPath("kamon"));
        }
    }

    private static void initialiseJython() {
        try {
            logger.info("Starting up Jython engine (might take a while)...");
            EngineInstance.jython().eval("True");
            logger.info("Jython engine loaded [" + EngineInstance.jython().getFactory().getEngineVersion() + "]");
        }
        catch (Exception e) {
            logger.warn("Exception while initialising jython engine", (Throwable)e);
        }
    }

    private static void startServer(ServerLaunchOptions launchOptions, ServerConfigFile serverConfigFile) {
        logger.info("Starting server...");
        try {
            Server.start("XL Deploy Server", launchOptions, serverConfigFile);
        }
        catch (Throwable e) {
            logger.error("Fatal error starting server");
            logger.error(e.getMessage());
            System.exit(1);
        }
    }

    private static void startSetup(ServerLaunchOptions launchOptions, ServerConfigFile serverConfigFile) {
        new Setup("XL Deploy Server", serverConfigFile, launchOptions).run();
    }

    ServerConfiguration loadConfigAndInitPasswordEncryptionKey() {
        ServerConfiguration config = this.serverConfigFile.loadConfig(false, false);
        String repositoryKeyStorePassword = this.launchOptions.getRepositoryKeystorePassword() != null ? this.launchOptions.getRepositoryKeystorePassword() : config.getRepositoryKeyStorePassword();
        try {
            SecretKey passwordEncryptionKey = DeployitKeys.getPasswordEncryptionKey((String)repositoryKeyStorePassword);
            PasswordEncrypter.init((SecretKey)passwordEncryptionKey);
        }
        catch (DeployitKeyStoreException e) {
            throw new RuntimeException("Could not load the encryption key. The server will not start.");
        }
        config.loadEncryptedPasswords();
        this.serverConfigFile.saveDirtyConfiguration(config);
        ServerConfiguration.setInstance((ServerConfiguration)config);
        this.isConfigAndPasswordInitDone = true;
        return config;
    }
}

