/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.core.rest.util;

import com.xebialabs.deployit.checks.Checks;
import com.xebialabs.deployit.engine.api.RoleService;
import com.xebialabs.deployit.engine.spi.command.RepositoryBaseCommand;
import com.xebialabs.deployit.engine.spi.command.UpdateCisCommand;
import com.xebialabs.deployit.engine.spi.command.util.Update;
import com.xebialabs.deployit.event.EventBusHolder;
import com.xebialabs.deployit.plugin.api.reflect.PropertyDescriptor;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.plugin.api.udm.artifact.SourceArtifact;
import com.xebialabs.deployit.repository.RepositoryService;
import com.xebialabs.deployit.security.PermissionDeniedException;
import com.xebialabs.deployit.security.Permissions;
import com.xebialabs.deployit.security.permission.Permission;
import com.xebialabs.deployit.security.permission.PlatformPermissions;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import nl.javadude.t2bus.EventHandlerStrategy;
import nl.javadude.t2bus.event.strategy.ThrowingRuntimeExceptionHandlerStrategy;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;

public class RepositoryHelper {
    private RepositoryService repositoryService;
    private List<Type> allowedConvertibleTypes;
    private RoleService roleService;

    @Autowired
    public RepositoryHelper(RepositoryService repositoryService, RoleService roleService, @Value(value="#{allowedConvertibleTypes}") List<Type> allowedConvertibleTypes) {
        this.repositoryService = repositoryService;
        this.roleService = roleService;
        this.allowedConvertibleTypes = allowedConvertibleTypes;
    }

    private <T> T getOrNull(ConfigurationItem ci, PropertyDescriptor pd) {
        if (ci == null) {
            return null;
        }
        return (T)pd.get(ci);
    }

    private boolean hasPermission(Permission permission, String id) {
        return permission.getPermissionHandler().hasPermission(id);
    }

    public boolean isFileUriNotChanged(ConfigurationItem ci, ConfigurationItem previous) {
        if (ci instanceof SourceArtifact && previous instanceof SourceArtifact) {
            return ((SourceArtifact)ci).getFileUri() == null || ((SourceArtifact)ci).getFileUri().equals(((SourceArtifact)previous).getFileUri());
        }
        return true;
    }

    public void checkIfConvertibleType(ConfigurationItem ci, ConfigurationItem previous) {
        if (!previous.getType().equals((Object)ci.getType())) {
            Predicate<Type> instanceOfAllowedType = type -> previous.getType().instanceOf(type) && ci.getType().instanceOf(type);
            Checks.checkArgument((boolean)this.allowedConvertibleTypes.stream().anyMatch(instanceOfAllowedType), (String)"Type of the Configuration Item cannot be changed from [%s] to [%s]", (Object[])new Object[]{previous.getType(), ci.getType()});
        }
    }

    public void publishCommand(RepositoryBaseCommand event) {
        List roles = this.roleService.listMyRoles(null, null, null);
        event.setSecurityContext(Permissions.getAuthenticatedUserName(), roles);
        EventBusHolder.publish((Object)event, (EventHandlerStrategy)new ThrowingRuntimeExceptionHandlerStrategy());
    }

    public List<ConfigurationItem> reloadEntities(Collection<ConfigurationItem> cis) {
        return cis.stream().map(ConfigurationItem::getId).map(id -> this.repositoryService.read(id, 1)).collect(Collectors.toList());
    }

    public void checkReadAccessOnRelations(ConfigurationItem existingCi, ConfigurationItem updatedCi, List<String> nonReadIdAggregator, Set<String> otherCiIdsInTransaction) {
        Collection propertyDescriptors = updatedCi.getType().getDescriptor().getPropertyDescriptors();
        for (PropertyDescriptor propertyDescriptor : propertyDescriptors) {
            if (propertyDescriptor.isAsContainment()) continue;
            switch (propertyDescriptor.getKind()) {
                case CI: {
                    ConfigurationItem linkedCi = (ConfigurationItem)propertyDescriptor.get(updatedCi);
                    if (linkedCi == null) break;
                    String id = linkedCi.getId();
                    ConfigurationItem existingLinkedCi = (ConfigurationItem)this.getOrNull(existingCi, propertyDescriptor);
                    if (existingLinkedCi != null && existingLinkedCi.getId().equals(id) || otherCiIdsInTransaction.contains(id) || this.hasPermission(PlatformPermissions.READ, id)) break;
                    nonReadIdAggregator.add(id);
                    break;
                }
                case SET_OF_CI: 
                case LIST_OF_CI: {
                    Collection cis = (Collection)propertyDescriptor.get(updatedCi);
                    Collection existingCis = (Collection)this.getOrNull(existingCi, propertyDescriptor);
                    ArrayList existingLinkedCiIds = existingCis == null ? new ArrayList() : (Collection)existingCis.stream().map(ConfigurationItem::getId).collect(Collectors.toList());
                    for (ConfigurationItem configurationItem : cis) {
                        if (configurationItem == null || existingLinkedCiIds.contains(configurationItem.getId()) || otherCiIdsInTransaction.contains(configurationItem.getId()) || this.hasPermission(PlatformPermissions.READ, configurationItem.getId())) continue;
                        nonReadIdAggregator.add(configurationItem.getId());
                    }
                    break;
                }
            }
        }
    }

    public List<Update> createOrUpdateCis(List<ConfigurationItem> cis, Optional<Set<String>> maybeExistingIds) {
        ArrayList<Update> updates = new ArrayList<Update>();
        Set ciIds = cis.stream().map(ConfigurationItem::getId).collect(Collectors.toSet());
        Set existingIds = maybeExistingIds.orElseGet(() -> ciIds.stream().filter(arg_0 -> ((RepositoryService)this.repositoryService).exists(arg_0)).collect(Collectors.toSet()));
        ArrayList aggregator = new ArrayList();
        cis.stream().filter(configurationItem -> {
            if (existingIds.contains(configurationItem.getId())) {
                ConfigurationItem previous = this.repositoryService.read(configurationItem.getId(), 1, null, false);
                if (!this.isFileUriNotChanged((ConfigurationItem)configurationItem, previous)) return false;
                this.checkIfConvertibleType((ConfigurationItem)configurationItem, previous);
                this.checkReadAccessOnRelations(previous, (ConfigurationItem)configurationItem, aggregator, ciIds);
                updates.add(new Update(previous, configurationItem));
                return true;
            } else {
                this.checkReadAccessOnRelations(null, (ConfigurationItem)configurationItem, aggregator, ciIds);
                updates.add(new Update(null, configurationItem));
            }
            return true;
        }).collect(Collectors.toList());
        if (!aggregator.isEmpty()) {
            throw new PermissionDeniedException("Permission READ is not granted on the following linked CIs: " + aggregator);
        }
        UpdateCisCommand command = new UpdateCisCommand(updates);
        this.publishCommand((RepositoryBaseCommand)command);
        return updates;
    }

    public List<ConfigurationItem> createOrUpdateAndReloadCis(List<ConfigurationItem> cis, Optional<Set<String>> maybeExistingIds) {
        List<Update> updates = this.createOrUpdateCis(cis, maybeExistingIds);
        return this.reloadEntities(updates.stream().map(Update::getNewCi).collect(Collectors.toList()));
    }
}

