/*
 * Decompiled with CFR 0.152.
 */
package io.aeron.driver.ext;

import io.aeron.driver.ext.LossGenerator;
import io.aeron.driver.ext.RandomLossGenerator;

public class DebugChannelEndpointConfiguration {
    public static final String RECEIVE_DATA_LOSS_RATE_PROP_NAME = "aeron.debug.receive.data.loss.rate";
    public static final String RECEIVE_DATA_LOSS_SEED_PROP_NAME = "aeron.debug.receive.data.loss.seed";
    public static final String RECEIVE_CONTROL_LOSS_RATE_PROP_NAME = "aeron.debug.receive.control.loss.rate";
    public static final String RECEIVE_CONTROL_LOSS_SEED_PROP_NAME = "aeron.debug.receive.control.loss.seed";
    public static final String SEND_DATA_LOSS_RATE_PROP_NAME = "aeron.debug.send.data.loss.rate";
    public static final String SEND_DATA_LOSS_SEED_PROP_NAME = "aeron.debug.send.data.loss.seed";
    public static final String SEND_CONTROL_LOSS_RATE_PROP_NAME = "aeron.debug.send.control.loss.rate";
    public static final String SEND_CONTROL_LOSS_SEED_PROP_NAME = "aeron.debug.send.control.loss.seed";
    private static final long RECEIVE_DATA_LOSS_SEED = Long.getLong("aeron.debug.receive.data.loss.seed", -1L);
    private static final double RECEIVE_DATA_LOSS_RATE = Double.parseDouble(System.getProperty("aeron.debug.receive.data.loss.rate", "0.0"));
    private static final long RECEIVE_CONTROL_LOSS_SEED = Long.getLong("aeron.debug.receive.control.loss.seed", -1L);
    private static final double RECEIVE_CONTROL_LOSS_RATE = Double.parseDouble(System.getProperty("aeron.debug.receive.control.loss.rate", "0.0"));
    private static final long SEND_DATA_LOSS_SEED = Long.getLong("aeron.debug.send.data.loss.seed", -1L);
    private static final double SEND_DATA_LOSS_RATE = Double.parseDouble(System.getProperty("aeron.debug.send.data.loss.rate", "0.0"));
    private static final long SEND_CONTROL_LOSS_SEED = Long.getLong("aeron.debug.send.control.loss.seed", -1L);
    private static final double SEND_CONTROL_LOSS_RATE = Double.parseDouble(System.getProperty("aeron.debug.send.control.loss.rate", "0.0"));

    public static LossGenerator lossGeneratorSupplier(double lossRate, long lossSeed) {
        if (0.0 == lossRate) {
            return (address, buffer, length) -> false;
        }
        return new RandomLossGenerator(lossRate, lossSeed);
    }

    public static LossGenerator receiveDataLossGeneratorSupplier() {
        return DebugChannelEndpointConfiguration.lossGeneratorSupplier(RECEIVE_DATA_LOSS_RATE, RECEIVE_DATA_LOSS_SEED);
    }

    public static LossGenerator receiveControlLossGeneratorSupplier() {
        return DebugChannelEndpointConfiguration.lossGeneratorSupplier(RECEIVE_CONTROL_LOSS_RATE, RECEIVE_CONTROL_LOSS_SEED);
    }

    public static LossGenerator sendDataLossGeneratorSupplier() {
        return DebugChannelEndpointConfiguration.lossGeneratorSupplier(SEND_DATA_LOSS_RATE, SEND_DATA_LOSS_SEED);
    }

    public static LossGenerator sendControlLossGeneratorSupplier() {
        return DebugChannelEndpointConfiguration.lossGeneratorSupplier(SEND_CONTROL_LOSS_RATE, SEND_CONTROL_LOSS_SEED);
    }
}

