/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.repository;

import com.xebialabs.deployit.checks.Checks;
import com.xebialabs.deployit.engine.spi.event.CiCopiedEvent;
import com.xebialabs.deployit.engine.spi.event.CiMovedEvent;
import com.xebialabs.deployit.engine.spi.event.CiRenamedEvent;
import com.xebialabs.deployit.engine.spi.event.CisCreatedEvent;
import com.xebialabs.deployit.engine.spi.event.CisDeletedEvent;
import com.xebialabs.deployit.engine.spi.event.CisUpdatedEvent;
import com.xebialabs.deployit.event.EventBusHolder;
import com.xebialabs.deployit.exception.NotFoundException;
import com.xebialabs.deployit.jcr.JcrQueryTemplate;
import com.xebialabs.deployit.jcr.JcrResult;
import com.xebialabs.deployit.jcr.JcrTemplate;
import com.xebialabs.deployit.jcr.JcrTemplateHolder;
import com.xebialabs.deployit.jcr.RuntimeRepositoryException;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.repository.ChangeSet;
import com.xebialabs.deployit.repository.ConfigurationItemData;
import com.xebialabs.deployit.repository.ItemAlreadyExistsException;
import com.xebialabs.deployit.repository.ItemInUseException;
import com.xebialabs.deployit.repository.JcrChangeSetExecutor;
import com.xebialabs.deployit.repository.JcrReferentialIntegrityChecker;
import com.xebialabs.deployit.repository.NodeReader;
import com.xebialabs.deployit.repository.NodeReaderContext;
import com.xebialabs.deployit.repository.NullProgressLogger;
import com.xebialabs.deployit.repository.PathHelper;
import com.xebialabs.deployit.repository.ProgressLogger;
import com.xebialabs.deployit.repository.RepositoryService;
import com.xebialabs.deployit.repository.Result;
import com.xebialabs.deployit.repository.ResultSetExtractor;
import com.xebialabs.deployit.repository.SearchParameters;
import com.xebialabs.deployit.repository.SearchQueryBuilder;
import com.xebialabs.deployit.repository.WorkDir;
import com.xebialabs.deployit.util.PasswordEncrypter;
import com.xebialabs.license.service.LicenseCiCounterFactory;
import com.xebialabs.license.service.LicenseService;
import com.xebialabs.xlplatform.repository.JcrLicenseCiCounterFactory;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.query.Query;
import javax.jcr.query.QueryResult;
import javax.jcr.query.RowIterator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JcrRepositoryService
implements RepositoryService {
    private final JcrTemplate jcrTemplate;
    private final PasswordEncrypter passwordEncrypter;
    private LicenseService licenseService;
    private boolean reuseNodeReaderContext = true;
    private static Logger logger = LoggerFactory.getLogger(JcrRepositoryService.class);

    public JcrRepositoryService(JcrTemplate jcrTemplate, PasswordEncrypter passwordEncrypter, LicenseService licenseService) {
        this.jcrTemplate = jcrTemplate;
        this.passwordEncrypter = passwordEncrypter;
        this.licenseService = licenseService;
        new JcrTemplateHolder(jcrTemplate);
    }

    @PostConstruct
    public void initializeLicenseValidator() {
        this.licenseService.initialize((LicenseCiCounterFactory)new JcrLicenseCiCounterFactory(this));
    }

    public boolean exists(String id) {
        logger.debug("Checking whether node [{}] exists.", (Object)id);
        return this.jcrTemplate.execute((Session session) -> session.itemExists(PathHelper.getAbsolutePathFromId((String)id)));
    }

    public <T extends ConfigurationItem> T read(String id) {
        return this.read(id, Integer.MAX_VALUE, null, this.reuseNodeReaderContext);
    }

    public <T extends ConfigurationItem> T read(String id, int depth) {
        return this.read(id, depth, null, this.reuseNodeReaderContext);
    }

    public <T extends ConfigurationItem> T read(String id, WorkDir workDir) {
        return this.read(id, Integer.MAX_VALUE, workDir, true);
    }

    public <T extends ConfigurationItem> T read(String id, boolean useCache) {
        return this.read(id, Integer.MAX_VALUE, null, useCache);
    }

    public <T extends ConfigurationItem> T read(String id, WorkDir workDir, boolean useCache) {
        return this.read(id, Integer.MAX_VALUE, workDir, useCache);
    }

    public <T extends ConfigurationItem> List<T> read(List<String> ids, int depth, boolean useCache) {
        return ids.stream().map(id -> this.read((String)id, useCache)).collect(Collectors.toList());
    }

    public <T extends ConfigurationItem> T read(String id, int depth, WorkDir workDir, boolean useCache) {
        logger.debug("Reading node [{}] with depth {} and workdir {} (useCache={})", new Object[]{id, depth, workDir, useCache});
        Checks.checkNotNull((Object)id, (String)"id is null");
        return this._read(id, depth, workDir, useCache, true);
    }

    private <T extends ConfigurationItem> T _read(String id, int depth, WorkDir workDir, boolean useCache, boolean failOnMissing) {
        return (T)this.jcrTemplate.execute((Session session) -> {
            String absolutePathFromId = PathHelper.getAbsolutePathFromId((String)id);
            boolean exists = session.nodeExists(absolutePathFromId);
            if (failOnMissing && !exists) {
                throw new NotFoundException("Repository entity [%s] not found", new Object[]{id});
            }
            if (!exists) {
                return null;
            }
            Node node = session.getNode(absolutePathFromId);
            if (useCache) {
                return NodeReader.read(session, node, depth, workDir, this.passwordEncrypter);
            }
            return NodeReader.read(session, node, depth, workDir, new NodeReaderContext(), this.passwordEncrypter);
        });
    }

    public List<ConfigurationItemData> list(SearchParameters parameters) {
        Checks.checkNotNull((Object)parameters, (String)"parameters is null");
        logger.debug("Listing node IDs with parameters {}.", (Object)parameters);
        JcrQueryTemplate queryTemplate = new SearchQueryBuilder(parameters).createTemplate();
        return this.list(queryTemplate);
    }

    public long count(SearchParameters criteria) {
        return 0L;
    }

    public <T extends ConfigurationItem> List<T> listEntities(SearchParameters parameters) {
        Checks.checkNotNull((Object)parameters, (String)"parameters is null");
        logger.debug("Listing nodes with parameters {}.", (Object)parameters);
        JcrQueryTemplate queryTemplate = new SearchQueryBuilder(parameters).createTemplate();
        return this.listEntities(queryTemplate);
    }

    public <T extends ConfigurationItem> List<T> listEntities(SearchParameters parameters, int depth, boolean useCache) {
        return this.listEntities(parameters);
    }

    public List<ConfigurationItemData> list(JcrQueryTemplate queryTemplate) {
        Checks.checkNotNull((Object)queryTemplate, (String)"queryTemplate is null");
        logger.debug("Listing node IDs with JCR query template {}.", (Object)queryTemplate);
        queryTemplate.setDepth(0);
        List entities = this.query(queryTemplate, result -> {
            try {
                Node node = result.getRow().getNode("ci");
                Type type = NodeReader.readType(node);
                if (type != null && type.exists()) {
                    return new ConfigurationItemData(PathHelper.getIdFromAbsolutePath((String)node.getPath()), type);
                }
                return null;
            }
            catch (RepositoryException re) {
                logger.error("Error while listing Configuration Item ids", (Throwable)re);
                throw new RuntimeRepositoryException(re, "Error while listing ConfigurationItem ids for '%s'", queryTemplate);
            }
        });
        return entities.stream().map(ci -> new ConfigurationItemData(ci.getId(), ci.getType())).collect(Collectors.toList());
    }

    protected <T extends ConfigurationItem> List<T> listEntities(JcrQueryTemplate queryTemplate) {
        Checks.checkNotNull((Object)queryTemplate, (String)"query is null");
        logger.debug("Listing nodes with JCR query template {}.", (Object)queryTemplate);
        return this.jcrTemplate.execute((Session session) -> {
            Query query = queryTemplate.createQuery(session);
            QueryResult queryResult = query.execute();
            return this.getOrderedEntities(session, queryResult, queryTemplate.getDepth());
        });
    }

    protected <T, R extends Result> List<T> query(JcrQueryTemplate queryTemplate, ResultSetExtractor<T, R> extractor) {
        Checks.checkNotNull((Object)queryTemplate, (String)"query is null");
        logger.debug("Querying with JCR query template {}.", (Object)queryTemplate);
        return this.jcrTemplate.execute((Session session) -> {
            Query query = queryTemplate.createQuery(session);
            QueryResult queryResult = query.execute();
            ArrayList<Object> items = new ArrayList<Object>();
            RowIterator iterator = queryResult.getRows();
            while (iterator.hasNext()) {
                JcrResult result = new JcrResult(iterator.nextRow());
                Object t = extractor.extractData((Result)result);
                if (t == null) continue;
                items.add(t);
            }
            return items;
        });
    }

    private <T extends ConfigurationItem> List<T> getOrderedEntities(Session session, QueryResult queryResult, int depth) throws RepositoryException {
        ArrayList items = new ArrayList();
        RowIterator iterator = queryResult.getRows();
        while (iterator.hasNext()) {
            Node node = iterator.nextRow().getNode("ci");
            Object item = NodeReader.read(session, node, depth, null, this.passwordEncrypter);
            items.add(item);
        }
        return items;
    }

    public <T extends ConfigurationItem> void create(T ... cis) {
        ChangeSet changeset = new ChangeSet();
        changeset.create(Arrays.asList(cis));
        this.execute(changeset);
        EventBusHolder.publish((Object)new CisCreatedEvent(cis));
    }

    public <T extends ConfigurationItem> void update(T ... cis) {
        ChangeSet changeset = new ChangeSet();
        changeset.update(Arrays.asList(cis));
        this.execute(changeset);
        EventBusHolder.publish((Object)new CisUpdatedEvent(changeset.getUpdateCis()));
    }

    public <T extends ConfigurationItem> void createOrUpdate(T ... cis) {
        ChangeSet changeSet = new ChangeSet();
        changeSet.createOrUpdate(Arrays.asList(cis));
        this.execute(changeSet);
        EventBusHolder.publish((Object)new CisCreatedEvent(new ArrayList(changeSet.getCreateOrUpdateActualCreatedCis())));
        EventBusHolder.publish((Object)new CisUpdatedEvent(new ArrayList(changeSet.getCreateOrUpdateActualUpdatedCis())));
    }

    public void delete(String ... ids) {
        ChangeSet changeset = new ChangeSet();
        ArrayList cis = new ArrayList();
        for (String id : ids) {
            Object e = this._read(id, 0, null, this.reuseNodeReaderContext, false);
            if (e == null) continue;
            cis.add(e);
        }
        changeset.delete(Arrays.asList(ids));
        this.checkReferentialIntegrity(changeset);
        this.execute(changeset);
        EventBusHolder.publish((Object)new CisDeletedEvent(cis));
    }

    public void rename(String id, String newName) {
        Checks.checkArgument((newName.indexOf(47) == -1 ? 1 : 0) != 0, (String)"New name [%s] should not contain a /", (Object[])new Object[]{newName});
        Object configurationItem = this._read(id, 0, null, this.reuseNodeReaderContext, true);
        ChangeSet changeSet = new ChangeSet();
        changeSet.rename(id, newName);
        this.execute(changeSet);
        EventBusHolder.publish((Object)new CiRenamedEvent(configurationItem, newName));
    }

    public <T extends ConfigurationItem> void move(String id, String newId) {
        logger.debug("Moving node [{}] to [{}]", (Object)id, (Object)newId);
        T configurationItem = this._read(id, 0, null, this.reuseNodeReaderContext, true);
        ChangeSet changeSet = new ChangeSet();
        changeSet.move(id, newId);
        this.execute(changeSet);
        EventBusHolder.publish((Object)new CiMovedEvent(configurationItem, newId));
    }

    public void copy(String id, String newId) {
        ChangeSet changeSet = new ChangeSet();
        changeSet.copy(id, newId);
        this.execute(changeSet);
        Object configurationItem = this._read(id, 0, null, this.reuseNodeReaderContext, true);
        EventBusHolder.publish((Object)new CiCopiedEvent(configurationItem, newId));
    }

    protected void checkMoveAllowed(Type type) {
    }

    protected void checkCopyAllowed(Session session, String toBeCopied, String newId) throws RepositoryException {
    }

    static Type readType(Session session, String id) throws RepositoryException {
        return Type.valueOf((String)session.getNode(PathHelper.getAbsolutePathFromId((String)id)).getProperty("$configuration.item.type").getString());
    }

    static String extractParentId(String id) {
        int indexOf = id.lastIndexOf(47);
        if (indexOf != -1) {
            return id.substring(0, indexOf);
        }
        return id;
    }

    public void execute(ChangeSet changeset) {
        this.execute(changeset, (ProgressLogger)new NullProgressLogger());
    }

    public void execute(ChangeSet changeset, ProgressLogger progressLogger) {
        this.jcrTemplate.execute(new JcrChangeSetExecutor(this, changeset, this.passwordEncrypter, this.licenseService, progressLogger));
    }

    public void execute(ChangeSet changeset, ProgressLogger progressLogger, String taskId) {
        this.jcrTemplate.execute(new JcrChangeSetExecutor(this, changeset, this.passwordEncrypter, this.licenseService, progressLogger));
    }

    public void checkReferentialIntegrity(ChangeSet changeset) throws ItemInUseException, ItemAlreadyExistsException {
        this.jcrTemplate.execute(new JcrReferentialIntegrityChecker(this, changeset, this.passwordEncrypter, this.licenseService));
    }

    public void setReuseNodeReaderContext(boolean reuseNodeReaderContext) {
        this.reuseNodeReaderContext = reuseNodeReaderContext;
    }
}

