/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.core.rest.websockets;

import com.xebialabs.deployit.core.events.ChangeSetEvent;
import com.xebialabs.deployit.core.websockets.WebSocketEndpoints;
import com.xebialabs.deployit.engine.spi.event.MaintenanceStartEvent;
import com.xebialabs.deployit.engine.spi.event.MaintenanceStopEvent;
import com.xebialabs.deployit.event.EventBusHolder;
import java.util.Collection;
import nl.javadude.t2bus.Subscribe;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.messaging.simp.SimpMessagingTemplate;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.stereotype.Controller;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.convert.ImplicitConversions$;
import scala.collection.immutable.Map;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@Controller
@ScalaSignature(bytes="\u0006\u0001\u0005-c\u0001B\u0005\u000b\u0001]A\u0001B\b\u0001\u0003\u0002\u0003\u0006Ia\b\u0005\u0006m\u0001!\ta\u000e\u0005\u0006y\u0001!I!\u0010\u0005\u0006\u0019\u0002!I!\u0014\u0005\u0006]\u0002!\ta\u001c\u0005\b\u0003\u000f\u0001A\u0011BA\u0005\u0011\u001d\t)\u0002\u0001C\u0001\u0003/Aq!a\f\u0001\t\u0003\t\tDA\fXK\n\u001cvnY6fi6+7o]1hKN\u001cVM\u001c3fe*\u00111\u0002D\u0001\u000bo\u0016\u00147o\\2lKR\u001c(BA\u0007\u000f\u0003\u0011\u0011Xm\u001d;\u000b\u0005=\u0001\u0012\u0001B2pe\u0016T!!\u0005\n\u0002\u0011\u0011,\u0007\u000f\\8zSRT!a\u0005\u000b\u0002\u0013a,'-[1mC\n\u001c(\"A\u000b\u0002\u0007\r|Wn\u0001\u0001\u0014\u0005\u0001A\u0002CA\r\u001d\u001b\u0005Q\"\"A\u000e\u0002\u000bM\u001c\u0017\r\\1\n\u0005uQ\"AB!osJ+g-A\bnKN\u001c\u0018mZ3UK6\u0004H.\u0019;f!\t\u0001\u0013&D\u0001\"\u0015\t\u00113%\u0001\u0003tS6\u0004(B\u0001\u0013&\u0003%iWm]:bO&twM\u0003\u0002'O\u0005y1\u000f\u001d:j]\u001e4'/Y7fo>\u00148NC\u0001)\u0003\ry'oZ\u0005\u0003U\u0005\u0012QcU5na6+7o]1hS:<G+Z7qY\u0006$X\r\u000b\u0002\u0002YA\u0011Q\u0006N\u0007\u0002])\u0011q\u0006M\u0001\u000bC:tw\u000e^1uS>t'BA\u00193\u0003\u001d1\u0017m\u0019;pefT!aM\u0013\u0002\u000b\t,\u0017M\\:\n\u0005Ur#!C!vi><\u0018N]3e\u0003\u0019a\u0014N\\5u}Q\u0011\u0001H\u000f\t\u0003s\u0001i\u0011A\u0003\u0005\u0006=\t\u0001\ra\b\u0015\u0003u1\n!bZ3u\u0011\u0016\fG-\u001a:t+\u0005q\u0004\u0003B G\u0013bq!\u0001\u0011#\u0011\u0005\u0005SR\"\u0001\"\u000b\u0005\r3\u0012A\u0002\u001fs_>$h(\u0003\u0002F5\u00051\u0001K]3eK\u001aL!a\u0012%\u0003\u00075\u000b\u0007O\u0003\u0002F5A\u0011qHS\u0005\u0003\u0017\"\u0013aa\u0015;sS:<\u0017\u0001\u00058pi&4\u00170\u00134O_R,U\u000e\u001d;z)\rq\u0015\u000b\u0017\t\u00033=K!\u0001\u0015\u000e\u0003\tUs\u0017\u000e\u001e\u0005\u0006%\u0012\u0001\raU\u0001\tK:$\u0007o\\5oiB\u0011AKV\u0007\u0002+*\u00111BD\u0005\u0003/V\u0013!cV3c'>\u001c7.\u001a;F]\u0012\u0004x.\u001b8ug\")\u0011\f\u0002a\u00015\u0006\u00191-[:1\u0005m+\u0007c\u0001/bG6\tQL\u0003\u0002_?\u0006!Q\u000f^5m\u0015\u0005\u0001\u0017\u0001\u00026bm\u0006L!AY/\u0003\u0015\r{G\u000e\\3di&|g\u000e\u0005\u0002eK2\u0001A!\u00034Y\u0003\u0003\u0005\tQ!\u0001h\u0005\ryF%M\t\u0003Q.\u0004\"!G5\n\u0005)T\"a\u0002(pi\"Lgn\u001a\t\u000331L!!\u001c\u000e\u0003\u0007\u0005s\u00170A\ftK:$7)[\"iC:<WmU3u\u001b\u0016\u001c8/Y4fgR\u0011a\n\u001d\u0005\u0006c\u0016\u0001\rA]\u0001\u0006KZ,g\u000e\u001e\t\u0003gZl\u0011\u0001\u001e\u0006\u0003k:\ta!\u001a<f]R\u001c\u0018BA<u\u00059\u0019\u0005.\u00198hKN+G/\u0012<f]RD#!B=\u0011\u0007i\f\u0019!D\u0001|\u0015\taX0A\u0003ue\t,8O\u0003\u0002\u007f\u007f\u0006A!.\u0019<bIV$WM\u0003\u0002\u0002\u0002\u0005\u0011a\u000e\\\u0005\u0004\u0003\u000bY(!C*vEN\u001c'/\u001b2f\u0003\u0001rw\u000e^5gs\u0006\u0013w.\u001e;NC&tG/\u001a8b]\u000e,Wj\u001c3f\u0007\"\fgnZ3\u0015\u00079\u000bY\u0001C\u0004\u0002\u000e\u0019\u0001\r!a\u0004\u0002\u000f\u0015t\u0017M\u00197fIB\u0019\u0011$!\u0005\n\u0007\u0005M!DA\u0004C_>dW-\u00198\u0002-M,g\u000eZ'bS:$XM\\1oG\u0016\u001cF/\u0019:uK\u0012$2ATA\r\u0011\u0019\tx\u00011\u0001\u0002\u001cA!\u0011QDA\u0015\u001b\t\tyBC\u0002r\u0003CQA!a\t\u0002&\u0005\u00191\u000f]5\u000b\u0007\u0005\u001d\u0002#\u0001\u0004f]\u001eLg.Z\u0005\u0005\u0003W\tyBA\u000bNC&tG/\u001a8b]\u000e,7\u000b^1si\u00163XM\u001c;)\u0005\u001dI\u0018AF:f]\u0012l\u0015-\u001b8uK:\fgnY3Ti>\u0004\b/\u001a3\u0015\u00079\u000b\u0019\u0004\u0003\u0004r\u0011\u0001\u0007\u0011Q\u0007\t\u0005\u0003;\t9$\u0003\u0003\u0002:\u0005}!\u0001F'bS:$XM\\1oG\u0016\u001cFo\u001c9Fm\u0016tG\u000f\u000b\u0002\ts\"\u001a\u0001!a\u0010\u0011\t\u0005\u0005\u0013qI\u0007\u0003\u0003\u0007R1!!\u0012&\u0003)\u0019H/\u001a:f_RL\b/Z\u0005\u0005\u0003\u0013\n\u0019E\u0001\u0006D_:$(o\u001c7mKJ\u0004")
public class WebSocketMessagesSender {
    @Autowired
    private final SimpMessagingTemplate messageTemplate;

    private Map<String, Object> getHeaders() {
        String currentUser = SecurityContextHolder.getContext().getAuthentication().getName();
        return (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"username"), (Object)currentUser)}));
    }

    private void notifyIfNotEmpty(WebSocketEndpoints endpoint, Collection<?> cis) {
        block0: {
            if (!ImplicitConversions$.MODULE$.collection$u0020AsScalaIterable(cis).nonEmpty()) break block0;
            this.messageTemplate.convertAndSend((Object)endpoint.getName(), cis, ImplicitConversions$.MODULE$.map$u0020AsJavaMap(this.getHeaders()));
        }
    }

    @Subscribe
    public void sendCiChangeSetMessages(ChangeSetEvent event) {
        this.notifyIfNotEmpty(WebSocketEndpoints.TOPIC_CI_CREATE, event.createCis());
        this.notifyIfNotEmpty(WebSocketEndpoints.TOPIC_CI_UPDATE, event.updateCis());
        this.notifyIfNotEmpty(WebSocketEndpoints.TOPIC_CI_DELETE, event.deleteCiIds());
        this.notifyIfNotEmpty(WebSocketEndpoints.TOPIC_CI_RENAME, event.renameCis());
        this.notifyIfNotEmpty(WebSocketEndpoints.TOPIC_CI_MOVE, event.moveCis());
        this.notifyIfNotEmpty(WebSocketEndpoints.TOPIC_CI_COPY, event.copyCis());
    }

    private void notifyAboutMaintenanceModeChange(boolean enabled) {
        this.messageTemplate.convertAndSend((Object)WebSocketEndpoints.TOPIC_MAINTENANCE.getName(), (Object)BoxesRunTime.boxToBoolean((boolean)enabled), ImplicitConversions$.MODULE$.map$u0020AsJavaMap(this.getHeaders()));
    }

    @Subscribe
    public void sendMaintenanceStarted(MaintenanceStartEvent event) {
        this.notifyAboutMaintenanceModeChange(true);
    }

    @Subscribe
    public void sendMaintenanceStopped(MaintenanceStopEvent event) {
        this.notifyAboutMaintenanceModeChange(false);
    }

    public WebSocketMessagesSender(@Autowired SimpMessagingTemplate messageTemplate) {
        this.messageTemplate = messageTemplate;
        EventBusHolder.register((Object)this);
    }
}

