/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.core.rest.json;

import com.google.common.annotations.VisibleForTesting;
import com.xebialabs.deployit.plugin.api.reflect.PropertyDescriptor;
import com.xebialabs.deployit.plugin.api.validation.PatternValidator;
import com.xebialabs.xltype.serialization.json.JsonWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.Set;
import javax.ws.rs.Consumes;
import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.ext.MessageBodyWriter;
import javax.ws.rs.ext.Provider;
import org.springframework.stereotype.Component;

@Component
@Provider
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
public class PropertyDescriptorJsonWriter
implements MessageBodyWriter<PropertyDescriptor> {
    private static void writeValue(JsonWriter writer, String key, Object value) {
        if (value instanceof Collection) {
            writer.key(key);
            writer.array();
            for (Object current : (Iterable)value) {
                writer.value(current);
            }
            writer.endArray();
        } else {
            writer.key(key).value(value);
        }
    }

    public boolean isWriteable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return PropertyDescriptor.class.isAssignableFrom(type);
    }

    public long getSize(PropertyDescriptor propertyDescriptor, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return -1L;
    }

    public void writeTo(PropertyDescriptor propertyDescriptor, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, Object> httpHeaders, OutputStream entityStream) throws IOException, WebApplicationException {
        entityStream.write(this.toJson(propertyDescriptor).getBytes());
    }

    @VisibleForTesting
    String toJson(PropertyDescriptor propertyDescriptor) {
        StringWriter stringWriter = new StringWriter();
        JsonWriter writer = new JsonWriter((Writer)stringWriter);
        PropertyDescriptorJsonWriter.writePropertyDescriptor(writer, propertyDescriptor);
        return stringWriter.toString();
    }

    static void writePropertyDescriptor(JsonWriter writer, PropertyDescriptor propertyDescriptor) {
        writer.object();
        writer.key("name").value((Object)propertyDescriptor.getName());
        writer.key("fqn").value((Object)propertyDescriptor.getFqn());
        writer.key("label").value((Object)propertyDescriptor.getLabel());
        writer.key("kind").value((Object)propertyDescriptor.getKind().name());
        writer.key("description").value((Object)propertyDescriptor.getDescription());
        writer.key("category").value((Object)propertyDescriptor.getCategory());
        writer.key("asContainment").value(propertyDescriptor.isAsContainment());
        writer.key("inspection").value(propertyDescriptor.isInspectionProperty());
        writer.key("required").value(propertyDescriptor.isRequired());
        writer.key("requiredInspection").value(propertyDescriptor.isRequiredForInspection());
        writer.key("password").value(propertyDescriptor.isPassword());
        writer.key("transient").value(propertyDescriptor.isTransient());
        writer.key("size").value((Object)propertyDescriptor.getSize().name());
        writer.key("referencedType").value((Object)propertyDescriptor.getReferencedType());
        PropertyDescriptorJsonWriter.writeValue(writer, "default", propertyDescriptor.getDefaultValue());
        if (propertyDescriptor.isHidden()) {
            writer.key("hidden").value(true);
        }
        PropertyDescriptorJsonWriter.writeValue(writer, "enumValues", propertyDescriptor.getEnumValues());
        PropertyDescriptorJsonWriter.writeInputHint(writer, propertyDescriptor);
        writer.endObject();
    }

    private static void writeInputHint(JsonWriter writer, PropertyDescriptor propertyDescriptor) {
        if (propertyDescriptor.getInputHint() != null) {
            writer.key("inputHint");
            writer.object();
            writer.key("kind").value((Object)propertyDescriptor.getInputHint().getKind());
            if (propertyDescriptor.getInputHint().getValues() != null) {
                writer.key("values");
                writer.array();
                propertyDescriptor.getInputHint().getValues().forEach(inputHintValue -> {
                    writer.object();
                    writer.key("value").value((Object)inputHintValue.getValue());
                    writer.key("label").value((Object)inputHintValue.getLabel());
                    writer.endObject();
                });
                writer.endArray();
            }
            writer.key("rules");
            writer.array();
            Set validationRules = propertyDescriptor.getInputHint().getValidationRules();
            if (validationRules != null && !validationRules.isEmpty()) {
                validationRules.stream().filter(v -> v instanceof PatternValidator).map(v -> (PatternValidator)v).forEach(patternValidator -> {
                    writer.object();
                    writer.key("message").value((Object)patternValidator.getMessage());
                    writer.key("pattern").value((Object)patternValidator.getPattern());
                    writer.endObject();
                });
            }
            writer.endArray();
            writer.key("prompt").value((Object)propertyDescriptor.getInputHint().getPrompt());
            writer.key("required").value(propertyDescriptor.getInputHint().isRequired());
            writer.key("copy-from-property").value((Object)propertyDescriptor.getInputHint().getCopyFromProperty());
            writer.endObject();
        }
    }
}

