/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.engine.tasker;

import akka.actor.Actor;
import akka.actor.ActorContext;
import akka.actor.ActorNotFound;
import akka.actor.ActorRef;
import akka.actor.ActorSelection;
import akka.actor.ActorSelection$;
import akka.actor.ActorSystem;
import akka.actor.Props$;
import akka.actor.ScalaActorRef;
import akka.actor.ScalaActorSelection;
import akka.actor.SupervisorStrategy;
import akka.actor.package$;
import akka.annotation.InternalApi;
import akka.pattern.AskableActorRef$;
import akka.pattern.AskableActorSelection$;
import akka.util.Timeout;
import com.github.nscala_time.time.Imports$;
import com.github.nscala_time.time.RichDateTime$;
import com.github.nscala_time.time.RichReadableInstant$;
import com.github.nscala_time.time.RichReadableInterval$;
import com.xebialabs.deployit.engine.api.execution.TaskExecutionState;
import com.xebialabs.deployit.engine.spi.services.RepositoryFactory;
import com.xebialabs.deployit.engine.tasker.ActiveTasksQueue$;
import com.xebialabs.deployit.engine.tasker.Archive;
import com.xebialabs.deployit.engine.tasker.ArchiveActor$;
import com.xebialabs.deployit.engine.tasker.ArchivedListeningActor;
import com.xebialabs.deployit.engine.tasker.ArchivedListeningActor$;
import com.xebialabs.deployit.engine.tasker.BlockPath;
import com.xebialabs.deployit.engine.tasker.BlockPath$Root$;
import com.xebialabs.deployit.engine.tasker.IEngine;
import com.xebialabs.deployit.engine.tasker.RecoverySupervisorActor;
import com.xebialabs.deployit.engine.tasker.RecoverySupervisorActor$;
import com.xebialabs.deployit.engine.tasker.RecoverySupervisorActor$ReadAll$;
import com.xebialabs.deployit.engine.tasker.Task;
import com.xebialabs.deployit.engine.tasker.TaskExecutionEngine$;
import com.xebialabs.deployit.engine.tasker.TaskManagingActor;
import com.xebialabs.deployit.engine.tasker.TaskManagingActor$;
import com.xebialabs.deployit.engine.tasker.TaskNotFoundException;
import com.xebialabs.deployit.engine.tasker.TaskRecoveryListener$;
import com.xebialabs.deployit.engine.tasker.TaskRegistryExtension;
import com.xebialabs.deployit.engine.tasker.TaskRegistryExtension$;
import com.xebialabs.deployit.engine.tasker.TaskSpecification;
import com.xebialabs.deployit.engine.tasker.TaskTransitionActor$;
import com.xebialabs.deployit.engine.tasker.TaskerException;
import com.xebialabs.deployit.engine.tasker.messages.Abort;
import com.xebialabs.deployit.engine.tasker.messages.AddPauseStep;
import com.xebialabs.deployit.engine.tasker.messages.Enqueue;
import com.xebialabs.deployit.engine.tasker.messages.ModifySteps;
import com.xebialabs.deployit.engine.tasker.messages.PathsNotFound;
import com.xebialabs.deployit.engine.tasker.messages.RunMode$;
import com.xebialabs.deployit.engine.tasker.messages.SkipSteps;
import com.xebialabs.deployit.engine.tasker.messages.StepModificationError;
import com.xebialabs.deployit.engine.tasker.messages.Stop;
import com.xebialabs.deployit.engine.tasker.messages.Stop$;
import com.xebialabs.deployit.engine.tasker.messages.TaskDone;
import com.xebialabs.deployit.engine.tasker.messages.UnSkipSteps;
import com.xebialabs.deployit.plugin.api.services.Repository;
import com.xebialabs.xlplatform.settings.CommonSettings;
import com.xebialabs.xlplatform.settings.CommonSettings$;
import com.xebialabs.xlplatform.settings.TaskerSettings;
import grizzled.slf4j.Logger;
import grizzled.slf4j.Logging;
import java.io.File;
import java.io.FileFilter;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.nio.file.Files;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;
import org.joda.time.ReadableInterval;
import org.slf4j.Marker;
import scala.Function0;
import scala.Function1;
import scala.Function3;
import scala.MatchError;
import scala.Option;
import scala.Option$;
import scala.PartialFunction;
import scala.Predef$;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.SetLike;
import scala.collection.TraversableLike;
import scala.collection.immutable.List;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.Buffer$;
import scala.concurrent.Await$;
import scala.concurrent.Awaitable;
import scala.concurrent.Promise;
import scala.concurrent.Promise$;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.Duration$;
import scala.concurrent.duration.package;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.java8.JFunction0;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;

@ScalaSignature(bytes="\u0006\u0001\t\u0015g\u0001\u0002\u00180\u0001iB\u0001b\u0014\u0001\u0003\u0002\u0003\u0006I\u0001\u0015\u0005\t'\u0002\u0011\t\u0011)A\u0005)\"AA\f\u0001BC\u0002\u0013\rQ\f\u0003\u0005g\u0001\t\u0005\t\u0015!\u0003_\u0011\u00159\u0007\u0001\"\u0001i\u0011\u001di\u0007A1A\u0005\u00029Daa\u001e\u0001!\u0002\u0013y\u0007b\u0002=\u0001\u0005\u0004%\t!\u001f\u0005\u0007{\u0002\u0001\u000b\u0011\u0002>\t\u000fy\u0004!\u0019!C\u0001s\"1q\u0010\u0001Q\u0001\niD\u0001\"!\u0001\u0001\u0005\u0004%\t!\u001f\u0005\b\u0003\u0007\u0001\u0001\u0015!\u0003{\u0011!\t)\u0001\u0001b\u0001\n\u0003I\bbBA\u0004\u0001\u0001\u0006IA\u001f\u0005\b\u0003\u0013\u0001A\u0011AA\u0006\u0011\u001d\tY\u0003\u0001C\u0001\u0003\u0017Aq!!\u000e\u0001\t\u0003\tY\u0001C\u0004\u00028\u0001!I!a\u0003\t\u000f\u0005e\u0002\u0001\"\u0001\u0002<!9\u0011q\t\u0001\u0005\u0002\u0005%\u0003\"CA8\u0001E\u0005I\u0011AA9\u0011\u001d\t)\t\u0001C\u0001\u0003\u000fCq!!+\u0001\t\u0013\tY\u000b\u0003\u0005\u0002B\u0002!\tbLAb\u0011\u0019y\u0005\u0001\"\u0001\u0002H\"9\u00111\u001a\u0001\u0005B\u00055\u0007\u0002CAt\u0001\u0001&I!!;\t\u000f\t\u0015\u0001\u0001\"\u0003\u0003\b!A!1\u0004\u0001\u0005\u0012=\u0012i\u0002C\u0004\u0003*\u0001!IAa\u000b\t\u000f\tE\u0002\u0001\"\u0011\u00034!A!\u0011\b\u0001!\n\u0013\u0011Y\u0004C\u0004\u0003B\u0001!\tEa\u0011\t\u000f\t\u0005\u0003\u0001\"\u0001\u0003L!9!\u0011\b\u0001\u0005\u0002\tE\u0003bBAt\u0001\u0011\u0005!\u0011\f\u0005\b\u0005?\u0002A\u0011\u0001B1\u0011\u001d\u0011)\u0007\u0001C\u0001\u0005OBqAa\u001b\u0001\t\u0003\u0011i\u0007C\u0004\u0003r\u0001!\tAa\u001d\t\u000f\t]\u0004\u0001\"\u0001\u0003z!9!Q\u0016\u0001\u0005\u0002\t=\u0006b\u0002B^\u0001\u0011\u0005!Q\u0018\u0005\b\u0005\u0003\u0004A\u0011\u0001Bb\u0005M!\u0016m]6Fq\u0016\u001cW\u000f^5p]\u0016sw-\u001b8f\u0015\t\u0001\u0014'\u0001\u0004uCN\\WM\u001d\u0006\u0003eM\na!\u001a8hS:,'B\u0001\u001b6\u0003!!W\r\u001d7ps&$(B\u0001\u001c8\u0003%AXMY5bY\u0006\u00147OC\u00019\u0003\r\u0019w.\\\u0002\u0001'\u0011\u00011hQ$\u0011\u0005q\nU\"A\u001f\u000b\u0005yz\u0014\u0001\u00027b]\u001eT\u0011\u0001Q\u0001\u0005U\u00064\u0018-\u0003\u0002C{\t1qJ\u00196fGR\u0004\"\u0001R#\u000e\u0003=J!AR\u0018\u0003\u000f%+enZ5oKB\u0011\u0001*T\u0007\u0002\u0013*\u0011!jS\u0001\u0006g24GG\u001b\u0006\u0002\u0019\u0006AqM]5{u2,G-\u0003\u0002O\u0013\n9Aj\\4hS:<\u0017aB1sG\"Lg/\u001a\t\u0003\tFK!AU\u0018\u0003\u000f\u0005\u00138\r[5wK\u0006\t\"/\u001a9pg&$xN]=GC\u000e$xN]=\u0011\u0005USV\"\u0001,\u000b\u0005]C\u0016\u0001C:feZL7-Z:\u000b\u0005e\u000b\u0014aA:qS&\u00111L\u0016\u0002\u0012%\u0016\u0004xn]5u_JLh)Y2u_JL\u0018AB:zgR,W.F\u0001_!\tyF-D\u0001a\u0015\t\t'-A\u0003bGR|'OC\u0001d\u0003\u0011\t7n[1\n\u0005\u0015\u0004'aC!di>\u00148+_:uK6\fqa]=ti\u0016l\u0007%\u0001\u0004=S:LGO\u0010\u000b\u0005S*\\G\u000e\u0005\u0002E\u0001!)q*\u0002a\u0001!\")1+\u0002a\u0001)\")A,\u0002a\u0002=\u0006qA/Y:lKJ\u001cV\r\u001e;j]\u001e\u001cX#A8\u0011\u0005A,X\"A9\u000b\u0005I\u001c\u0018\u0001C:fiRLgnZ:\u000b\u0005Q,\u0014A\u0003=ma2\fGOZ8s[&\u0011a/\u001d\u0002\u000f)\u0006\u001c8.\u001a:TKR$\u0018N\\4t\u0003=!\u0018m]6feN+G\u000f^5oON\u0004\u0013\u0001C1sG\"Lg/\u001a:\u0016\u0003i\u0004\"aX>\n\u0005q\u0004'\u0001C!di>\u0014(+\u001a4\u0002\u0013\u0005\u00148\r[5wKJ\u0004\u0013\u0001\u0005;bg.$&/\u00198tSRLwN\\3s\u0003E!\u0018m]6Ue\u0006t7/\u001b;j_:,'\u000fI\u0001\u0013e\u0016\u001cwN^3ssN+\b/\u001a:wSN|'/A\nsK\u000e|g/\u001a:z'V\u0004XM\u001d<jg>\u0014\b%\u0001\u000buCN\\'+Z2pm\u0016\u0014\u0018\u0010T5ti\u0016tWM]\u0001\u0016i\u0006\u001c8NU3d_Z,'/\u001f'jgR,g.\u001a:!\u00035\u0019\b.\u001e;e_^tG+Y:lgR\u0011\u0011Q\u0002\t\u0005\u0003\u001f\t)\"\u0004\u0002\u0002\u0012)\u0011\u00111C\u0001\u0006g\u000e\fG.Y\u0005\u0005\u0003/\t\tB\u0001\u0003V]&$\bf\u0001\t\u0002\u001cA!\u0011QDA\u0014\u001b\t\tyB\u0003\u0003\u0002\"\u0005\r\u0012AC1o]>$\u0018\r^5p]*\u0011\u0011QE\u0001\u0006U\u00064\u0018\r_\u0005\u0005\u0003S\tyB\u0001\u0006Qe\u0016$Um\u001d;s_f\fA!\u001b8ji\"\u001a\u0011#a\f\u0011\t\u0005u\u0011\u0011G\u0005\u0005\u0003g\tyBA\u0007Q_N$8i\u001c8tiJ,8\r^\u0001\re\u0016\u001cwN^3s)\u0006\u001c8n]\u0001\u0010G2,\u0017M\\+q)6\u0004h)\u001b7fg\u0006IqN\u001c*fG>4XM\u001d\u000b\u0005\u0003\u001b\ti\u0004C\u0004\u0002@Q\u0001\r!!\u0011\u0002\tQ\f7o\u001b\t\u0004\t\u0006\r\u0013bAA#_\t!A+Y:l\u0003\u0019\u0019\u0017M\\2fYR1\u0011QBA&\u0003KBq!!\u0014\u0016\u0001\u0004\ty%\u0001\u0004uCN\\\u0017\u000e\u001a\t\u0005\u0003#\nyF\u0004\u0003\u0002T\u0005m\u0003\u0003BA+\u0003#i!!a\u0016\u000b\u0007\u0005e\u0013(\u0001\u0004=e>|GOP\u0005\u0005\u0003;\n\t\"\u0001\u0004Qe\u0016$WMZ\u0005\u0005\u0003C\n\u0019G\u0001\u0004TiJLgn\u001a\u0006\u0005\u0003;\n\t\u0002C\u0005\u0002hU\u0001\n\u00111\u0001\u0002j\u0005)am\u001c:dKB!\u0011qBA6\u0013\u0011\ti'!\u0005\u0003\u000f\t{w\u000e\\3b]\u0006\u00012-\u00198dK2$C-\u001a4bk2$HEM\u000b\u0003\u0003gRC!!\u001b\u0002v-\u0012\u0011q\u000f\t\u0005\u0003s\n\t)\u0004\u0002\u0002|)!\u0011QPA@\u0003%)hn\u00195fG.,GM\u0003\u0003\u0002\"\u0005E\u0011\u0002BAB\u0003w\u0012\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u0003-\t'o\u00195jm\u0016<\u0016\u000e\u001e5\u0015\r\u00055\u0011\u0011RAM\u0011\u001d\tie\u0006a\u0001\u0003\u0017\u0003B!!$\u0002\u0014:\u0019A)a$\n\u0007\u0005Eu&A\u0004qC\u000e\\\u0017mZ3\n\t\u0005U\u0015q\u0013\u0002\u0007)\u0006\u001c8.\u00133\u000b\u0007\u0005Eu\u0006C\u0004\u0002\u001c^\u0001\r!!(\u0002\u00075\u001cx\r\u0005\u0006\u0002\u0010\u0005}\u00151\u0012>{\u0003GKA!!)\u0002\u0012\tIa)\u001e8di&|gn\r\t\u0005\u0003\u001f\t)+\u0003\u0003\u0002(\u0006E!AB!osJ+g-\u0001\tde\u0016\fG/\u001a*fa>\u001c\u0018\u000e^8ssR!\u0011QVA`!\u0011\ty+a/\u000e\u0005\u0005E&bA,\u00024*!\u0011QWA\\\u0003\r\t\u0007/\u001b\u0006\u0004\u0003s\u001b\u0014A\u00029mk\u001eLg.\u0003\u0003\u0002>\u0006E&A\u0003*fa>\u001c\u0018\u000e^8ss\"9\u0011q\b\rA\u0002\u0005\u0005\u0013aD2sK\u0006$X\rV1tW\u0006\u001bGo\u001c:\u0015\u0007i\f)\rC\u0004\u0002@e\u0001\r!!\u0011\u0015\t\u00055\u0011\u0011\u001a\u0005\b\u0003\u001bR\u0002\u0019AA(\u0003%\u00198.\u001b9Ti\u0016\u00048\u000f\u0006\u0004\u0002\u000e\u0005=\u0017\u0011\u001b\u0005\b\u0003\u001bZ\u0002\u0019AA(\u0011\u001d\t\u0019n\u0007a\u0001\u0003+\fqa\u001d;fa:\u00138\u000f\u0005\u0004\u0002X\u0006u\u0017\u0011]\u0007\u0003\u00033T1!a7@\u0003\u0011)H/\u001b7\n\t\u0005}\u0017\u0011\u001c\u0002\u0005\u0019&\u001cH\u000fE\u0002=\u0003GL1!!:>\u0005\u001dIe\u000e^3hKJ\fQb]6jaN#X\r\u001d)bi\"\u001cHCBA\u0007\u0003W\fi\u000fC\u0004\u0002Nq\u0001\r!a\u0014\t\u000f\u0005MG\u00041\u0001\u0002pB1\u0011\u0011_A}\u0003\u007ftA!a=\u0002x:!\u0011QKA{\u0013\t\t\u0019\"\u0003\u0003\u0002\u0012\u0006E\u0011\u0002BA~\u0003{\u00141aU3r\u0015\u0011\t\t*!\u0005\u0011\u0007\u0011\u0013\t!C\u0002\u0003\u0004=\u0012\u0011B\u00117pG.\u0004\u0016\r\u001e5\u0002\u00155\fg.Y4f'R,\u0007\u000f\u0006\u0004\u0002\u000e\t%!1\u0002\u0005\b\u0003\u001bj\u0002\u0019AA(\u0011\u001d\u0011i!\ba\u0001\u0005\u001f\tq!\\3tg\u0006<W\r\u0005\u0003\u0003\u0012\t]QB\u0001B\n\u0015\r\u0011)bL\u0001\t[\u0016\u001c8/Y4fg&!!\u0011\u0004B\n\u0005-iu\u000eZ5gsN#X\r]:\u0002\u001f1|wn[;q)\u0006\u001c8.Q2u_J$BAa\b\u0003&A\u0019qL!\t\n\u0007\t\r\u0002M\u0001\bBGR|'oU3mK\u000e$\u0018n\u001c8\t\u000f\t\u001db\u00041\u0001\u0002P\u0005\t1/A\u0007j]R\u0014$\t\\8dWB\u000bG\u000f\u001b\u000b\u0005\u0003\u007f\u0014i\u0003C\u0004\u00030}\u0001\r!!9\u0002\u0017=dG\rU8tSRLwN\\\u0001\fk:\u001c8.\u001b9Ti\u0016\u00048\u000f\u0006\u0004\u0002\u000e\tU\"q\u0007\u0005\b\u0003\u001b\u0002\u0003\u0019AA(\u0011\u001d\t\u0019\u000e\ta\u0001\u0003+\fq\"\u001e8tW&\u00048\u000b^3q!\u0006$\bn\u001d\u000b\u0007\u0003\u001b\u0011iDa\u0010\t\u000f\u00055\u0013\u00051\u0001\u0002P!9\u00111[\u0011A\u0002\u0005=\u0018\u0001D1eIB\u000bWo]3Ti\u0016\u0004HCBA\u0007\u0005\u000b\u00129\u0005C\u0004\u0002N\t\u0002\r!a\u0014\t\u000f\t%#\u00051\u0001\u0002b\u0006A\u0001o\\:ji&|g\u000e\u0006\u0004\u0002\u000e\t5#q\n\u0005\b\u0003\u001b\u001a\u0003\u0019AA(\u0011\u001d\u0011Ie\ta\u0001\u0003\u007f$b!!\u0004\u0003T\tU\u0003bBA'I\u0001\u0007\u0011q\n\u0005\b\u0003'$\u0003\u0019\u0001B,!\u0019\t9.!8\u0002\u0000R1\u0011Q\u0002B.\u0005;Bq!!\u0014&\u0001\u0004\ty\u0005C\u0004\u0002T\u0016\u0002\rAa\u0016\u0002\tM$x\u000e\u001d\u000b\u0005\u0003\u001b\u0011\u0019\u0007C\u0004\u0002N\u0019\u0002\r!a\u0014\u0002\u000b\u0005\u0014wN\u001d;\u0015\t\u00055!\u0011\u000e\u0005\b\u0003\u001b:\u0003\u0019AA(\u0003\u001d)\u00070Z2vi\u0016$B!!\u0004\u0003p!9\u0011Q\n\u0015A\u0002\u0005=\u0013\u0001\u0003:fiJLWM^3\u0015\t\u0005\u0005#Q\u000f\u0005\b\u0003\u001bJ\u0003\u0019AA(\u0003!\u00198\r[3ek2,GCBA\u0007\u0005w\u0012i\bC\u0004\u0002N)\u0002\r!a\u0014\t\u000f\t}$\u00061\u0001\u0003\u0002\u0006Q1o\u00195fIVdW-\u0011;\u0011\t\t\r%Q\u0015\b\u0005\u0005\u000b\u0013yJ\u0004\u0003\u0003\b\nee\u0002\u0002BE\u0005'sAAa#\u0003\u0010:!\u0011Q\u000bBG\u0013\u0005A\u0014b\u0001BIo\u00051q-\u001b;ik\nLAA!&\u0003\u0018\u0006Yan]2bY\u0006|F/[7f\u0015\r\u0011\tjN\u0005\u0005\u00057\u0013i*\u0001\u0003uS6,'\u0002\u0002BK\u0005/KAA!)\u0003$\u00069\u0011*\u001c9peR\u001c(\u0002\u0002BN\u0005;KAAa*\u0003*\nAA)\u0019;f)&lW-\u0003\u0003\u0003,\n\r&a\u0003+za\u0016LU\u000e]8siN\f\u0001B]3hSN$XM\u001d\u000b\u0005\u0003\u001f\u0012\t\fC\u0004\u00034.\u0002\rA!.\u0002\tM\u0004Xm\u0019\t\u0004\t\n]\u0016b\u0001B]_\t\tB+Y:l'B,7-\u001b4jG\u0006$\u0018n\u001c8\u0002+\u001d,G/\u00117m\u0013:\u001cw.\u001c9mKR,G+Y:lgR\u0011!q\u0018\t\u0007\u0003/\fi.!\u0011\u0002\u0013\u001d,GoU=ti\u0016lG#\u00010")
public class TaskExecutionEngine
implements IEngine,
Logging {
    private final RepositoryFactory repositoryFactory;
    private final ActorSystem system;
    private final TaskerSettings taskerSettings;
    private final ActorRef archiver;
    private final ActorRef taskTransitioner;
    private final ActorRef recoverySupervisor;
    private final ActorRef taskRecoveryListener;
    private Logger grizzled$slf4j$Logging$$_logger;
    private volatile boolean bitmap$0;

    public Logger logger() {
        return Logging.logger$((Logging)this);
    }

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void trace(Function0<Object> msg) {
        Logging.trace$((Logging)this, msg);
    }

    public void trace(Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, msg, t);
    }

    public void trace(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$((Logging)this);
    }

    public void debug(Function0<Object> msg) {
        Logging.debug$((Logging)this, msg);
    }

    public void debug(Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, msg, t);
    }

    public void debug(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isErrorEnabled() {
        return Logging.isErrorEnabled$((Logging)this);
    }

    public void error(Function0<Object> msg) {
        Logging.error$((Logging)this, msg);
    }

    public void error(Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, msg, t);
    }

    public void error(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isInfoEnabled() {
        return Logging.isInfoEnabled$((Logging)this);
    }

    public void info(Function0<Object> msg) {
        Logging.info$((Logging)this, msg);
    }

    public void info(Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, msg, t);
    }

    public void info(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isWarnEnabled() {
        return Logging.isWarnEnabled$((Logging)this);
    }

    public void warn(Function0<Object> msg) {
        Logging.warn$((Logging)this, msg);
    }

    public void warn(Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, msg, t);
    }

    public void warn(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, (Marker)mkr, msg, t);
    }

    @Override
    public void cancel(String taskid) {
        IEngine.super.cancel(taskid);
    }

    private Logger grizzled$slf4j$Logging$$_logger$lzycompute() {
        TaskExecutionEngine taskExecutionEngine = this;
        synchronized (taskExecutionEngine) {
            if (!this.bitmap$0) {
                this.grizzled$slf4j$Logging$$_logger = Logging.grizzled$slf4j$Logging$$_logger$((Logging)this);
                this.bitmap$0 = true;
            }
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    public Logger grizzled$slf4j$Logging$$_logger() {
        return !this.bitmap$0 ? this.grizzled$slf4j$Logging$$_logger$lzycompute() : this.grizzled$slf4j$Logging$$_logger;
    }

    public ActorSystem system() {
        return this.system;
    }

    public TaskerSettings taskerSettings() {
        return this.taskerSettings;
    }

    public ActorRef archiver() {
        return this.archiver;
    }

    public ActorRef taskTransitioner() {
        return this.taskTransitioner;
    }

    public ActorRef recoverySupervisor() {
        return this.recoverySupervisor;
    }

    public ActorRef taskRecoveryListener() {
        return this.taskRecoveryListener;
    }

    @Override
    @PreDestroy
    public void shutdownTasks() {
        ((IterableLike)((TaskRegistryExtension)TaskRegistryExtension$.MODULE$.apply(this.system())).getTasks().filter((Function1 & Serializable & scala.Serializable)t -> BoxesRunTime.boxToBoolean((boolean)TaskExecutionEngine.$anonfun$shutdownTasks$1(t)))).foreach((Function1 & Serializable & scala.Serializable)t -> {
            TaskExecutionEngine.$anonfun$shutdownTasks$2(this, t);
            return BoxedUnit.UNIT;
        });
        Await$.MODULE$.ready((Awaitable)this.system().terminate(), (Duration)this.taskerSettings().shutdownTimeout());
    }

    @PostConstruct
    public void init() {
        ActiveTasksQueue$.MODULE$.apply(this.system());
        this.recoverTasks();
    }

    @Override
    public void recoverTasks() {
        this.cleanUpTmpFiles();
        try {
            Timeout timeout = this.taskerSettings().askTimeout();
            ActorRef qual$1 = akka.pattern.package$.MODULE$.ask(this.recoverySupervisor());
            RecoverySupervisorActor$ReadAll$ x$1 = RecoverySupervisorActor$ReadAll$.MODULE$;
            Timeout x$2 = timeout;
            ActorRef x$3 = AskableActorRef$.MODULE$.$qmark$default$3$extension(qual$1, (Object)x$1);
            Task[] tasks = ((RecoverySupervisorActor.Tasks)Await$.MODULE$.result((Awaitable)AskableActorRef$.MODULE$.$qmark$extension1(qual$1, (Object)x$1, x$2, x$3), (Duration)timeout.duration())).tasks();
            new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])tasks)).foreach((Function1 & Serializable & scala.Serializable)task -> Try$.MODULE$.apply((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.onRecover((Task)task)).recover((PartialFunction)new scala.Serializable(this){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ TaskExecutionEngine $outer;

                public final <A1 extends Throwable, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                    Object object;
                    A1 A1 = x1;
                    if (A1 instanceof Exception) {
                        Exception exception = (Exception)A1;
                        this.$outer.error((Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> "Error while recovering tasks.", (Function0<Throwable>)(Function0 & Serializable & scala.Serializable)() -> exception);
                        object = BoxedUnit.UNIT;
                    } else {
                        object = function1.apply(x1);
                    }
                    return (B1)object;
                }

                public final boolean isDefinedAt(Throwable x1) {
                    Throwable throwable = x1;
                    boolean bl = throwable instanceof Exception;
                    return bl;
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                }

                private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                    return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$applyOrElse$1(), $anonfun$applyOrElse$2(java.lang.Exception )}, serializedLambda);
                }
            }));
        }
        catch (Exception e) {
            this.error((Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> "Error while recovering.", (Function0<Throwable>)(Function0 & Serializable & scala.Serializable)() -> e);
        }
    }

    private void cleanUpTmpFiles() {
        File[] tmpFiles = this.taskerSettings().recoveryDir().listFiles(new FileFilter(null){

            public boolean accept(File pathname) {
                return pathname.getName().endsWith(".task.tmp");
            }
        });
        ((List)Option$.MODULE$.apply((Object)tmpFiles).toList().flatten((Function1 & Serializable & scala.Serializable)xs -> new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])xs)))).foreach((Function1 & Serializable & scala.Serializable)file -> {
            TaskExecutionEngine.$anonfun$cleanUpTmpFiles$2(this, file);
            return BoxedUnit.UNIT;
        });
    }

    public void onRecover(Task task) {
        block0: {
            task.context().repository_$eq(this.createRepository(task));
            Timeout timeout = this.taskerSettings().askTimeout();
            ActorRef qual$1 = akka.pattern.package$.MODULE$.ask(this.createTaskActor(task));
            TaskManagingActor.messages.Recovered x$1 = new TaskManagingActor.messages.Recovered(task);
            Timeout x$2 = timeout;
            ActorRef x$3 = AskableActorRef$.MODULE$.$qmark$default$3$extension(qual$1, (Object)x$1);
            Await$.MODULE$.ready((Awaitable)AskableActorRef$.MODULE$.$qmark$extension1(qual$1, (Object)x$1, x$2, x$3), (Duration)timeout.duration());
            if (!task.cancelling()) break block0;
            this.cancel(task.getId());
        }
    }

    @Override
    public void cancel(String taskid, boolean force) {
        this.archiveWith(taskid, (Function3<String, ActorRef, ActorRef, Object>)(Function3 & Serializable & scala.Serializable)(x$1, x$2, x$3) -> new TaskManagingActor.messages.Cancel((String)x$1, (ActorRef)x$2, (ActorRef)x$3, RunMode$.MODULE$.withForce(force)));
    }

    public boolean cancel$default$2() {
        return false;
    }

    public void archiveWith(String taskid, Function3<String, ActorRef, ActorRef, Object> msg) {
        Promise p = Promise$.MODULE$.apply();
        ActorRef listener = this.system().actorOf(ArchivedListeningActor$.MODULE$.props(taskid, (Promise<String>)p));
        Object message = msg.apply((Object)taskid, (Object)this.archiver(), (Object)listener);
        ActorSelection taskActor = this.lookupTaskActor(taskid);
        ScalaActorRef qual$1 = package$.MODULE$.actorRef2Scala(listener);
        ArchivedListeningActor.Forward x$1 = new ArchivedListeningActor.Forward(taskActor, message);
        ActorRef x$2 = qual$1.$bang$default$2((Object)x$1);
        qual$1.$bang((Object)x$1, x$2);
        Await$.MODULE$.ready((Awaitable)p.future(), (Duration)Duration$.MODULE$.Inf());
        this.system().stop(listener);
        Try try_ = (Try)p.future().value().get();
        if (try_ instanceof Failure) {
            Failure failure = (Failure)try_;
            Throwable ex = failure.exception();
            throw ex;
        }
        if (!(try_ instanceof Success)) {
            throw new MatchError((Object)try_);
        }
        Success success = (Success)try_;
        String taskId = (String)success.value();
        this.debug((Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(28).append("Task ").append(taskId).append(" successfully archived.").toString());
        ((TaskRegistryExtension)TaskRegistryExtension$.MODULE$.apply(this.system())).deleteTask(taskid);
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    private Repository createRepository(Task task) {
        return this.repositoryFactory.create(new File(task.getWorkDir().getPath()));
    }

    public ActorRef createTaskActor(Task task) {
        return this.system().actorOf(TaskManagingActor$.MODULE$.props(task), task.getId());
    }

    @Override
    public void archive(String taskid) {
        this.archiveWith(taskid, (Function3<String, ActorRef, ActorRef, Object>)(Function3 & Serializable & scala.Serializable)(taskId, archiveActor, notificationActor) -> new TaskManagingActor.messages.ArchiveTask((String)taskId, (ActorRef)archiveActor, (ActorRef)notificationActor));
    }

    @Override
    public void skipSteps(String taskid, java.util.List<Integer> stepNrs) {
        this.skipStepPaths(taskid, (Seq<BlockPath>)((Seq)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(stepNrs).asScala()).map((Function1 & Serializable & scala.Serializable)oldPosition -> this.int2BlockPath((Integer)oldPosition), Buffer$.MODULE$.canBuildFrom())));
    }

    private void skipStepPaths(String taskid, Seq<BlockPath> stepNrs) {
        this.manageStep(taskid, new SkipSteps(taskid, stepNrs));
    }

    private void manageStep(String taskid, ModifySteps message) {
        ActorRef x$3;
        Timeout x$2;
        ModifySteps x$1;
        Timeout timeout = ((CommonSettings)CommonSettings$.MODULE$.apply(this.system())).satellite().remoteAskTimeout();
        ActorSelection qual$1 = akka.pattern.package$.MODULE$.ask(this.lookupTaskActor(taskid));
        Object object = Await$.MODULE$.result((Awaitable)AskableActorSelection$.MODULE$.$qmark$extension1(qual$1, (Object)(x$1 = message), x$2 = timeout, x$3 = AskableActorSelection$.MODULE$.$qmark$default$3$extension(qual$1, (Object)x$1)), (Duration)timeout.duration());
        if (object instanceof StepModificationError) {
            StepModificationError stepModificationError = (StepModificationError)object;
            throw new TaskerException(stepModificationError.msg());
        }
        if (object instanceof PathsNotFound) {
            PathsNotFound pathsNotFound = (PathsNotFound)object;
            Seq<BlockPath> paths = pathsNotFound.paths();
            throw new TaskerException(new StringBuilder(55).append("Cannot find a path to add a pause step at the position ").append(paths).toString());
        }
        if (object instanceof ActorNotFound) {
            throw new RuntimeException("Probably connection to satellite is lost");
        }
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public ActorSelection lookupTaskActor(String s) {
        return this.system().actorSelection(this.system().child(s));
    }

    private BlockPath int2BlockPath(Integer oldPosition) {
        return BlockPath$Root$.MODULE$.$div(1).$div(1).$div(Predef$.MODULE$.Integer2int(oldPosition));
    }

    @Override
    public void unskipSteps(String taskid, java.util.List<Integer> stepNrs) {
        this.unskipStepPaths(taskid, (Seq<BlockPath>)((Seq)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(stepNrs).asScala()).map((Function1 & Serializable & scala.Serializable)oldPosition -> this.int2BlockPath((Integer)oldPosition), Buffer$.MODULE$.canBuildFrom())));
    }

    private void unskipStepPaths(String taskid, Seq<BlockPath> stepNrs) {
        this.manageStep(taskid, new UnSkipSteps(taskid, stepNrs));
    }

    @Override
    public void addPauseStep(String taskid, Integer position) {
        this.addPauseStep(taskid, this.int2BlockPath(position));
    }

    @Override
    public void addPauseStep(String taskid, BlockPath position) {
        this.manageStep(taskid, new AddPauseStep(taskid, position));
    }

    @Override
    public void unskipStepPaths(String taskid, java.util.List<BlockPath> stepNrs) {
        this.unskipStepPaths(taskid, (Seq<BlockPath>)((Seq)JavaConverters$.MODULE$.asScalaBufferConverter(stepNrs).asScala()));
    }

    @Override
    public void skipStepPaths(String taskid, java.util.List<BlockPath> stepNrs) {
        this.skipStepPaths(taskid, (Seq<BlockPath>)((Seq)JavaConverters$.MODULE$.asScalaBufferConverter(stepNrs).asScala()));
    }

    @Override
    public void stop(String taskid) {
        ScalaActorSelection qual$1 = ActorSelection$.MODULE$.toScala(this.lookupTaskActor(taskid));
        Stop x$1 = new Stop(taskid);
        ActorRef x$2 = qual$1.$bang$default$2((Object)x$1);
        qual$1.$bang((Object)x$1, x$2);
    }

    @Override
    public void abort(String taskid) {
        ScalaActorSelection qual$1 = ActorSelection$.MODULE$.toScala(this.lookupTaskActor(taskid));
        Abort x$1 = new Abort(taskid);
        ActorRef x$2 = qual$1.$bang$default$2((Object)x$1);
        qual$1.$bang((Object)x$1, x$2);
    }

    @Override
    public void execute(String taskid) {
        Task task = this.retrieve(taskid);
        task.setState(TaskExecutionState.QUEUED);
        ScalaActorSelection qual$1 = ActorSelection$.MODULE$.toScala(this.lookupTaskActor(taskid));
        Enqueue x$1 = new Enqueue(taskid);
        ActorRef x$2 = qual$1.$bang$default$2((Object)x$1);
        qual$1.$bang((Object)x$1, x$2);
    }

    @Override
    public Task retrieve(String taskid) {
        return (Task)((TaskRegistryExtension)TaskRegistryExtension$.MODULE$.apply(this.system())).getTask(taskid).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            throw new TaskNotFoundException("registry", taskid);
        });
    }

    @Override
    public void schedule(String taskid, DateTime scheduleAt) {
        long tickMillis;
        if (scheduleAt.isBeforeNow()) {
            throw new TaskerException(new StringBuilder(66).append("Cannot schedule a task for the past, date entered was [").append(TaskExecutionEngine.p$1(scheduleAt)).append(", now is [").append(TaskExecutionEngine.p$1(Imports$.MODULE$.DateTime().now())).append("]").toString());
        }
        long delayMillis = RichReadableInterval$.MODULE$.millis$extension(Imports$.MODULE$.richReadableInterval((ReadableInterval)RichReadableInstant$.MODULE$.to$extension(Imports$.MODULE$.richReadableInstant((ReadableInstant)Imports$.MODULE$.DateTime().now()), (ReadableInstant)scheduleAt)));
        if (delayMillis > (long)Integer.MAX_VALUE * (tickMillis = this.taskerSettings().tickDuration().toMillis())) {
            DateTime time = new DateTime((Object)RichDateTime$.MODULE$.millis$extension(Imports$.MODULE$.richDateTime(Imports$.MODULE$.DateTime().now())).addToCopy(tickMillis * Integer.MAX_VALUE));
            throw new TaskerException(new StringBuilder(93).append("Cannot schedule task [").append(taskid).append("] at [").append(TaskExecutionEngine.p$1(scheduleAt)).append("], because it is too far into the future. Can only schedule to [").append(TaskExecutionEngine.p$1(time)).append("]").toString());
        }
        ScalaActorSelection qual$1 = ActorSelection$.MODULE$.toScala(this.lookupTaskActor(taskid));
        TaskManagingActor.messages.Schedule x$1 = new TaskManagingActor.messages.Schedule(taskid, scheduleAt);
        ActorRef x$2 = qual$1.$bang$default$2((Object)x$1);
        qual$1.$bang((Object)x$1, x$2);
    }

    @Override
    public String register(TaskSpecification spec) {
        Task task = new Task(spec.getId(), spec);
        task.context().repository_$eq(this.createRepository(task));
        Timeout timeout = this.taskerSettings().askTimeout();
        ActorRef qual$1 = akka.pattern.package$.MODULE$.ask(this.createTaskActor(task));
        TaskManagingActor.messages.Register x$1 = new TaskManagingActor.messages.Register(task);
        Timeout x$2 = timeout;
        ActorRef x$3 = AskableActorRef$.MODULE$.$qmark$default$3$extension(qual$1, (Object)x$1);
        Await$.MODULE$.ready((Awaitable)AskableActorRef$.MODULE$.$qmark$extension1(qual$1, (Object)x$1, x$2, x$3), (Duration)timeout.duration());
        return task.getId();
    }

    @Override
    public java.util.List<Task> getAllIncompleteTasks() {
        return (java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter(((TaskRegistryExtension)TaskRegistryExtension$.MODULE$.apply(this.system())).getTasks()).asJava();
    }

    @Override
    public ActorSystem getSystem() {
        return this.system();
    }

    public static final /* synthetic */ boolean $anonfun$shutdownTasks$1(Task t) {
        return ((SetLike)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TaskExecutionState[]{TaskExecutionState.ABORTING, TaskExecutionState.EXECUTING, TaskExecutionState.FAILING, TaskExecutionState.STOPPING}))).contains((Object)t.getState());
    }

    public static final /* synthetic */ void $anonfun$shutdownTasks$2(TaskExecutionEngine $this, Task t) {
        $this.info((Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(32).append("Stopping task [").append(t.getId()).append("] due to shutdown").toString());
        ScalaActorSelection qual$1 = ActorSelection$.MODULE$.toScala($this.lookupTaskActor(t.getId()));
        Stop$ x$1 = Stop$.MODULE$;
        ActorRef x$2 = qual$1.$bang$default$2((Object)x$1);
        qual$1.$bang((Object)x$1, x$2);
        Promise promise = Promise$.MODULE$.apply();
        $this.system().actorOf(Props$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> new Actor(null, t, promise){
            private final ActorContext context;
            private final ActorRef self;
            public final Task t$1;
            public final Promise promise$1;

            public final ActorRef sender() {
                return Actor.sender$((Actor)this);
            }

            @InternalApi
            public void aroundReceive(PartialFunction<Object, BoxedUnit> receive2, Object msg) {
                Actor.aroundReceive$((Actor)this, receive2, (Object)msg);
            }

            @InternalApi
            public void aroundPreStart() {
                Actor.aroundPreStart$((Actor)this);
            }

            @InternalApi
            public void aroundPostStop() {
                Actor.aroundPostStop$((Actor)this);
            }

            @InternalApi
            public void aroundPreRestart(Throwable reason, Option<Object> message) {
                Actor.aroundPreRestart$((Actor)this, (Throwable)reason, message);
            }

            @InternalApi
            public void aroundPostRestart(Throwable reason) {
                Actor.aroundPostRestart$((Actor)this, (Throwable)reason);
            }

            public SupervisorStrategy supervisorStrategy() {
                return Actor.supervisorStrategy$((Actor)this);
            }

            public void preStart() throws Exception {
                Actor.preStart$((Actor)this);
            }

            public void postStop() throws Exception {
                Actor.postStop$((Actor)this);
            }

            public void preRestart(Throwable reason, Option<Object> message) throws Exception {
                Actor.preRestart$((Actor)this, (Throwable)reason, message);
            }

            public void postRestart(Throwable reason) throws Exception {
                Actor.postRestart$((Actor)this, (Throwable)reason);
            }

            public void unhandled(Object message) {
                Actor.unhandled$((Actor)this, (Object)message);
            }

            public ActorContext context() {
                return this.context;
            }

            public final ActorRef self() {
                return this.self;
            }

            public void akka$actor$Actor$_setter_$context_$eq(ActorContext x$1) {
                this.context = x$1;
            }

            public final void akka$actor$Actor$_setter_$self_$eq(ActorRef x$1) {
                this.self = x$1;
            }

            public PartialFunction<Object, BoxedUnit> receive() {
                return new scala.Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anon$1 $outer;

                    /*
                     * Enabled aggressive block sorting
                     */
                    public final <A1, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                        Object object;
                        A1 A1 = x1;
                        if (A1 instanceof TaskDone) {
                            TaskDone taskDone = (TaskDone)A1;
                            Task doneTask = taskDone.task();
                            String string = doneTask.getId();
                            String string2 = this.$outer.t$1.getId();
                            if (!(string != null ? !string.equals(string2) : string2 != null)) {
                                this.$outer.promise$1.success((Object)doneTask.getId());
                                object = BoxedUnit.UNIT;
                                return (B1)object;
                            }
                        }
                        object = function1.apply(x1);
                        return (B1)object;
                    }

                    /*
                     * Enabled force condition propagation
                     * Lifted jumps to return sites
                     */
                    public final boolean isDefinedAt(Object x1) {
                        Object object = x1;
                        if (!(object instanceof TaskDone)) return false;
                        TaskDone taskDone = (TaskDone)object;
                        Task doneTask = taskDone.task();
                        String string = doneTask.getId();
                        String string2 = this.$outer.t$1.getId();
                        if (string != null) {
                            if (!string.equals(string2)) return false;
                            return true;
                        }
                        if (string2 == null) return true;
                        return false;
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                };
            }
            {
                this.t$1 = t$1;
                this.promise$1 = promise$1;
                Actor.$init$((Actor)this);
            }
        }, ClassTag$.MODULE$.apply(Actor.class)));
        Try try_ = Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> (String)Await$.MODULE$.result((Awaitable)promise.future(), (Duration)new package.DurationInt(scala.concurrent.duration.package$.MODULE$.DurationInt(10)).seconds()));
        if (try_ instanceof Failure) {
            Failure failure = (Failure)try_;
            Throwable exception = failure.exception();
            $this.warn((Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(22).append("Failed to stop task [").append(t.getId()).append("]").toString(), (Function0<Throwable>)(Function0 & Serializable & scala.Serializable)() -> exception);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (try_ instanceof Success) {
            Success success = (Success)try_;
            String value = (String)success.value();
            $this.info((Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(28).append("Successfully stopped task [").append(value).append("]").toString());
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            throw new MatchError((Object)try_);
        }
    }

    public static final /* synthetic */ void $anonfun$cleanUpTmpFiles$2(TaskExecutionEngine $this, File file) {
        try {
            $this.warn((Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(30).append("Deleting corrupted task file: ").append(file.getAbsolutePath()).toString());
            Files.delete(file.toPath());
        }
        catch (Throwable e) {
            $this.error((Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(42).append("Unable to delete corrupted recovery file: ").append(file.getAbsolutePath()).toString(), (Function0<Throwable>)(Function0 & Serializable & scala.Serializable)() -> e);
        }
    }

    private static final String p$1(DateTime d) {
        return d.toString("yyyy-MM-dd HH:mm:ss Z");
    }

    public TaskExecutionEngine(Archive archive, RepositoryFactory repositoryFactory, ActorSystem system) {
        this.repositoryFactory = repositoryFactory;
        this.system = system;
        Logging.$init$((Logging)this);
        this.taskerSettings = ((CommonSettings)CommonSettings$.MODULE$.apply(system)).tasker();
        this.archiver = system.actorOf(ArchiveActor$.MODULE$.props(archive), ArchiveActor$.MODULE$.name());
        this.taskTransitioner = system.actorOf(TaskTransitionActor$.MODULE$.props(this), TaskTransitionActor$.MODULE$.name());
        this.recoverySupervisor = system.actorOf(RecoverySupervisorActor$.MODULE$.props(this.taskerSettings().recoveryDir()), RecoverySupervisorActor$.MODULE$.name());
        this.taskRecoveryListener = system.actorOf(TaskRecoveryListener$.MODULE$.props(this.recoverySupervisor()), TaskRecoveryListener$.MODULE$.name());
    }
}

