/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlplatform.scheduler;

import akka.actor.ActorRef;
import akka.actor.ActorSystem;
import akka.actor.ScalaActorRef;
import akka.actor.package$;
import com.xebialabs.deployit.engine.spi.event.CiBaseEvent;
import com.xebialabs.deployit.engine.spi.event.CisCreatedEvent;
import com.xebialabs.deployit.engine.spi.event.CisDeletedEvent;
import com.xebialabs.deployit.engine.spi.event.CisUpdatedEvent;
import com.xebialabs.deployit.engine.spi.event.DeployitEventListener;
import com.xebialabs.deployit.engine.spi.event.SystemStartedEvent;
import com.xebialabs.deployit.engine.spi.event.SystemStoppedEvent;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.plugin.api.udm.Metadata;
import com.xebialabs.deployit.repository.RepositoryService;
import com.xebialabs.deployit.repository.SearchParameters;
import com.xebialabs.xlplatform.scheduler.ActorJob;
import com.xebialabs.xlplatform.scheduler.ControlTaskExecutor;
import com.xebialabs.xlplatform.scheduler.Scheduler;
import com.xebialabs.xlplatform.scheduler.SchedulerActorSystem$;
import com.xebialabs.xlplatform.scheduler.ci.ControlTaskInvokable;
import com.xebialabs.xlplatform.scheduler.ci.ScheduledJob;
import com.xebialabs.xlplatform.scheduler.spring.ServiceHolder;
import grizzled.slf4j.Logger;
import grizzled.slf4j.Logging;
import java.io.Serializable;
import java.util.List;
import nl.javadude.t2bus.Subscribe;
import org.slf4j.Marker;
import scala.Function0;
import scala.Function1;
import scala.collection.TraversableLike;
import scala.collection.convert.ImplicitConversions$;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.concurrent.ExecutionContextExecutor;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@DeployitEventListener
@ScalaSignature(bytes="\u0006\u0001\u0005\u0015f\u0001\u0002\f\u0018\u0001\u0001B\u0001\u0002\u0007\u0001\u0003\u0006\u0004%\ta\f\u0005\tq\u0001\u0011\t\u0011)A\u0005a!A\u0011\b\u0001BC\u0002\u0013\u0005q\u0006\u0003\u0005;\u0001\t\u0005\t\u0015!\u00031\u0011!Y\u0004A!b\u0001\n\u0003a\u0004\u0002C#\u0001\u0005\u0003\u0005\u000b\u0011B\u001f\t\u000b\u0019\u0003A\u0011A$\t\u000b\u0019\u0003A\u0011A'\t\u000f9\u0003!\u0019!C\u0002\u001f\"11\u000b\u0001Q\u0001\nACq\u0001\u0016\u0001C\u0002\u0013\rQ\u000b\u0003\u0004]\u0001\u0001\u0006IA\u0016\u0005\u0006;\u0002!\tA\u0018\u0005\u0006q\u0002!\t!\u001f\u0005\u0007\u007f\u0002!\t!!\u0001\t\u000f\u00055\u0001\u0001\"\u0001\u0002\u0010!9\u00111\u0004\u0001\u0005\u0002\u0005u\u0001\u0002CA\u0015\u0001\u0011\u0005q#a\u000b\t\u0011\u0005u\u0004\u0001\"\u0001\u0018\u0003\u007fB\u0001\"!%\u0001\t\u00039\u00121\u0013\u0005\t\u0003/\u0003A\u0011A\f\u0002\u001a\niQI^3oi2K7\u000f^3oKJT!\u0001G\r\u0002\u0013M\u001c\u0007.\u001a3vY\u0016\u0014(B\u0001\u000e\u001c\u0003)AH\u000e\u001d7bi\u001a|'/\u001c\u0006\u00039u\t\u0011\u0002_3cS\u0006d\u0017MY:\u000b\u0003y\t1aY8n\u0007\u0001\u00192\u0001A\u0011(!\t\u0011S%D\u0001$\u0015\u0005!\u0013!B:dC2\f\u0017B\u0001\u0014$\u0005\u0019\te.\u001f*fMB\u0011\u0001&L\u0007\u0002S)\u0011!fK\u0001\u0006g24GG\u001b\u0006\u0002Y\u0005AqM]5{u2,G-\u0003\u0002/S\t9Aj\\4hS:<W#\u0001\u0019\u0011\u0005E2T\"\u0001\u001a\u000b\u0005M\"\u0014!B1di>\u0014(\"A\u001b\u0002\t\u0005\\7.Y\u0005\u0003oI\u0012\u0001\"Q2u_J\u0014VMZ\u0001\u000bg\u000eDW\rZ;mKJ\u0004\u0013aE2p]R\u0014x\u000e\u001c+bg.,\u00050Z2vi>\u0014\u0018\u0001F2p]R\u0014x\u000e\u001c+bg.,\u00050Z2vi>\u0014\b%A\tsKB|7/\u001b;pef\u001cVM\u001d<jG\u0016,\u0012!\u0010\t\u0003}\rk\u0011a\u0010\u0006\u0003\u0001\u0006\u000b!B]3q_NLGo\u001c:z\u0015\t\u00115$\u0001\u0005eKBdw._5u\u0013\t!uHA\tSKB|7/\u001b;pef\u001cVM\u001d<jG\u0016\f!C]3q_NLGo\u001c:z'\u0016\u0014h/[2fA\u00051A(\u001b8jiz\"B\u0001\u0013&L\u0019B\u0011\u0011\nA\u0007\u0002/!)\u0001d\u0002a\u0001a!)\u0011h\u0002a\u0001a!)1h\u0002a\u0001{Q\t\u0001*A\u0006bGR|'oU=ti\u0016lW#\u0001)\u0011\u0005E\n\u0016B\u0001*3\u0005-\t5\r^8s'f\u001cH/Z7\u0002\u0019\u0005\u001cGo\u001c:TsN$X-\u001c\u0011\u0002!\u0015DXmY;uS>t7i\u001c8uKb$X#\u0001,\u0011\u0005]SV\"\u0001-\u000b\u0005e\u001b\u0013AC2p]\u000e,(O]3oi&\u00111\f\u0017\u0002\u0019\u000bb,7-\u001e;j_:\u001cuN\u001c;fqR,\u00050Z2vi>\u0014\u0018!E3yK\u000e,H/[8o\u0007>tG/\u001a=uA\u0005\u0011\"/Z2fSZ,7+_:uK6\u001cF/\u0019:u)\ty&\r\u0005\u0002#A&\u0011\u0011m\t\u0002\u0005+:LG\u000fC\u0003d\u001b\u0001\u0007A-A\u0003fm\u0016tG\u000f\u0005\u0002fW6\taM\u0003\u0002dO*\u0011\u0001.[\u0001\u0004gBL'B\u00016B\u0003\u0019)gnZ5oK&\u0011AN\u001a\u0002\u0013'f\u001cH/Z7Ti\u0006\u0014H/\u001a3Fm\u0016tG\u000f\u000b\u0002\u000e]B\u0011qN^\u0007\u0002a*\u0011\u0011O]\u0001\u0006iJ\u0012Wo\u001d\u0006\u0003gR\f\u0001B[1wC\u0012,H-\u001a\u0006\u0002k\u0006\u0011a\u000e\\\u0005\u0003oB\u0014\u0011bU;cg\u000e\u0014\u0018NY3\u0002#I,7-Z5wK\u000eK7o\u0011:fCR,G\r\u0006\u0002`u\")1M\u0004a\u0001wB\u0011Q\r`\u0005\u0003{\u001a\u0014qbQ5t\u0007J,\u0017\r^3e\u000bZ,g\u000e\u001e\u0015\u0003\u001d9\f\u0011C]3dK&4XmQ5t+B$\u0017\r^3e)\ry\u00161\u0001\u0005\u0007G>\u0001\r!!\u0002\u0011\u0007\u0015\f9!C\u0002\u0002\n\u0019\u0014qbQ5t+B$\u0017\r^3e\u000bZ,g\u000e\u001e\u0015\u0003\u001f9\f\u0011C]3dK&4XmQ5t\t\u0016dW\r^3e)\ry\u0016\u0011\u0003\u0005\u0007GB\u0001\r!a\u0005\u0011\u0007\u0015\f)\"C\u0002\u0002\u0018\u0019\u0014qbQ5t\t\u0016dW\r^3e\u000bZ,g\u000e\u001e\u0015\u0003!9\f\u0011C]3dK&4XmU=ti\u0016l7\u000b^8q)\ry\u0016q\u0004\u0005\u0007GF\u0001\r!!\t\u0011\u0007\u0015\f\u0019#C\u0002\u0002&\u0019\u0014!cU=ti\u0016l7\u000b^8qa\u0016$WI^3oi\"\u0012\u0011C\\\u0001\nM&dG/\u001a:DSN,B!!\f\u0002FQ!\u0011qFA;)\u0011\t\t$!\u001a\u0011\r\u0005M\u0012QHA!\u001b\t\t)D\u0003\u0003\u00028\u0005e\u0012aB7vi\u0006\u0014G.\u001a\u0006\u0004\u0003w\u0019\u0013AC2pY2,7\r^5p]&!\u0011qHA\u001b\u0005\u0019\u0011UO\u001a4feB!\u00111IA#\u0019\u0001!q!a\u0012\u0013\u0005\u0004\tIEA\u0001U#\u0011\tY%!\u0015\u0011\u0007\t\ni%C\u0002\u0002P\r\u0012qAT8uQ&tw\r\u0005\u0003\u0002T\u0005\u0005TBAA+\u0015\u0011\t9&!\u0017\u0002\u0007U$WN\u0003\u0003\u0002\\\u0005u\u0013aA1qS*\u0019\u0011qL!\u0002\rAdWoZ5o\u0013\u0011\t\u0019'!\u0016\u0003#\r{gNZ5hkJ\fG/[8o\u0013R,W\u000eC\u0004\u0002hI\u0001\u001d!!\u001b\u0002\u0005\r$\bCBA6\u0003c\n\t%\u0004\u0002\u0002n)\u0019\u0011qN\u0012\u0002\u000fI,g\r\\3di&!\u00111OA7\u0005!\u0019E.Y:t)\u0006<\u0007BB2\u0013\u0001\u0004\t9\bE\u0002f\u0003sJ1!a\u001fg\u0005-\u0019\u0015NQ1tK\u00163XM\u001c;\u0002\u0015I,7\u000f^1si*{'\rF\u0002`\u0003\u0003Cq!a!\u0014\u0001\u0004\t))A\u0002k_\n\u0004B!a\"\u0002\u000e6\u0011\u0011\u0011\u0012\u0006\u0004\u0003\u0017;\u0012AA2j\u0013\u0011\ty)!#\u0003\u0019M\u001b\u0007.\u001a3vY\u0016$'j\u001c2\u0002\u0011M$\u0018M\u001d;K_\n$2aXAK\u0011\u001d\t\u0019\t\u0006a\u0001\u0003\u000b\u000bqa\u001d;pa*{'\rF\u0002`\u00037Cq!a!\u0016\u0001\u0004\t)\tK\u0002\u0001\u0003?\u00032!ZAQ\u0013\r\t\u0019K\u001a\u0002\u0016\t\u0016\u0004Hn\\=ji\u00163XM\u001c;MSN$XM\\3s\u0001")
public class EventListener
implements Logging {
    private final ActorRef scheduler;
    private final ActorRef controlTaskExecutor;
    private final RepositoryService repositoryService;
    private final ActorSystem actorSystem;
    private final ExecutionContextExecutor executionContext;
    private Logger grizzled$slf4j$Logging$$_logger;
    private volatile boolean bitmap$0;

    public Logger logger() {
        return Logging.logger$((Logging)this);
    }

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void trace(Function0<Object> msg) {
        Logging.trace$((Logging)this, msg);
    }

    public void trace(Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, msg, t);
    }

    public void trace(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$((Logging)this);
    }

    public void debug(Function0<Object> msg) {
        Logging.debug$((Logging)this, msg);
    }

    public void debug(Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, msg, t);
    }

    public void debug(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isErrorEnabled() {
        return Logging.isErrorEnabled$((Logging)this);
    }

    public void error(Function0<Object> msg) {
        Logging.error$((Logging)this, msg);
    }

    public void error(Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, msg, t);
    }

    public void error(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isInfoEnabled() {
        return Logging.isInfoEnabled$((Logging)this);
    }

    public void info(Function0<Object> msg) {
        Logging.info$((Logging)this, msg);
    }

    public void info(Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, msg, t);
    }

    public void info(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isWarnEnabled() {
        return Logging.isWarnEnabled$((Logging)this);
    }

    public void warn(Function0<Object> msg) {
        Logging.warn$((Logging)this, msg);
    }

    public void warn(Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, msg, t);
    }

    public void warn(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, (Marker)mkr, msg, t);
    }

    private Logger grizzled$slf4j$Logging$$_logger$lzycompute() {
        EventListener eventListener = this;
        synchronized (eventListener) {
            if (!this.bitmap$0) {
                this.grizzled$slf4j$Logging$$_logger = Logging.grizzled$slf4j$Logging$$_logger$((Logging)this);
                this.bitmap$0 = true;
            }
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    public Logger grizzled$slf4j$Logging$$_logger() {
        return !this.bitmap$0 ? this.grizzled$slf4j$Logging$$_logger$lzycompute() : this.grizzled$slf4j$Logging$$_logger;
    }

    public ActorRef scheduler() {
        return this.scheduler;
    }

    public ActorRef controlTaskExecutor() {
        return this.controlTaskExecutor;
    }

    public RepositoryService repositoryService() {
        return this.repositoryService;
    }

    public ActorSystem actorSystem() {
        return this.actorSystem;
    }

    public ExecutionContextExecutor executionContext() {
        return this.executionContext;
    }

    @Subscribe
    public void receiveSystemStart(SystemStartedEvent event) {
        this.logger().debug((Function0 & Serializable & scala.Serializable)() -> "Starting scheduled control task jobs");
        Type scheduledJobType = Type.valueOf(ScheduledJob.class);
        this.logger().debug((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(28).append("Searching all nodes of type ").append(scheduledJobType).toString());
        List cis = this.repositoryService().list(new SearchParameters().setType(scheduledJobType).setAncestor(Metadata.ConfigurationItemRoot.CONFIGURATION.getRootNodeName()).setResultsPerPage(-1L));
        this.logger().debug((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(29).append("Found ").append(cis.size()).append(" jobs matching criteria").toString());
        ImplicitConversions$.MODULE$.list$u0020asScalaBuffer(cis).foreach((Function1 & Serializable & scala.Serializable)cid -> {
            this.startJob((ScheduledJob)this.repositoryService().read(cid.getId()));
            return BoxedUnit.UNIT;
        });
    }

    @Subscribe
    public void receiveCisCreated(CisCreatedEvent event) {
        this.filterCis((CiBaseEvent)event, ClassTag$.MODULE$.apply(ScheduledJob.class)).foreach((Function1 & Serializable & scala.Serializable)job -> {
            this.startJob(job);
            return BoxedUnit.UNIT;
        });
    }

    @Subscribe
    public void receiveCisUpdated(CisUpdatedEvent event) {
        this.filterCis((CiBaseEvent)event, ClassTag$.MODULE$.apply(ScheduledJob.class)).foreach((Function1 & Serializable & scala.Serializable)job -> {
            this.restartJob(job);
            return BoxedUnit.UNIT;
        });
    }

    @Subscribe
    public void receiveCisDeleted(CisDeletedEvent event) {
        this.filterCis((CiBaseEvent)event, ClassTag$.MODULE$.apply(ScheduledJob.class)).foreach((Function1 & Serializable & scala.Serializable)job -> {
            this.stopJob(job);
            return BoxedUnit.UNIT;
        });
    }

    @Subscribe
    public void receiveSystemStop(SystemStoppedEvent event) {
        this.logger().info((Function0 & Serializable & scala.Serializable)() -> "Stopping scheduled control task jobs");
        SchedulerActorSystem$.MODULE$.shutdownTheSystem();
    }

    public <T extends ConfigurationItem> Buffer<T> filterCis(CiBaseEvent event, ClassTag<T> ct) {
        return (Buffer)((TraversableLike)ImplicitConversions$.MODULE$.list$u0020asScalaBuffer(event.getCis()).filter((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)EventListener.$anonfun$filterCis$1(ct, x$1)))).map((Function1 & Serializable & scala.Serializable)x$2 -> x$2, Buffer$.MODULE$.canBuildFrom());
    }

    public void restartJob(ScheduledJob job) {
        this.stopJob(job);
        this.startJob(job);
    }

    public void startJob(ScheduledJob job) {
        block1: {
            if (!job.enabled()) break block1;
            ScheduledJob scheduledJob = job;
            if (!(scheduledJob instanceof ControlTaskInvokable)) {
                throw new IllegalArgumentException(new StringBuilder(32).append("Unable to schedule unknown job ").append((Object)job).append("!").toString());
            }
            ScheduledJob scheduledJob2 = scheduledJob;
            ControlTaskExecutor.Messages.InvokeControlTask invokeControlTask = new ControlTaskExecutor.Messages.InvokeControlTask(((ControlTaskInvokable)((Object)scheduledJob2)).getConfigurationItemId(), ((ControlTaskInvokable)((Object)scheduledJob2)).getControlTaskName(), ((ControlTaskInvokable)((Object)scheduledJob2)).getControlTaskParams());
            ControlTaskExecutor.Messages.InvokeControlTask message = invokeControlTask;
            ScalaActorRef qual$1 = package$.MODULE$.actorRef2Scala(this.scheduler());
            Scheduler.Messages.ScheduleJob x$1 = new Scheduler.Messages.ScheduleJob(new ActorJob(job.getId(), this.controlTaskExecutor(), message), job.getTrigger());
            ActorRef x$2 = qual$1.$bang$default$2((Object)x$1);
            qual$1.$bang((Object)x$1, x$2);
        }
    }

    public void stopJob(ScheduledJob job) {
        ScalaActorRef qual$1 = package$.MODULE$.actorRef2Scala(this.scheduler());
        Scheduler.Messages.CancelJob x$1 = new Scheduler.Messages.CancelJob(job.getId());
        ActorRef x$2 = qual$1.$bang$default$2((Object)x$1);
        qual$1.$bang((Object)x$1, x$2);
    }

    public static final /* synthetic */ boolean $anonfun$filterCis$1(ClassTag ct$1, ConfigurationItem x$1) {
        return x$1.getType().isSubTypeOf(Type.valueOf((Class)ct$1.runtimeClass()));
    }

    public EventListener(ActorRef scheduler, ActorRef controlTaskExecutor, RepositoryService repositoryService) {
        this.scheduler = scheduler;
        this.controlTaskExecutor = controlTaskExecutor;
        this.repositoryService = repositoryService;
        Logging.$init$((Logging)this);
        this.actorSystem = SchedulerActorSystem$.MODULE$.actorSystem();
        this.executionContext = this.actorSystem().dispatcher();
    }

    public EventListener() {
        this(SchedulerActorSystem$.MODULE$.scheduler(), SchedulerActorSystem$.MODULE$.controlTaskExecutor(), ServiceHolder.getRepositoryService());
    }
}

