/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.repository.sql.commands;

import com.xebialabs.deployit.checks.Checks;
import com.xebialabs.deployit.core.sql.SqlDialect;
import com.xebialabs.deployit.core.sql.spring.package;
import com.xebialabs.deployit.engine.spi.event.CiCopiedEvent;
import com.xebialabs.deployit.event.EventBusHolder;
import com.xebialabs.deployit.plugin.api.reflect.PropertyDescriptor;
import com.xebialabs.deployit.plugin.api.reflect.PropertyKind;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.plugin.api.udm.artifact.SourceArtifact;
import com.xebialabs.deployit.repository.ItemAlreadyExistsException;
import com.xebialabs.deployit.repository.internal.Root;
import com.xebialabs.deployit.repository.sql.CiHistoryRepository;
import com.xebialabs.deployit.repository.sql.artifacts.ArtifactDataRepository;
import com.xebialabs.deployit.repository.sql.artifacts.ArtifactRepository;
import com.xebialabs.deployit.repository.sql.base.CIS$;
import com.xebialabs.deployit.repository.sql.base.package$;
import com.xebialabs.deployit.repository.sql.commands.ChangeSetContext;
import com.xebialabs.deployit.repository.sql.commands.InsertCommand;
import com.xebialabs.deployit.repository.sql.reader.CiReader;
import com.xebialabs.deployit.repository.sql.specific.TypeSpecificInserter;
import com.xebialabs.deployit.repository.validation.CommandValidator;
import com.xebialabs.deployit.util.PasswordEncrypter;
import com.xebialabs.deployit.util.Tuple;
import com.xebialabs.license.LicenseCiCounter;
import java.io.Serializable;
import java.util.HashSet;
import java.util.Iterator;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Predef;
import scala.Predef$;
import scala.collection.Iterable;
import scala.collection.convert.ImplicitConversions$;
import scala.collection.immutable.List;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u0001\u0005=h\u0001B\f\u0019\u0001\u0015B\u0001B\u000b\u0001\u0003\u0006\u0004%\te\u000b\u0005\nq\u0001\u0011\t\u0011)A\u0005YeB\u0001B\u000f\u0001\u0003\u0002\u0003\u0006Ia\u000f\u0005\t\u0003\u0002\u0011\t\u0011)A\u0005\u0005\"AQ\t\u0001B\u0001B\u0003%a\t\u0003\u0005K\u0001\t\u0005\t\u0015!\u0003L\u0011!\t\u0006A!A!\u0002\u0013\u0011\u0006\u0002\u0003-\u0001\u0005\u0003\u0005\u000b\u0011B-\t\u0011}\u0003!\u0011!Q\u0001\n\u0001D!\"!\f\u0001\u0005\u0003\u0005\u000b\u0011BA\u0018\u0011)\tY\u0004\u0001BC\u0002\u0013\u0005\u0011Q\b\u0005\u000b\u00037\u0002!\u0011!Q\u0001\n\u0005}\u0002BCA/\u0001\t\u0015\r\u0011b\u0001\u0002`!Q\u0011Q\u000e\u0001\u0003\u0002\u0003\u0006I!!\u0019\t\u000f\u0005=\u0004\u0001\"\u0001\u0002r!9\u0011Q\u0012\u0001\u0005B\u0005=\u0005bBAQ\u0001\u0011\u0005\u00131\u0015\u0005\b\u0003O\u0003A\u0011BAU\u0011\u001d\t)\f\u0001C\u0005\u0003oCq!a4\u0001\t\u0013\t\t\u000eC\u0004\u0002Z\u0002!I!a7\t\u000f\u0005\u0015\b\u0001\"\u0003\u0002h\nY1i\u001c9z\u0007>lW.\u00198e\u0015\tI\"$\u0001\u0005d_6l\u0017M\u001c3t\u0015\tYB$A\u0002tc2T!!\b\u0010\u0002\u0015I,\u0007o\\:ji>\u0014\u0018P\u0003\u0002 A\u0005AA-\u001a9m_fLGO\u0003\u0002\"E\u0005I\u00010\u001a2jC2\f'm\u001d\u0006\u0002G\u0005\u00191m\\7\u0004\u0001M\u0011\u0001A\n\t\u0003O!j\u0011\u0001G\u0005\u0003Sa\u0011Q\"\u00138tKJ$8i\\7nC:$\u0017\u0001\u00046eE\u000e$V-\u001c9mCR,W#\u0001\u0017\u0011\u000552T\"\u0001\u0018\u000b\u0005=\u0002\u0014\u0001B2pe\u0016T!!\r\u001a\u0002\t)$'m\u0019\u0006\u0003gQ\nqb\u001d9sS:<gM]1nK^|'o\u001b\u0006\u0002k\u0005\u0019qN]4\n\u0005]r#\u0001\u0004&eE\u000e$V-\u001c9mCR,\u0017!\u00046eE\u000e$V-\u001c9mCR,\u0007%\u0003\u0002+Q\u0005\u0011\u0012M\u001d;jM\u0006\u001cGOU3q_NLGo\u001c:z!\tat(D\u0001>\u0015\tq$$A\u0005beRLg-Y2ug&\u0011\u0001)\u0010\u0002\u0013\u0003J$\u0018NZ1diJ+\u0007o\\:ji>\u0014\u00180\u0001\fbeRLg-Y2u\t\u0006$\u0018MU3q_NLGo\u001c:z!\ta4)\u0003\u0002E{\t1\u0012I\u001d;jM\u0006\u001cG\u000fR1uCJ+\u0007o\\:ji>\u0014\u00180A\ndS\"K7\u000f^8ssJ+\u0007o\\:ji>\u0014\u0018\u0010\u0005\u0002H\u00116\t!$\u0003\u0002J5\t\u00192)\u001b%jgR|'/\u001f*fa>\u001c\u0018\u000e^8ss\u0006\t\u0002/Y:to>\u0014H-\u00128def\u0004H/\u001a:\u0011\u00051{U\"A'\u000b\u00059s\u0012\u0001B;uS2L!\u0001U'\u0003#A\u000b7o]<pe\u0012,en\u0019:zaR,'/\u0001\tmS\u000e,gn]3DS\u000e{WO\u001c;feB\u00111KV\u0007\u0002)*\u0011Q\u000bI\u0001\bY&\u001cWM\\:f\u0013\t9FK\u0001\tMS\u000e,gn]3DS\u000e{WO\u001c;fe\u0006A1-\u001b*fC\u0012,'\u000f\u0005\u0002[;6\t1L\u0003\u0002]5\u00051!/Z1eKJL!AX.\u0003\u0011\rK'+Z1eKJ\f1d\u0019:fCR,G+\u001f9f'B,7-\u001b4jG&s7/\u001a:uKJ\u001c\bCB1eMB\f\t\"D\u0001c\u0015\u0005\u0019\u0017!B:dC2\f\u0017BA3c\u0005%1UO\\2uS>t'\u0007\u0005\u0002h]6\t\u0001N\u0003\u0002jU\u00069!/\u001a4mK\u000e$(BA6m\u0003\r\t\u0007/\u001b\u0006\u0003[z\ta\u0001\u001d7vO&t\u0017BA8i\u0005\u0011!\u0016\u0010]3\u0011\u0007E\fYAD\u0002s\u0003\u000bq1a]A\u0001\u001d\t!xP\u0004\u0002v}:\u0011a/ \b\u0003ort!\u0001_>\u000e\u0003eT!A\u001f\u0013\u0002\rq\u0012xn\u001c;?\u0013\u0005\u0019\u0013BA\u0011#\u0013\ty\u0002%\u0003\u0002\u001e=%\u00111\u0004H\u0005\u0004\u0003\u0007Q\u0012\u0001\u00022bg\u0016LA!a\u0002\u0002\n\u00059\u0001/Y2lC\u001e,'bAA\u00025%!\u0011QBA\b\u0005!\u0019\u0015\u000eU&UsB,'\u0002BA\u0004\u0003\u0013\u0001b!a\u0005\u0002\u001c\u0005\u0005b\u0002BA\u000b\u00033q1\u0001_A\f\u0013\u0005\u0019\u0017bAA\u0004E&!\u0011QDA\u0010\u0005\u0011a\u0015n\u001d;\u000b\u0007\u0005\u001d!\r\u0005\u0003\u0002$\u0005%RBAA\u0013\u0015\r\t9CG\u0001\tgB,7-\u001b4jG&!\u00111FA\u0013\u0005Q!\u0016\u0010]3Ta\u0016\u001c\u0017NZ5d\u0013:\u001cXM\u001d;fe\u0006\u00012m\\7nC:$g+\u00197jI\u0006$xN\u001d\t\u0005\u0003c\t9$\u0004\u0002\u00024)\u0019\u0011Q\u0007\u000f\u0002\u0015Y\fG.\u001b3bi&|g.\u0003\u0003\u0002:\u0005M\"\u0001E\"p[6\fg\u000e\u001a,bY&$\u0017\r^8s\u0003\u001d\u0019w\u000e]=DSN,\"!a\u0010\u0011\r\u0005M\u0011\u0011IA#\u0013\u0011\t\u0019%a\b\u0003\u0011%#XM]1cY\u0016\u0004r\u0001TA$\u0003\u0017\nY%C\u0002\u0002J5\u0013Q\u0001V;qY\u0016\u0004B!!\u0014\u0002V9!\u0011qJA)!\tA(-C\u0002\u0002T\t\fa\u0001\u0015:fI\u00164\u0017\u0002BA,\u00033\u0012aa\u0015;sS:<'bAA*E\u0006A1m\u001c9z\u0007&\u001c\b%\u0001\u0006tc2$\u0015.\u00197fGR,\"!!\u0019\u0011\t\u0005\r\u0014\u0011N\u0007\u0003\u0003KR1aGA4\u0015\tyc$\u0003\u0003\u0002l\u0005\u0015$AC*rY\u0012K\u0017\r\\3di\u0006Y1/\u001d7ES\u0006dWm\u0019;!\u0003\u0019a\u0014N\\5u}Q1\u00121OA=\u0003w\ni(a \u0002\u0002\u0006\r\u0015QQAD\u0003\u0013\u000bY\t\u0006\u0003\u0002v\u0005]\u0004CA\u0014\u0001\u0011\u001d\tif\u0004a\u0002\u0003CBQAK\bA\u00021BQAO\bA\u0002mBQ!Q\bA\u0002\tCQ!R\bA\u0002\u0019CQAS\bA\u0002-CQ!U\bA\u0002ICQ\u0001W\bA\u0002eCQaX\bA\u0002\u0001Dq!!\f\u0010\u0001\u0004\ty\u0003C\u0004\u0002<=\u0001\r!a\u0010\u0002\u000f\u0015DXmY;uKR!\u0011\u0011SAL!\r\t\u00171S\u0005\u0004\u0003+\u0013'\u0001B+oSRDq!!'\u0011\u0001\u0004\tY*A\u0004d_:$X\r\u001f;\u0011\u0007\u001d\ni*C\u0002\u0002 b\u0011\u0001c\u00115b]\u001e,7+\u001a;D_:$X\r\u001f;\u0002\u0011Y\fG.\u001b3bi\u0016$B!!%\u0002&\"9\u0011\u0011T\tA\u0002\u0005m\u0015\u0001B2paf$\u0002\"!%\u0002,\u0006=\u00161\u0017\u0005\b\u0003[\u0013\u0002\u0019AA&\u0003\u00191'o\\7JI\"9\u0011\u0011\u0017\nA\u0002\u0005-\u0013\u0001\u0002;p\u0013\u0012Dq!!'\u0013\u0001\u0004\tY*A\tsKBd\u0017mY3SK\u001a,'/\u001a8dKN$B!!%\u0002:\"9\u00111X\nA\u0002\u0005u\u0016A\u0003:fM\u0016\u0014XM\\2fgBA\u0011QJA`\u0003\u0017\n\u0019-\u0003\u0003\u0002B\u0006e#aA'baB!\u0011QYAf\u001b\t\t9MC\u0002\u0002J*\f1!\u001e3n\u0013\u0011\ti-a2\u0003#\r{gNZ5hkJ\fG/[8o\u0013R,W.\u0001\u0007wC2LG-\u0019;f\u0007>\u0004\u0018\u0010\u0006\u0005\u0002\u0012\u0006M\u0017Q[Al\u0011\u001d\ti\u000b\u0006a\u0001\u0003\u0017Bq!!-\u0015\u0001\u0004\tY\u0005C\u0004\u0002\u001aR\u0001\r!a'\u0002\u0011I,g.Y7f\u0007&$\u0002\"!%\u0002^\u0006\u0005\u00181\u001d\u0005\b\u0003?,\u0002\u0019AAb\u0003\t\u0019\u0017\u000eC\u0004\u0002.V\u0001\r!a\u0013\t\u000f\u0005EV\u00031\u0001\u0002L\u0005Qa/\u00197jI\u0006$XmQ5\u0015\u0011\u0005E\u0015\u0011^Av\u0003[Dq!!,\u0017\u0001\u0004\tY\u0005C\u0004\u00022Z\u0001\r!a\u0013\t\u000f\u0005}g\u00031\u0001\u0002D\u0002")
public class CopyCommand
extends InsertCommand {
    private final ArtifactRepository artifactRepository;
    private final ArtifactDataRepository artifactDataRepository;
    private final CiReader ciReader;
    private final CommandValidator commandValidator;
    private final Iterable<Tuple<String, String>> copyCis;
    private final SqlDialect sqlDialect;

    @Override
    public JdbcTemplate jdbcTemplate() {
        return super.jdbcTemplate();
    }

    public Iterable<Tuple<String, String>> copyCis() {
        return this.copyCis;
    }

    public SqlDialect sqlDialect() {
        return this.sqlDialect;
    }

    @Override
    public void execute(ChangeSetContext context) {
        this.copyCis().foreach((Function1 & Serializable & scala.Serializable)t -> {
            this.copy((String)t.a, (String)t.b, context);
            return BoxedUnit.UNIT;
        });
    }

    @Override
    public void validate(ChangeSetContext context) {
        this.copyCis().foreach((Function1 & Serializable & scala.Serializable)t -> {
            this.validateCopy((String)t.a, (String)t.b, context);
            return BoxedUnit.UNIT;
        });
    }

    private void copy(String fromId, String toId, ChangeSetContext context) {
        String string = fromId;
        String string2 = toId;
        Checks.checkArgument(((string == null ? string2 != null : !string.equals(string2)) ? 1 : 0) != 0, (String)"Cannot copy ci [%s] to same location", (Object[])new Object[]{toId});
        String path = package$.MODULE$.idToPath(fromId);
        ConfigurationItem ci = this.ciReader.readByPath(path, 0);
        this.validateCi(fromId, toId, ci);
        Buffer tuples = (Buffer)ImplicitConversions$.MODULE$.list$u0020asScalaBuffer(this.jdbcTemplate().query(this.SELECT_CI_TREE_BY_PATH(), (RowMapper)new package.MapRowMapper(), new Object[]{path, new StringBuilder(2).append(path).append("/%").toString()})).map((Function1 & Serializable & scala.Serializable)map -> {
            ConfigurationItem ci = $this.ciReader.readUsingCache(package$.MODULE$.asCiPKType(map.get(CIS$.MODULE$.ID().name())), 1, (Function0<Map<String, Object>>)(Function0 & Serializable & scala.Serializable)() -> map);
            String copiedId = ci.getId();
            this.renameCi(ci, fromId, toId);
            return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)copiedId), (Object)ci);
        }, Buffer$.MODULE$.canBuildFrom());
        this.replaceReferences((scala.collection.immutable.Map<String, ConfigurationItem>)tuples.toMap(Predef$.MODULE$.$conforms()));
        this.insertCis((Iterable<ConfigurationItem>)((Iterable)tuples.map((Function1 & Serializable & scala.Serializable)x$1 -> (ConfigurationItem)x$1._2(), Buffer$.MODULE$.canBuildFrom())), context, (Function2<Integer, ConfigurationItem, BoxedUnit>)(Function2 & Serializable & scala.Serializable)(ciPk, copiedCi) -> {
            CopyCommand.$anonfun$copy$4(this, fromId, toId, ciPk, copiedCi);
            return BoxedUnit.UNIT;
        });
        EventBusHolder.publish((Object)new CiCopiedEvent(ci, toId));
    }

    private void replaceReferences(scala.collection.immutable.Map<String, ConfigurationItem> references) {
        references.values().foreach((Function1 & Serializable & scala.Serializable)newCi -> {
            CopyCommand.$anonfun$replaceReferences$1(references, newCi);
            return BoxedUnit.UNIT;
        });
    }

    private void validateCopy(String fromId, String toId, ChangeSetContext context) {
        String string = fromId;
        String string2 = toId;
        Checks.checkArgument(((string == null ? string2 != null : !string.equals(string2)) ? 1 : 0) != 0, (String)"Cannot copy ci [%s] to same location", (Object[])new Object[]{toId});
        String path = package$.MODULE$.idToPath(fromId);
        ConfigurationItem ci = this.ciReader.readByPath(path, 0);
        this.validateCi(fromId, toId, ci);
        this.insertCisValidation((Iterable<ConfigurationItem>)((Iterable)ImplicitConversions$.MODULE$.list$u0020asScalaBuffer(this.jdbcTemplate().query(this.SELECT_CI_TREE_BY_PATH(), (RowMapper)new package.MapRowMapper(), new Object[]{path, new StringBuilder(2).append(path).append("/%").toString()})).map((Function1 & Serializable & scala.Serializable)map -> {
            ConfigurationItem ci = $this.ciReader.readUsingCache(package$.MODULE$.asCiPKType(map.get(CIS$.MODULE$.ID().name())), 1, (Function0<Map<String, Object>>)(Function0 & Serializable & scala.Serializable)() -> map);
            this.renameCi(ci, fromId, toId);
            return ci;
        }, Buffer$.MODULE$.canBuildFrom())), context);
    }

    private void renameCi(ConfigurationItem ci, String fromId, String toId) {
        String newId = new StringBuilder(0).append(toId).append(ci.getId().substring(fromId.length())).toString();
        ci.setId(newId);
    }

    private void validateCi(String fromId, String toId, ConfigurationItem ci) {
        Type type = ci.getType();
        Type type2 = Type.valueOf(Root.class);
        Checks.checkArgument(((type == null ? type2 != null : !type.equals(type2)) ? 1 : 0) != 0, (String)"Cannot copy root node [%s].", (Object[])new Object[]{toId});
        this.commandValidator.checkCopyAllowed(this.ciReader.readByPath((String)package$.MODULE$.parentPath(fromId).get(), 0).getType(), this.ciReader.readByPath((String)package$.MODULE$.parentPath(toId).get(), 0).getType());
        if (this.exists(toId)) {
            throw new ItemAlreadyExistsException("The destination id [%s] exists.", new Object[]{toId});
        }
    }

    public static final /* synthetic */ void $anonfun$copy$4(CopyCommand $this, String fromId$1, String toId$1, Integer ciPk, ConfigurationItem copiedCi) {
        ConfigurationItem configurationItem = copiedCi;
        if (configurationItem instanceof SourceArtifact) {
            SourceArtifact sourceArtifact = (SourceArtifact)configurationItem;
            String fromCiId = new StringBuilder(0).append(fromId$1).append(sourceArtifact.getId().substring(toId$1.length())).toString();
            $this.artifactDataRepository.copy(fromCiId, ciPk);
            $this.artifactRepository.updateFilename(ciPk, $this.artifactRepository.getFilename(fromCiId));
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
    }

    private static final void replaceCiReference$1(PropertyDescriptor pd$1, ConfigurationItem newCi$1, scala.collection.immutable.Map references$1) {
        Object object = pd$1.get(newCi$1);
        if (object instanceof ConfigurationItem) {
            ConfigurationItem configurationItem = (ConfigurationItem)object;
            pd$1.set(newCi$1, references$1.getOrElse((Object)configurationItem.getId(), (Function0 & Serializable & scala.Serializable)() -> configurationItem));
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
    }

    private static final void replaceListReferences$1(PropertyDescriptor pd$1, ConfigurationItem newCi$1, scala.collection.immutable.Map references$1) {
        ListIterator itr = ((java.util.List)pd$1.get(newCi$1)).listIterator();
        while (itr.hasNext()) {
            String oldId = ((ConfigurationItem)itr.next()).getId();
            references$1.get((Object)oldId).foreach((Function1 & Serializable & scala.Serializable)x$1 -> {
                itr.set(x$1);
                return BoxedUnit.UNIT;
            });
        }
    }

    public static final /* synthetic */ void $anonfun$replaceReferences$5(HashSet toAdd$1, Iterator itr$2, ConfigurationItem ci) {
        toAdd$1.add(ci);
        itr$2.remove();
    }

    private static final void replaceSetReferences$1(PropertyDescriptor pd$1, ConfigurationItem newCi$1, scala.collection.immutable.Map references$1) {
        HashSet toAdd = new HashSet();
        Set set = (Set)pd$1.get(newCi$1);
        Iterator itr = set.iterator();
        while (itr.hasNext()) {
            String oldId = ((ConfigurationItem)itr.next()).getId();
            references$1.get((Object)oldId).foreach((Function1 & Serializable & scala.Serializable)ci -> {
                CopyCommand.$anonfun$replaceReferences$5(toAdd, itr, ci);
                return BoxedUnit.UNIT;
            });
        }
        set.addAll(toAdd);
    }

    public static final /* synthetic */ void $anonfun$replaceReferences$2(ConfigurationItem newCi$1, scala.collection.immutable.Map references$1, PropertyDescriptor pd) {
        PropertyKind propertyKind = pd.getKind();
        if (PropertyKind.CI.equals(propertyKind)) {
            CopyCommand.replaceCiReference$1(pd, newCi$1, references$1);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (PropertyKind.LIST_OF_CI.equals(propertyKind)) {
            CopyCommand.replaceListReferences$1(pd, newCi$1, references$1);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (PropertyKind.SET_OF_CI.equals(propertyKind)) {
            CopyCommand.replaceSetReferences$1(pd, newCi$1, references$1);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
    }

    public static final /* synthetic */ void $anonfun$replaceReferences$1(scala.collection.immutable.Map references$1, ConfigurationItem newCi) {
        ImplicitConversions$.MODULE$.collection$u0020AsScalaIterable(newCi.getType().getDescriptor().getPropertyDescriptors()).foreach((Function1 & Serializable & scala.Serializable)pd -> {
            CopyCommand.$anonfun$replaceReferences$2(newCi, references$1, pd);
            return BoxedUnit.UNIT;
        });
    }

    public CopyCommand(JdbcTemplate jdbcTemplate, ArtifactRepository artifactRepository, ArtifactDataRepository artifactDataRepository, CiHistoryRepository ciHistoryRepository, PasswordEncrypter passwordEncrypter, LicenseCiCounter licenseCiCounter, CiReader ciReader, Function2<Type, Integer, List<TypeSpecificInserter>> createTypeSpecificInserters, CommandValidator commandValidator, Iterable<Tuple<String, String>> copyCis, SqlDialect sqlDialect) {
        this.artifactRepository = artifactRepository;
        this.artifactDataRepository = artifactDataRepository;
        this.ciReader = ciReader;
        this.commandValidator = commandValidator;
        this.copyCis = copyCis;
        this.sqlDialect = sqlDialect;
        super(jdbcTemplate, artifactRepository, artifactDataRepository, ciHistoryRepository, passwordEncrypter, licenseCiCounter, createTypeSpecificInserters);
    }
}

