/*
 * Decompiled with CFR 0.152.
 */
package org.rzo.netty.mcast.discovery;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.channel.socket.DatagramPacket;
import io.netty.handler.ipfilter.IpFilterRule;
import io.netty.handler.ipfilter.IpFilterRuleList;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.NetworkInterface;
import java.net.SocketAddress;
import java.util.Enumeration;
import java.util.Iterator;
import org.rzo.netty.ahessian.Constants;
import org.rzo.netty.ahessian.bootstrap.ChannelPipelineFactory;
import org.rzo.netty.mcast.MulticastEndpoint;

public class DiscoveryServer
extends MulticastEndpoint {
    private String name;
    private String host;
    private int port;
    private IpFilterRuleList firewall;

    public void init() throws Exception {
        if (this.host == null) {
            this.host = this.whatIsMyIp();
        }
        ChannelPipelineFactory factory = new ChannelPipelineFactory(){

            @Override
            public ChannelPipelineFactory.HandlerList getPipeline() throws Exception {
                ChannelPipelineFactory.HandlerList pipeline = new ChannelPipelineFactory.HandlerList();
                pipeline.addLast("discoveryServer", (ChannelHandler)new ChannelInboundHandlerAdapter(){

                    public void channelRead(ChannelHandlerContext ctx, Object e) throws Exception {
                        String request = DiscoveryServer.this.getStringMessage((ByteBuf)((DatagramPacket)e).content());
                        InetSocketAddress remoteAddress = (InetSocketAddress)((DatagramPacket)e).sender();
                        if (DiscoveryServer.this.debug && DiscoveryServer.this.logger != null) {
                            DiscoveryServer.this.logger.info("discoveryServer messageReceived " + request + "/" + remoteAddress);
                        }
                        if (request == null) {
                            return;
                        }
                        if (DiscoveryServer.this.name != null && DiscoveryServer.this.name.equals(request) && DiscoveryServer.this.host != null && DiscoveryServer.this.port > 0) {
                            if (DiscoveryServer.this.validate((ByteBuf)((DatagramPacket)e).content(), remoteAddress)) {
                                DiscoveryServer.this.send(Unpooled.wrappedBuffer((byte[])(DiscoveryServer.this.name + "&" + DiscoveryServer.this.host + "&" + DiscoveryServer.this.port).getBytes()));
                            }
                        } else if (DiscoveryServer.this.debug && DiscoveryServer.this.logger != null) {
                            DiscoveryServer.this.logger.info("discoveryServer request rejected");
                        }
                    }
                });
                return pipeline;
            }
        };
        super.init(factory);
    }

    public String getName() {
        return this.name;
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public void setIpSet(IpFilterRuleList ipSet) {
        this.firewall = ipSet;
    }

    private String whatIsMyIp() {
        String result = null;
        try {
            Enumeration<NetworkInterface> e = NetworkInterface.getNetworkInterfaces();
            while (e.hasMoreElements()) {
                NetworkInterface ne = e.nextElement();
                Enumeration<InetAddress> e2 = ne.getInetAddresses();
                while (e2.hasMoreElements()) {
                    InetAddress ia = e2.nextElement();
                    if (ia.isAnyLocalAddress() || ia.isLinkLocalAddress() || ia.isLoopbackAddress() || ia.isMulticastAddress() || result != null && ia.isSiteLocalAddress()) continue;
                    result = ia.getHostAddress();
                }
            }
        }
        catch (Exception ex) {
            Constants.ahessianLogger.warn("", (Throwable)ex);
        }
        return result;
    }

    private boolean validate(ByteBuf e, SocketAddress socketAddress) {
        if (this.firewall == null) {
            return true;
        }
        InetAddress inetAddress = ((InetSocketAddress)socketAddress).getAddress();
        Iterator iterator = this.firewall.iterator();
        IpFilterRule ipFilterRule = null;
        while (iterator.hasNext()) {
            ipFilterRule = (IpFilterRule)iterator.next();
            if (!ipFilterRule.contains(inetAddress)) continue;
            boolean result = ipFilterRule.isAllowRule();
            if (this.debug && this.logger != null) {
                this.logger.info("DiscoverServer firewall ip allowed: " + result);
            }
            return result;
        }
        if (this.debug && this.logger != null) {
            this.logger.info("DiscoverServer no firewall: ");
        }
        return true;
    }

    public static void main(String[] args) {
        DiscoveryServer server = new DiscoveryServer();
        server.setName("serviceManagerServer");
        server.setHost("localhost");
        server.setPort(8080);
        try {
            server.init();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

