/*
 * Decompiled with CFR 0.152.
 */
package akka.io.dns.internal;

import akka.annotation.InternalApi;
import akka.io.Dns;
import akka.io.Dns$Resolved$;
import akka.io.PeriodicCacheCleanup;
import akka.io.SimpleDnsCache;
import akka.io.SimpleDnsCache$;
import akka.io.dns.AAAARecord;
import akka.io.dns.ARecord;
import akka.io.dns.CachePolicy;
import akka.io.dns.DnsProtocol;
import akka.io.dns.DnsProtocol$Ip$;
import akka.io.dns.ResourceRecord;
import java.io.Serializable;
import java.net.InetAddress;
import java.util.concurrent.atomic.AtomicReference;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterable;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Map$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.SortedSet;
import scala.collection.immutable.SortedSet$;
import scala.reflect.ScalaSignature;
import scala.runtime.java8.JFunction0;

@InternalApi
@ScalaSignature(bytes="\u0006\u0001\u0005\u001db\u0001B\u0006\r\u0001UAQ!\b\u0001\u0005\u0002yAq!\t\u0001C\u0002\u0013%!\u0005\u0003\u0004X\u0001\u0001\u0006Ia\t\u0005\b1\u0002\u0011\r\u0011\"\u0003Z\u0011\u0019i\u0006\u0001)A\u00055\")a\f\u0001C!?\")1\u000e\u0001C\tY\"1Q\u000e\u0001C\u0003!9DaA\u001d\u0001\u0005\u0006A\u0019\bbBA\u000b\u0001\u0011\u0015\u0013q\u0003\u0002\u000e\u0003NLhn\u0019#og\u000e\u000b7\r[3\u000b\u00055q\u0011\u0001C5oi\u0016\u0014h.\u00197\u000b\u0005=\u0001\u0012a\u00013og*\u0011\u0011CE\u0001\u0003S>T\u0011aE\u0001\u0005C.\\\u0017m\u0001\u0001\u0014\u0007\u00011\"\u0004\u0005\u0002\u001815\t\u0001#\u0003\u0002\u001a!\t\u0019AI\\:\u0011\u0005]Y\u0012B\u0001\u000f\u0011\u0005Q\u0001VM]5pI&\u001c7)Y2iK\u000ecW-\u00198va\u00061A(\u001b8jiz\"\u0012a\b\t\u0003A\u0001i\u0011\u0001D\u0001\tG\u0006\u001c\u0007.\u001a*fMV\t1\u0005E\u0002%[=j\u0011!\n\u0006\u0003M\u001d\na!\u0019;p[&\u001c'B\u0001\u0015*\u0003)\u0019wN\\2veJ,g\u000e\u001e\u0006\u0003U-\nA!\u001e;jY*\tA&\u0001\u0003kCZ\f\u0017B\u0001\u0018&\u0005=\tEo\\7jGJ+g-\u001a:f]\u000e,\u0007\u0003\u0002\u0019;{Qs!!\r\u001d\u000f\u0005I:dBA\u001a7\u001b\u0005!$BA\u001b\u0015\u0003\u0019a$o\\8u}%\t1#\u0003\u0002\u0012%%\u0011\u0011\bE\u0001\u000f'&l\u0007\u000f\\3E]N\u001c\u0015m\u00195f\u0013\tYDHA\u0003DC\u000eDWM\u0003\u0002:!A!a(Q\"L\u001b\u0005y$\"\u0001!\u0002\u000bM\u001c\u0017\r\\1\n\u0005\t{$A\u0002+va2,'\u0007\u0005\u0002E\u0011:\u0011QI\u0012\t\u0003g}J!aR \u0002\rA\u0013X\rZ3g\u0013\tI%J\u0001\u0004TiJLgn\u001a\u0006\u0003\u000f~\u0002\"\u0001T)\u000f\u00055{eBA\u0019O\u0013\ty\u0001#\u0003\u0002Q\u001d\u0005YAI\\:Qe>$xnY8m\u0013\t\u00116KA\u0006SKF,Xm\u001d;UsB,'B\u0001)\u000f!\taU+\u0003\u0002W'\nA!+Z:pYZ,G-A\u0005dC\u000eDWMU3gA\u0005Aa.\u00198p\u0005\u0006\u001cX-F\u0001[!\tq4,\u0003\u0002]\u007f\t!Aj\u001c8h\u0003%q\u0017M\\8CCN,\u0007%\u0001\u0004dC\u000eDW\r\u001a\u000b\u0003A&\u00042AP1d\u0013\t\u0011wH\u0001\u0004PaRLwN\u001c\t\u0003I\u001et!aF3\n\u0005\u0019\u0004\u0012a\u0001#og&\u0011a\u000b\u001b\u0006\u0003MBAQA\u001b\u0004A\u0002\r\u000bAA\\1nK\u0006)1\r\\8dWR\t!,A\u0002hKR$\"a\u001c9\u0011\u0007y\nG\u000bC\u0003r\u0011\u0001\u0007Q(A\u0002lKf\f1\u0001];u)\u0011!x\u000f\u001f>\u0011\u0005y*\u0018B\u0001<@\u0005\u0011)f.\u001b;\t\u000bEL\u0001\u0019A\u001f\t\u000beL\u0001\u0019\u0001+\u0002\u000fI,7m\u001c:eg\")10\u0003a\u0001y\u0006\u0019A\u000f\u001e7\u0011\u0007u\f\tA\u0004\u0002N}&\u0011qPD\u0001\f\u0007\u0006\u001c\u0007.\u001a)pY&\u001c\u00170\u0003\u0003\u0002\u0004\u0005\u0015!aC\"bG\",\u0007k\u001c7jGfT!a \b)\u0007%\tI\u0001\u0005\u0003\u0002\f\u0005EQBAA\u0007\u0015\r\tyaP\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002BA\n\u0003\u001b\u0011q\u0001^1jYJ,7-A\u0004dY\u0016\fg.\u001e9\u0015\u0003QD3ACA\u0005Q\r\u0001\u0011Q\u0004\t\u0005\u0003?\t\u0019#\u0004\u0002\u0002\")\u0019\u0011q\u0002\n\n\t\u0005\u0015\u0012\u0011\u0005\u0002\f\u0013:$XM\u001d8bY\u0006\u0003\u0018\u000e")
public class AsyncDnsCache
extends Dns
implements PeriodicCacheCleanup {
    private final AtomicReference<SimpleDnsCache.Cache<Tuple2<String, DnsProtocol.RequestType>, DnsProtocol.Resolved>> cacheRef = new AtomicReference(new SimpleDnsCache.Cache((SortedSet)SortedSet$.MODULE$.apply((Seq)Nil$.MODULE$, SimpleDnsCache$.MODULE$.expiryEntryOrdering()), (Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$), (Function0<Object>)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> this.clock()));
    private final long nanoBase = System.nanoTime();

    private AtomicReference<SimpleDnsCache.Cache<Tuple2<String, DnsProtocol.RequestType>, DnsProtocol.Resolved>> cacheRef() {
        return this.cacheRef;
    }

    private long nanoBase() {
        return this.nanoBase;
    }

    @Override
    public Option<Dns.Resolved> cached(String name) {
        boolean x$12 = false;
        boolean x$22 = DnsProtocol$Ip$.MODULE$.apply$default$1();
        List ipv4 = (List)this.cacheRef().get().get((Tuple2<String, DnsProtocol.RequestType>)new Tuple2((Object)name, (Object)new DnsProtocol.Ip(x$22, x$12))).toList().flatMap((Function1 & Serializable & scala.Serializable)x$1 -> x$1.records(), List$.MODULE$.canBuildFrom());
        List ipv6 = (List)this.cacheRef().get().get((Tuple2<String, DnsProtocol.RequestType>)new Tuple2((Object)name, (Object)new DnsProtocol.Ip(false, DnsProtocol$Ip$.MODULE$.apply$default$2()))).toList().flatMap((Function1 & Serializable & scala.Serializable)x$2 -> x$2.records(), List$.MODULE$.canBuildFrom());
        List both = (List)this.cacheRef().get().get((Tuple2<String, DnsProtocol.RequestType>)new Tuple2((Object)name, (Object)new DnsProtocol.Ip(DnsProtocol$Ip$.MODULE$.apply$default$1(), DnsProtocol$Ip$.MODULE$.apply$default$2()))).toList().flatMap((Function1 & Serializable & scala.Serializable)x$3 -> x$3.records(), List$.MODULE$.canBuildFrom());
        List all = (List)((List)((List)ipv4.$plus$plus((GenTraversableOnce)ipv6, List$.MODULE$.canBuildFrom())).$plus$plus((GenTraversableOnce)both, List$.MODULE$.canBuildFrom())).collect((PartialFunction)new scala.Serializable(null){
            public static final long serialVersionUID = 0L;

            public final <A1 extends ResourceRecord, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                Object object;
                A1 A1 = x1;
                if (A1 instanceof ARecord) {
                    ARecord aRecord = (ARecord)A1;
                    object = aRecord.ip();
                } else if (A1 instanceof AAAARecord) {
                    AAAARecord aAAARecord = (AAAARecord)A1;
                    object = aAAARecord.ip();
                } else {
                    object = function1.apply(x1);
                }
                return (B1)object;
            }

            public final boolean isDefinedAt(ResourceRecord x1) {
                ResourceRecord resourceRecord = x1;
                boolean bl = resourceRecord instanceof ARecord ? true : resourceRecord instanceof AAAARecord;
                return bl;
            }
        }, List$.MODULE$.canBuildFrom());
        return all.isEmpty() ? None$.MODULE$ : new Some((Object)Dns$Resolved$.MODULE$.apply(name, (Iterable<InetAddress>)all));
    }

    public long clock() {
        long now = System.nanoTime();
        return now - this.nanoBase() < 0L ? 0L : (now - this.nanoBase()) / 1000000L;
    }

    public final Option<DnsProtocol.Resolved> get(Tuple2<String, DnsProtocol.RequestType> key) {
        return this.cacheRef().get().get(key);
    }

    public final void put(Tuple2<String, DnsProtocol.RequestType> key, DnsProtocol.Resolved records, CachePolicy.CachePolicy ttl) {
        SimpleDnsCache.Cache<Tuple2<String, DnsProtocol.RequestType>, DnsProtocol.Resolved> c;
        do {
            c = this.cacheRef().get();
        } while (!this.cacheRef().compareAndSet(c, c.put(key, records, ttl)));
    }

    @Override
    public final void cleanup() {
        SimpleDnsCache.Cache<Tuple2<String, DnsProtocol.RequestType>, DnsProtocol.Resolved> c;
        do {
            c = this.cacheRef().get();
        } while (!this.cacheRef().compareAndSet(c, c.cleanup()));
    }
}

