/*
 * Decompiled with CFR 0.152.
 */
package io.aeron;

final class BufferBuilderUtil {
    static final int MAX_CAPACITY = 0x7FFFFFF7;
    static final int MIN_ALLOCATED_CAPACITY = 4096;

    private BufferBuilderUtil() {
    }

    static int findSuitableCapacity(int currentCapacity, int requiredCapacity) {
        int capacity = currentCapacity;
        do {
            int candidateCapacity = capacity + (capacity >> 1);
            int newCapacity = Math.max(candidateCapacity, 4096);
            if (candidateCapacity < 0 || newCapacity > 0x7FFFFFF7) {
                if (capacity == 0x7FFFFFF7) {
                    throw new IllegalStateException("max capacity reached: 2147483639");
                }
                capacity = 0x7FFFFFF7;
                continue;
            }
            capacity = newCapacity;
        } while (capacity < requiredCapacity);
        return capacity;
    }
}

