/*
 * Decompiled with CFR 0.152.
 */
package liquibase.lockservice;

import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import liquibase.configuration.GlobalConfiguration;
import liquibase.configuration.LiquibaseConfiguration;
import liquibase.database.Database;
import liquibase.database.ObjectQuotingStrategy;
import liquibase.database.core.DerbyDatabase;
import liquibase.database.core.MSSQLDatabase;
import liquibase.exception.DatabaseException;
import liquibase.exception.LiquibaseException;
import liquibase.exception.LockException;
import liquibase.exception.UnexpectedLiquibaseException;
import liquibase.executor.Executor;
import liquibase.executor.ExecutorService;
import liquibase.lockservice.DatabaseChangeLogLock;
import liquibase.lockservice.LockService;
import liquibase.logging.LogService;
import liquibase.logging.LogType;
import liquibase.snapshot.InvalidExampleException;
import liquibase.snapshot.SnapshotGeneratorFactory;
import liquibase.sql.Sql;
import liquibase.sqlgenerator.SqlGeneratorFactory;
import liquibase.statement.core.CreateDatabaseChangeLogLockTableStatement;
import liquibase.statement.core.DropTableStatement;
import liquibase.statement.core.InitializeDatabaseChangeLogLockTableStatement;
import liquibase.statement.core.LockDatabaseChangeLogStatement;
import liquibase.statement.core.RawSqlStatement;
import liquibase.statement.core.SelectFromDatabaseChangeLogLockStatement;
import liquibase.statement.core.UnlockDatabaseChangeLogStatement;
import liquibase.structure.core.Table;

public class StandardLockService
implements LockService {
    private static ResourceBundle coreBundle = ResourceBundle.getBundle("liquibase/i18n/liquibase-core");
    protected Database database;
    protected boolean hasChangeLogLock;
    private Long changeLogLockPollRate;
    private Long changeLogLockRecheckTime;
    private Boolean hasDatabaseChangeLogLockTable;
    private boolean isDatabaseChangeLogLockTableInitialized;
    private ObjectQuotingStrategy quotingStrategy;

    @Override
    public int getPriority() {
        return 1;
    }

    @Override
    public boolean supports(Database database) {
        return true;
    }

    @Override
    public void setDatabase(Database database) {
        this.database = database;
    }

    public Long getChangeLogLockWaitTime() {
        if (this.changeLogLockPollRate != null) {
            return this.changeLogLockPollRate;
        }
        return LiquibaseConfiguration.getInstance().getConfiguration(GlobalConfiguration.class).getDatabaseChangeLogLockWaitTime();
    }

    @Override
    public void setChangeLogLockWaitTime(long changeLogLockWaitTime) {
        this.changeLogLockPollRate = changeLogLockWaitTime;
    }

    public Long getChangeLogLockRecheckTime() {
        if (this.changeLogLockRecheckTime != null) {
            return this.changeLogLockRecheckTime;
        }
        return LiquibaseConfiguration.getInstance().getConfiguration(GlobalConfiguration.class).getDatabaseChangeLogLockPollRate();
    }

    @Override
    public void setChangeLogLockRecheckTime(long changeLogLockRecheckTime) {
        this.changeLogLockRecheckTime = changeLogLockRecheckTime;
    }

    @Override
    public void init() throws DatabaseException {
        boolean createdTable = false;
        Executor executor = ExecutorService.getInstance().getExecutor(this.database);
        if (!this.hasDatabaseChangeLogLockTable()) {
            try {
                executor.comment("Create Database Lock Table");
                executor.execute(new CreateDatabaseChangeLogLockTableStatement());
                this.database.commit();
                LogService.getLog(this.getClass()).debug(LogType.LOG, "Created database lock table with name: " + this.database.escapeTableName(this.database.getLiquibaseCatalogName(), this.database.getLiquibaseSchemaName(), this.database.getDatabaseChangeLogLockTableName()));
            }
            catch (DatabaseException e) {
                if (e.getMessage() != null && e.getMessage().contains("exists")) {
                    LogService.getLog(this.getClass()).debug(LogType.LOG, "Database lock table already appears to exist due to exception: " + e.getMessage() + ". Continuing on");
                }
                throw e;
            }
            this.hasDatabaseChangeLogLockTable = true;
            createdTable = true;
            this.hasDatabaseChangeLogLockTable = true;
        }
        if (!this.isDatabaseChangeLogLockTableInitialized(createdTable)) {
            executor.comment("Initialize Database Lock Table");
            executor.execute(new InitializeDatabaseChangeLogLockTableStatement());
            this.database.commit();
        }
        if (executor.updatesDatabase() && this.database instanceof DerbyDatabase && ((DerbyDatabase)this.database).supportsBooleanDataType()) {
            String lockTable = this.database.escapeTableName(this.database.getLiquibaseCatalogName(), this.database.getLiquibaseSchemaName(), this.database.getDatabaseChangeLogLockTableName());
            Object obj = executor.queryForObject(new RawSqlStatement("SELECT MIN(locked) AS test FROM " + lockTable + " FETCH FIRST ROW ONLY"), Object.class);
            if (!(obj instanceof Boolean)) {
                executor.execute(new DropTableStatement(this.database.getLiquibaseCatalogName(), this.database.getLiquibaseSchemaName(), this.database.getDatabaseChangeLogLockTableName(), false));
                executor.execute(new CreateDatabaseChangeLogLockTableStatement());
                executor.execute(new InitializeDatabaseChangeLogLockTableStatement());
            }
        }
    }

    public boolean isDatabaseChangeLogLockTableInitialized(boolean tableJustCreated) throws DatabaseException {
        if (!this.isDatabaseChangeLogLockTableInitialized) {
            Executor executor = ExecutorService.getInstance().getExecutor(this.database);
            try {
                this.isDatabaseChangeLogLockTableInitialized = executor.queryForInt(new RawSqlStatement("SELECT COUNT(*) FROM " + this.database.escapeTableName(this.database.getLiquibaseCatalogName(), this.database.getLiquibaseSchemaName(), this.database.getDatabaseChangeLogLockTableName()))) > 0;
            }
            catch (LiquibaseException e) {
                if (executor.updatesDatabase()) {
                    throw new UnexpectedLiquibaseException(e);
                }
                this.isDatabaseChangeLogLockTableInitialized = !tableJustCreated;
            }
        }
        return this.isDatabaseChangeLogLockTableInitialized;
    }

    @Override
    public boolean hasChangeLogLock() {
        return this.hasChangeLogLock;
    }

    public boolean hasDatabaseChangeLogLockTable() throws DatabaseException {
        if (this.hasDatabaseChangeLogLockTable == null) {
            try {
                this.hasDatabaseChangeLogLockTable = SnapshotGeneratorFactory.getInstance().hasDatabaseChangeLogLockTable(this.database);
            }
            catch (LiquibaseException e) {
                throw new UnexpectedLiquibaseException(e);
            }
        }
        return this.hasDatabaseChangeLogLockTable;
    }

    @Override
    public void waitForLock() throws LockException {
        boolean locked = false;
        long timeToGiveUp = new Date().getTime() + this.getChangeLogLockWaitTime() * 1000L * 60L;
        while (!locked && new Date().getTime() < timeToGiveUp) {
            locked = this.acquireLock();
            if (locked) continue;
            LogService.getLog(this.getClass()).info(LogType.LOG, "Waiting for changelog lock....");
            try {
                Thread.sleep(this.getChangeLogLockRecheckTime() * 1000L);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
        if (!locked) {
            String lockedBy;
            DatabaseChangeLogLock[] locks = this.listLocks();
            if (locks.length > 0) {
                DatabaseChangeLogLock lock = locks[0];
                lockedBy = lock.getLockedBy() + " since " + DateFormat.getDateTimeInstance(3, 3).format(lock.getLockGranted());
            } else {
                lockedBy = "UNKNOWN";
            }
            throw new LockException("Could not acquire change log lock.  Currently locked by " + lockedBy);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean acquireLock() throws LockException {
        if (this.hasChangeLogLock) {
            return true;
        }
        this.quotingStrategy = this.database.getObjectQuotingStrategy();
        Executor executor = ExecutorService.getInstance().getExecutor(this.database);
        try {
            this.database.rollback();
            this.init();
            Boolean locked = ExecutorService.getInstance().getExecutor(this.database).queryForObject(new SelectFromDatabaseChangeLogLockStatement("LOCKED"), Boolean.class);
            if (locked.booleanValue()) {
                boolean bl = false;
                return bl;
            }
            executor.comment("Lock Database");
            int rowsUpdated = executor.update(new LockDatabaseChangeLogStatement());
            if (rowsUpdated == -1 && this.database instanceof MSSQLDatabase) {
                LogService.getLog(this.getClass()).debug(LogType.LOG, "Database did not return a proper row count (Might have NOCOUNT enabled)");
                this.database.rollback();
                Sql[] sql = SqlGeneratorFactory.getInstance().generateSql(new LockDatabaseChangeLogStatement(), this.database);
                if (sql.length != 1) {
                    throw new UnexpectedLiquibaseException("Did not expect " + sql.length + " statements");
                }
                rowsUpdated = executor.update(new RawSqlStatement("EXEC sp_executesql N'SET NOCOUNT OFF " + sql[0].toSql().replace("'", "''") + "'"));
            }
            if (rowsUpdated > 1) {
                throw new LockException("Did not update change log lock correctly");
            }
            if (rowsUpdated == 0) {
                boolean bl = false;
                return bl;
            }
            this.database.commit();
            LogService.getLog(this.getClass()).info(LogType.LOG, coreBundle.getString("successfully.acquired.change.log.lock"));
            this.hasChangeLogLock = true;
            this.database.setCanCacheLiquibaseTableInfo(true);
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            throw new LockException(e);
        }
        finally {
            try {
                this.database.rollback();
            }
            catch (DatabaseException databaseException) {}
        }
    }

    @Override
    public void releaseLock() throws LockException {
        ObjectQuotingStrategy incomingQuotingStrategy = null;
        if (this.quotingStrategy != null) {
            incomingQuotingStrategy = this.database.getObjectQuotingStrategy();
            this.database.setObjectQuotingStrategy(this.quotingStrategy);
        }
        Executor executor = ExecutorService.getInstance().getExecutor(this.database);
        try {
            if (this.hasDatabaseChangeLogLockTable()) {
                executor.comment("Release Database Lock");
                this.database.rollback();
                int updatedRows = executor.update(new UnlockDatabaseChangeLogStatement());
                if (updatedRows == -1 && this.database instanceof MSSQLDatabase) {
                    LogService.getLog(this.getClass()).debug(LogType.LOG, "Database did not return a proper row count (Might have NOCOUNT enabled.)");
                    this.database.rollback();
                    Sql[] sql = SqlGeneratorFactory.getInstance().generateSql(new UnlockDatabaseChangeLogStatement(), this.database);
                    if (sql.length != 1) {
                        throw new UnexpectedLiquibaseException("Did not expect " + sql.length + " statements");
                    }
                    updatedRows = executor.update(new RawSqlStatement("EXEC sp_executesql N'SET NOCOUNT OFF " + sql[0].toSql().replace("'", "''") + "'"));
                }
                if (updatedRows != 1) {
                    throw new LockException("Did not update change log lock correctly.\n\n" + updatedRows + " rows were updated instead of the expected 1 row using executor " + executor.getClass().getName() + "" + " there are " + executor.queryForInt(new RawSqlStatement("SELECT COUNT(*) FROM " + this.database.getDatabaseChangeLogLockTableName())) + " rows in the table");
                }
                this.database.commit();
            }
        }
        catch (Exception e) {
            throw new LockException(e);
        }
        finally {
            try {
                this.hasChangeLogLock = false;
                this.database.setCanCacheLiquibaseTableInfo(false);
                LogService.getLog(this.getClass()).info(LogType.LOG, "Successfully released change log lock");
                this.database.rollback();
            }
            catch (DatabaseException databaseException) {}
            if (incomingQuotingStrategy != null) {
                this.database.setObjectQuotingStrategy(incomingQuotingStrategy);
            }
        }
    }

    @Override
    public DatabaseChangeLogLock[] listLocks() throws LockException {
        try {
            if (!this.hasDatabaseChangeLogLockTable()) {
                return new DatabaseChangeLogLock[0];
            }
            ArrayList<DatabaseChangeLogLock> allLocks = new ArrayList<DatabaseChangeLogLock>();
            SelectFromDatabaseChangeLogLockStatement sqlStatement = new SelectFromDatabaseChangeLogLockStatement("ID", "LOCKED", "LOCKGRANTED", "LOCKEDBY");
            List<Map<String, ?>> rows = ExecutorService.getInstance().getExecutor(this.database).queryForList(sqlStatement);
            for (Map<String, ?> columnMap : rows) {
                Object lockedValue = columnMap.get("LOCKED");
                Boolean locked = lockedValue instanceof Number ? Boolean.valueOf(((Number)lockedValue).intValue() == 1) : (Boolean)lockedValue;
                if (locked == null || !locked.booleanValue()) continue;
                allLocks.add(new DatabaseChangeLogLock(((Number)columnMap.get("ID")).intValue(), (Date)columnMap.get("LOCKGRANTED"), (String)columnMap.get("LOCKEDBY")));
            }
            return allLocks.toArray(new DatabaseChangeLogLock[allLocks.size()]);
        }
        catch (Exception e) {
            throw new LockException(e);
        }
    }

    @Override
    public void forceReleaseLock() throws LockException, DatabaseException {
        this.init();
        this.releaseLock();
    }

    @Override
    public void reset() {
        this.hasChangeLogLock = false;
        this.hasDatabaseChangeLogLockTable = null;
        this.isDatabaseChangeLogLockTableInitialized = false;
    }

    @Override
    public void destroy() throws DatabaseException {
        try {
            if (SnapshotGeneratorFactory.getInstance().has(new Table().setName(this.database.getDatabaseChangeLogLockTableName()).setSchema(this.database.getLiquibaseCatalogName(), this.database.getLiquibaseSchemaName()), this.database)) {
                ExecutorService.getInstance().getExecutor(this.database).execute(new DropTableStatement(this.database.getLiquibaseCatalogName(), this.database.getLiquibaseSchemaName(), this.database.getDatabaseChangeLogLockTableName(), false));
                this.hasDatabaseChangeLogLockTable = null;
            }
            this.reset();
        }
        catch (InvalidExampleException e) {
            throw new UnexpectedLiquibaseException(e);
        }
    }
}

