/*
 * Decompiled with CFR 0.152.
 */
package io.aeron;

import io.aeron.logbuffer.LogBufferDescriptor;

public class ChannelUriStringBuilder {
    public static final String TAG_PREFIX = "tag:";
    private final StringBuilder sb = new StringBuilder(64);
    private String prefix;
    private String media;
    private String endpoint;
    private String networkInterface;
    private String controlEndpoint;
    private String controlMode;
    private String tags;
    private String alias;
    private Boolean reliable;
    private Integer ttl;
    private Integer mtu;
    private Integer termLength;
    private Integer initialTermId;
    private Integer termId;
    private Integer termOffset;
    private Integer sessionId;
    private Long linger;
    private Boolean sparse;
    private boolean isSessionIdTagged;

    public ChannelUriStringBuilder clear() {
        this.prefix = null;
        this.media = null;
        this.endpoint = null;
        this.networkInterface = null;
        this.controlEndpoint = null;
        this.controlMode = null;
        this.tags = null;
        this.alias = null;
        this.reliable = null;
        this.ttl = null;
        this.mtu = null;
        this.termLength = null;
        this.initialTermId = null;
        this.termId = null;
        this.termOffset = null;
        this.sessionId = null;
        this.linger = null;
        this.sparse = null;
        this.isSessionIdTagged = false;
        return this;
    }

    public ChannelUriStringBuilder validate() {
        if (null == this.media) {
            throw new IllegalStateException("media type is mandatory");
        }
        if ("udp".equals(this.media) && null == this.endpoint && null == this.controlEndpoint) {
            throw new IllegalStateException("either 'endpoint' or 'control' must be specified for UDP.");
        }
        int count = 0;
        count += null == this.initialTermId ? 0 : 1;
        count += null == this.termId ? 0 : 1;
        if ((count += null == this.termOffset ? 0 : 1) > 0) {
            if (count < 3) {
                throw new IllegalStateException("if any of then a complete set of 'initialTermId', 'termId', and 'termOffset' must be provided");
            }
            if (this.termId - this.initialTermId < 0) {
                throw new IllegalStateException("difference greater than 2^31 - 1: termId=" + this.termId + " - initialTermId=" + this.initialTermId);
            }
            if (null != this.termLength && this.termOffset > this.termLength) {
                throw new IllegalStateException("termOffset=" + this.termOffset + " > termLength=" + this.termLength);
            }
        }
        return this;
    }

    public ChannelUriStringBuilder prefix(String prefix) {
        if (null != prefix && !prefix.equals("") && !prefix.equals("aeron-spy")) {
            throw new IllegalArgumentException("invalid prefix: " + prefix);
        }
        this.prefix = prefix;
        return this;
    }

    public String prefix() {
        return this.prefix;
    }

    public ChannelUriStringBuilder media(String media) {
        switch (media) {
            case "udp": 
            case "ipc": {
                break;
            }
            default: {
                throw new IllegalArgumentException("invalid media: " + media);
            }
        }
        this.media = media;
        return this;
    }

    public String media() {
        return this.media;
    }

    public ChannelUriStringBuilder endpoint(String endpoint) {
        this.endpoint = endpoint;
        return this;
    }

    public String endpoint() {
        return this.endpoint;
    }

    public ChannelUriStringBuilder networkInterface(String networkInterface) {
        this.networkInterface = networkInterface;
        return this;
    }

    public String networkInterface() {
        return this.networkInterface;
    }

    public ChannelUriStringBuilder controlEndpoint(String controlEndpoint) {
        this.controlEndpoint = controlEndpoint;
        return this;
    }

    public String controlEndpoint() {
        return this.controlEndpoint;
    }

    public ChannelUriStringBuilder controlMode(String controlMode) {
        if (null != controlMode && !controlMode.equals("manual") && !controlMode.equals("dynamic")) {
            throw new IllegalArgumentException("invalid control mode: " + controlMode);
        }
        this.controlMode = controlMode;
        return this;
    }

    public String controlMode() {
        return this.controlMode;
    }

    public ChannelUriStringBuilder reliable(Boolean isReliable) {
        this.reliable = isReliable;
        return this;
    }

    public Boolean reliable() {
        return this.reliable;
    }

    public ChannelUriStringBuilder ttl(Integer ttl) {
        if (null != ttl && (ttl < 0 || ttl > 255)) {
            throw new IllegalArgumentException("TTL not in range 0-255: " + ttl);
        }
        this.ttl = ttl;
        return this;
    }

    public Integer ttl() {
        return this.ttl;
    }

    public ChannelUriStringBuilder mtu(Integer mtu) {
        if (null != mtu) {
            if (mtu < 32 || mtu > 65504) {
                throw new IllegalArgumentException("MTU not in range 32-65504: " + mtu);
            }
            if ((mtu & 0x1F) != 0) {
                throw new IllegalArgumentException("MTU not a multiple of FRAME_ALIGNMENT: mtu=" + mtu);
            }
        }
        this.mtu = mtu;
        return this;
    }

    public Integer mtu() {
        return this.mtu;
    }

    public ChannelUriStringBuilder termLength(Integer termLength) {
        if (null != termLength) {
            LogBufferDescriptor.checkTermLength(termLength);
        }
        this.termLength = termLength;
        return this;
    }

    public Integer termLength() {
        return this.termLength;
    }

    public ChannelUriStringBuilder initialTermId(Integer initialTermId) {
        this.initialTermId = initialTermId;
        return this;
    }

    public Integer initialTermId() {
        return this.initialTermId;
    }

    public ChannelUriStringBuilder termId(Integer termId) {
        this.termId = termId;
        return this;
    }

    public Integer termId() {
        return this.termId;
    }

    public ChannelUriStringBuilder termOffset(Integer termOffset) {
        if (null != termOffset) {
            if (termOffset < 0 || termOffset > 0x40000000) {
                throw new IllegalArgumentException("term offset not in range 0-1g: " + termOffset);
            }
            if (0 != (termOffset & 0x1F)) {
                throw new IllegalArgumentException("term offset not multiple of FRAME_ALIGNMENT: " + termOffset);
            }
        }
        this.termOffset = termOffset;
        return this;
    }

    public Integer termOffset() {
        return this.termOffset;
    }

    public ChannelUriStringBuilder sessionId(Integer sessionId) {
        this.sessionId = sessionId;
        return this;
    }

    public Integer sessionId() {
        return this.sessionId;
    }

    public ChannelUriStringBuilder linger(Long lingerNs) {
        if (null != lingerNs && lingerNs < 0L) {
            throw new IllegalArgumentException("linger value cannot be negative: " + lingerNs);
        }
        this.linger = lingerNs;
        return this;
    }

    public Long linger() {
        return this.linger;
    }

    public ChannelUriStringBuilder sparse(Boolean isSparse) {
        this.sparse = isSparse;
        return this;
    }

    public Boolean sparse() {
        return this.sparse;
    }

    public ChannelUriStringBuilder tags(String tags) {
        this.tags = tags;
        return this;
    }

    public String tags() {
        return this.tags;
    }

    public ChannelUriStringBuilder isSessionIdTagged(boolean isSessionIdTagged) {
        this.isSessionIdTagged = isSessionIdTagged;
        return this;
    }

    public boolean isSessionIdTagged() {
        return this.isSessionIdTagged;
    }

    public ChannelUriStringBuilder alias(String alias) {
        this.alias = alias;
        return this;
    }

    public String alias() {
        return this.alias;
    }

    public ChannelUriStringBuilder initialPosition(long position, int initialTermId, int termLength) {
        if (position < 0L || 0L != (position & 0x1FL)) {
            throw new IllegalArgumentException("invalid position: " + position);
        }
        int bitsToShift = LogBufferDescriptor.positionBitsToShift(termLength);
        this.initialTermId = initialTermId;
        this.termId = LogBufferDescriptor.computeTermIdFromPosition(position, bitsToShift, initialTermId);
        this.termOffset = (int)(position & (long)(termLength - 1));
        this.termLength = termLength;
        return this;
    }

    public String build() {
        char lastChar;
        this.sb.setLength(0);
        if (null != this.prefix && !"".equals(this.prefix)) {
            this.sb.append(this.prefix).append(':');
        }
        this.sb.append("aeron").append(':').append(this.media).append('?');
        if (null != this.tags) {
            this.sb.append("tags").append('=').append(this.tags).append('|');
        }
        if (null != this.endpoint) {
            this.sb.append("endpoint").append('=').append(this.endpoint).append('|');
        }
        if (null != this.networkInterface) {
            this.sb.append("interface").append('=').append(this.networkInterface).append('|');
        }
        if (null != this.controlEndpoint) {
            this.sb.append("control").append('=').append(this.controlEndpoint).append('|');
        }
        if (null != this.controlMode) {
            this.sb.append("control-mode").append('=').append(this.controlMode).append('|');
        }
        if (null != this.mtu) {
            this.sb.append("mtu").append('=').append(this.mtu).append('|');
        }
        if (null != this.termLength) {
            this.sb.append("term-length").append('=').append(this.termLength).append('|');
        }
        if (null != this.initialTermId) {
            this.sb.append("init-term-id").append('=').append(this.initialTermId).append('|');
        }
        if (null != this.termId) {
            this.sb.append("term-id").append('=').append(this.termId).append('|');
        }
        if (null != this.termOffset) {
            this.sb.append("term-offset").append('=').append(this.termOffset).append('|');
        }
        if (null != this.sessionId) {
            this.sb.append("session-id").append('=').append(ChannelUriStringBuilder.prefixTag(this.isSessionIdTagged, this.sessionId)).append('|');
        }
        if (null != this.ttl) {
            this.sb.append("ttl").append('=').append(this.ttl).append('|');
        }
        if (null != this.reliable) {
            this.sb.append("reliable").append('=').append(this.reliable).append('|');
        }
        if (null != this.linger) {
            this.sb.append("linger").append('=').append(this.linger.intValue()).append('|');
        }
        if (null != this.alias) {
            this.sb.append("alias").append('=').append(this.alias).append('|');
        }
        if (null != this.sparse) {
            this.sb.append("sparse").append('=').append(this.sparse).append('|');
        }
        if ((lastChar = this.sb.charAt(this.sb.length() - 1)) == '|' || lastChar == '?') {
            this.sb.setLength(this.sb.length() - 1);
        }
        return this.sb.toString();
    }

    private static String prefixTag(boolean isTagged, Integer value) {
        return isTagged ? TAG_PREFIX + value.toString() : value.toString();
    }
}

