/*
 * Decompiled with CFR 0.152.
 */
package akka.remote.artery.tcp;

import akka.annotation.InternalApi;
import akka.event.LogMarker$;
import akka.event.MarkerLoggingAdapter;
import akka.remote.security.provider.DeprecatedAkkaProvider$;
import java.security.SecureRandom;

@InternalApi
public final class SecureRandomFactory$ {
    public static SecureRandomFactory$ MODULE$;

    static {
        new SecureRandomFactory$();
    }

    public SecureRandom createSecureRandom(String randomNumberGenerator, MarkerLoggingAdapter log) {
        SecureRandom secureRandom;
        String string = randomNumberGenerator;
        boolean bl = "SHA1PRNG".equals(string) ? true : "NativePRNG".equals(string);
        if (bl) {
            log.debug("SSL random number generator set to: {}", (Object)string);
            secureRandom = SecureRandom.getInstance(string);
        } else {
            boolean bl2 = "".equals(string) ? true : "SecureRandom".equals(string);
            if (bl2) {
                log.debug("SSL random number generator set to [SecureRandom]");
                secureRandom = new SecureRandom();
            } else {
                boolean bl3 = "AES128CounterSecureRNG".equals(string) ? true : "AES256CounterSecureRNG".equals(string);
                if (bl3) {
                    log.warning("SSL random number generator set to deprecated [{}], using [SecureRandom] instead. The [{}] implementation can be enabled with configuration value [Deprecated{r}], but that is not recommended.", (Object)string, (Object)string, (Object)string);
                    secureRandom = new SecureRandom();
                } else {
                    boolean bl4 = "DeprecatedAES128CounterSecureRNG".equals(string) ? true : "DeprecatedAES256CounterSecureRNG".equals(string);
                    if (bl4) {
                        log.warning("SSL random number generator set to deprecated [{}]. Use [SecureRandom] instead.", (Object)string);
                        secureRandom = SecureRandom.getInstance(string, DeprecatedAkkaProvider$.MODULE$);
                    } else {
                        log.warning(LogMarker$.MODULE$.Security(), "Unknown SSL random number generator [{}] falling back to SecureRandom", (Object)string);
                        secureRandom = new SecureRandom();
                    }
                }
            }
        }
        SecureRandom rng = secureRandom;
        rng.nextInt();
        return rng;
    }

    private SecureRandomFactory$() {
        MODULE$ = this;
    }
}

