/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.deployment.planner;

import com.google.common.base.Preconditions;
import com.xebialabs.deployit.deployment.planner.MultiDeltaSpecificationHelper;
import com.xebialabs.deployit.plugin.api.deployment.specification.Delta;
import com.xebialabs.deployit.plugin.api.deployment.specification.DeltaSpecification;
import com.xebialabs.deployit.plugin.api.deployment.specification.DeltaSpecificationWithDependencies;
import com.xebialabs.deployit.plugin.api.deployment.specification.Operation;
import com.xebialabs.deployit.plugin.api.udm.DeployedApplication;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class MultiDeltaSpecification
implements DeltaSpecificationWithDependencies {
    private final List<List<DeltaSpecification>> deltaSpecifications;
    private final DeployedApplication mainApplication;

    public MultiDeltaSpecification(DeltaSpecification deltaSpecification) {
        this(deltaSpecification, Collections.emptyList());
    }

    private MultiDeltaSpecification(DeltaSpecification mainDeltaSpecification, List<List<DeltaSpecification>> dependencies) {
        Preconditions.checkNotNull((Object)mainDeltaSpecification, (Object)"Wrong usage of internal API: mainDeltaSpecification must not be null");
        this.deltaSpecifications = dependencies.stream().map(ArrayList::new).collect(Collectors.toList());
        ArrayList<DeltaSpecification> emptyList = new ArrayList<DeltaSpecification>();
        emptyList.add(mainDeltaSpecification);
        this.deltaSpecifications.add(emptyList);
        this.mainApplication = mainDeltaSpecification.getDeployedApplication();
    }

    private MultiDeltaSpecification(List<List<DeltaSpecification>> dependencies, DeltaSpecification mainDeltaSpecification) {
        Preconditions.checkNotNull((Object)mainDeltaSpecification, (Object)"Wrong usage of internal API: mainDeltaSpecification must not be null");
        ArrayList<List<DeltaSpecification>> deltaList = new ArrayList<List<DeltaSpecification>>();
        if (mainDeltaSpecification.getOperation() == Operation.DESTROY) {
            deltaList.add(Collections.singletonList(mainDeltaSpecification));
        }
        deltaList.addAll(dependencies.stream().map(ArrayList::new).collect(Collectors.toList()));
        if (mainDeltaSpecification.getOperation() != Operation.DESTROY) {
            deltaList.add(Collections.singletonList(mainDeltaSpecification));
        }
        this.deltaSpecifications = deltaList;
        this.mainApplication = mainDeltaSpecification.getDeployedApplication();
    }

    private MultiDeltaSpecification(List<List<DeltaSpecification>> allDeltaSpecifications, DeployedApplication mainApplication) {
        Preconditions.checkArgument((allDeltaSpecifications.size() >= 1 ? 1 : 0) != 0, (Object)"Wrong usage of internal API: allDeltaSpecifications must contain 1 element");
        this.deltaSpecifications = allDeltaSpecifications;
        this.mainApplication = mainApplication;
    }

    private Stream<List<DeltaSpecification>> deltaSpecificationStream() {
        return this.deltaSpecifications.stream();
    }

    public List<DeltaSpecification> getAllDeltaSpecifications() {
        return this.flattenDeltaSpecs();
    }

    private List<DeltaSpecification> flattenDeltaSpecs() {
        ArrayList<DeltaSpecification> deltaSpecs = new ArrayList<DeltaSpecification>();
        this.deltaSpecificationStream().forEach(deltaSpecs::addAll);
        return deltaSpecs;
    }

    public List<List<DeltaSpecification>> getAllGroupedDeltaSpecifications() {
        return this.deltaSpecifications;
    }

    public List<DeployedApplication> getAllDeployedApplications() {
        return this.flattenDeltaSpecs().stream().map(MultiDeltaSpecificationHelper::correctDeployedApplication).collect(Collectors.toList());
    }

    public List<Delta> getAllDeltas() {
        return this.flattenDeltaSpecs().stream().flatMap(spec -> spec.getDeltas().stream()).collect(Collectors.toList());
    }

    public List<String> getOrchestrators() {
        return Collections.unmodifiableList(this.mainApplication.getOrchestrator());
    }

    public DeployedApplication getMainApplication() {
        return this.mainApplication;
    }

    public static MultiDeltaSpecification withDependencies(DeltaSpecification main, List<List<DeltaSpecification>> dependencies) {
        return new MultiDeltaSpecification(main, dependencies);
    }

    public static MultiDeltaSpecification forUpdate(DeltaSpecification main, List<List<DeltaSpecification>> dependencies) {
        return new MultiDeltaSpecification(dependencies, main);
    }

    public static MultiDeltaSpecification forRollback(List<List<DeltaSpecification>> deltaSpecifications, DeployedApplication mainApplication) {
        return new MultiDeltaSpecification(deltaSpecifications, mainApplication);
    }

    public static MultiDeltaSpecification forUndeploy(List<List<DeltaSpecification>> deltaSpecifications, DeployedApplication mainApplication) {
        return new MultiDeltaSpecification(deltaSpecifications, mainApplication);
    }
}

