/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.core.rest.websockets;

import com.xebialabs.deployit.core.events.ChangeSetEvent;
import com.xebialabs.deployit.core.websockets.WebSocketEndpoints;
import com.xebialabs.deployit.engine.spi.event.MaintenanceStartEvent;
import com.xebialabs.deployit.engine.spi.event.MaintenanceStopEvent;
import com.xebialabs.deployit.event.EventBusHolder;
import java.util.Collection;
import nl.javadude.t2bus.Subscribe;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.messaging.simp.SimpMessagingTemplate;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.stereotype.Controller;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.convert.ImplicitConversions$;
import scala.collection.immutable.Map;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@Controller
@ScalaSignature(bytes="\u0006\u0001\u0005-c\u0001B\u0001\u0003\u0001=\u0011qcV3c'>\u001c7.\u001a;NKN\u001c\u0018mZ3t'\u0016tG-\u001a:\u000b\u0005\r!\u0011AC<fEN|7m[3ug*\u0011QAB\u0001\u0005e\u0016\u001cHO\u0003\u0002\b\u0011\u0005!1m\u001c:f\u0015\tI!\"\u0001\u0005eKBdw._5u\u0015\tYA\"A\u0005yK\nL\u0017\r\\1cg*\tQ\"A\u0002d_6\u001c\u0001a\u0005\u0002\u0001!A\u0011\u0011\u0003F\u0007\u0002%)\t1#A\u0003tG\u0006d\u0017-\u0003\u0002\u0016%\t1\u0011I\\=SK\u001aD\u0001b\u0006\u0001\u0003\u0002\u0003\u0006I\u0001G\u0001\u0010[\u0016\u001c8/Y4f)\u0016l\u0007\u000f\\1uKB\u0011\u0011DI\u0007\u00025)\u00111\u0004H\u0001\u0005g&l\u0007O\u0003\u0002\u001e=\u0005IQ.Z:tC\u001eLgn\u001a\u0006\u0003?\u0001\nqb\u001d9sS:<gM]1nK^|'o\u001b\u0006\u0002C\u0005\u0019qN]4\n\u0005\rR\"!F*j[BlUm]:bO&tw\rV3na2\fG/\u001a\u0015\u0003-\u0015\u0002\"AJ\u0017\u000e\u0003\u001dR!\u0001K\u0015\u0002\u0015\u0005tgn\u001c;bi&|gN\u0003\u0002+W\u00059a-Y2u_JL(B\u0001\u0017\u001f\u0003\u0015\u0011W-\u00198t\u0013\tqsEA\u0005BkR|w/\u001b:fI\")\u0001\u0007\u0001C\u0001c\u00051A(\u001b8jiz\"\"A\r\u001b\u0011\u0005M\u0002Q\"\u0001\u0002\t\u000b]y\u0003\u0019\u0001\r)\u0005Q*\u0003\"B\u001c\u0001\t\u0013A\u0014AC4fi\"+\u0017\rZ3sgV\t\u0011\b\u0005\u0003;\u0003\u0012\u0003bBA\u001e@!\ta$#D\u0001>\u0015\tqd\"\u0001\u0004=e>|GOP\u0005\u0003\u0001J\ta\u0001\u0015:fI\u00164\u0017B\u0001\"D\u0005\ri\u0015\r\u001d\u0006\u0003\u0001J\u0001\"AO#\n\u0005\u0019\u001b%AB*ue&tw\rC\u0003I\u0001\u0011%\u0011*\u0001\to_RLg-_%g\u001d>$X)\u001c9usR\u0019!*\u0014+\u0011\u0005EY\u0015B\u0001'\u0013\u0005\u0011)f.\u001b;\t\u000b9;\u0005\u0019A(\u0002\u0011\u0015tG\r]8j]R\u0004\"\u0001\u0015*\u000e\u0003ES!a\u0001\u0004\n\u0005M\u000b&AE,fEN{7m[3u\u000b:$\u0007o\\5oiNDQ!V$A\u0002Y\u000b1aY5ta\t9\u0016\rE\u0002Y;~k\u0011!\u0017\u0006\u00035n\u000bA!\u001e;jY*\tA,\u0001\u0003kCZ\f\u0017B\u00010Z\u0005)\u0019u\u000e\u001c7fGRLwN\u001c\t\u0003A\u0006d\u0001\u0001B\u0005c)\u0006\u0005\t\u0011!B\u0001G\n\u0019q\fJ\u0019\u0012\u0005\u0011<\u0007CA\tf\u0013\t1'CA\u0004O_RD\u0017N\\4\u0011\u0005EA\u0017BA5\u0013\u0005\r\te.\u001f\u0005\u0006W\u0002!\t\u0001\\\u0001\u0018g\u0016tGmQ5DQ\u0006tw-Z*fi6+7o]1hKN$\"AS7\t\u000b9T\u0007\u0019A8\u0002\u000b\u00154XM\u001c;\u0011\u0005A\u001cX\"A9\u000b\u0005I4\u0011AB3wK:$8/\u0003\u0002uc\nq1\t[1oO\u0016\u001cV\r^#wK:$\bF\u00016w!\t9h0D\u0001y\u0015\tI(0A\u0003ue\t,8O\u0003\u0002|y\u0006A!.\u0019<bIV$WMC\u0001~\u0003\tqG.\u0003\u0002\u0000q\nI1+\u001e2tGJL'-\u001a\u0005\b\u0003\u0007\u0001A\u0011BA\u0003\u0003\u0001rw\u000e^5gs\u0006\u0013w.\u001e;NC&tG/\u001a8b]\u000e,Wj\u001c3f\u0007\"\fgnZ3\u0015\u0007)\u000b9\u0001\u0003\u0005\u0002\n\u0005\u0005\u0001\u0019AA\u0006\u0003\u001d)g.\u00192mK\u0012\u00042!EA\u0007\u0013\r\tyA\u0005\u0002\b\u0005>|G.Z1o\u0011\u001d\t\u0019\u0002\u0001C\u0001\u0003+\tac]3oI6\u000b\u0017N\u001c;f]\u0006t7-Z*uCJ$X\r\u001a\u000b\u0004\u0015\u0006]\u0001b\u00028\u0002\u0012\u0001\u0007\u0011\u0011\u0004\t\u0005\u00037\t9#\u0004\u0002\u0002\u001e)\u0019a.a\b\u000b\t\u0005\u0005\u00121E\u0001\u0004gBL'bAA\u0013\u0011\u00051QM\\4j]\u0016LA!!\u000b\u0002\u001e\t)R*Y5oi\u0016t\u0017M\\2f'R\f'\u000f^#wK:$\bfAA\tm\"9\u0011q\u0006\u0001\u0005\u0002\u0005E\u0012AF:f]\u0012l\u0015-\u001b8uK:\fgnY3Ti>\u0004\b/\u001a3\u0015\u0007)\u000b\u0019\u0004C\u0004o\u0003[\u0001\r!!\u000e\u0011\t\u0005m\u0011qG\u0005\u0005\u0003s\tiB\u0001\u000bNC&tG/\u001a8b]\u000e,7\u000b^8q\u000bZ,g\u000e\u001e\u0015\u0004\u0003[1\bf\u0001\u0001\u0002@A!\u0011\u0011IA$\u001b\t\t\u0019EC\u0002\u0002Fy\t!b\u001d;fe\u0016|G/\u001f9f\u0013\u0011\tI%a\u0011\u0003\u0015\r{g\u000e\u001e:pY2,'\u000f")
public class WebSocketMessagesSender {
    @Autowired
    private final SimpMessagingTemplate messageTemplate;

    private Map<String, Object> getHeaders() {
        String currentUser = SecurityContextHolder.getContext().getAuthentication().getName();
        return (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"username"), (Object)currentUser)}));
    }

    private void notifyIfNotEmpty(WebSocketEndpoints endpoint, Collection<?> cis) {
        block0: {
            if (!ImplicitConversions$.MODULE$.collection$u0020AsScalaIterable(cis).nonEmpty()) break block0;
            this.messageTemplate.convertAndSend((Object)endpoint.getName(), cis, ImplicitConversions$.MODULE$.map$u0020AsJavaMap(this.getHeaders()));
        }
    }

    @Subscribe
    public void sendCiChangeSetMessages(ChangeSetEvent event) {
        this.notifyIfNotEmpty(WebSocketEndpoints.TOPIC_CI_CREATE, event.createCis());
        this.notifyIfNotEmpty(WebSocketEndpoints.TOPIC_CI_UPDATE, event.updateCis());
        this.notifyIfNotEmpty(WebSocketEndpoints.TOPIC_CI_DELETE, event.deleteCiIds());
        this.notifyIfNotEmpty(WebSocketEndpoints.TOPIC_CI_RENAME, event.renameCis());
        this.notifyIfNotEmpty(WebSocketEndpoints.TOPIC_CI_MOVE, event.moveCis());
        this.notifyIfNotEmpty(WebSocketEndpoints.TOPIC_CI_COPY, event.copyCis());
    }

    private void notifyAboutMaintenanceModeChange(boolean enabled) {
        this.messageTemplate.convertAndSend((Object)WebSocketEndpoints.TOPIC_MAINTENANCE.getName(), (Object)BoxesRunTime.boxToBoolean((boolean)enabled), ImplicitConversions$.MODULE$.map$u0020AsJavaMap(this.getHeaders()));
    }

    @Subscribe
    public void sendMaintenanceStarted(MaintenanceStartEvent event) {
        this.notifyAboutMaintenanceModeChange(true);
    }

    @Subscribe
    public void sendMaintenanceStopped(MaintenanceStopEvent event) {
        this.notifyAboutMaintenanceModeChange(false);
    }

    public WebSocketMessagesSender(@Autowired SimpMessagingTemplate messageTemplate) {
        this.messageTemplate = messageTemplate;
        EventBusHolder.register((Object)this);
    }
}

