/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.repository.sql.commands;

import com.xebialabs.deployit.checks.Checks;
import com.xebialabs.deployit.core.sql.SqlDialect;
import com.xebialabs.deployit.core.sql.spring.package;
import com.xebialabs.deployit.engine.spi.event.CiRenamedEvent;
import com.xebialabs.deployit.engine.spi.exception.DeployitException;
import com.xebialabs.deployit.event.EventBusHolder;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.repository.ItemAlreadyExistsException;
import com.xebialabs.deployit.repository.internal.Root;
import com.xebialabs.deployit.repository.sql.artifacts.ArtifactDataRepository;
import com.xebialabs.deployit.repository.sql.base.CIS$;
import com.xebialabs.deployit.repository.sql.base.package$;
import com.xebialabs.deployit.repository.sql.commands.ChangeSetContext;
import com.xebialabs.deployit.repository.sql.commands.UpdatePathCommand;
import com.xebialabs.deployit.util.Tuple;
import java.io.Serializable;
import java.util.Map;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005\u001db\u0001B\u0001\u0003\u0001=\u0011QBU3oC6,7i\\7nC:$'BA\u0002\u0005\u0003!\u0019w.\\7b]\u0012\u001c(BA\u0003\u0007\u0003\r\u0019\u0018\u000f\u001c\u0006\u0003\u000f!\t!B]3q_NLGo\u001c:z\u0015\tI!\"\u0001\u0005eKBdw._5u\u0015\tYA\"A\u0005yK\nL\u0017\r\\1cg*\tQ\"A\u0002d_6\u001c\u0001a\u0005\u0002\u0001!A\u0011\u0011CE\u0007\u0002\u0005%\u00111C\u0001\u0002\u0012+B$\u0017\r^3QCRD7i\\7nC:$\u0007\u0002C\u000b\u0001\u0005\u000b\u0007I\u0011\t\f\u0002\u0019)$'m\u0019+f[Bd\u0017\r^3\u0016\u0003]\u0001\"\u0001G\u0011\u000e\u0003eQ!AG\u000e\u0002\t\r|'/\u001a\u0006\u00039u\tAA\u001b3cG*\u0011adH\u0001\u0010gB\u0014\u0018N\\4ge\u0006lWm^8sW*\t\u0001%A\u0002pe\u001eL!AI\r\u0003\u0019)#'m\u0019+f[Bd\u0017\r^3\t\u0011\u0011\u0002!\u0011!Q\u0001\n]\tQB\u001b3cGR+W\u000e\u001d7bi\u0016\u0004\u0003\u0002\u0003\u0014\u0001\u0005\u0003\u0005\u000b\u0011B\u0014\u0002%\u0005\u0014H/\u001b4bGR\u0014V\r]8tSR|'/\u001f\t\u0003Q-j\u0011!\u000b\u0006\u0003U\u0011\t\u0011\"\u0019:uS\u001a\f7\r^:\n\u00051J#AF!si&4\u0017m\u0019;ECR\f'+\u001a9pg&$xN]=\t\u00119\u0002!Q1A\u0005\u0002=\n\u0011B]3oC6,7)[:\u0016\u0003A\u00022!M\u001e?\u001d\t\u0011\u0004H\u0004\u00024m5\tAG\u0003\u00026\u001d\u00051AH]8pizJ\u0011aN\u0001\u0006g\u000e\fG.Y\u0005\u0003si\nq\u0001]1dW\u0006<WMC\u00018\u0013\taTH\u0001\u0005Ji\u0016\u0014\u0018M\u00197f\u0015\tI$\b\u0005\u0003@\u0005\u0012#U\"\u0001!\u000b\u0005\u0005C\u0011\u0001B;uS2L!a\u0011!\u0003\u000bQ+\b\u000f\\3\u0011\u0005\u0015KeB\u0001$H!\t\u0019$(\u0003\u0002Iu\u00051\u0001K]3eK\u001aL!AS&\u0003\rM#(/\u001b8h\u0015\tA%\b\u0003\u0005N\u0001\t\u0005\t\u0015!\u00031\u0003)\u0011XM\\1nK\u000eK7\u000f\t\u0005\t\u001f\u0002\u0011)\u0019!C\u0002!\u0006Q1/\u001d7ES\u0006dWm\u0019;\u0016\u0003E\u0003\"AU+\u000e\u0003MS!!\u0002+\u000b\u0005iA\u0011B\u0001,T\u0005)\u0019\u0016\u000f\u001c#jC2,7\r\u001e\u0005\t1\u0002\u0011\t\u0011)A\u0005#\u0006Y1/\u001d7ES\u0006dWm\u0019;!\u0011\u0015Q\u0006\u0001\"\u0001\\\u0003\u0019a\u0014N\\5u}Q!Al\u00181b)\tif\f\u0005\u0002\u0012\u0001!)q*\u0017a\u0002#\")Q#\u0017a\u0001/!)a%\u0017a\u0001O!)a&\u0017a\u0001a!)1\r\u0001C!I\u00069Q\r_3dkR,GCA3j!\t1w-D\u0001;\u0013\tA'H\u0001\u0003V]&$\b\"\u00026c\u0001\u0004Y\u0017aB2p]R,\u0007\u0010\u001e\t\u0003#1L!!\u001c\u0002\u0003!\rC\u0017M\\4f'\u0016$8i\u001c8uKb$\b\"B8\u0001\t\u0003\u0002\u0018\u0001\u0003<bY&$\u0017\r^3\u0015\u0005\u0015\f\b\"\u00026o\u0001\u0004Y\u0007\"B:\u0001\t\u0013!\u0018A\u0002:f]\u0006lW\rF\u0002fk^DQA\u001e:A\u0002\u0011\u000bQa\u001c7e\u0013\u0012DQ\u0001\u001f:A\u0002\u0011\u000bqA\\3x\u001d\u0006lW\rC\u0003{\u0001\u0011%10\u0001\bwC2LG-\u0019;f%\u0016t\u0017-\\3\u0015\u0007\u0015dX\u0010C\u0003ws\u0002\u0007A\tC\u0003ys\u0002\u0007A\t\u0003\u0004\u0000\u0001\u0011%\u0011\u0011A\u0001\u0014cV,'/_!oIB\u0013XMV1mS\u0012\fG/\u001a\u000b\u0007\u0003\u0007\t\u0019#!\n\u0011\r\u0019\f)\u0001RA\u0005\u0013\r\t9A\u000f\u0002\u0007)V\u0004H.\u001a\u001a\u0011\u000f\u0005-\u00111\u0003#\u0002\u00185\u0011\u0011Q\u0002\u0006\u0004\u0003\u0006=!BAA\t\u0003\u0011Q\u0017M^1\n\t\u0005U\u0011Q\u0002\u0002\u0004\u001b\u0006\u0004\b\u0003BA\r\u0003?i!!a\u0007\u000b\t\u0005u\u0011qB\u0001\u0005Y\u0006tw-\u0003\u0003\u0002\"\u0005m!AB(cU\u0016\u001cG\u000fC\u0003w}\u0002\u0007A\tC\u0003y}\u0002\u0007A\t")
public class RenameCommand
extends UpdatePathCommand {
    private final JdbcTemplate jdbcTemplate;
    private final Iterable<Tuple<String, String>> renameCis;
    private final SqlDialect sqlDialect;

    @Override
    public JdbcTemplate jdbcTemplate() {
        return this.jdbcTemplate;
    }

    public Iterable<Tuple<String, String>> renameCis() {
        return this.renameCis;
    }

    public SqlDialect sqlDialect() {
        return this.sqlDialect;
    }

    @Override
    public void execute(ChangeSetContext context) {
        this.renameCis().foreach((Function1 & Serializable & scala.Serializable)t -> {
            this.rename((String)t.a, (String)t.b);
            return BoxedUnit.UNIT;
        });
    }

    @Override
    public void validate(ChangeSetContext context) {
        this.renameCis().foreach((Function1 & Serializable & scala.Serializable)t -> {
            this.validateRename((String)t.a, (String)t.b);
            return BoxedUnit.UNIT;
        });
    }

    private void rename(String oldId, String newName) {
        String string;
        Map map;
        block3: {
            Tuple2<String, Map<String, Object>> tuple2;
            block2: {
                tuple2 = this.queryAndPreValidate(oldId, newName);
                if (tuple2 == null) break block2;
                String oldPath = (String)tuple2._1();
                map = (Map)tuple2._2();
                if (oldPath == null) break block2;
                string = oldPath;
                if (map != null) break block3;
            }
            throw new MatchError(tuple2);
        }
        Map map2 = map;
        Tuple2 tuple2 = new Tuple2((Object)string, (Object)map2);
        Tuple2 tuple22 = tuple2;
        String oldPath = (String)tuple22._1();
        Map map3 = (Map)tuple22._2();
        this.updateNameAndPath(oldPath, (String)package$.MODULE$.parentPath(oldId).get() + "/" + newName);
        EventBusHolder.publish((Object)new CiRenamedEvent(package$.MODULE$.readBaseCiFromMap(map3), newName));
    }

    private void validateRename(String oldId, String newName) {
        this.queryAndPreValidate(oldId, newName);
        String newPath = (String)package$.MODULE$.parentPath(oldId).get() + "/" + newName;
        if (this.exists(newPath)) {
            throw new ItemAlreadyExistsException("The destination id [%s] exists.", new Object[]{package$.MODULE$.pathToId(newPath)});
        }
    }

    private Tuple2<String, Map<String, Object>> queryAndPreValidate(String oldId, String newName) {
        Type ciType;
        Checks.checkArgument((!new StringOps(Predef$.MODULE$.augmentString(newName)).contains((Object)BoxesRunTime.boxToCharacter((char)'/')) ? 1 : 0) != 0, (String)"New name [%s] should not contain a /", (Object[])new Object[]{newName});
        String oldPath = package$.MODULE$.idToPath(oldId);
        Map map = (Map)this.jdbcTemplate().queryForObject(this.SELECT_CI_BY_PATH(), (RowMapper)new package.MapRowMapper(), new Object[]{oldPath});
        Type type = ciType = Type.valueOf((String)((String)map.get(CIS$.MODULE$.ci_type().name())));
        Type type2 = Type.valueOf(Root.class);
        if (!(type != null ? !type.equals(type2) : type2 != null)) {
            throw new DeployitException("Cannot rename a core.Root configuration item");
        }
        return new Tuple2((Object)oldPath, (Object)map);
    }

    public RenameCommand(JdbcTemplate jdbcTemplate, ArtifactDataRepository artifactRepository, Iterable<Tuple<String, String>> renameCis, SqlDialect sqlDialect) {
        this.jdbcTemplate = jdbcTemplate;
        this.renameCis = renameCis;
        this.sqlDialect = sqlDialect;
        super(jdbcTemplate, artifactRepository);
    }
}

