/*
 * Decompiled with CFR 0.152.
 */
package akka.serialization;

import akka.actor.ActorRef;
import akka.actor.ActorSystem;
import akka.actor.Address;
import akka.actor.ExtendedActorSystem;
import akka.actor.Extension;
import akka.actor.NoSerializationVerificationNeeded;
import akka.annotation.InternalApi;
import akka.event.LogMarker$;
import akka.event.LogSource$;
import akka.event.Logging$;
import akka.event.LoggingAdapter;
import akka.event.MarkerLoggingAdapter;
import akka.serialization.ByteBufferSerializer;
import akka.serialization.DisabledJavaSerializer;
import akka.serialization.JavaSerializer;
import akka.serialization.NullSerializer$;
import akka.serialization.Serialization$;
import akka.serialization.SerializationSetup;
import akka.serialization.Serializer;
import akka.serialization.SerializerDetails;
import akka.serialization.SerializerDetails$;
import akka.serialization.SerializerWithStringManifest;
import com.typesafe.config.Config;
import com.typesafe.config.ConfigMergeable;
import java.io.NotSerializableException;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.NoSuchElementException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicReference;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterable;
import scala.collection.Iterator;
import scala.collection.Iterator$;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.SeqLike;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.generic.CanBuildFrom;
import scala.collection.immutable.Iterable$;
import scala.collection.immutable.List$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Map$;
import scala.collection.immutable.MapLike;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq$;
import scala.collection.immutable.Vector;
import scala.collection.mutable.ArrayBuffer;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;

@ScalaSignature(bytes="\u0006\u0001\u0011Ut!B\u0001\u0003\u0011\u00039\u0011!D*fe&\fG.\u001b>bi&|gN\u0003\u0002\u0004\t\u0005i1/\u001a:jC2L'0\u0019;j_:T\u0011!B\u0001\u0005C.\\\u0017m\u0001\u0001\u0011\u0005!IQ\"\u0001\u0002\u0007\u000b)\u0011\u0001\u0012A\u0006\u0003\u001bM+'/[1mSj\fG/[8o'\tIA\u0002\u0005\u0002\u000e!5\taBC\u0001\u0010\u0003\u0015\u00198-\u00197b\u0013\t\tbB\u0001\u0004B]f\u0014VM\u001a\u0005\u0006'%!\t\u0001F\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003\u001d)AAF\u0005\u0001/\ty1\t\\1tgN+'/[1mSj,'\u000f\u0005\u0003\u000e1i\t\u0014BA\r\u000f\u0005\u0019!V\u000f\u001d7feA\u00121\u0004\u000b\t\u00049\r2cBA\u000f\"!\tqb\"D\u0001 \u0015\t\u0001c!\u0001\u0004=e>|GOP\u0005\u0003E9\ta\u0001\u0015:fI\u00164\u0017B\u0001\u0013&\u0005\u0015\u0019E.Y:t\u0015\t\u0011c\u0002\u0005\u0002(Q1\u0001A!C\u0015\u0016\u0003\u0003\u0005\tQ!\u0001+\u0005\ryF%M\t\u0003W9\u0002\"!\u0004\u0017\n\u00055r!a\u0002(pi\"Lgn\u001a\t\u0003\u001b=J!\u0001\r\b\u0003\u0007\u0005s\u0017\u0010\u0005\u0002\te%\u00111G\u0001\u0002\u000b'\u0016\u0014\u0018.\u00197ju\u0016\u0014\b\u0002C\u001b\n\u0005\u0004%\t\u0001\u0002\u001c\u00027\r,(O]3oiR\u0013\u0018M\\:q_J$\u0018J\u001c4pe6\fG/[8o+\u00059\u0004c\u0001\u001d<{5\t\u0011H\u0003\u0002;\u001d\u0005!Q\u000f^5m\u0013\ta\u0014HA\bEs:\fW.[2WCJL\u0017M\u00197f!\tqt(D\u0001\n\r\u0011\u0001\u0015BQ!\u0003\u0017%sgm\u001c:nCRLwN\\\n\u0005\u007f1\u0011U\t\u0005\u0002\u000e\u0007&\u0011AI\u0004\u0002\b!J|G-^2u!\tia)\u0003\u0002H\u001d\ta1+\u001a:jC2L'0\u00192mK\"A\u0011j\u0010BK\u0002\u0013\u0005!*A\u0004bI\u0012\u0014Xm]:\u0016\u0003-\u0003\"\u0001T(\u000e\u00035S!A\u0014\u0003\u0002\u000b\u0005\u001cGo\u001c:\n\u0005Ak%aB!eIJ,7o\u001d\u0005\t%~\u0012\t\u0012)A\u0005\u0017\u0006A\u0011\r\u001a3sKN\u001c\b\u0005\u0003\u0005U\u007f\tU\r\u0011\"\u0001V\u0003\u0019\u0019\u0018p\u001d;f[V\ta\u000b\u0005\u0002M/&\u0011\u0001,\u0014\u0002\f\u0003\u000e$xN]*zgR,W\u000e\u0003\u0005[\u007f\tE\t\u0015!\u0003W\u0003\u001d\u0019\u0018p\u001d;f[\u0002BQaE \u0005\u0002q#2!P/_\u0011\u0015I5\f1\u0001L\u0011\u0015!6\f1\u0001W\u0011\u001d\u0001w(!A\u0005\u0002\u0005\fAaY8qsR\u0019QHY2\t\u000f%{\u0006\u0013!a\u0001\u0017\"9Ak\u0018I\u0001\u0002\u00041\u0006bB3@#\u0003%\tAZ\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00132+\u00059'FA&iW\u0005I\u0007C\u00016p\u001b\u0005Y'B\u00017n\u0003%)hn\u00195fG.,GM\u0003\u0002o\u001d\u0005Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\u0005A\\'!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\"9!oPI\u0001\n\u0003\u0019\u0018AD2paf$C-\u001a4bk2$HEM\u000b\u0002i*\u0012a\u000b\u001b\u0005\bm~\n\t\u0011\"\u0011x\u00035\u0001(o\u001c3vGR\u0004&/\u001a4jqV\t\u0001\u0010\u0005\u0002z}6\t!P\u0003\u0002|y\u0006!A.\u00198h\u0015\u0005i\u0018\u0001\u00026bm\u0006L!a >\u0003\rM#(/\u001b8h\u0011%\t\u0019aPA\u0001\n\u0003\t)!\u0001\u0007qe>$Wo\u0019;Be&$\u00180\u0006\u0002\u0002\bA\u0019Q\"!\u0003\n\u0007\u0005-aBA\u0002J]RD\u0011\"a\u0004@\u0003\u0003%\t!!\u0005\u0002\u001dA\u0014x\u000eZ;di\u0016cW-\\3oiR\u0019a&a\u0005\t\u0015\u0005U\u0011QBA\u0001\u0002\u0004\t9!A\u0002yIEB\u0011\"!\u0007@\u0003\u0003%\t%a\u0007\u0002\u001fA\u0014x\u000eZ;di&#XM]1u_J,\"!!\b\u0011\u000b\u0005}\u0011Q\u0005\u0018\u000e\u0005\u0005\u0005\"bAA\u0012\u001d\u0005Q1m\u001c7mK\u000e$\u0018n\u001c8\n\t\u0005\u001d\u0012\u0011\u0005\u0002\t\u0013R,'/\u0019;pe\"I\u00111F \u0002\u0002\u0013\u0005\u0011QF\u0001\tG\u0006tW)];bYR!\u0011qFA\u001b!\ri\u0011\u0011G\u0005\u0004\u0003gq!a\u0002\"p_2,\u0017M\u001c\u0005\n\u0003+\tI#!AA\u00029B\u0011\"!\u000f@\u0003\u0003%\t%a\u000f\u0002\u0011!\f7\u000f[\"pI\u0016$\"!a\u0002\t\u0013\u0005}r(!A\u0005B\u0005\u0005\u0013\u0001\u0003;p'R\u0014\u0018N\\4\u0015\u0003aD\u0011\"!\u0012@\u0003\u0003%\t%a\u0012\u0002\r\u0015\fX/\u00197t)\u0011\ty#!\u0013\t\u0013\u0005U\u00111IA\u0001\u0002\u0004q\u0003bBA'\u0013\u0001\u0006IaN\u0001\u001dGV\u0014(/\u001a8u)J\fgn\u001d9peRLeNZ8s[\u0006$\u0018n\u001c8!Q\u0011\tY%!\u0015\u0011\t\u0005M\u0013qK\u0007\u0003\u0003+R!A\u001c\u0003\n\t\u0005e\u0013Q\u000b\u0002\f\u0013:$XM\u001d8bY\u0006\u0003\u0018N\u0002\u0004\u0002^%\u0001\u0011q\f\u0002\t'\u0016$H/\u001b8hgN\u0019\u00111\f\u0007\t\u0017\u0005\r\u00141\fBC\u0002\u0013\u0005\u0011QM\u0001\u0007G>tg-[4\u0016\u0005\u0005\u001d\u0004\u0003BA5\u0003kj!!a\u001b\u000b\t\u0005\r\u0014Q\u000e\u0006\u0005\u0003_\n\t(\u0001\u0005usB,7/\u00194f\u0015\t\t\u0019(A\u0002d_6LA!a\u001e\u0002l\t11i\u001c8gS\u001eD1\"a\u001f\u0002\\\t\u0005\t\u0015!\u0003\u0002h\u000591m\u001c8gS\u001e\u0004\u0003bB\n\u0002\\\u0011\u0005\u0011q\u0010\u000b\u0005\u0003\u0003\u000b\u0019\tE\u0002?\u00037B\u0001\"a\u0019\u0002~\u0001\u0007\u0011q\r\u0005\u000b\u0003\u000f\u000bYF1A\u0005\u0002\u0005%\u0015aC*fe&\fG.\u001b>feN,\"!a#\u0011\u000fq\ti)!%\u0002\u0012&\u0019\u0011qR\u0013\u0003\u00075\u000b\u0007\u000fE\u0002\u001d\u0003'K!a`\u0013\t\u0013\u0005]\u00151\fQ\u0001\n\u0005-\u0015\u0001D*fe&\fG.\u001b>feN\u0004\u0003BCAN\u00037\u0012\r\u0011\"\u0001\u0002\n\u0006)2+\u001a:jC2L'0\u0019;j_:\u0014\u0015N\u001c3j]\u001e\u001c\b\"CAP\u00037\u0002\u000b\u0011BAF\u0003Y\u0019VM]5bY&T\u0018\r^5p]\nKg\u000eZ5oON\u0004\u0003\u0002CAR\u00037\"i!!*\u0002\u0017\r|gNZ5h)>l\u0015\r\u001d\u000b\u0005\u0003\u0017\u000b9\u000b\u0003\u0005\u0002*\u0006\u0005\u0006\u0019AA4\u0003\r\u0019gm\u001a\u0005\b\u0003[KA\u0011AAX\u0003M\u0019XM]5bY&TX\rZ!di>\u0014\b+\u0019;i)\u0011\t\t*!-\t\u0011\u0005M\u00161\u0016a\u0001\u0003k\u000b\u0001\"Y2u_J\u0014VM\u001a\t\u0004\u0019\u0006]\u0016bAA]\u001b\nA\u0011i\u0019;peJ+gmB\u0005\u0002>&\t\t\u0011#\u0001\u0002@\u0006Y\u0011J\u001c4pe6\fG/[8o!\rq\u0014\u0011\u0019\u0004\t\u0001&\t\t\u0011#\u0001\u0002DN)\u0011\u0011YAc\u000bB9\u0011qYAg\u0017ZkTBAAe\u0015\r\tYMD\u0001\beVtG/[7f\u0013\u0011\ty-!3\u0003#\u0005\u00137\u000f\u001e:bGR4UO\\2uS>t'\u0007C\u0004\u0014\u0003\u0003$\t!a5\u0015\u0005\u0005}\u0006BCA \u0003\u0003\f\t\u0011\"\u0012\u0002B!Q\u0011\u0011\\Aa\u0003\u0003%\t)a7\u0002\u000b\u0005\u0004\b\u000f\\=\u0015\u000bu\ni.a8\t\r%\u000b9\u000e1\u0001L\u0011\u0019!\u0016q\u001ba\u0001-\"Q\u00111]Aa\u0003\u0003%\t)!:\u0002\u000fUt\u0017\r\u001d9msR!\u0011q]Ax!\u0015i\u0011\u0011^Aw\u0013\r\tYO\u0004\u0002\u0007\u001fB$\u0018n\u001c8\u0011\t5A2J\u0016\u0005\n\u0003c\f\t/!AA\u0002u\n1\u0001\u001f\u00131\u0011)\t)0!1\u0002\u0002\u0013%\u0011q_\u0001\fe\u0016\fGMU3t_24X\r\u0006\u0002\u0002zB\u0019\u00110a?\n\u0007\u0005u(P\u0001\u0004PE*,7\r\u001e\u0005\b\u0005\u0003IA\u0011\u0001B\u0002\u0003a9\u0018\u000e\u001e5Ue\u0006t7\u000f]8si&sgm\u001c:nCRLwN\\\u000b\u0005\u0005\u000b\u0011Y\u0001\u0006\u0003\u0003\b\teA\u0003\u0002B\u0005\u0005\u001f\u00012a\nB\u0006\t\u001d\u0011i!a@C\u0002)\u0012\u0011\u0001\u0016\u0005\t\u0005#\ty\u00101\u0001\u0003\u0014\u0005\ta\rE\u0003\u000e\u0005+\u0011I!C\u0002\u0003\u00189\u0011\u0011BR;oGRLwN\u001c\u0019\t\u000fQ\u000by\u00101\u0001\u0003\u001cA\u0019AJ!\b\n\u0007\t}QJA\nFqR,g\u000eZ3e\u0003\u000e$xN]*zgR,W\u000eC\u0004\u0003$%!\tA!\n\u0002=\u001d,GoQ;se\u0016tG\u000f\u0016:b]N\u0004xN\u001d;J]\u001a|'/\\1uS>tG#A\u001f\u0007\u000b)\u0011\u0001A!\u000b\u0014\u000b\t\u001dBBa\u000b\u0011\u00071\u0013i#C\u0002\u000305\u0013\u0011\"\u0012=uK:\u001c\u0018n\u001c8\t\u0015Q\u00139C!b\u0001\n\u0003\u0011\u0019$\u0006\u0002\u0003\u001c!Q!La\n\u0003\u0002\u0003\u0006IAa\u0007\t\u000fM\u00119\u0003\"\u0001\u0003:Q!!1\bB\u001f!\rA!q\u0005\u0005\b)\n]\u0002\u0019\u0001B\u000e\u0011)\u0011\tEa\nC\u0002\u0013\u0005!1I\u0001\tg\u0016$H/\u001b8hgV\u0011!Q\t\t\u0005\u0005\u000f\nYF\u0004\u0002\t\u0001!I!1\nB\u0014A\u0003%!QI\u0001\ng\u0016$H/\u001b8hg\u0002B!Ba\u0014\u0003(\t\u0007I\u0011\u0001B)\u0003Y\tE\u000e\\8x\u0015\u00064\u0018mU3sS\u0006d\u0017N_1uS>tWCAA\u0018\u0011%\u0011)Fa\n!\u0002\u0013\ty#A\fBY2|wOS1wCN+'/[1mSj\fG/[8oA!I!\u0011\fB\u0014A\u0003%!1L\u0001\u0005?2|w\r\u0005\u0003\u0003^\t\rTB\u0001B0\u0015\r\u0011\t\u0007B\u0001\u0006KZ,g\u000e^\u0005\u0005\u0005K\u0012yF\u0001\u000bNCJ\\WM\u001d'pO\u001eLgnZ!eCB$XM\u001d\u0005\u000b\u0005S\u00129C1A\u0005\u0002\t-\u0014a\u00017pOV\u0011!Q\u000e\t\u0005\u0005;\u0012y'\u0003\u0003\u0003r\t}#A\u0004'pO\u001eLgnZ!eCB$XM\u001d\u0005\n\u0005k\u00129\u0003)A\u0005\u0005[\nA\u0001\\8hA!Q!\u0011\u0010B\u0014\u0005\u0004%IAa\u001f\u0002\u001b5\fg.\u001b4fgR\u001c\u0015m\u00195f+\t\u0011i\b\u0005\u0004\u0003\u0000\t-%qR\u0007\u0003\u0005\u0003SAAa!\u0003\u0006\u00061\u0011\r^8nS\u000eTAAa\"\u0003\n\u0006Q1m\u001c8dkJ\u0014XM\u001c;\u000b\u0005ib\u0018\u0002\u0002BG\u0005\u0003\u0013q\"\u0011;p[&\u001c'+\u001a4fe\u0016t7-\u001a\t\t\u0005#\u00139*!%\u0003\u001a6\u0011!1\u0013\u0006\u0005\u0005+\u000b\t#A\u0005j[6,H/\u00192mK&!\u0011q\u0012BJ!\u0015i\u0011\u0011\u001eBNa\u0011\u0011iJa)\u0011\u000be\u0014yJ!)\n\u0005\u0011R\bcA\u0014\u0003$\u0012Y!Q\u0015BT\u0003\u0003\u0005\tQ!\u0001+\u0005\ryFE\r\u0005\n\u0005S\u00139\u0003)A\u0005\u0005{\na\"\\1oS\u001a,7\u000f^\"bG\",\u0007\u0005C\u0005\u0003.\n\u001dB\u0011\u0001\u0003\u00030\u0006A2/\u001a:jC2L'0\u0019;j_:LeNZ8s[\u0006$\u0018n\u001c8\u0016\u0005\tE\u0006c\u0001B$\u007f!\"!1VA)\u0011!\u0011\tAa\n\u0005\n\t]V\u0003\u0002B]\u0005{#BAa/\u0003@B\u0019qE!0\u0005\u000f\t5!Q\u0017b\u0001U!A!\u0011\u0003B[\u0001\u0004\u0011\t\rE\u0003\u000e\u0005+\u0011Y\f\u0003\u0005\u0003F\n\u001dB\u0011\u0001Bd\u0003%\u0019XM]5bY&TX\r\u0006\u0003\u0003J\nm\u0007#\u0002\u001d\u0003L\n=\u0017b\u0001Bgs\t\u0019AK]=\u0011\u000b5\u0011\tN!6\n\u0007\tMgBA\u0003BeJ\f\u0017\u0010E\u0002\u000e\u0005/L1A!7\u000f\u0005\u0011\u0011\u0015\u0010^3\t\u000f\tu'1\u0019a\u0001\u0019\u0005\tq\u000e\u0003\u0005\u0003b\n\u001dB\u0011\u0001Br\u0003-!Wm]3sS\u0006d\u0017N_3\u0016\t\t\u0015(1\u001e\u000b\t\u0005O\u0014iO!=\u0003vB)\u0001Ha3\u0003jB\u0019qEa;\u0005\u000f\t5!q\u001cb\u0001U!A!q\u001eBp\u0001\u0004\u0011y-A\u0003csR,7\u000f\u0003\u0005\u0003t\n}\u0007\u0019AA\u0004\u00031\u0019XM]5bY&TXM]%e\u0011!\u00119Pa8A\u0002\te\u0018!B2mCjT\b#B\u0007\u0002j\nm\b\u0007\u0002B\u007f\u0007\u0003\u0001B\u0001H\u0012\u0003\u0000B\u0019qe!\u0001\u0005\u0019\r\r1QAA\u0001\u0002\u0003\u0015\ta!\u0006\u0003\u0007}#C\u0007\u0003\u0005\u0003x\n}\u0007\u0019AB\u0004!\u0015i\u0011\u0011^B\u0005a\u0011\u0019Yaa\u0004\u0011\tq\u00193Q\u0002\t\u0004O\r=A\u0001DB\u0002\u0007\u000b\t\t\u0011!A\u0003\u0002\rE\u0011cA\u0016\u0004\u0014A\u0019qEa;\u0012\u0007-\u0012I\u000f\u0003\u0005\u0003b\n\u001dB\u0011AB\r)!\u0019Yb!\b\u0004 \r\u0005\u0002\u0003\u0002\u001d\u0003L2A\u0001Ba<\u0004\u0018\u0001\u0007!q\u001a\u0005\t\u0005g\u001c9\u00021\u0001\u0002\b!A11EB\f\u0001\u0004\t\t*\u0001\u0005nC:Lg-Z:u\u0011!\u00199Ca\n\u0005\n\r%\u0012\u0001\u00063fg\u0016\u0014\u0018.\u00197ju\u0016\u0014\u0015\u0010^3BeJ\f\u0017\u0010F\u0004\r\u0007W\u0019ic!\r\t\u0011\t=8Q\u0005a\u0001\u0005\u001fDqaa\f\u0004&\u0001\u0007\u0011'\u0001\u0006tKJL\u0017\r\\5{KJD\u0001ba\t\u0004&\u0001\u0007\u0011\u0011\u0013\u0005\t\u0007k\u00119\u0003\"\u0001\u00048\u0005)B-Z:fe&\fG.\u001b>f\u0005f$XMQ;gM\u0016\u0014Hc\u0002\u0007\u0004:\r%31\n\u0005\t\u0007w\u0019\u0019\u00041\u0001\u0004>\u0005\u0019!-\u001e4\u0011\t\r}2QI\u0007\u0003\u0007\u0003R1aa\u0011}\u0003\rq\u0017n\\\u0005\u0005\u0007\u000f\u001a\tE\u0001\u0006CsR,')\u001e4gKJD\u0001Ba=\u00044\u0001\u0007\u0011q\u0001\u0005\t\u0007G\u0019\u0019\u00041\u0001\u0002\u0012\"211GB(\u0007C\u0002R!DB)\u0007+J1aa\u0015\u000f\u0005\u0019!\bN]8xgB!1qKB/\u001b\t\u0019IFC\u0002\u0004\\q\f!![8\n\t\r}3\u0011\f\u0002\u0019\u001d>$8+\u001a:jC2L'0\u00192mK\u0016C8-\u001a9uS>t7EAB+\u0011!\u0011\tOa\n\u0005\u0002\r\u0015T\u0003BB4\u0007[\"ba!\u001b\u0004p\rE\u0004#\u0002\u001d\u0003L\u000e-\u0004cA\u0014\u0004n\u00119!QBB2\u0005\u0004Q\u0003\u0002\u0003Bx\u0007G\u0002\rAa4\t\u0011\t]81\ra\u0001\u0007g\u0002B\u0001H\u0012\u0004l!A1q\u000fB\u0014\t\u0003\u0019I(A\tgS:$7+\u001a:jC2L'0\u001a:G_J$2!MB>\u0011\u001d\u0011in!\u001eA\u00021A\u0001ba \u0003(\u0011\u00051\u0011Q\u0001\u000eg\u0016\u0014\u0018.\u00197ju\u0016\u0014hi\u001c:\u0015\u0007E\u001a\u0019\t\u0003\u0005\u0003x\u000eu\u0004\u0019ABCa\u0011\u00199ia#\u0011\tq\u00193\u0011\u0012\t\u0004O\r-EaCBG\u0007\u0007\u000b\t\u0011!A\u0003\u0002)\u00121a\u0018\u00139Q\u0019\u0019iha\u0014\u0004b!A11\u0013B\u0014\t\u0003\u0019)*\u0001\u0007tKJL\u0017\r\\5{KJ|e\r\u0006\u0003\u0004\u0018\u000ee\u0005\u0003\u0002\u001d\u0003LFB\u0001ba'\u0004\u0012\u0002\u0007\u0011\u0011S\u0001\u000eg\u0016\u0014\u0018.\u00197ju\u0016\u0014h)\u0015(\t\u0015\r}%q\u0005b\u0001\n\u0013\u0019\t+A\ttKJL\u0017\r\\5{KJ$U\r^1jYN,\"aa)\u0011\r\tE5QUBU\u0013\u0011\u00199Ka%\u0003\u0007M+\u0017\u000fE\u0002\t\u0007WK1a!,\u0003\u0005E\u0019VM]5bY&TXM\u001d#fi\u0006LGn\u001d\u0005\n\u0007c\u00139\u0003)A\u0005\u0007G\u000b!c]3sS\u0006d\u0017N_3s\t\u0016$\u0018-\u001b7tA!Q1Q\u0017B\u0014\u0005\u0004%Iaa.\u0002\u0017M,'/[1mSj,'o]\u000b\u0003\u0007s\u0003b\u0001HAG\u0003#\u000b\u0004\"CB_\u0005O\u0001\u000b\u0011BB]\u00031\u0019XM]5bY&TXM]:!\u0011-\u0019\tMa\nC\u0002\u0013\u0005Aaa1\u0002\u0011\tLg\u000eZ5oON,\"a!2\u0011\r\tE5QUBd!\r\u00119%\u0006\u0005\n\u0007\u0017\u00149\u0003)A\u0005\u0007\u000b\f\u0011BY5oI&twm\u001d\u0011\t\u0011\r='q\u0005C\u0005\u0007#\fA$\u001a8tkJ,wJ\u001c7z\u00032dwn^3e'\u0016\u0014\u0018.\u00197ju\u0016\u00148\u000f\u0006\u0003\u0004T\u000ee\u0007cA\u0007\u0004V&\u00191q\u001b\b\u0003\tUs\u0017\u000e\u001e\u0005\t\u00077\u001ci\r1\u0001\u0004^\u0006!\u0011\u000e^3s!\u0015\u0019yn!;2\u001d\u0011\u0019\to!:\u000f\u0007y\u0019\u0019/C\u0001\u0010\u0013\r\u00199OD\u0001\ba\u0006\u001c7.Y4f\u0013\u0011\t9ca;\u000b\u0007\r\u001dh\u0002\u0003\u0005\u0004p\n\u001dB\u0011BBy\u0003M\u0019\u0007.Z2l\u000f>|w\r\\3Qe>$xNY;g)\u0011\tyca=\t\u0011\rU8Q\u001ea\u0001\u0003#\u000b\u0011b\u00197bgNt\u0015-\\3\t\u0011\re(q\u0005C\u0005\u0007w\fAa]8siR!1QYB\u007f\u0011!\u0019ypa>A\u0002\u0011\u0005\u0011AA5o!\u0019\u0019y\u000eb\u0001\u0004H&!AQABv\u0005!IE/\u001a:bE2,\u0007B\u0003C\u0005\u0005O\u0011\r\u0011\"\u0003\u0005\f\u0005i1/\u001a:jC2L'0\u001a:NCB,\"\u0001\"\u0004\u0011\u000f\u0011=A\u0011\u0003C\u000bc5\u0011!QQ\u0005\u0005\t'\u0011)IA\tD_:\u001cWO\u001d:f]RD\u0015m\u001d5NCB\u0004D\u0001b\u0006\u0005\u001cA!Ad\tC\r!\r9C1\u0004\u0003\f\t;!y\"!A\u0001\u0002\u000b\u0005!F\u0001\u0003`IE\u0002\u0004\"\u0003C\u0011\u0005O\u0001\u000b\u0011\u0002C\u0007\u00039\u0019XM]5bY&TXM]'ba\u0002B!\u0002\"\n\u0003(\t\u0007I\u0011\u0001C\u0014\u0003Q\u0019XM]5bY&TXM\u001d\"z\u0013\u0012,g\u000e^5usV\u0011A\u0011\u0006\t\u00079\u00055\u0015qA\u0019\t\u0013\u00115\"q\u0005Q\u0001\n\u0011%\u0012!F:fe&\fG.\u001b>fe\nK\u0018\nZ3oi&$\u0018\u0010\t\u0005\u000b\tc\u00119C1A\u0005\n\u0011M\u0012!G9vS\u000e\\7+\u001a:jC2L'0\u001a:Cs&#WM\u001c;jif,\"\u0001\"\u000e\u0011\t5\u0011\t.\r\u0005\n\ts\u00119\u0003)A\u0005\tk\t!$];jG.\u001cVM]5bY&TXM\u001d\"z\u0013\u0012,g\u000e^5us\u0002B\u0001\u0002\"\u0010\u0003(\u0011%AqH\u0001\u0012O\u0016$8+\u001a:jC2L'0\u001a:Cs&#GcA\u0019\u0005B!AA1\tC\u001e\u0001\u0004\t9!\u0001\u0002jI\"QAq\tB\u0014\u0005\u0004%IA!\u0015\u0002C%\u001c(*\u0019<b'\u0016\u0014\u0018.\u00197ju\u0006$\u0018n\u001c8XCJt\u0017N\\4F]\u0006\u0014G.\u001a3\t\u0013\u0011-#q\u0005Q\u0001\n\u0005=\u0012AI5t\u0015\u00064\u0018mU3sS\u0006d\u0017N_1uS>tw+\u0019:oS:<WI\\1cY\u0016$\u0007\u0005\u0003\u0006\u0005P\t\u001d\"\u0019!C\u0005\u0005#\n\u0001%[:XCJt\u0017N\\4P]:{g+\u001a:jM&\u001c\u0017\r^5p]\u0016s\u0017M\u00197fI\"IA1\u000bB\u0014A\u0003%\u0011qF\u0001\"SN<\u0016M\u001d8j]\u001e|eNT8WKJLg-[2bi&|g.\u00128bE2,G\r\t\u0005\t\t/\u00129\u0003\"\u0003\u0005Z\u0005Q\u0012n\u001d#jg\u0006dGn\\<fI*\u000bg/Y*fe&\fG.\u001b>feR!\u0011q\u0006C.\u0011\u001d\u0019y\u0003\"\u0016A\u0002EB\u0011\u0002b\u0018\u0003(\u0011\u0005A\u0001\"\u0019\u0002;MDw.\u001e7e/\u0006\u0014h.\u00112pkRT\u0015M^1TKJL\u0017\r\\5{KJ$b!a\f\u0005d\u0011E\u0004\u0002\u0003C3\t;\u0002\r\u0001b\u001a\u0002\u001fM,'/[1mSj,Gm\u00117bgN\u0004D\u0001\"\u001b\u0005nA!Ad\tC6!\r9CQ\u000e\u0003\f\t_\"\u0019'!A\u0001\u0002\u000b\u0005!F\u0001\u0003`IE\u0012\u0004bBB\u0018\t;\u0002\r!\r\u0015\u0005\t;\n\t\u0006")
public class Serialization
implements Extension {
    private final ExtendedActorSystem system;
    private final Settings settings;
    private final boolean AllowJavaSerialization;
    private final MarkerLoggingAdapter _log;
    private final LoggingAdapter log;
    private final AtomicReference<Map<String, Option<Class<?>>>> manifestCache;
    private final scala.collection.immutable.Seq<SerializerDetails> serializerDetails;
    private final Map<String, Serializer> serializers;
    private final scala.collection.immutable.Seq<Tuple2<Class<?>, Serializer>> bindings;
    private final ConcurrentHashMap<Class<?>, Serializer> serializerMap;
    private final Map<Object, Serializer> serializerByIdentity;
    private final Serializer[] quickSerializerByIdentity;
    private final boolean isJavaSerializationWarningEnabled;
    private final boolean isWarningOnNoVerificationEnabled;

    public static Information getCurrentTransportInformation() {
        return Serialization$.MODULE$.getCurrentTransportInformation();
    }

    public static String serializedActorPath(ActorRef actorRef) {
        return Serialization$.MODULE$.serializedActorPath(actorRef);
    }

    public ExtendedActorSystem system() {
        return this.system;
    }

    public Settings settings() {
        return this.settings;
    }

    public boolean AllowJavaSerialization() {
        return this.AllowJavaSerialization;
    }

    public LoggingAdapter log() {
        return this.log;
    }

    private AtomicReference<Map<String, Option<Class<?>>>> manifestCache() {
        return this.manifestCache;
    }

    @InternalApi
    public Information serializationInformation() {
        return this.system().provider().serializationInformation();
    }

    private <T> T withTransportInformation(Function0<T> f) {
        Object object;
        Information oldInfo = (Information)Serialization$.MODULE$.currentTransportInformation().value();
        try {
            if (oldInfo == null) {
                Serialization$.MODULE$.currentTransportInformation().value_$eq((Object)this.serializationInformation());
            }
            object = f.apply();
        }
        finally {
            Serialization$.MODULE$.currentTransportInformation().value_$eq((Object)oldInfo);
        }
        return (T)object;
    }

    public Try<byte[]> serialize(Object o) {
        return (Try)this.withTransportInformation((Function0 & Serializable & scala.Serializable)() -> Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> this.findSerializerFor(o).toBinary(o)));
    }

    public <T> Try<T> deserialize(byte[] bytes, int serializerId, Option<Class<? extends T>> clazz) {
        return Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> {
            Serializer serializer;
            try {
                serializer = this.getSerializerById(serializerId);
            }
            catch (NoSuchElementException noSuchElementException) {
                throw new NotSerializableException(new StringBuilder(155).append("Cannot find serializer with id [").append(serializerId).append("]. The most probable reason is that the configuration entry ").append("akka.actor.serializers is not in synch between the two systems.").toString());
            }
            Serializer serializer2 = serializer;
            return this.withTransportInformation((Function0 & Serializable & scala.Serializable)() -> serializer2.fromBinary(bytes, clazz));
        });
    }

    public Try<Object> deserialize(byte[] bytes, int serializerId, String manifest) {
        return Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> {
            Serializer serializer;
            try {
                serializer = this.getSerializerById(serializerId);
            }
            catch (NoSuchElementException noSuchElementException) {
                throw new NotSerializableException(new StringBuilder(155).append("Cannot find serializer with id [").append(serializerId).append("]. The most probable reason is that the configuration entry ").append("akka.actor.serializers is not in synch between the two systems.").toString());
            }
            Serializer serializer2 = serializer;
            return this.deserializeByteArray(bytes, serializer2, manifest);
        });
    }

    private Object deserializeByteArray(byte[] bytes, Serializer serializer, String manifest) {
        return this.withTransportInformation((Function0 & Serializable & scala.Serializable)() -> {
            Object object;
            Serializer serializer = serializer;
            if (serializer instanceof SerializerWithStringManifest) {
                SerializerWithStringManifest serializerWithStringManifest = (SerializerWithStringManifest)serializer;
                object = serializerWithStringManifest.fromBinary(bytes, manifest);
            } else {
                Object object2;
                String string = manifest;
                String string2 = "";
                if (!(string != null ? !string.equals(string2) : string2 != null)) {
                    object2 = serializer.fromBinary(bytes, (Option<Class<?>>)None$.MODULE$);
                } else {
                    Object object3;
                    Map<String, Option<Class<?>>> cache = this.manifestCache().get();
                    Option option = cache.get((Object)manifest);
                    if (option instanceof Some) {
                        Some some = (Some)option;
                        Option cachedClassManifest = (Option)some.value();
                        object3 = serializer.fromBinary(bytes, cachedClassManifest);
                    } else if (None$.MODULE$.equals(option)) {
                        Try try_ = this.system().dynamicAccess().getClassFor(manifest, ClassTag$.MODULE$.AnyRef());
                        if (!(try_ instanceof Success)) {
                            if (try_ instanceof Failure) {
                                throw new NotSerializableException(new StringBuilder(56).append("Cannot find manifest class [").append(manifest).append("] for serializer with id [").append(serializer.identifier()).append("].").toString());
                            }
                            throw new MatchError(try_);
                        }
                        Success success = (Success)try_;
                        Class classManifest = (Class)success.value();
                        Some classManifestOption = new Some((Object)classManifest);
                        this.updateCache$1(cache, manifest, (Option)classManifestOption);
                        Object object4 = serializer.fromBinary(bytes, (Option<Class<?>>)classManifestOption);
                        object3 = object4;
                    } else {
                        throw new MatchError((Object)option);
                    }
                    object2 = object3;
                }
                object = object2;
            }
            return object;
        });
    }

    public Object deserializeByteBuffer(ByteBuffer buf, int serializerId, String manifest) throws NotSerializableException {
        Object object;
        Serializer serializer;
        try {
            serializer = this.getSerializerById(serializerId);
        }
        catch (NoSuchElementException noSuchElementException) {
            throw new NotSerializableException(new StringBuilder(155).append("Cannot find serializer with id [").append(serializerId).append("]. The most probable reason is that the configuration entry ").append("akka.actor.serializers is not in synch between the two systems.").toString());
        }
        Serializer serializer2 = serializer;
        Information oldInfo = (Information)Serialization$.MODULE$.currentTransportInformation().value();
        try {
            Object object2;
            Serializer serializer3;
            if (oldInfo == null) {
                Serialization$.MODULE$.currentTransportInformation().value_$eq((Object)this.serializationInformation());
            }
            if ((serializer3 = serializer2) instanceof ByteBufferSerializer) {
                Serializer serializer4 = serializer3;
                object2 = ((ByteBufferSerializer)((Object)serializer4)).fromBinary(buf, manifest);
            } else {
                byte[] bytes = new byte[buf.remaining()];
                buf.get(bytes);
                object2 = this.deserializeByteArray(bytes, serializer2, manifest);
            }
            object = object2;
        }
        finally {
            Serialization$.MODULE$.currentTransportInformation().value_$eq((Object)oldInfo);
        }
        return object;
    }

    public <T> Try<T> deserialize(byte[] bytes, Class<T> clazz) {
        return (Try)this.withTransportInformation((Function0 & Serializable & scala.Serializable)() -> Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> this.serializerFor(clazz).fromBinary(bytes, (Option<Class<?>>)new Some((Object)clazz))));
    }

    public Serializer findSerializerFor(Object o) {
        return o == null ? NullSerializer$.MODULE$ : this.serializerFor(o.getClass());
    }

    public Serializer serializerFor(Class<?> clazz) throws NotSerializableException {
        Serializer serializer;
        Serializer serializer2 = this.serializerMap().get(clazz);
        if (serializer2 == null) {
            Serializer serializer3;
            Serializer serializer4;
            Serializer serializer5;
            scala.collection.immutable.Seq seq = (scala.collection.immutable.Seq)this.bindings().filter((Function1 & Serializable & scala.Serializable)x0$2 -> BoxesRunTime.boxToBoolean((boolean)Serialization.$anonfun$serializerFor$3(clazz, x0$2)));
            Some some = Seq$.MODULE$.unapplySeq((Seq)seq);
            if (!some.isEmpty() && some.get() != null && ((SeqLike)some.get()).lengthCompare(0) == 0) {
                throw new NotSerializableException(new StringBuilder(49).append("No configured serialization-bindings for class [").append(clazz.getName()).append("]").toString());
            }
            if (Serialization.unique$1(seq)) {
                serializer5 = (Serializer)((Tuple2)seq.head())._2();
            } else {
                scala.collection.immutable.Seq possibilitiesWithoutJavaSerializer = (scala.collection.immutable.Seq)seq.filter((Function1 & Serializable & scala.Serializable)x0$3 -> BoxesRunTime.boxToBoolean((boolean)Serialization.$anonfun$serializerFor$4(x0$3)));
                if (possibilitiesWithoutJavaSerializer.isEmpty()) {
                    throw new NotSerializableException(new StringBuilder(52).append("More than one JavaSerializer configured for class [").append(clazz.getName()).append("]").toString());
                }
                if (!Serialization.unique$1(possibilitiesWithoutJavaSerializer)) {
                    this._log.warning(LogMarker$.MODULE$.Security(), "Multiple serializers found for [{}], choosing first of: [{}]", (Object)clazz.getName(), (Object)((TraversableOnce)possibilitiesWithoutJavaSerializer.map((Function1 & Serializable & scala.Serializable)x0$4 -> {
                        Tuple2 tuple2 = x0$4;
                        if (tuple2 == null) {
                            throw new MatchError((Object)tuple2);
                        }
                        Serializer s = (Serializer)tuple2._2();
                        String string = s.getClass().getName();
                        return string;
                    }, Seq$.MODULE$.canBuildFrom())).mkString(", "));
                }
                serializer5 = (Serializer)((Tuple2)possibilitiesWithoutJavaSerializer.head())._2();
            }
            Serializer ser = serializer4 = serializer5;
            Serializer serializer6 = this.serializerMap().putIfAbsent(clazz, ser);
            if (serializer6 == null) {
                if (this.shouldWarnAboutJavaSerializer(clazz, ser)) {
                    this._log.warning(LogMarker$.MODULE$.Security(), "Using the default Java serializer for class [{}] which is not recommended because of performance implications. Use another serializer or disable this warning using the setting 'akka.actor.warn-about-java-serializer-usage'", (Object)clazz.getName());
                }
                this.log().debug("Using serializer [{}] for message [{}]", ser.getClass().getName(), clazz.getName());
                serializer3 = ser;
            } else {
                serializer3 = serializer6;
            }
            serializer = serializer3;
        } else {
            serializer = serializer2;
        }
        return serializer;
    }

    /*
     * Unable to fully structure code
     */
    public Try<Serializer> serializerOf(String serializerFQN) {
        if (this.system().settings().AllowJavaSerialization()) ** GOTO lbl-1000
        v0 = serializerFQN;
        var3_2 = JavaSerializer.class.getName();
        if (!(v0 != null ? v0.equals(var3_2) == false : var3_2 != null)) {
            this.log().debug("Replacing JavaSerializer with DisabledJavaSerializer, due to `akka.actor.allow-java-serialization = off`.");
            v1 = DisabledJavaSerializer.class.getName();
        } else lbl-1000:
        // 2 sources

        {
            v1 = serializerFQN;
        }
        fqn = v1;
        return this.system().dynamicAccess().createInstanceFor(fqn, (scala.collection.immutable.Seq<Tuple2<Class<?>, Object>>)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$u2192$extension(Predef$.MODULE$.ArrowAssoc(ExtendedActorSystem.class), (Object)this.system())})), ClassTag$.MODULE$.apply(Serializer.class)).recoverWith((PartialFunction)new scala.Serializable(this, fqn){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ Serialization $outer;
            private final String fqn$1;

            public final <A1 extends Throwable, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                A1 A1 = x1;
                Try<T> try_ = A1 instanceof NoSuchMethodException ? this.$outer.system().dynamicAccess().createInstanceFor(this.fqn$1, (scala.collection.immutable.Seq<Tuple2<Class<?>, Object>>)Nil$.MODULE$, ClassTag$.MODULE$.apply(Serializer.class)) : function1.apply(x1);
                return (B1)try_;
            }

            public final boolean isDefinedAt(Throwable x1) {
                Throwable throwable = x1;
                boolean bl = throwable instanceof NoSuchMethodException;
                return bl;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.fqn$1 = fqn$1;
            }
        });
    }

    private scala.collection.immutable.Seq<SerializerDetails> serializerDetails() {
        return this.serializerDetails;
    }

    private Map<String, Serializer> serializers() {
        return this.serializers;
    }

    public scala.collection.immutable.Seq<Tuple2<Class<?>, Serializer>> bindings() {
        return this.bindings;
    }

    private void ensureOnlyAllowedSerializers(Iterator<Serializer> iter) {
        block0: {
            if (this.system().settings().AllowJavaSerialization()) break block0;
            Predef$.MODULE$.require(iter.forall((Function1 & Serializable & scala.Serializable)x$6 -> BoxesRunTime.boxToBoolean((boolean)Serialization.$anonfun$ensureOnlyAllowedSerializers$2(this, x$6))), (Function0 & Serializable & scala.Serializable)() -> "Disallowed JavaSerializer binding.");
        }
    }

    private boolean checkGoogleProtobuf(String className) {
        return !className.startsWith("com.google.protobuf") || this.system().dynamicAccess().getClassFor(className, ClassTag$.MODULE$.Any()).isSuccess();
    }

    private scala.collection.immutable.Seq<Tuple2<Class<?>, Serializer>> sort(Iterable<Tuple2<Class<?>, Serializer>> in) {
        ArrayBuffer arrayBuffer = new ArrayBuffer(in.size());
        return (scala.collection.immutable.Seq)((TraversableLike)in.$div$colon((Object)arrayBuffer, (Function2 & Serializable & scala.Serializable)(buf, ca) -> {
            int n = buf.indexWhere((Function1 & Serializable & scala.Serializable)x$8 -> BoxesRunTime.boxToBoolean((boolean)Serialization.$anonfun$sort$2(ca, x$8)));
            switch (n) {
                case -1: {
                    buf.append((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{ca}));
                    break;
                }
                default: {
                    buf.insert(n, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{ca}));
                    break;
                }
            }
            return buf;
        })).to(Predef$.MODULE$.fallbackStringCanBuildFrom());
    }

    private ConcurrentHashMap<Class<?>, Serializer> serializerMap() {
        return this.serializerMap;
    }

    public Map<Object, Serializer> serializerByIdentity() {
        return this.serializerByIdentity;
    }

    private Serializer[] quickSerializerByIdentity() {
        return this.quickSerializerByIdentity;
    }

    private Serializer getSerializerById(int id) {
        Serializer serializer;
        if (0 <= id && id < this.quickSerializerByIdentity().length) {
            Serializer serializer2;
            Serializer serializer3 = this.quickSerializerByIdentity()[id];
            if (serializer3 == null) {
                throw new NoSuchElementException(new StringBuilder(15).append("key not found: ").append(id).toString());
            }
            serializer = serializer2 = serializer3;
        } else {
            serializer = (Serializer)this.serializerByIdentity().apply((Object)BoxesRunTime.boxToInteger((int)id));
        }
        return serializer;
    }

    private boolean isJavaSerializationWarningEnabled() {
        return this.isJavaSerializationWarningEnabled;
    }

    private boolean isWarningOnNoVerificationEnabled() {
        return this.isWarningOnNoVerificationEnabled;
    }

    public boolean akka$serialization$Serialization$$isDisallowedJavaSerializer(Serializer serializer) {
        return serializer instanceof JavaSerializer && !this.system().settings().AllowJavaSerialization();
    }

    @InternalApi
    public boolean shouldWarnAboutJavaSerializer(Class<?> serializedClass, Serializer serializer) {
        return this.isJavaSerializationWarningEnabled() && (serializer instanceof JavaSerializer || serializer instanceof DisabledJavaSerializer) && !serializedClass.getName().startsWith("akka.") && !serializedClass.getName().startsWith("java.lang.") && !this.suppressWarningOnNonSerializationVerification$1(serializedClass);
    }

    private final boolean updateCache$1(Map cache, String key, Option value) {
        while (!this.manifestCache().compareAndSet(cache, cache.updated((Object)key, (Object)value))) {
            cache = this.manifestCache().get();
        }
        return true;
    }

    public static final /* synthetic */ boolean $anonfun$serializerFor$1(scala.collection.immutable.Seq possibilities$1, Tuple2 x$1) {
        return ((Class)x$1._1()).isAssignableFrom((Class)((Tuple2)possibilities$1.apply(0))._1());
    }

    public static final /* synthetic */ boolean $anonfun$serializerFor$2(scala.collection.immutable.Seq possibilities$1, Tuple2 x$2) {
        return BoxesRunTime.equals((Object)x$2._2(), (Object)((Tuple2)possibilities$1.apply(0))._2());
    }

    private static final boolean unique$1(scala.collection.immutable.Seq possibilities) {
        return possibilities.size() == 1 || possibilities.forall((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)Serialization.$anonfun$serializerFor$1(possibilities, x$1))) || possibilities.forall((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)Serialization.$anonfun$serializerFor$2(possibilities, x$2)));
    }

    public static final /* synthetic */ boolean $anonfun$serializerFor$3(Class clazz$3, Tuple2 x0$2) {
        Tuple2 tuple2 = x0$2;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        Class c = (Class)tuple2._1();
        boolean bl = c.isAssignableFrom(clazz$3);
        return bl;
    }

    public static final /* synthetic */ boolean $anonfun$serializerFor$4(Tuple2 x0$3) {
        Tuple2 tuple2 = x0$3;
        boolean bl = tuple2 != null && tuple2._2() instanceof JavaSerializer ? false : tuple2 == null || !(tuple2._2() instanceof DisabledJavaSerializer);
        return bl;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final /* synthetic */ boolean $anonfun$serializers$1(Tuple2 check$ifrefutable$1) {
        Tuple2 tuple2 = check$ifrefutable$1;
        if (tuple2 == null) return false;
        String k = (String)tuple2._1();
        String v = (String)tuple2._2();
        if (k == null) return false;
        if (v == null) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final /* synthetic */ boolean $anonfun$bindings$1(Tuple2 check$ifrefutable$2) {
        Tuple2 tuple2 = check$ifrefutable$2;
        if (tuple2 == null) return false;
        String className = (String)tuple2._1();
        String alias = (String)tuple2._2();
        if (className == null) return false;
        if (alias == null) return false;
        return true;
    }

    public static final /* synthetic */ boolean $anonfun$bindings$2(Serialization $this, Tuple2 x$4) {
        String string;
        String string2;
        String alias;
        block3: {
            Tuple2 tuple2;
            block2: {
                tuple2 = x$4;
                if (tuple2 == null) break block2;
                String className = (String)tuple2._1();
                alias = (String)tuple2._2();
                if (className == null) break block2;
                string2 = className;
                if (alias != null) break block3;
            }
            throw new MatchError((Object)tuple2);
        }
        String string3 = string = alias;
        String string4 = "none";
        boolean bl = (string3 == null ? string4 != null : !string3.equals(string4)) && $this.checkGoogleProtobuf(string2);
        return bl;
    }

    public static final /* synthetic */ boolean $anonfun$ensureOnlyAllowedSerializers$2(Serialization $this, Serializer x$6) {
        return !$this.akka$serialization$Serialization$$isDisallowedJavaSerializer(x$6);
    }

    public static final /* synthetic */ boolean $anonfun$sort$2(Tuple2 ca$1, Tuple2 x$8) {
        return ((Class)x$8._1()).isAssignableFrom((Class)ca$1._1());
    }

    public static final /* synthetic */ void $anonfun$quickSerializerByIdentity$1(int size$1, Serializer[] table$1, Tuple2 x0$9) {
        BoxedUnit boxedUnit;
        Tuple2 tuple2 = x0$9;
        if (tuple2 != null) {
            int id = tuple2._1$mcI$sp();
            Serializer ser = (Serializer)tuple2._2();
            if (0 <= id && id < size$1) {
                table$1[id] = ser;
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
        } else {
            throw new MatchError((Object)tuple2);
        }
        BoxedUnit boxedUnit2 = boxedUnit;
    }

    private final boolean suppressWarningOnNonSerializationVerification$1(Class serializedClass) {
        return !this.isWarningOnNoVerificationEnabled() && NoSerializationVerificationNeeded.class.isAssignableFrom(serializedClass);
    }

    public Serialization(ExtendedActorSystem system) {
        Vector vector;
        this.system = system;
        this.settings = new Settings(system.settings().config());
        this.AllowJavaSerialization = system.settings().AllowJavaSerialization();
        this._log = Logging$.MODULE$.withMarker(system, this.getClass().getName(), LogSource$.MODULE$.fromString());
        this.log = this._log;
        this.manifestCache = new AtomicReference<Map>(Predef$.MODULE$.Map().empty());
        Option option = system.settings().setup().get(ClassTag$.MODULE$.apply(SerializationSetup.class));
        if (None$.MODULE$.equals(option)) {
            vector = package$.MODULE$.Vector().empty();
        } else if (option instanceof Some) {
            Some some = (Some)option;
            SerializationSetup setting = (SerializationSetup)some.value();
            vector = (scala.collection.immutable.Seq)setting.createSerializers().apply((Object)system);
        } else {
            throw new MatchError(option);
        }
        this.serializerDetails = (scala.collection.immutable.Seq)vector.collect((PartialFunction)new scala.Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ Serialization $outer;

            public final <A1 extends SerializerDetails, B1> B1 applyOrElse(A1 x2, Function1<A1, B1> function1) {
                Object object;
                A1 A1;
                A1 A12 = x2;
                if (A12 != null && this.$outer.akka$serialization$Serialization$$isDisallowedJavaSerializer((A1 = A12).serializer())) {
                    this.$outer.log().debug("Replacing JavaSerializer with DisabledJavaSerializer, due to `akka.actor.allow-java-serialization = off`.");
                    object = SerializerDetails$.MODULE$.apply(A1.alias(), new DisabledJavaSerializer(this.$outer.system()), A1.useFor());
                } else {
                    object = A12;
                }
                return (B1)object;
            }

            public final boolean isDefinedAt(SerializerDetails x2) {
                SerializerDetails serializerDetails;
                SerializerDetails serializerDetails2 = x2;
                boolean bl = serializerDetails2 != null && this.$outer.akka$serialization$Serialization$$isDisallowedJavaSerializer((serializerDetails = serializerDetails2).serializer()) ? true : true;
                return bl;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, Seq$.MODULE$.canBuildFrom());
        Map fromConfig = (Map)this.settings().Serializers().withFilter((Function1 & Serializable & scala.Serializable)check$ifrefutable$1 -> BoxesRunTime.boxToBoolean((boolean)Serialization.$anonfun$serializers$1(check$ifrefutable$1))).map((Function1 & Serializable & scala.Serializable)x$3 -> {
            String string;
            String v;
            block3: {
                Tuple2 tuple2;
                block2: {
                    tuple2 = x$3;
                    if (tuple2 == null) break block2;
                    String k = (String)tuple2._1();
                    v = (String)tuple2._2();
                    if (k == null) break block2;
                    string = k;
                    if (v != null) break block3;
                }
                throw new MatchError((Object)tuple2);
            }
            String string2 = v;
            Tuple2 tuple2 = Predef.ArrowAssoc$.MODULE$.$u2192$extension(Predef$.MODULE$.ArrowAssoc((Object)string), this.serializerOf(string2).get());
            return tuple2;
        }, Map$.MODULE$.canBuildFrom());
        Map result = fromConfig.$plus$plus((GenTraversableOnce)this.serializerDetails().map((Function1 & Serializable & scala.Serializable)d -> Predef.ArrowAssoc$.MODULE$.$u2192$extension(Predef$.MODULE$.ArrowAssoc((Object)d.alias()), (Object)d.serializer()), Seq$.MODULE$.canBuildFrom()));
        this.ensureOnlyAllowedSerializers((Iterator<Serializer>)((Iterator)result.map((Function1 & Serializable & scala.Serializable)x0$5 -> {
            Serializer ser;
            Tuple2 tuple2 = x0$5;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            Serializer serializer = ser = (Serializer)tuple2._2();
            return serializer;
        }, scala.collection.package$.MODULE$.breakOut((CanBuildFrom)Iterator$.MODULE$.IteratorCanBuildFrom()))));
        this.serializers = result;
        scala.collection.immutable.Iterable fromConfig2 = (scala.collection.immutable.Iterable)this.settings().SerializationBindings().withFilter((Function1 & Serializable & scala.Serializable)check$ifrefutable$2 -> BoxesRunTime.boxToBoolean((boolean)Serialization.$anonfun$bindings$1(check$ifrefutable$2))).withFilter((Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)Serialization.$anonfun$bindings$2(this, x$4))).map((Function1 & Serializable & scala.Serializable)x$5 -> {
            String string;
            String alias;
            block3: {
                Tuple2 tuple2;
                block2: {
                    tuple2 = x$5;
                    if (tuple2 == null) break block2;
                    String className = (String)tuple2._1();
                    alias = (String)tuple2._2();
                    if (className == null) break block2;
                    string = className;
                    if (alias != null) break block3;
                }
                throw new MatchError((Object)tuple2);
            }
            String string2 = alias;
            Tuple2 tuple2 = new Tuple2(this.system().dynamicAccess().getClassFor(string, ClassTag$.MODULE$.Any()).get(), this.serializers().apply((Object)string2));
            return tuple2;
        }, Iterable$.MODULE$.canBuildFrom());
        scala.collection.immutable.Seq fromSettings = (scala.collection.immutable.Seq)this.serializerDetails().flatMap((Function1 & Serializable & scala.Serializable)detail -> (scala.collection.immutable.Seq)detail.useFor().map((Function1 & Serializable & scala.Serializable)clazz -> Predef.ArrowAssoc$.MODULE$.$u2192$extension(Predef$.MODULE$.ArrowAssoc(clazz), (Object)detail.serializer()), Seq$.MODULE$.canBuildFrom()), Seq$.MODULE$.canBuildFrom());
        scala.collection.immutable.Seq<Tuple2<Class<?>, Serializer>> result2 = this.sort((Iterable)fromConfig2.$plus$plus((GenTraversableOnce)fromSettings, Iterable$.MODULE$.canBuildFrom()));
        this.ensureOnlyAllowedSerializers((Iterator<Serializer>)((Iterator)result2.map((Function1 & Serializable & scala.Serializable)x0$6 -> {
            Serializer ser;
            Tuple2 tuple2 = x0$6;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            Serializer serializer = ser = (Serializer)tuple2._2();
            return serializer;
        }, scala.collection.package$.MODULE$.breakOut((CanBuildFrom)Iterator$.MODULE$.IteratorCanBuildFrom()))));
        this.bindings = result2;
        ConcurrentHashMap concurrentHashMap = new ConcurrentHashMap();
        this.serializerMap = (ConcurrentHashMap)this.bindings().$div$colon(concurrentHashMap, (Function2 & Serializable & scala.Serializable)(x0$7, x1$1) -> {
            Tuple2 tuple2;
            ConcurrentHashMap map;
            block3: {
                Tuple2 tuple22;
                block2: {
                    tuple22 = new Tuple2(x0$7, x1$1);
                    if (tuple22 == null) break block2;
                    map = (ConcurrentHashMap)tuple22._1();
                    tuple2 = (Tuple2)tuple22._2();
                    if (tuple2 != null) break block3;
                }
                throw new MatchError((Object)tuple22);
            }
            Class c = (Class)tuple2._1();
            Serializer s = (Serializer)tuple2._2();
            map.put(c, s);
            ConcurrentHashMap concurrentHashMap = map;
            return concurrentHashMap;
        });
        this.serializerByIdentity = ((MapLike)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$u2192$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)NullSerializer$.MODULE$.identifier())), (Object)NullSerializer$.MODULE$)}))).$plus$plus((GenTraversableOnce)this.serializers().map((Function1 & Serializable & scala.Serializable)x0$8 -> {
            Tuple2 tuple2 = x0$8;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            Serializer v = (Serializer)tuple2._2();
            Tuple2 tuple22 = new Tuple2((Object)BoxesRunTime.boxToInteger((int)v.identifier()), (Object)v);
            return tuple22;
        }, Map$.MODULE$.canBuildFrom()));
        int size = 1024;
        Serializer[] table = new Serializer[size];
        this.serializerByIdentity().foreach((Function1 & Serializable & scala.Serializable)x0$9 -> {
            Serialization.$anonfun$quickSerializerByIdentity$1(size, table, x0$9);
            return BoxedUnit.UNIT;
        });
        this.quickSerializerByIdentity = table;
        this.isJavaSerializationWarningEnabled = this.settings().config().getBoolean("akka.actor.warn-about-java-serializer-usage");
        this.isWarningOnNoVerificationEnabled = this.settings().config().getBoolean("akka.actor.warn-on-no-serialization-verification");
    }

    public static final class Information
    implements Product,
    scala.Serializable {
        private final Address address;
        private final ActorSystem system;

        public Address address() {
            return this.address;
        }

        public ActorSystem system() {
            return this.system;
        }

        public Information copy(Address address, ActorSystem system) {
            return new Information(address, system);
        }

        public Address copy$default$1() {
            return this.address();
        }

        public ActorSystem copy$default$2() {
            return this.system();
        }

        public String productPrefix() {
            return "Information";
        }

        public int productArity() {
            return 2;
        }

        public Object productElement(int x$1) {
            Object object;
            int n = x$1;
            switch (n) {
                case 0: {
                    object = this.address();
                    break;
                }
                case 1: {
                    object = this.system();
                    break;
                }
                default: {
                    throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
                }
            }
            return object;
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof Information;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            Object object = x$1;
            if (!(object instanceof Information)) return false;
            boolean bl = true;
            if (!bl) return false;
            Information information = (Information)x$1;
            Address address = this.address();
            Address address2 = information.address();
            if (address == null) {
                if (address2 != null) {
                    return false;
                }
            } else if (!((Object)address).equals(address2)) return false;
            ActorSystem actorSystem = this.system();
            ActorSystem actorSystem2 = information.system();
            if (actorSystem == null) {
                if (actorSystem2 == null) return true;
                return false;
            } else {
                if (!actorSystem.equals(actorSystem2)) return false;
                return true;
            }
        }

        public Information(Address address, ActorSystem system) {
            this.address = address;
            this.system = system;
            Product.$init$((Product)this);
        }
    }

    public static class Settings {
        private final Config config;
        private final Map<String, String> Serializers;
        private final Map<String, String> SerializationBindings;

        public Config config() {
            return this.config;
        }

        public Map<String, String> Serializers() {
            return this.Serializers;
        }

        public Map<String, String> SerializationBindings() {
            return this.SerializationBindings;
        }

        private final Map<String, String> configToMap(Config cfg) {
            return (Map)((TraversableOnce)JavaConverters$.MODULE$.mapAsScalaMapConverter(cfg.root().unwrapped()).asScala()).toMap(Predef$.MODULE$.$conforms()).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
                Tuple2 tuple2 = x0$1;
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                String k = (String)tuple2._1();
                Object v = tuple2._2();
                Tuple2 tuple22 = Predef.ArrowAssoc$.MODULE$.$u2192$extension(Predef$.MODULE$.ArrowAssoc((Object)k), (Object)v.toString());
                return tuple22;
            }, Map$.MODULE$.canBuildFrom());
        }

        public Settings(Config config) {
            Config config2;
            this.config = config;
            this.Serializers = this.configToMap(config.getConfig("akka.actor.serializers"));
            Config defaultBindings = config.getConfig("akka.actor.serialization-bindings");
            if (config.getBoolean("akka.actor.enable-additional-serialization-bindings") || !config.getBoolean("akka.actor.allow-java-serialization") || config.hasPath("akka.remote.artery.enabled") && config.getBoolean("akka.remote.artery.enabled")) {
                Config bs = defaultBindings.withFallback((ConfigMergeable)config.getConfig("akka.actor.additional-serialization-bindings"));
                String additionalWhenJavaOffKey = "akka.actor.java-serialization-disabled-additional-serialization-bindings";
                config2 = !config.getBoolean("akka.actor.allow-java-serialization") ? bs.withFallback((ConfigMergeable)config.getConfig(additionalWhenJavaOffKey)) : bs;
            } else {
                config2 = defaultBindings;
            }
            Config bindings = config2;
            this.SerializationBindings = this.configToMap(bindings);
        }
    }
}

