/*
 * Decompiled with CFR 0.152.
 */
package io.aeron.driver.media;

import io.aeron.driver.DataPacketDispatcher;
import io.aeron.driver.MediaDriver;
import io.aeron.driver.media.UdpChannel;
import io.aeron.driver.media.UdpChannelTransport;
import io.aeron.driver.status.SystemCounterDescriptor;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import org.agrona.LangUtil;
import org.agrona.collections.Long2ObjectHashMap;
import org.agrona.concurrent.status.AtomicCounter;

public class ReceiveDestinationUdpTransport
extends UdpChannelTransport {
    private final Long2ObjectHashMap<InetSocketAddress> controlAddressMap = new Long2ObjectHashMap();

    public ReceiveDestinationUdpTransport(UdpChannel udpChannel, DataPacketDispatcher dispatcher, AtomicCounter statusIndicator, MediaDriver.Context context) {
        super(udpChannel, udpChannel.remoteData(), udpChannel.remoteData(), null, context.errorLog(), context.systemCounters().get(SystemCounterDescriptor.INVALID_PACKETS));
    }

    public void addControlAddress(long imageCorrelationId, InetSocketAddress controlAddress) {
        this.controlAddressMap.put(imageCorrelationId, (Object)controlAddress);
    }

    public void removeControlAddress(long imageCorrelationId) {
        this.controlAddressMap.remove(imageCorrelationId);
    }

    public int sendTo(ByteBuffer buffer, long imageCorrelationId) {
        InetSocketAddress controlAddress = (InetSocketAddress)this.controlAddressMap.get(imageCorrelationId);
        int bytesSent = 0;
        try {
            if (null != this.sendDatagramChannel && null != controlAddress) {
                bytesSent = this.sendDatagramChannel.send(buffer, controlAddress);
            }
        }
        catch (IOException ex) {
            LangUtil.rethrowUnchecked((Throwable)ex);
        }
        return bytesSent;
    }
}

