/*
 * Decompiled with CFR 0.152.
 */
package io.aeron.driver;

import io.aeron.ChannelUri;
import io.aeron.driver.Configuration;
import io.aeron.driver.MediaDriver;
import io.aeron.driver.buffer.RawLog;
import io.aeron.logbuffer.FrameDescriptor;
import io.aeron.logbuffer.LogBufferDescriptor;
import org.agrona.SystemUtil;
import org.agrona.concurrent.UnsafeBuffer;

class PublicationParams {
    long lingerTimeoutNs = 0L;
    int termLength = 0;
    int mtuLength = 0;
    int initialTermId = 0;
    int termId = 0;
    int termOffset = 0;
    int sessionId = 0;
    boolean isReplay = false;
    boolean hasSessionId = false;

    PublicationParams() {
    }

    static int getTermBufferLength(ChannelUri channelUri, int defaultTermLength) {
        String termLengthParam = channelUri.get("term-length");
        int termLength = defaultTermLength;
        if (null != termLengthParam) {
            termLength = (int)SystemUtil.parseSize((String)"term-offset", (String)termLengthParam);
            LogBufferDescriptor.checkTermLength((int)termLength);
        }
        return termLength;
    }

    static int getMtuLength(ChannelUri channelUri, int defaultMtuLength) {
        int mtuLength = defaultMtuLength;
        String mtuParam = channelUri.get("mtu");
        if (null != mtuParam) {
            mtuLength = (int)SystemUtil.parseSize((String)"mtu", (String)mtuParam);
            Configuration.validateMtuLength(mtuLength);
        }
        return mtuLength;
    }

    static long getLingerTimeoutNs(ChannelUri channelUri, long driverLingerTImeoutNs) {
        long lingerTimeoutNs = driverLingerTImeoutNs;
        String lingerParam = channelUri.get("linger");
        if (null != lingerParam) {
            lingerTimeoutNs = SystemUtil.parseDuration((String)"linger", (String)lingerParam);
            Configuration.validatePublicationLingerTimeoutNs(lingerTimeoutNs, driverLingerTImeoutNs);
        }
        return lingerTimeoutNs;
    }

    static void validateMtuForMaxMessage(PublicationParams params, boolean isExclusive) {
        int maxMessageLength;
        int termLength = params.termLength;
        int n = maxMessageLength = isExclusive ? FrameDescriptor.computeExclusiveMaxMessageLength((int)termLength) : FrameDescriptor.computeMaxMessageLength((int)termLength);
        if (params.mtuLength > maxMessageLength) {
            throw new IllegalStateException("MTU greater than max message length for term length: mtu=" + params.mtuLength + " maxMessageLength=" + maxMessageLength + " termLength=" + termLength);
        }
    }

    static void confirmMatch(ChannelUri uri, PublicationParams params, RawLog rawLog, int existingSessionId) {
        int mtuLength = LogBufferDescriptor.mtuLength((UnsafeBuffer)rawLog.metaData());
        if (uri.containsKey("mtu") && mtuLength != params.mtuLength) {
            throw new IllegalStateException("Existing publication has different MTU length: existing=" + mtuLength + " requested=" + params.mtuLength);
        }
        if (uri.containsKey("term-length") && rawLog.termLength() != params.termLength) {
            throw new IllegalStateException("Existing publication has different term length: existing=" + rawLog.termLength() + " requested=" + params.termLength);
        }
        if (uri.containsKey("session-id") && params.sessionId != existingSessionId) {
            throw new IllegalStateException("Existing publication has different session id: existing=" + existingSessionId + " requested=" + params.sessionId);
        }
    }

    static PublicationParams getPublicationParams(MediaDriver.Context context, ChannelUri channelUri, boolean isExclusive, boolean isIpc) {
        PublicationParams params = new PublicationParams();
        params.termLength = PublicationParams.getTermBufferLength(channelUri, isIpc ? context.ipcTermBufferLength() : context.publicationTermBufferLength());
        params.mtuLength = PublicationParams.getMtuLength(channelUri, isIpc ? context.ipcMtuLength() : context.mtuLength());
        params.lingerTimeoutNs = PublicationParams.getLingerTimeoutNs(channelUri, context.publicationLingerTimeoutNs());
        String sessionIdStr = channelUri.get("session-id");
        if (null != sessionIdStr) {
            params.sessionId = Integer.parseInt(sessionIdStr);
            params.hasSessionId = true;
        }
        if (isExclusive) {
            int count = 0;
            String initialTermIdStr = channelUri.get("init-term-id");
            count = initialTermIdStr != null ? count + 1 : count;
            String termIdStr = channelUri.get("term-id");
            count = termIdStr != null ? count + 1 : count;
            String termOffsetStr = channelUri.get("term-offset");
            int n = count = termOffsetStr != null ? count + 1 : count;
            if (count > 0) {
                if (count < 3) {
                    throw new IllegalArgumentException("Params must be used as a complete set: init-term-id term-id term-offset");
                }
                params.initialTermId = Integer.parseInt(initialTermIdStr);
                params.termId = Integer.parseInt(termIdStr);
                params.termOffset = Integer.parseInt(termOffsetStr);
                if (params.termOffset > params.termLength) {
                    throw new IllegalArgumentException("term-offset=" + params.termOffset + " > " + "term-length" + "=" + params.termLength);
                }
                if (params.termOffset < 0) {
                    throw new IllegalArgumentException("term-offset=" + params.termOffset + " must be greater than zero");
                }
                if ((params.termOffset & 0x1F) != 0) {
                    throw new IllegalArgumentException("term-offset=" + params.termOffset + " must be a multiple of FRAME_ALIGNMENT");
                }
                params.isReplay = true;
            }
        }
        return params;
    }
}

