/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.rest.mappers;

import com.thoughtworks.xstream.XStream;
import com.xebialabs.deployit.ClosingExceptionMapper;
import com.xebialabs.deployit.Exceptions;
import com.xebialabs.deployit.ServerConfiguration;
import com.xebialabs.deployit.core.rest.resteasy.PathInterceptor;
import com.xebialabs.deployit.engine.spi.exception.DeployitException;
import com.xebialabs.deployit.engine.spi.exception.HttpResponseCodeResult;
import com.xebialabs.deployit.engine.spi.exception.SuppressStackTrace;
import com.xebialabs.deployit.service.validation.Validator;
import com.xebialabs.xltype.serialization.xstream.XStreamReaderWriter;
import java.util.Collection;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.ExceptionMapper;
import javax.ws.rs.ext.Provider;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Provider
@Component
public class DeployitExceptionMapper
extends ClosingExceptionMapper<DeployitException>
implements ExceptionMapper<DeployitException> {
    @Context
    private HttpServletRequest request;
    private XStream xStream;
    private static ThreadLocal<Boolean> doCDataWrapping = new ThreadLocal();
    private static String logMsg = "Intercepting DeployitException";

    public static void doCDataWrapping(boolean wrap) {
        doCDataWrapping.set(wrap);
    }

    @Autowired
    public DeployitExceptionMapper(ServerConfiguration config) {
        this(XStreamReaderWriter.getConfiguredXStream(), config);
    }

    public DeployitExceptionMapper(XStream xStream, ServerConfiguration config) {
        super(config.isHideInternals());
        this.xStream = xStream;
    }

    @Override
    public Response handleException(DeployitException exception) {
        String content;
        this.handleLogging(exception);
        int status = this.getResponseStatus(exception);
        if (exception.hasEntity()) {
            content = this.xStream.toXML(exception.getEntity());
        } else {
            content = Exceptions.getAllMessages((Exception)exception);
            Boolean wrap = doCDataWrapping.get();
            if (wrap != null && wrap.booleanValue()) {
                content = "<![CDATA[" + content.replace("]]>", "___") + "]]>";
            }
        }
        Response resp = this.checkWhetherWeHideInternals(status, (RuntimeException)exception, content);
        if (resp != null) {
            return resp;
        }
        Response.ResponseBuilder response = Response.status((int)status);
        response.header("X-Deployit-Exception", (Object)"true");
        response.header("X-Exception-Type", (Object)exception.getClass().getName());
        response.header("X-Path", PathInterceptor.PATH.get());
        if (exception.hasEntity()) {
            if ("application/json".equals(this.request.getHeader("Accept-Type"))) {
                response.entity(this.getJsonEntity(exception));
            } else {
                response.entity((Object)content);
                response.type("application/xml");
            }
            response.header("X-Entity", (Object)"true");
        } else {
            response.entity((Object)content);
            response.type("text/plain");
        }
        return response.build();
    }

    private Object getJsonEntity(DeployitException exception) {
        if (exception instanceof Validator.ValidationsFailedException && exception.getEntity() instanceof Collection) {
            List cis = (List)exception.getEntity();
            return new Validator.ValidatedCis(cis);
        }
        return exception.getEntity();
    }

    private void handleLogging(DeployitException exception) {
        SuppressStackTrace annotation = exception.getClass().getAnnotation(SuppressStackTrace.class);
        this.logger.info(exception.getMessage());
        if (annotation.suppressStackTrace()) {
            this.logger.trace(logMsg, (Throwable)exception);
        } else {
            this.logger.info(logMsg, (Throwable)exception);
        }
    }

    private int getResponseStatus(DeployitException exception) {
        HttpResponseCodeResult annotation = exception.getClass().getAnnotation(HttpResponseCodeResult.class);
        int status = 500;
        if (annotation != null) {
            status = annotation.statusCode();
        }
        return status;
    }
}

