/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.uuid;

import java.security.SecureRandom;
import java.util.Random;
import org.apache.jackrabbit.uuid.Constants;
import org.apache.jackrabbit.uuid.UUID;

public final class VersionFourGenerator
implements Constants {
    private static Random regularRandom = new Random();
    private static SecureRandom secureRandom;
    private static volatile boolean secureRandomSeeded;
    private static final int MAX_SEED_TIME = 1000;
    private static String usePRNG;
    private static String usePRNGPackage;

    public UUID nextIdentifier() {
        return this.nextUUID(true);
    }

    public UUID nextIdentifier(boolean secure) {
        if (secure) {
            return this.nextUUID(true);
        }
        return this.nextUUID(false);
    }

    private static synchronized void initSecureRandom() {
        if (secureRandom != null) {
            return;
        }
        try {
            secureRandom = usePRNGPackage != null ? SecureRandom.getInstance(usePRNG, usePRNGPackage) : SecureRandom.getInstance(usePRNG);
        }
        catch (Exception e) {
            secureRandom = new SecureRandom();
        }
        Thread t = new Thread(){

            public void run() {
                byte[] seed = secureRandom.generateSeed(32);
                secureRandom.setSeed(seed);
                secureRandomSeeded = true;
            }
        };
        secureRandomSeeded = false;
        t.start();
        try {
            t.join(1000L);
        }
        catch (InterruptedException e) {
            // empty catch block
        }
        if (!secureRandomSeeded) {
            secureRandom.setSeed(System.currentTimeMillis());
            for (int j = 0; j < 16; ++j) {
                int i = 0;
                long start = System.currentTimeMillis();
                while (start == System.currentTimeMillis()) {
                    ++i;
                }
                secureRandom.setSeed(i);
            }
        }
    }

    private UUID nextUUID(boolean secure) {
        byte[] raw = new byte[16];
        if (secure) {
            VersionFourGenerator.initSecureRandom();
            secureRandom.nextBytes(raw);
        } else {
            regularRandom.nextBytes(raw);
        }
        raw[6] = (byte)(raw[6] & 0xF);
        raw[6] = (byte)(raw[6] | 0x40);
        raw[8] = (byte)(raw[8] & 0x3F);
        raw[8] = (byte)(raw[8] | 0x80);
        return new UUID(raw);
    }

    public static void setPRNGProvider(String prngName, String packageName) {
        usePRNG = prngName;
        usePRNGPackage = packageName;
        secureRandom = null;
    }

    static {
        usePRNG = "SHA1PRNG";
        usePRNGPackage = "SUN";
    }
}

