/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.core.rest.api;

import com.xebialabs.deployit.core.rest.api.DtoWriter;
import com.xebialabs.deployit.core.rest.api.support.PaginationSupport$;
import com.xebialabs.deployit.core.rest.secured.AbstractSecuredResource;
import com.xebialabs.deployit.engine.api.RoleService;
import com.xebialabs.deployit.engine.api.dto.Ordering;
import com.xebialabs.deployit.engine.api.dto.Paging;
import com.xebialabs.deployit.engine.api.security.Role;
import com.xebialabs.deployit.engine.api.security.RolePrincipals;
import com.xebialabs.deployit.engine.spi.event.PrincipalRoleAssignmentCreatedEvent;
import com.xebialabs.deployit.engine.spi.event.PrincipalRoleAssignmentDeletedEvent;
import com.xebialabs.deployit.engine.spi.event.RoleCreatedEvent;
import com.xebialabs.deployit.engine.spi.event.RoleDeletedEvent;
import com.xebialabs.deployit.engine.spi.event.RolePrincipalsChangedEvent;
import com.xebialabs.deployit.engine.spi.event.RoleRenamedEvent;
import com.xebialabs.deployit.event.EventBusHolder;
import com.xebialabs.deployit.security.Permissions;
import com.xebialabs.deployit.security.permission.PlatformPermissions;
import grizzled.slf4j.Logger;
import grizzled.slf4j.Logging;
import java.io.Serializable;
import java.util.List;
import java.util.stream.Collectors;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.core.Context;
import org.jboss.resteasy.spi.HttpResponse;
import org.slf4j.Marker;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.StringContext;
import scala.collection.Seq;
import scala.collection.convert.ImplicitConversions$;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;

@Controller
@ScalaSignature(bytes="\u0006\u0001\u0005\u001dh\u0001B\u0001\u0003\u0001=\u0011ABU8mKJ+7o\\;sG\u0016T!a\u0001\u0003\u0002\u0007\u0005\u0004\u0018N\u0003\u0002\u0006\r\u0005!!/Z:u\u0015\t9\u0001\"\u0001\u0003d_J,'BA\u0005\u000b\u0003!!W\r\u001d7ps&$(BA\u0006\r\u0003%AXMY5bY\u0006\u00147OC\u0001\u000e\u0003\r\u0019w.\\\u0002\u0001'\u0011\u0001\u0001CF\u000f\u0011\u0005E!R\"\u0001\n\u000b\u0005M!\u0011aB:fGV\u0014X\rZ\u0005\u0003+I\u0011q#\u00112tiJ\f7\r^*fGV\u0014X\r\u001a*fg>,(oY3\u0011\u0005]YR\"\u0001\r\u000b\u0005\rI\"B\u0001\u000e\t\u0003\u0019)gnZ5oK&\u0011A\u0004\u0007\u0002\f%>dWmU3sm&\u001cW\r\u0005\u0002\u001fG5\tqD\u0003\u0002!C\u0005)1\u000f\u001c45U*\t!%\u0001\u0005he&T(\u0010\\3e\u0013\t!sDA\u0004M_\u001e<\u0017N\\4\t\u0011\u0019\u0002!\u0011!Q\u0001\n\u001d\nqa]3sm&\u001cW\r\u0005\u0002)W5\t\u0011F\u0003\u0002+\u0011\u0005A1/Z2ve&$\u00180\u0003\u0002\u001dS!)Q\u0006\u0001C\u0001]\u00051A(\u001b8jiz\"\"aL\u0019\u0011\u0005A\u0002Q\"\u0001\u0002\t\u000b\u0019b\u0003\u0019A\u0014)\u00051\u001a\u0004C\u0001\u001b@\u001b\u0005)$B\u0001\u001c8\u0003)\tgN\\8uCRLwN\u001c\u0006\u0003qe\nqAZ1di>\u0014\u0018P\u0003\u0002;w\u0005)!-Z1og*\u0011A(P\u0001\u0010gB\u0014\u0018N\\4ge\u0006lWm^8sW*\ta(A\u0002pe\u001eL!\u0001Q\u001b\u0003\u0013\u0005+Ho\\<je\u0016$\u0007b\u0002\"\u0001\u0005\u0004%IaQ\u0001\nIR|wK]5uKJ,\u0012\u0001\u0012\t\u0003a\u0015K!A\u0012\u0002\u0003\u0013\u0011#xn\u0016:ji\u0016\u0014\bB\u0002%\u0001A\u0003%A)\u0001\u0006ei><&/\u001b;fe\u0002BqA\u0013\u0001C\u0002\u0013\u00051*\u0001\u0005sKN\u0004xN\\:f+\u0005a\u0005CA'U\u001b\u0005q%BA(Q\u0003\r\u0019\b/\u001b\u0006\u0003#J\u000b\u0001B]3ti\u0016\f7/\u001f\u0006\u0003'v\nQA\u001b2pgNL!!\u0016(\u0003\u0019!#H\u000f\u001d*fgB|gn]3\t\r]\u0003\u0001\u0015!\u0003M\u0003%\u0011Xm\u001d9p]N,\u0007\u0005\u000b\u0002W3B\u0011!LY\u0007\u00027*\u0011q\u0001\u0018\u0006\u0003;z\u000b!A]:\u000b\u0005}\u0003\u0017AA<t\u0015\u0005\t\u0017!\u00026bm\u0006D\u0018BA2\\\u0005\u001d\u0019uN\u001c;fqRDQ!\u001a\u0001\u0005B\u0019\fa!\u001a=jgR\u001cHCA4n!\tA7.D\u0001j\u0015\u0005Q\u0017!B:dC2\f\u0017B\u00017j\u0005\u001d\u0011un\u001c7fC:DQA\u001c3A\u0002=\f\u0001B]8mK:\u000bW.\u001a\t\u0003a^t!!];\u0011\u0005ILW\"A:\u000b\u0005Qt\u0011A\u0002\u001fs_>$h(\u0003\u0002wS\u00061\u0001K]3eK\u001aL!\u0001_=\u0003\rM#(/\u001b8h\u0015\t1\u0018\u000eC\u0003|\u0001\u0011\u0005C0\u0001\u0003mSN$H#C?\u0002\u0016\u0005e\u0011QDA\u0017!\u0015q\u0018qAA\u0006\u001b\u0005y(\u0002BA\u0001\u0003\u0007\tA!\u001e;jY*\u0011\u0011QA\u0001\u0005U\u00064\u0018-C\u0002\u0002\n}\u0014A\u0001T5tiB!\u0011QBA\t\u001b\t\tyA\u0003\u0002+1%!\u00111CA\b\u0005\u0011\u0011v\u000e\\3\t\r\u0005]!\u00101\u0001p\u0003\tIG\r\u0003\u0004\u0002\u001ci\u0004\ra\\\u0001\fe>dW\rU1ui\u0016\u0014h\u000eC\u0004\u0002 i\u0004\r!!\t\u0002\rA\fw-\u001b8h!\u0011\t\u0019#!\u000b\u000e\u0005\u0005\u0015\"bAA\u00141\u0005\u0019A\r^8\n\t\u0005-\u0012Q\u0005\u0002\u0007!\u0006<\u0017N\\4\t\u000f\u0005=\"\u00101\u0001\u00022\u0005)qN\u001d3feB!\u00111EA\u001a\u0013\u0011\t)$!\n\u0003\u0011=\u0013H-\u001a:j]\u001eDaa\u001f\u0001\u0005B\u0005eB\u0003CA\u001e\u0003{\ty$!\u0011\u0011\ty\f9a\u001c\u0005\b\u00037\t9\u00041\u0001p\u0011!\ty\"a\u000eA\u0002\u0005\u0005\u0002\u0002CA\u0018\u0003o\u0001\r!!\r\t\u000f\u0005\u0015\u0003\u0001\"\u0011\u0002H\u0005YA.[:u\u001bf\u0014v\u000e\\3t)!\tY$!\u0013\u0002L\u00055\u0003bBA\u000e\u0003\u0007\u0002\ra\u001c\u0005\t\u0003?\t\u0019\u00051\u0001\u0002\"!A\u0011qFA\"\u0001\u0004\t\t\u0004C\u0004\u0002R\u0001!\t%a\u0015\u0002\u00131L7\u000f\u001e*pY\u0016\u001cHCCA\u001e\u0003+\nI&a\u0017\u0002^!9\u0011qKA(\u0001\u0004y\u0017\u0001C;tKJt\u0017-\\3\t\u000f\u0005m\u0011q\na\u0001_\"A\u0011qDA(\u0001\u0004\t\t\u0003\u0003\u0005\u00020\u0005=\u0003\u0019AA\u0019\u0011\u001d\t\t\u0007\u0001C!\u0003G\naa\u0019:fCR,G\u0003BA3\u0003W\u00022\u0001[A4\u0013\r\tI'\u001b\u0002\u0005+:LG\u000fC\u0004\u0002n\u0005}\u0003\u0019A8\u0002\t9\fW.\u001a\u0005\b\u0003c\u0002A\u0011IA:\u0003A)\b\u000fZ1uKB\u0013\u0018N\\2ja\u0006d7\u000f\u0006\u0003\u0002f\u0005U\u0004\u0002CA<\u0003_\u0002\r!!\u001f\u0002\u001dI|G.\u001a)sS:\u001c\u0017\u000e]1mgB!\u0011QBA>\u0013\u0011\ti(a\u0004\u0003\u001dI{G.\u001a)sS:\u001c\u0017\u000e]1mg\"9\u0011\u0011\u000f\u0001\u0005B\u0005\u0005ECBA3\u0003\u0007\u000b)\tC\u0004\u0002n\u0005}\u0004\u0019A8\t\u0011\u0005\u001d\u0015q\u0010a\u0001\u0003w\t!\u0002\u001d:j]\u000eL\u0007/\u00197t\u0011\u001d\t\t\b\u0001C\u0005\u0003\u0017#\u0002\"!\u001a\u0002\u000e\u0006=\u0015\u0011\u0013\u0005\b\u0003/\tI\t1\u0001p\u0011\u001d\ti'!#A\u0002=D\u0001\"a\"\u0002\n\u0002\u0007\u00111\b\u0005\b\u0003+\u0003A\u0011IAL\u0003\u0019\t7o]5h]R1\u0011QMAM\u00037Cq!!\u001c\u0002\u0014\u0002\u0007q\u000eC\u0004\u0002\u001e\u0006M\u0005\u0019A8\u0002\u0013A\u0014\u0018N\\2ja\u0006d\u0007bBAQ\u0001\u0011\u0005\u00131U\u0001\tk:\f7o]5h]R1\u0011QMAS\u0003OCq!!\u001c\u0002 \u0002\u0007q\u000eC\u0004\u0002\u001e\u0006}\u0005\u0019A8\t\u000f\u0005-\u0006\u0001\"\u0011\u0002.\u00061!/\u001a8b[\u0016$b!!\u001a\u00020\u0006E\u0006bBA7\u0003S\u0003\ra\u001c\u0005\b\u0003g\u000bI\u000b1\u0001p\u0003\u001dqWm\u001e(b[\u0016Dq!a.\u0001\t\u0003\nI,\u0001\u0004eK2,G/\u001a\u000b\u0005\u0003K\nY\fC\u0004\u0002n\u0005U\u0006\u0019A8\t\u000f\u0005}\u0006\u0001\"\u0011\u0002B\u0006\u0011\"/Z1e%>dW\r\u0015:j]\u000eL\u0007/\u00197t)!\t\u0019-!2\u0002H\u0006%\u0007#\u0002@\u0002\b\u0005e\u0004bBA\u000e\u0003{\u0003\ra\u001c\u0005\t\u0003?\ti\f1\u0001\u0002\"!A\u0011qFA_\u0001\u0004\t\t\u0004C\u0004\u0002N\u0002!I!a4\u0002=\u0019L'/\u001a*pY\u0016\u0004&/\u001b8dSB\fGn]\"iC:<W\rZ#wK:$H\u0003BA3\u0003#D\u0001\"a\u001e\u0002L\u0002\u0007\u00111\u001b\t\u0006}\u0006\u001d\u0011Q\u001b\t\u0004Q\u0005]\u0017bAA\nS!\u001a\u0001!a7\u0011\t\u0005u\u00171]\u0007\u0003\u0003?T1!!9<\u0003)\u0019H/\u001a:f_RL\b/Z\u0005\u0005\u0003K\fyN\u0001\u0006D_:$(o\u001c7mKJ\u0004")
public class RoleResource
extends AbstractSecuredResource
implements RoleService,
Logging {
    private final com.xebialabs.deployit.security.RoleService service;
    private final DtoWriter dtoWriter;
    @Context
    private final HttpResponse response;
    private Logger grizzled$slf4j$Logging$$_logger;
    private volatile boolean bitmap$0;

    public Logger logger() {
        return Logging.logger$((Logging)this);
    }

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void trace(Function0<Object> msg) {
        Logging.trace$((Logging)this, msg);
    }

    public void trace(Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, msg, t);
    }

    public void trace(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$((Logging)this);
    }

    public void debug(Function0<Object> msg) {
        Logging.debug$((Logging)this, msg);
    }

    public void debug(Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, msg, t);
    }

    public void debug(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isErrorEnabled() {
        return Logging.isErrorEnabled$((Logging)this);
    }

    public void error(Function0<Object> msg) {
        Logging.error$((Logging)this, msg);
    }

    public void error(Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, msg, t);
    }

    public void error(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isInfoEnabled() {
        return Logging.isInfoEnabled$((Logging)this);
    }

    public void info(Function0<Object> msg) {
        Logging.info$((Logging)this, msg);
    }

    public void info(Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, msg, t);
    }

    public void info(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isWarnEnabled() {
        return Logging.isWarnEnabled$((Logging)this);
    }

    public void warn(Function0<Object> msg) {
        Logging.warn$((Logging)this, msg);
    }

    public void warn(Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, msg, t);
    }

    public void warn(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, (Marker)mkr, msg, t);
    }

    @GET
    public List<String> list() {
        return super.list();
    }

    @Path(value="roles")
    @GET
    public List<String> listMyRoles() {
        return super.listMyRoles();
    }

    @Path(value="roles/{username}")
    @GET
    public List<String> listRoles(String x$1) {
        return super.listRoles(x$1);
    }

    @Path(value="principals")
    @GET
    public List<RolePrincipals> readRolePrincipals() {
        return super.readRolePrincipals();
    }

    private Logger grizzled$slf4j$Logging$$_logger$lzycompute() {
        RoleResource roleResource = this;
        synchronized (roleResource) {
            if (!this.bitmap$0) {
                this.grizzled$slf4j$Logging$$_logger = Logging.grizzled$slf4j$Logging$$_logger$((Logging)this);
                this.bitmap$0 = true;
            }
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    public Logger grizzled$slf4j$Logging$$_logger() {
        return !this.bitmap$0 ? this.grizzled$slf4j$Logging$$_logger$lzycompute() : this.grizzled$slf4j$Logging$$_logger;
    }

    private DtoWriter dtoWriter() {
        return this.dtoWriter;
    }

    public HttpResponse response() {
        return this.response;
    }

    public boolean exists(String roleName) {
        return this.service.roleExists(roleName);
    }

    public List<Role> list(String id, String rolePattern, Paging paging, Ordering order) {
        List<Role> list;
        if (rolePattern == null && (paging == null || paging.resultsPerPage() == -1) && order == null) {
            list = this.dtoWriter().writeRoles(this.service.getRoles(id));
        } else {
            PaginationSupport$.MODULE$.addTotalCountHeader(this.service.countRoles(id, rolePattern), this.response());
            list = this.dtoWriter().writeRoles(this.service.getRoles(id, rolePattern, paging, order));
        }
        return list;
    }

    public List<String> list(String rolePattern, Paging paging, Ordering order) {
        List<String> list;
        if (rolePattern == null && (paging == null || paging.resultsPerPage() == -1) && order == null) {
            list = this.service.getRoles().stream().map(x$1 -> x$1.getName()).collect(Collectors.toList());
        } else {
            PaginationSupport$.MODULE$.addTotalCountHeader(this.service.countRoles((Number)Predef$.MODULE$.int2Integer(-1), rolePattern), this.response());
            list = this.service.getRoles(rolePattern, paging, order).stream().map(x$2 -> x$2.getName()).collect(Collectors.toList());
        }
        return list;
    }

    public List<String> listMyRoles(String rolePattern, Paging paging, Ordering order) {
        return this.service.getRolesFor(Permissions.getAuthentication(), rolePattern, paging, order).stream().map(x$3 -> x$3.getName()).collect(Collectors.toList());
    }

    public List<String> listRoles(String username, String rolePattern, Paging paging, Ordering order) {
        this.checkPermission(PlatformPermissions.EDIT_SECURITY);
        return this.service.getRolesFor(username, rolePattern, paging, order).stream().map(x$4 -> x$4.getName()).collect(Collectors.toList());
    }

    public void create(String name) {
        block0: {
            this.checkPermission(PlatformPermissions.EDIT_SECURITY);
            if (this.service.roleExists(name)) break block0;
            this.service.create(name);
            EventBusHolder.publish((Object)new RoleCreatedEvent(name));
        }
    }

    public void updatePrincipals(RolePrincipals rolePrincipals) {
        this.updatePrincipals(rolePrincipals.getRole().getId(), rolePrincipals.getRole().getName(), rolePrincipals.getPrincipals());
    }

    public void updatePrincipals(String name, List<String> principals) {
        this.updatePrincipals(null, name, principals);
    }

    private void updatePrincipals(String id, String name, List<String> principals) {
        this.checkPermission(PlatformPermissions.EDIT_SECURITY);
        com.xebialabs.deployit.security.Role role = new com.xebialabs.deployit.security.Role(id, name, principals);
        this.service.createOrUpdateRole(role);
        this.fireRolePrincipalsChangedEvent(this.service.readRoleAssignments());
    }

    public void assign(String name, String principal) {
        com.xebialabs.deployit.security.Role role = this.service.getRoleForRoleName(name);
        Buffer newPrincipals = (Buffer)ImplicitConversions$.MODULE$.list$u0020asScalaBuffer(role.getPrincipals()).$colon$plus((Object)principal, Buffer$.MODULE$.canBuildFrom());
        this.updatePrincipals(name, ImplicitConversions$.MODULE$.buffer$u0020AsJavaList(newPrincipals));
        EventBusHolder.publish((Object)new PrincipalRoleAssignmentCreatedEvent(principal, name));
    }

    public void unassign(String name, String principal) {
        com.xebialabs.deployit.security.Role role = this.service.getRoleForRoleName(name);
        Buffer newPrincipals = (Buffer)ImplicitConversions$.MODULE$.list$u0020asScalaBuffer(role.getPrincipals()).filter((Function1 & Serializable & scala.Serializable)p -> BoxesRunTime.boxToBoolean((boolean)RoleResource.$anonfun$unassign$1(principal, p)));
        this.updatePrincipals(name, ImplicitConversions$.MODULE$.buffer$u0020AsJavaList(newPrincipals));
        EventBusHolder.publish((Object)new PrincipalRoleAssignmentDeletedEvent(principal, name));
    }

    public void rename(String name, String newName) {
        this.checkPermission(PlatformPermissions.EDIT_SECURITY);
        this.service.rename(name, newName);
        EventBusHolder.publish((Object)new RoleRenamedEvent(name, newName));
    }

    public void delete(String name) {
        this.checkPermission(PlatformPermissions.EDIT_SECURITY);
        this.service.deleteByName(name);
        EventBusHolder.publish((Object)new RoleDeletedEvent(name));
    }

    public List<RolePrincipals> readRolePrincipals(String rolePattern, Paging paging, Ordering order) {
        this.checkPermission(PlatformPermissions.EDIT_SECURITY);
        ObjectRef multimap = ObjectRef.create(null);
        if (rolePattern == null && (paging == null || paging.resultsPerPage() == -1) && order == null) {
            multimap.elem = this.service.readRoleAssignments();
        } else {
            multimap.elem = this.service.readRoleAssignments(rolePattern, paging, order);
            long total = this.service.countRoles((Number)Predef$.MODULE$.int2Integer(-1), rolePattern);
            PaginationSupport$.MODULE$.addTotalCountHeader(total, this.response());
        }
        this.logger().debug((Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"com.xebialabs.deployit.security.RoleService delivered roles: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{(List)multimap$1.elem})));
        List<RolePrincipals> assignments = this.dtoWriter().writeRoleAssignments((List)multimap.elem);
        this.logger().debug((Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Going to return the following roles: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{assignments})));
        return assignments;
    }

    private void fireRolePrincipalsChangedEvent(List<com.xebialabs.deployit.security.Role> rolePrincipals) {
        EventBusHolder.publish((Object)new RolePrincipalsChangedEvent(rolePrincipals.stream().map(r -> r.getName() + " => " + r.getPrincipals()).collect(Collectors.toList())));
    }

    public static final /* synthetic */ boolean $anonfun$unassign$1(String principal$1, String p) {
        String string = p;
        String string2 = principal$1;
        return string == null ? string2 != null : !string.equals(string2);
    }

    @Autowired
    public RoleResource(com.xebialabs.deployit.security.RoleService service) {
        this.service = service;
        Logging.$init$((Logging)this);
        this.dtoWriter = new DtoWriter();
        this.response = null;
    }
}

