/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.core.rest.api;

import com.xebialabs.deployit.checks.Checks;
import com.xebialabs.deployit.core.rest.api.DtoReader;
import com.xebialabs.deployit.core.rest.api.SearchParametersFactory;
import com.xebialabs.deployit.core.rest.resteasy.Workdir;
import com.xebialabs.deployit.core.rest.resteasy.WorkdirHolder;
import com.xebialabs.deployit.core.rest.secured.AbstractSecuredResource;
import com.xebialabs.deployit.core.rest.util.RepositoryHelper;
import com.xebialabs.deployit.engine.api.dto.ArtifactAndData;
import com.xebialabs.deployit.engine.api.dto.ConfigurationItemId;
import com.xebialabs.deployit.engine.api.dto.ConfigurationItemProperties;
import com.xebialabs.deployit.engine.spi.command.CopyCiCommand;
import com.xebialabs.deployit.engine.spi.command.CreateCisCommand;
import com.xebialabs.deployit.engine.spi.command.DeleteCiCommand;
import com.xebialabs.deployit.engine.spi.command.DeleteCisCommand;
import com.xebialabs.deployit.engine.spi.command.MoveCiCommand;
import com.xebialabs.deployit.engine.spi.command.RenameCiCommand;
import com.xebialabs.deployit.engine.spi.command.RepositoryBaseCommand;
import com.xebialabs.deployit.engine.spi.command.UpdateCiCommand;
import com.xebialabs.deployit.engine.spi.exception.DeployitException;
import com.xebialabs.deployit.exception.NotFoundException;
import com.xebialabs.deployit.io.ArtifactFileUtils;
import com.xebialabs.deployit.plugin.api.reflect.PropertyDescriptor;
import com.xebialabs.deployit.plugin.api.reflect.PropertyKind;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.plugin.api.udm.artifact.Artifact;
import com.xebialabs.deployit.plugin.api.udm.artifact.FolderArtifact;
import com.xebialabs.deployit.plugin.api.udm.artifact.SourceArtifact;
import com.xebialabs.deployit.repository.RepositoryService;
import com.xebialabs.deployit.repository.SearchParameters;
import com.xebialabs.deployit.repository.WorkDir;
import com.xebialabs.deployit.security.PermissionDeniedException;
import com.xebialabs.deployit.security.permission.PlatformPermissions;
import com.xebialabs.deployit.service.validation.Validator;
import com.xebialabs.deployit.util.TFiles;
import com.xebialabs.overthere.OverthereFile;
import com.xebialabs.overthere.local.LocalFile;
import com.xebialabs.xldeploy.packager.SourceArtifactEnricher;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.joda.time.DateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;

public class RepositoryResource
extends AbstractSecuredResource
implements com.xebialabs.deployit.engine.api.RepositoryService {
    public static final Predicate<String> canRead = input -> PlatformPermissions.READ.getPermissionHandler().hasPermission(input);
    private final RepositoryService repositoryService;
    private final Validator validator;
    private final RepositoryHelper repositoryHelper;
    private SourceArtifactEnricher sourceArtifactEnricher;
    @Value(value="#{serverConfiguration.uploadFileBufferSize}")
    private Integer uploadFileBufferSize;
    private static final Logger logger = LoggerFactory.getLogger(RepositoryResource.class);

    public RepositoryResource(RepositoryService repositoryService, Validator validator, SourceArtifactEnricher sourceArtifactEnricher, RepositoryHelper repositoryHelper) {
        this.repositoryService = repositoryService;
        this.validator = validator;
        this.sourceArtifactEnricher = sourceArtifactEnricher;
        this.repositoryHelper = repositoryHelper;
    }

    public ConfigurationItem read(String id) {
        this.checkPermission(PlatformPermissions.READ, id);
        return this.repositoryService.read(id, 1);
    }

    public List<ConfigurationItem> read(List<String> ids) {
        ArrayList<ConfigurationItem> result = new ArrayList<ConfigurationItem>();
        ids.stream().filter(canRead).forEach(ciId -> {
            try {
                ConfigurationItem entity = this.repositoryService.read(ciId, 1);
                result.add(entity);
            }
            catch (NotFoundException nfe) {
                logger.error("No configuration item with ID [{}] exists in the repository", ciId);
                logger.debug("Exception was:", (Throwable)nfe);
            }
            catch (RuntimeException re) {
                logger.error("Could not read configuration item [{}]", ciId);
                logger.error("Exception was: ", (Throwable)re);
            }
        });
        return result;
    }

    public List<ConfigurationItemId> query(Type type, String parent, String ancestor, String namePattern, DateTime lastModifiedBefore, DateTime lastModifiedAfter, long page, long resultPerPage) {
        return this.queryV2(type, parent, ancestor, namePattern, null, lastModifiedBefore, lastModifiedAfter, page, resultPerPage);
    }

    public List<ConfigurationItemId> queryV2(Type type, String parent, String ancestor, String namePattern, String idPattern, DateTime lastModifiedBefore, DateTime lastModifiedAfter, long page, long resultPerPage) {
        return this.list(SearchParametersFactory.createSearchParams(type, page, resultPerPage, parent, ancestor, namePattern, idPattern, lastModifiedBefore != null ? lastModifiedBefore.toGregorianCalendar() : null, lastModifiedAfter != null ? lastModifiedAfter.toGregorianCalendar() : null, 0));
    }

    public List<ConfigurationItemId> queryV3(Type type, String parent, String ancestor, String namePattern, String idPattern, DateTime lastModifiedBefore, DateTime lastModifiedAfter, long page, long resultPerPage, ConfigurationItemProperties properties) {
        return this.list(SearchParametersFactory.createSearchParams(type, page, resultPerPage, parent, ancestor, namePattern, idPattern, lastModifiedBefore != null ? lastModifiedBefore.toGregorianCalendar() : null, lastModifiedAfter != null ? lastModifiedAfter.toGregorianCalendar() : null, 0, properties));
    }

    public List<ConfigurationItemId> candidateValues(String propertyName, String namePattern, long page, long resultPerPage, ConfigurationItem ci) {
        return this.list(SearchParametersFactory.createSearchParamsForCandidateValues(propertyName, namePattern, page, resultPerPage, ci));
    }

    private List<ConfigurationItemId> list(SearchParameters searchParams) {
        PlatformPermissions.READ.getPermissionHandler().applyPermission(searchParams);
        return this.repositoryService.list(searchParams).stream().map(DtoReader.ciDataToCiId).collect(Collectors.toList());
    }

    public ConfigurationItem create(String id, ConfigurationItem ci) {
        this.checkPermission(PlatformPermissions.EDIT_REPO, id);
        Checks.checkArgument((boolean)id.equals(ci.getId()), (String)"The Configuration item id is [%s], but the id parameter is [%s]", (Object[])new Object[]{ci.getId(), id});
        return this.createInternal(ci);
    }

    @Workdir(prefix="artifact")
    public ConfigurationItem create(String id, ArtifactAndData aad) {
        WorkDir workDir = WorkdirHolder.get();
        this.checkPermission(PlatformPermissions.EDIT_REPO, id);
        Artifact artifact = aad.getArtifact();
        Checks.checkArgument((boolean)id.equals(artifact.getId()), (String)"The Configuration item id is [%s], but the id parameter is [%s]", (Object[])new Object[]{artifact.getId(), id});
        artifact.setFile((OverthereFile)this.readArtifactData(aad, workDir));
        if (artifact instanceof FolderArtifact) {
            Checks.checkTrue((boolean)TFiles.isArchive((String)artifact.getFile().getPath()), (String)"Folder artifact [%s] is not a valid ZIP archive", (Object[])new Object[]{artifact.getFile().getName()});
        }
        return this.createInternal((ConfigurationItem)artifact);
    }

    private ConfigurationItem createInternal(ConfigurationItem ci) {
        if (ci instanceof SourceArtifact) {
            ArtifactFileUtils.handleArtifact((SourceArtifactEnricher)this.sourceArtifactEnricher, (SourceArtifact)((SourceArtifact)ci));
        }
        this.validator.validateCi(ci);
        List validationMessages = this.validator.validateInputHint(ci);
        ArrayList<String> ids = new ArrayList<String>();
        this.repositoryHelper.checkReadAccessOnRelations(null, ci, ids, Collections.emptySet());
        if (!ids.isEmpty()) {
            throw new PermissionDeniedException("Permission READ is not granted on the following linked CIs: " + ids);
        }
        Set<ConfigurationItem> ciSet = new CiCollector(Collections.singletonList(ci)).collect();
        this.repositoryHelper.publishCommand((RepositoryBaseCommand)new CreateCisCommand(new ArrayList<ConfigurationItem>(ciSet)));
        ConfigurationItem configurationItem = this.repositoryService.read(ci.getId(), 1);
        configurationItem.get$validationMessages().addAll(validationMessages);
        return configurationItem;
    }

    @Workdir(prefix="artifact")
    public List<ConfigurationItem> create(List<ConfigurationItem> cis) {
        Set<String> ciIds = cis.stream().map(ConfigurationItem::getId).collect(Collectors.toSet());
        ciIds.stream().filter(ciId -> !ciIds.contains(this.parentId((String)ciId))).forEach(id -> this.checkPermission(PlatformPermissions.EDIT_REPO, (String)id));
        this.validator.validateCis(cis);
        ArrayList<String> ids = new ArrayList<String>();
        for (ConfigurationItem ci : cis) {
            if (ci instanceof SourceArtifact) {
                ArtifactFileUtils.handleArtifact((SourceArtifactEnricher)this.sourceArtifactEnricher, (SourceArtifact)((SourceArtifact)ci));
            }
            this.repositoryHelper.checkReadAccessOnRelations(null, ci, ids, ciIds);
        }
        if (!ids.isEmpty()) {
            throw new PermissionDeniedException("Permission READ is not granted on the following linked CIs: " + ids);
        }
        Set<ConfigurationItem> ciSet = new CiCollector(cis).collect();
        CreateCisCommand event = new CreateCisCommand(new ArrayList<ConfigurationItem>(ciSet));
        this.repositoryHelper.publishCommand((RepositoryBaseCommand)event);
        return this.repositoryHelper.reloadEntities(cis);
    }

    public ConfigurationItem update(String id, ConfigurationItem ci) {
        this.checkPermission(PlatformPermissions.EDIT_REPO, id);
        Checks.checkArgument((boolean)id.equals(ci.getId()), (String)"The Configuration item id is [%s], but the id parameter is [%s]", (Object[])new Object[]{ci.getId(), id});
        return this.updateInternal(ci);
    }

    @Workdir(prefix="artifact")
    public ConfigurationItem update(String id, ArtifactAndData aad) {
        WorkDir workDir = WorkdirHolder.get();
        this.checkPermission(PlatformPermissions.EDIT_REPO, id);
        Checks.checkArgument((boolean)id.equals(aad.getArtifact().getId()), (String)"The Configuration item id is [%s], but the id parameter is [%s]", (Object[])new Object[]{aad.getArtifact().getId(), id});
        aad.getArtifact().setFile((OverthereFile)this.readArtifactData(aad, workDir));
        return this.updateInternal((ConfigurationItem)aad.getArtifact());
    }

    private ConfigurationItem updateInternal(ConfigurationItem ci) {
        this.validator.validateCi(ci);
        List validationMessages = this.validator.validateInputHint(ci);
        ConfigurationItem previous = this.repositoryService.read(ci.getId(), false);
        Checks.checkArgument((boolean)this.repositoryHelper.isFileUriNotChanged(ci, previous), (String)"File URIs cannot be updated. If you want to change the file URI, create a new CI for the artifact. (https://docs.xebialabs.com/xl-deploy/how-to/add-an-externally-stored-artifact-to-a-package.html#changing-the-uri-of-a-deployable-artifact)", (Object[])new Object[0]);
        this.repositoryHelper.checkIfConvertibleType(ci, previous);
        ArrayList<String> ids = new ArrayList<String>();
        this.repositoryHelper.checkReadAccessOnRelations(previous, ci, ids, Collections.emptySet());
        if (!ids.isEmpty()) {
            throw new PermissionDeniedException("Permission READ is not granted on the following linked CIs: " + ids);
        }
        this.repositoryHelper.publishCommand((RepositoryBaseCommand)new UpdateCiCommand(previous, ci));
        ConfigurationItem configurationItem = this.repositoryService.read(ci.getId(), 1, null, false);
        configurationItem.get$validationMessages().addAll(validationMessages);
        return configurationItem;
    }

    public List<ConfigurationItem> update(List<ConfigurationItem> cis) {
        Set ciIds = cis.stream().map(ConfigurationItem::getId).collect(Collectors.toSet());
        Set existingIds = ciIds.stream().filter(arg_0 -> ((RepositoryService)this.repositoryService).exists(arg_0)).collect(Collectors.toSet());
        List<ConfigurationItem> filteredCis = cis.stream().filter(new MultiUpdatePermissionCheck(ciIds, existingIds)).collect(Collectors.toList());
        return this.repositoryHelper.createOrUpdateAndReloadCis(filteredCis, Optional.of(existingIds));
    }

    public ConfigurationItem move(String id, String targetId) {
        this.checkPermission(PlatformPermissions.EDIT_REPO, id);
        this.checkPermission(PlatformPermissions.EDIT_REPO, targetId);
        String idRoot = id.split("/")[0];
        String targetRoot = targetId.split("/")[0];
        Checks.checkArgument((boolean)idRoot.equals(targetRoot), (String)"Cannot move ci [%s] to [%s] because that is outside of the root where it is stored.", (Object[])new Object[]{id, targetId});
        this.repositoryHelper.publishCommand((RepositoryBaseCommand)new MoveCiCommand(id, targetId));
        return this.read(targetId);
    }

    public ConfigurationItem copy(String id, String targetId) {
        this.checkPermission(PlatformPermissions.EDIT_REPO, id);
        this.checkPermission(PlatformPermissions.EDIT_REPO, targetId);
        String idRoot = id.split("/")[0];
        String targetRoot = targetId.split("/")[0];
        Checks.checkArgument((boolean)idRoot.equals(targetRoot), (String)"Cannot copy ci [%s] to [%s] because that is outside of the root where it is stored.", (Object[])new Object[]{id, targetId});
        this.repositoryHelper.publishCommand((RepositoryBaseCommand)new CopyCiCommand(id, targetId, this.read(id).getType()));
        return this.read(targetId);
    }

    public ConfigurationItem rename(String id, String targetName) {
        this.checkPermission(PlatformPermissions.EDIT_REPO, id);
        this.repositoryHelper.publishCommand((RepositoryBaseCommand)new RenameCiCommand(id, targetName, this.read(id).getType()));
        String targetId = this.parentId(id) + '/' + targetName;
        return this.read(targetId);
    }

    private String parentId(String id) {
        return id.substring(0, id.lastIndexOf(47));
    }

    public List<ConfigurationItem> validate(List<ConfigurationItem> cis) {
        this.validator.validateCis(cis);
        for (ConfigurationItem ci : cis) {
            List validationMessages = this.validator.validateInputHint(ci);
            ci.get$validationMessages().addAll(validationMessages);
        }
        return cis;
    }

    public void delete(String id) {
        this.checkDeletePermission(id);
        this.repositoryHelper.publishCommand((RepositoryBaseCommand)new DeleteCiCommand(id));
    }

    public void deleteList(List<String> ids) {
        this.repositoryHelper.publishCommand((RepositoryBaseCommand)new DeleteCisCommand(ids));
    }

    protected void checkDeletePermission(String id) {
        this.checkPermission(PlatformPermissions.EDIT_REPO, id);
    }

    public Boolean exists(String id) {
        return this.repositoryService.exists(id);
    }

    private LocalFile readArtifactData(ArtifactAndData aad, WorkDir workDir) {
        Checks.checkArgument((aad.getFilename() != null ? 1 : 0) != 0, (String)"The filename for the artifact should not be null", (Object[])new Object[0]);
        LocalFile localFile = workDir.newFile(aad.getFilename());
        try (OutputStream outputStream = localFile.getOutputStream();
             InputStream inputStream = aad.getDataInputStream();){
            this.copy(inputStream, outputStream);
        }
        catch (IOException e) {
            String message = "Could not write Artifact data for [" + aad.getArtifact().getId() + "] to [" + localFile + "]";
            logger.error(message, (Throwable)e);
            throw new DeployitException(message);
        }
        return localFile;
    }

    private void copy(InputStream from, OutputStream to) throws IOException {
        int r;
        byte[] buf = new byte[this.uploadFileBufferSize.intValue()];
        while ((r = from.read(buf)) != -1) {
            to.write(buf, 0, r);
        }
    }

    static class CiCollector {
        private Collection<? extends ConfigurationItem> cis;

        public CiCollector(Collection<? extends ConfigurationItem> cis) {
            this.cis = cis;
        }

        public Set<ConfigurationItem> collect() {
            HashSet<ConfigurationItem> collector = new HashSet<ConfigurationItem>();
            this.collectNestedCis(this.cis, collector);
            return collector;
        }

        private Set<ConfigurationItem> collectNestedCis(Collection<? extends ConfigurationItem> cis, Set<ConfigurationItem> collector) {
            for (ConfigurationItem configurationItem : cis) {
                collector.add(configurationItem);
                for (PropertyDescriptor property : configurationItem.getType().getDescriptor().getPropertyDescriptors()) {
                    Collection<ConfigurationItem> children;
                    PropertyKind kind = property.getKind();
                    if (kind == PropertyKind.SET_OF_CI || kind == PropertyKind.LIST_OF_CI) {
                        children = this.getChildren(configurationItem, property);
                        this.collectNestedCis(children, collector);
                        continue;
                    }
                    if (kind != PropertyKind.CI) continue;
                    children = this.getChildrenForCI(configurationItem, property);
                    this.collectNestedCis(children, collector);
                }
            }
            return collector;
        }

        private Collection<ConfigurationItem> getChildrenForCI(ConfigurationItem parent, PropertyDescriptor property) {
            ConfigurationItem ci = (ConfigurationItem)property.get(parent);
            ArrayList<ConfigurationItem> children = new ArrayList<ConfigurationItem>();
            if (ci != null && this.isChild(ci, parent)) {
                children.add(ci);
            }
            return children;
        }

        private Collection<ConfigurationItem> getChildren(ConfigurationItem parent, PropertyDescriptor property) {
            Collection references = (Collection)property.get(parent);
            if (property.isAsContainment()) {
                return references;
            }
            ArrayList<ConfigurationItem> children = new ArrayList<ConfigurationItem>();
            for (ConfigurationItem ci : references) {
                if (!this.isChild(ci, parent)) continue;
                children.add(ci);
            }
            return children;
        }

        private boolean isChild(ConfigurationItem ci, ConfigurationItem parent) {
            for (PropertyDescriptor property : ci.getType().getDescriptor().getPropertyDescriptors()) {
                PropertyKind kind = property.getKind();
                if (kind != PropertyKind.CI || !property.isAsContainment() || !parent.equals(property.get(ci))) continue;
                return true;
            }
            return false;
        }
    }

    private class MultiUpdatePermissionCheck
    implements Predicate<ConfigurationItem> {
        private final Set<String> ciIds;
        private final Set<String> existingIds;
        private final Set<String> canNotEdit;
        private final Map<String, Boolean> permissionCache = new HashMap<String, Boolean>();

        private MultiUpdatePermissionCheck(Set<String> ciIds, Set<String> existingIds) {
            this.ciIds = ciIds;
            this.existingIds = existingIds;
            this.canNotEdit = this.existingIds.stream().filter(ciId -> !RepositoryResource.this.hasPermission(PlatformPermissions.EDIT_REPO, ciId)).collect(Collectors.toSet());
        }

        @Override
        public boolean test(ConfigurationItem configurationItem) {
            String currentId = configurationItem.getId();
            while (this.ciIds.contains(RepositoryResource.this.parentId(currentId))) {
                if (this.canNotEdit.contains(currentId)) {
                    return false;
                }
                if (this.existingIds.contains(currentId)) {
                    return true;
                }
                currentId = RepositoryResource.this.parentId(currentId);
            }
            return this.permissionCache.computeIfAbsent(currentId, id -> RepositoryResource.this.hasPermission(PlatformPermissions.EDIT_REPO, id));
        }
    }
}

