/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.oauth2.provider.endpoint;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.springframework.security.oauth2.common.exceptions.InvalidGrantException;
import org.springframework.security.oauth2.common.exceptions.InvalidRequestException;
import org.springframework.security.oauth2.common.exceptions.OAuth2Exception;
import org.springframework.security.oauth2.common.exceptions.RedirectMismatchException;
import org.springframework.security.oauth2.provider.ClientDetails;
import org.springframework.security.oauth2.provider.endpoint.RedirectResolver;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;
import org.springframework.web.util.UriComponents;
import org.springframework.web.util.UriComponentsBuilder;

public class DefaultRedirectResolver
implements RedirectResolver {
    private Collection<String> redirectGrantTypes = Arrays.asList("implicit", "authorization_code");
    private boolean matchSubdomains = true;
    private boolean matchPorts = true;

    public void setMatchSubdomains(boolean matchSubdomains) {
        this.matchSubdomains = matchSubdomains;
    }

    public void setMatchPorts(boolean matchPorts) {
        this.matchPorts = matchPorts;
    }

    public void setRedirectGrantTypes(Collection<String> redirectGrantTypes) {
        this.redirectGrantTypes = new HashSet<String>(redirectGrantTypes);
    }

    @Override
    public String resolveRedirect(String requestedRedirect, ClientDetails client) throws OAuth2Exception {
        Set<String> authorizedGrantTypes = client.getAuthorizedGrantTypes();
        if (authorizedGrantTypes.isEmpty()) {
            throw new InvalidGrantException("A client must have at least one authorized grant type.");
        }
        if (!this.containsRedirectGrantType(authorizedGrantTypes)) {
            throw new InvalidGrantException("A redirect_uri can only be used by implicit or authorization_code grant types.");
        }
        Set<String> registeredRedirectUris = client.getRegisteredRedirectUri();
        if (registeredRedirectUris == null || registeredRedirectUris.isEmpty()) {
            throw new InvalidRequestException("At least one redirect_uri must be registered with the client.");
        }
        return this.obtainMatchingRedirect(registeredRedirectUris, requestedRedirect);
    }

    private boolean containsRedirectGrantType(Set<String> grantTypes) {
        for (String type : grantTypes) {
            if (!this.redirectGrantTypes.contains(type)) continue;
            return true;
        }
        return false;
    }

    protected boolean redirectMatches(String requestedRedirect, String redirectUri) {
        String registeredRedirectUriPath;
        UriComponents requestedRedirectUri = UriComponentsBuilder.fromUriString((String)requestedRedirect).build();
        String requestedRedirectUriScheme = requestedRedirectUri.getScheme() != null ? requestedRedirectUri.getScheme() : "";
        String requestedRedirectUriHost = requestedRedirectUri.getHost() != null ? requestedRedirectUri.getHost() : "";
        String requestedRedirectUriPath = requestedRedirectUri.getPath() != null ? requestedRedirectUri.getPath() : "";
        UriComponents registeredRedirectUri = UriComponentsBuilder.fromUriString((String)redirectUri).build();
        String registeredRedirectUriScheme = registeredRedirectUri.getScheme() != null ? registeredRedirectUri.getScheme() : "";
        String registeredRedirectUriHost = registeredRedirectUri.getHost() != null ? registeredRedirectUri.getHost() : "";
        String string = registeredRedirectUriPath = registeredRedirectUri.getPath() != null ? registeredRedirectUri.getPath() : "";
        boolean portsMatch = this.matchPorts ? registeredRedirectUri.getPort() == requestedRedirectUri.getPort() : true;
        return registeredRedirectUriScheme.equals(requestedRedirectUriScheme) && this.hostMatches(registeredRedirectUriHost, requestedRedirectUriHost) && portsMatch && registeredRedirectUriPath.equals(StringUtils.cleanPath((String)requestedRedirectUriPath));
    }

    protected boolean hostMatches(String registered, String requested) {
        if (this.matchSubdomains) {
            return registered.equals(requested) || requested.endsWith("." + registered);
        }
        return registered.equals(requested);
    }

    private String obtainMatchingRedirect(Set<String> redirectUris, String requestedRedirect) {
        Assert.notEmpty(redirectUris, (String)"Redirect URIs cannot be empty");
        if (redirectUris.size() == 1 && requestedRedirect == null) {
            return redirectUris.iterator().next();
        }
        for (String redirectUri : redirectUris) {
            if (requestedRedirect == null || !this.redirectMatches(requestedRedirect, redirectUri)) continue;
            return requestedRedirect;
        }
        throw new RedirectMismatchException("Invalid redirect: " + requestedRedirect + " does not match one of the registered values: " + redirectUris.toString());
    }
}

