/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.engine.tasker;

import akka.actor.Actor;
import akka.actor.ActorContext;
import akka.actor.ActorNotFound;
import akka.actor.ActorRef;
import akka.actor.ActorSelection;
import akka.actor.ActorSelection$;
import akka.actor.ActorSystem;
import akka.actor.Props$;
import akka.actor.ScalaActorRef;
import akka.actor.ScalaActorSelection;
import akka.actor.SupervisorStrategy;
import akka.actor.package$;
import akka.annotation.InternalApi;
import akka.pattern.AskableActorRef$;
import akka.pattern.AskableActorSelection$;
import akka.util.Timeout;
import com.github.nscala_time.time.Imports$;
import com.github.nscala_time.time.RichDateTime$;
import com.github.nscala_time.time.RichReadableInstant$;
import com.github.nscala_time.time.RichReadableInterval$;
import com.xebialabs.deployit.engine.api.execution.TaskExecutionState;
import com.xebialabs.deployit.engine.spi.services.RepositoryFactory;
import com.xebialabs.deployit.engine.tasker.ActiveTasksQueue$;
import com.xebialabs.deployit.engine.tasker.Archive;
import com.xebialabs.deployit.engine.tasker.ArchiveActor$;
import com.xebialabs.deployit.engine.tasker.ArchivedListeningActor;
import com.xebialabs.deployit.engine.tasker.ArchivedListeningActor$;
import com.xebialabs.deployit.engine.tasker.BlockPath;
import com.xebialabs.deployit.engine.tasker.BlockPath$Root$;
import com.xebialabs.deployit.engine.tasker.IEngine;
import com.xebialabs.deployit.engine.tasker.RecoverySupervisorActor;
import com.xebialabs.deployit.engine.tasker.RecoverySupervisorActor$;
import com.xebialabs.deployit.engine.tasker.RecoverySupervisorActor$ReadAll$;
import com.xebialabs.deployit.engine.tasker.Task;
import com.xebialabs.deployit.engine.tasker.TaskExecutionEngine$;
import com.xebialabs.deployit.engine.tasker.TaskManagingActor;
import com.xebialabs.deployit.engine.tasker.TaskManagingActor$;
import com.xebialabs.deployit.engine.tasker.TaskNotFoundException;
import com.xebialabs.deployit.engine.tasker.TaskRecoveryListener$;
import com.xebialabs.deployit.engine.tasker.TaskRegistryExtension;
import com.xebialabs.deployit.engine.tasker.TaskRegistryExtension$;
import com.xebialabs.deployit.engine.tasker.TaskSpecification;
import com.xebialabs.deployit.engine.tasker.TaskTransitionActor$;
import com.xebialabs.deployit.engine.tasker.TaskerException;
import com.xebialabs.deployit.engine.tasker.messages.Abort;
import com.xebialabs.deployit.engine.tasker.messages.AddPauseStep;
import com.xebialabs.deployit.engine.tasker.messages.Enqueue;
import com.xebialabs.deployit.engine.tasker.messages.ModifySteps;
import com.xebialabs.deployit.engine.tasker.messages.PathsNotFound;
import com.xebialabs.deployit.engine.tasker.messages.RunMode$;
import com.xebialabs.deployit.engine.tasker.messages.SkipSteps;
import com.xebialabs.deployit.engine.tasker.messages.StepModificationError;
import com.xebialabs.deployit.engine.tasker.messages.Stop;
import com.xebialabs.deployit.engine.tasker.messages.Stop$;
import com.xebialabs.deployit.engine.tasker.messages.TaskDone;
import com.xebialabs.deployit.engine.tasker.messages.UnSkipSteps;
import com.xebialabs.deployit.plugin.api.services.Repository;
import com.xebialabs.xlplatform.settings.CommonSettings;
import com.xebialabs.xlplatform.settings.CommonSettings$;
import com.xebialabs.xlplatform.settings.TaskerSettings;
import grizzled.slf4j.Logger;
import grizzled.slf4j.Logging;
import java.io.File;
import java.io.FileFilter;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.nio.file.Files;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;
import org.joda.time.ReadableInterval;
import org.slf4j.Marker;
import scala.Function0;
import scala.Function1;
import scala.Function3;
import scala.MatchError;
import scala.Option;
import scala.Option$;
import scala.PartialFunction;
import scala.Predef$;
import scala.StringContext;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.SetLike;
import scala.collection.TraversableLike;
import scala.collection.immutable.List;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.Buffer$;
import scala.concurrent.Await$;
import scala.concurrent.Awaitable;
import scala.concurrent.Promise;
import scala.concurrent.Promise$;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.Duration$;
import scala.concurrent.duration.package;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.java8.JFunction0;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;

@ScalaSignature(bytes="\u0006\u0001\t\u0015g\u0001B\u0001\u0003\u00015\u00111\u0003V1tW\u0016CXmY;uS>tWI\\4j]\u0016T!a\u0001\u0003\u0002\rQ\f7o[3s\u0015\t)a!\u0001\u0004f]\u001eLg.\u001a\u0006\u0003\u000f!\t\u0001\u0002Z3qY>L\u0018\u000e\u001e\u0006\u0003\u0013)\t\u0011\u0002_3cS\u0006d\u0017MY:\u000b\u0003-\t1aY8n\u0007\u0001\u0019B\u0001\u0001\b\u00175A\u0011q\u0002F\u0007\u0002!)\u0011\u0011CE\u0001\u0005Y\u0006twMC\u0001\u0014\u0003\u0011Q\u0017M^1\n\u0005U\u0001\"AB(cU\u0016\u001cG\u000f\u0005\u0002\u001815\t!!\u0003\u0002\u001a\u0005\t9\u0011*\u00128hS:,\u0007CA\u000e!\u001b\u0005a\"BA\u000f\u001f\u0003\u0015\u0019HN\u001a\u001bk\u0015\u0005y\u0012\u0001C4sSjTH.\u001a3\n\u0005\u0005b\"a\u0002'pO\u001eLgn\u001a\u0005\tG\u0001\u0011\t\u0011)A\u0005I\u00059\u0011M]2iSZ,\u0007CA\f&\u0013\t1#AA\u0004Be\u000eD\u0017N^3\t\u0011!\u0002!\u0011!Q\u0001\n%\n\u0011C]3q_NLGo\u001c:z\r\u0006\u001cGo\u001c:z!\tQs&D\u0001,\u0015\taS&\u0001\u0005tKJ4\u0018nY3t\u0015\tqC!A\u0002ta&L!\u0001M\u0016\u0003#I+\u0007o\\:ji>\u0014\u0018PR1di>\u0014\u0018\u0010\u0003\u00053\u0001\t\u0015\r\u0011b\u00014\u0003\u0019\u0019\u0018p\u001d;f[V\tA\u0007\u0005\u00026u5\taG\u0003\u00028q\u0005)\u0011m\u0019;pe*\t\u0011(\u0001\u0003bW.\f\u0017BA\u001e7\u0005-\t5\r^8s'f\u001cH/Z7\t\u0011u\u0002!\u0011!Q\u0001\nQ\nqa]=ti\u0016l\u0007\u0005C\u0003@\u0001\u0011\u0005\u0001)\u0001\u0004=S:LGO\u0010\u000b\u0005\u0003\n\u001bE\t\u0005\u0002\u0018\u0001!)1E\u0010a\u0001I!)\u0001F\u0010a\u0001S!)!G\u0010a\u0002i!9a\t\u0001b\u0001\n\u00039\u0015A\u0004;bg.,'oU3ui&twm]\u000b\u0002\u0011B\u0011\u0011JT\u0007\u0002\u0015*\u00111\nT\u0001\tg\u0016$H/\u001b8hg*\u0011Q\nC\u0001\u000bq2\u0004H.\u0019;g_Jl\u0017BA(K\u00059!\u0016m]6feN+G\u000f^5oONDa!\u0015\u0001!\u0002\u0013A\u0015a\u0004;bg.,'oU3ui&twm\u001d\u0011\t\u000fM\u0003!\u0019!C\u0001)\u0006A\u0011M]2iSZ,'/F\u0001V!\t)d+\u0003\u0002Xm\tA\u0011i\u0019;peJ+g\r\u0003\u0004Z\u0001\u0001\u0006I!V\u0001\nCJ\u001c\u0007.\u001b<fe\u0002Bqa\u0017\u0001C\u0002\u0013\u0005A+\u0001\tuCN\\GK]1og&$\u0018n\u001c8fe\"1Q\f\u0001Q\u0001\nU\u000b\u0011\u0003^1tWR\u0013\u0018M\\:ji&|g.\u001a:!\u0011\u001dy\u0006A1A\u0005\u0002Q\u000b!C]3d_Z,'/_*va\u0016\u0014h/[:pe\"1\u0011\r\u0001Q\u0001\nU\u000b1C]3d_Z,'/_*va\u0016\u0014h/[:pe\u0002Bqa\u0019\u0001C\u0002\u0013\u0005A+\u0001\u000buCN\\'+Z2pm\u0016\u0014\u0018\u0010T5ti\u0016tWM\u001d\u0005\u0007K\u0002\u0001\u000b\u0011B+\u0002+Q\f7o\u001b*fG>4XM]=MSN$XM\\3sA!)q\r\u0001C\u0001Q\u0006i1\u000f[;uI><h\u000eV1tWN$\u0012!\u001b\t\u0003U6l\u0011a\u001b\u0006\u0002Y\u0006)1oY1mC&\u0011an\u001b\u0002\u0005+:LG\u000f\u000b\u0002gaB\u0011\u0011O^\u0007\u0002e*\u00111\u000f^\u0001\u000bC:tw\u000e^1uS>t'\"A;\u0002\u000b)\fg/\u0019=\n\u0005]\u0014(A\u0003)sK\u0012+7\u000f\u001e:ps\")\u0011\u0010\u0001C\u0001Q\u0006!\u0011N\\5uQ\tA8\u0010\u0005\u0002ry&\u0011QP\u001d\u0002\u000e!>\u001cHoQ8ogR\u0014Xo\u0019;\t\u000b}\u0004A\u0011\u00015\u0002\u0019I,7m\u001c<feR\u000b7o[:\t\r\u0005\r\u0001\u0001\"\u0003i\u0003=\u0019G.Z1o+B$V\u000e\u001d$jY\u0016\u001c\bbBA\u0004\u0001\u0011\u0005\u0011\u0011B\u0001\n_:\u0014VmY8wKJ$2![A\u0006\u0011!\ti!!\u0002A\u0002\u0005=\u0011\u0001\u0002;bg.\u00042aFA\t\u0013\r\t\u0019B\u0001\u0002\u0005)\u0006\u001c8\u000eC\u0004\u0002\u0018\u0001!\t!!\u0007\u0002\r\r\fgnY3m)\u0015I\u00171DA\u001b\u0011!\ti\"!\u0006A\u0002\u0005}\u0011A\u0002;bg.LG\r\u0005\u0003\u0002\"\u0005=b\u0002BA\u0012\u0003W\u00012!!\nl\u001b\t\t9CC\u0002\u0002*1\ta\u0001\u0010:p_Rt\u0014bAA\u0017W\u00061\u0001K]3eK\u001aLA!!\r\u00024\t11\u000b\u001e:j]\u001eT1!!\fl\u0011)\t9$!\u0006\u0011\u0002\u0003\u0007\u0011\u0011H\u0001\u0006M>\u00148-\u001a\t\u0004U\u0006m\u0012bAA\u001fW\n9!i\\8mK\u0006t\u0007bBA!\u0001\u0011\u0005\u00111I\u0001\fCJ\u001c\u0007.\u001b<f/&$\b\u000eF\u0003j\u0003\u000b\n)\u0006\u0003\u0005\u0002\u001e\u0005}\u0002\u0019AA$!\u0011\tI%a\u0014\u000f\u0007]\tY%C\u0002\u0002N\t\tq\u0001]1dW\u0006<W-\u0003\u0003\u0002R\u0005M#A\u0002+bg.LEMC\u0002\u0002N\tA\u0001\"a\u0016\u0002@\u0001\u0007\u0011\u0011L\u0001\u0004[N<\u0007#\u00036\u0002\\\u0005\u001dS+VA0\u0013\r\tif\u001b\u0002\n\rVt7\r^5p]N\u00022A[A1\u0013\r\t\u0019g\u001b\u0002\u0007\u0003:L(+\u001a4\t\u000f\u0005\u001d\u0004\u0001\"\u0003\u0002j\u0005\u00012M]3bi\u0016\u0014V\r]8tSR|'/\u001f\u000b\u0005\u0003W\ni\b\u0005\u0003\u0002n\u0005eTBAA8\u0015\ra\u0013\u0011\u000f\u0006\u0005\u0003g\n)(A\u0002ba&T1!a\u001e\u0007\u0003\u0019\u0001H.^4j]&!\u00111PA8\u0005)\u0011V\r]8tSR|'/\u001f\u0005\t\u0003\u001b\t)\u00071\u0001\u0002\u0010!A\u0011\u0011\u0011\u0001\u0005\u0012\t\t\u0019)A\bde\u0016\fG/\u001a+bg.\f5\r^8s)\r)\u0016Q\u0011\u0005\t\u0003\u001b\ty\b1\u0001\u0002\u0010!11\u0005\u0001C\u0001\u0003\u0013#2![AF\u0011!\ti\"a\"A\u0002\u0005}\u0001bBAH\u0001\u0011\u0005\u0013\u0011S\u0001\ng.L\u0007o\u0015;faN$R![AJ\u0003+C\u0001\"!\b\u0002\u000e\u0002\u0007\u0011q\u0004\u0005\t\u0003/\u000bi\t1\u0001\u0002\u001a\u000691\u000f^3q\u001dJ\u001c\bCBAN\u0003C\u000b)+\u0004\u0002\u0002\u001e*\u0019\u0011q\u0014\n\u0002\tU$\u0018\u000e\\\u0005\u0005\u0003G\u000biJ\u0001\u0003MSN$\bcA\b\u0002(&\u0019\u0011\u0011\u0016\t\u0003\u000f%sG/Z4fe\"A\u0011Q\u0016\u0001!\n\u0013\ty+A\u0007tW&\u00048\u000b^3q!\u0006$\bn\u001d\u000b\u0006S\u0006E\u00161\u0017\u0005\t\u0003;\tY\u000b1\u0001\u0002 !A\u0011qSAV\u0001\u0004\t)\f\u0005\u0004\u00028\u0006}\u0016Q\u0019\b\u0005\u0003s\u000biL\u0004\u0003\u0002&\u0005m\u0016\"\u00017\n\u0007\u000553.\u0003\u0003\u0002B\u0006\r'aA*fc*\u0019\u0011QJ6\u0011\u0007]\t9-C\u0002\u0002J\n\u0011\u0011B\u00117pG.\u0004\u0016\r\u001e5\t\u000f\u00055\u0007\u0001\"\u0003\u0002P\u0006QQ.\u00198bO\u0016\u001cF/\u001a9\u0015\u000b%\f\t.a5\t\u0011\u0005u\u00111\u001aa\u0001\u0003?A\u0001\"!6\u0002L\u0002\u0007\u0011q[\u0001\b[\u0016\u001c8/Y4f!\u0011\tI.a8\u000e\u0005\u0005m'bAAo\u0005\u0005AQ.Z:tC\u001e,7/\u0003\u0003\u0002b\u0006m'aC'pI&4\u0017p\u0015;faND\u0001\"!:\u0001\t#\u0011\u0011q]\u0001\u0010Y>|7.\u001e9UCN\\\u0017i\u0019;peR!\u0011\u0011^Ax!\r)\u00141^\u0005\u0004\u0003[4$AD!di>\u00148+\u001a7fGRLwN\u001c\u0005\t\u0003c\f\u0019\u000f1\u0001\u0002 \u0005\t1\u000fC\u0004\u0002v\u0002!I!a>\u0002\u001b%tGO\r\"m_\u000e\\\u0007+\u0019;i)\u0011\t)-!?\t\u0011\u0005m\u00181\u001fa\u0001\u0003K\u000b1b\u001c7e!>\u001c\u0018\u000e^5p]\"9\u0011q \u0001\u0005B\t\u0005\u0011aC;og.L\u0007o\u0015;faN$R!\u001bB\u0002\u0005\u000bA\u0001\"!\b\u0002~\u0002\u0007\u0011q\u0004\u0005\t\u0003/\u000bi\u00101\u0001\u0002\u001a\"A!\u0011\u0002\u0001!\n\u0013\u0011Y!A\bv]N\\\u0017\u000e]*uKB\u0004\u0016\r\u001e5t)\u0015I'Q\u0002B\b\u0011!\tiBa\u0002A\u0002\u0005}\u0001\u0002CAL\u0005\u000f\u0001\r!!.\t\u000f\tM\u0001\u0001\"\u0011\u0003\u0016\u0005a\u0011\r\u001a3QCV\u001cXm\u0015;faR)\u0011Na\u0006\u0003\u001a!A\u0011Q\u0004B\t\u0001\u0004\ty\u0002\u0003\u0005\u0003\u001c\tE\u0001\u0019AAS\u0003!\u0001xn]5uS>t\u0007b\u0002B\n\u0001\u0011\u0005!q\u0004\u000b\u0006S\n\u0005\"1\u0005\u0005\t\u0003;\u0011i\u00021\u0001\u0002 !A!1\u0004B\u000f\u0001\u0004\t)\rC\u0004\u0003\n\u0001!\tAa\n\u0015\u000b%\u0014ICa\u000b\t\u0011\u0005u!Q\u0005a\u0001\u0003?A\u0001\"a&\u0003&\u0001\u0007!Q\u0006\t\u0007\u00037\u000b\t+!2\t\u000f\u00055\u0006\u0001\"\u0001\u00032Q)\u0011Na\r\u00036!A\u0011Q\u0004B\u0018\u0001\u0004\ty\u0002\u0003\u0005\u0002\u0018\n=\u0002\u0019\u0001B\u0017\u0011\u001d\u0011I\u0004\u0001C\u0001\u0005w\tAa\u001d;paR\u0019\u0011N!\u0010\t\u0011\u0005u!q\u0007a\u0001\u0003?AqA!\u0011\u0001\t\u0003\u0011\u0019%A\u0003bE>\u0014H\u000fF\u0002j\u0005\u000bB\u0001\"!\b\u0003@\u0001\u0007\u0011q\u0004\u0005\b\u0005\u0013\u0002A\u0011\u0001B&\u0003\u001d)\u00070Z2vi\u0016$2!\u001bB'\u0011!\tiBa\u0012A\u0002\u0005}\u0001b\u0002B)\u0001\u0011\u0005!1K\u0001\te\u0016$(/[3wKR!\u0011q\u0002B+\u0011!\tiBa\u0014A\u0002\u0005}\u0001b\u0002B-\u0001\u0011\u0005!1L\u0001\tg\u000eDW\rZ;mKR)\u0011N!\u0018\u0003`!A\u0011Q\u0004B,\u0001\u0004\ty\u0002\u0003\u0005\u0003b\t]\u0003\u0019\u0001B2\u0003)\u00198\r[3ek2,\u0017\t\u001e\t\u0005\u0005K\u00129I\u0004\u0003\u0003h\t\u0005e\u0002\u0002B5\u0005wrAAa\u001b\u0003v9!!Q\u000eB9\u001d\u0011\t)Ca\u001c\n\u0003-I1Aa\u001d\u000b\u0003\u00199\u0017\u000e\u001e5vE&!!q\u000fB=\u0003-q7oY1mC~#\u0018.\\3\u000b\u0007\tM$\"\u0003\u0003\u0003~\t}\u0014\u0001\u0002;j[\u0016TAAa\u001e\u0003z%!!1\u0011BC\u0003\u001dIU\u000e]8siNTAA! \u0003\u0000%!!\u0011\u0012BF\u0005!!\u0015\r^3US6,\u0017\u0002\u0002BG\u0005\u000b\u00131\u0002V=qK&k\u0007o\u001c:ug\"9!\u0011\u0013\u0001\u0005\u0002\tM\u0015\u0001\u0003:fO&\u001cH/\u001a:\u0015\t\u0005}!Q\u0013\u0005\t\u0005/\u0013y\t1\u0001\u0003\u001a\u0006!1\u000f]3d!\r9\"1T\u0005\u0004\u0005;\u0013!!\u0005+bg.\u001c\u0006/Z2jM&\u001c\u0017\r^5p]\"9!\u0011\u0015\u0001\u0005\u0002\t\r\u0016!F4fi\u0006cG.\u00138d_6\u0004H.\u001a;f)\u0006\u001c8n\u001d\u000b\u0003\u0005K\u0003b!a'\u0002\"\u0006=\u0001b\u0002BU\u0001\u0011\u0005!1V\u0001\nO\u0016$8+_:uK6$\u0012\u0001\u000e\u0005\n\u0005_\u0003\u0011\u0013!C\u0001\u0005c\u000b\u0001cY1oG\u0016dG\u0005Z3gCVdG\u000f\n\u001a\u0016\u0005\tM&\u0006BA\u001d\u0005k[#Aa.\u0011\t\te&\u0011Y\u0007\u0003\u0005wSAA!0\u0003@\u0006IQO\\2iK\u000e\\W\r\u001a\u0006\u0003g.LAAa1\u0003<\n\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3")
public class TaskExecutionEngine
implements IEngine,
Logging {
    private final RepositoryFactory repositoryFactory;
    private final ActorSystem system;
    private final TaskerSettings taskerSettings;
    private final ActorRef archiver;
    private final ActorRef taskTransitioner;
    private final ActorRef recoverySupervisor;
    private final ActorRef taskRecoveryListener;
    private Logger grizzled$slf4j$Logging$$_logger;
    private volatile boolean bitmap$0;

    public Logger logger() {
        return Logging.logger$((Logging)this);
    }

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void trace(Function0<Object> msg) {
        Logging.trace$((Logging)this, msg);
    }

    public void trace(Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, msg, t);
    }

    public void trace(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$((Logging)this);
    }

    public void debug(Function0<Object> msg) {
        Logging.debug$((Logging)this, msg);
    }

    public void debug(Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, msg, t);
    }

    public void debug(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isErrorEnabled() {
        return Logging.isErrorEnabled$((Logging)this);
    }

    public void error(Function0<Object> msg) {
        Logging.error$((Logging)this, msg);
    }

    public void error(Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, msg, t);
    }

    public void error(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isInfoEnabled() {
        return Logging.isInfoEnabled$((Logging)this);
    }

    public void info(Function0<Object> msg) {
        Logging.info$((Logging)this, msg);
    }

    public void info(Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, msg, t);
    }

    public void info(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isWarnEnabled() {
        return Logging.isWarnEnabled$((Logging)this);
    }

    public void warn(Function0<Object> msg) {
        Logging.warn$((Logging)this, msg);
    }

    public void warn(Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, msg, t);
    }

    public void warn(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, (Marker)mkr, msg, t);
    }

    @Override
    public void cancel(String taskid) {
        IEngine.super.cancel(taskid);
    }

    private Logger grizzled$slf4j$Logging$$_logger$lzycompute() {
        TaskExecutionEngine taskExecutionEngine = this;
        synchronized (taskExecutionEngine) {
            if (!this.bitmap$0) {
                this.grizzled$slf4j$Logging$$_logger = Logging.grizzled$slf4j$Logging$$_logger$((Logging)this);
                this.bitmap$0 = true;
            }
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    public Logger grizzled$slf4j$Logging$$_logger() {
        return !this.bitmap$0 ? this.grizzled$slf4j$Logging$$_logger$lzycompute() : this.grizzled$slf4j$Logging$$_logger;
    }

    public ActorSystem system() {
        return this.system;
    }

    public TaskerSettings taskerSettings() {
        return this.taskerSettings;
    }

    public ActorRef archiver() {
        return this.archiver;
    }

    public ActorRef taskTransitioner() {
        return this.taskTransitioner;
    }

    public ActorRef recoverySupervisor() {
        return this.recoverySupervisor;
    }

    public ActorRef taskRecoveryListener() {
        return this.taskRecoveryListener;
    }

    @Override
    @PreDestroy
    public void shutdownTasks() {
        ((IterableLike)((TaskRegistryExtension)TaskRegistryExtension$.MODULE$.apply(this.system())).getTasks().filter((Function1 & Serializable & scala.Serializable)t -> BoxesRunTime.boxToBoolean((boolean)TaskExecutionEngine.$anonfun$shutdownTasks$1(t)))).foreach((Function1 & Serializable & scala.Serializable)t -> {
            TaskExecutionEngine.$anonfun$shutdownTasks$2(this, t);
            return BoxedUnit.UNIT;
        });
        Await$.MODULE$.ready((Awaitable)this.system().terminate(), (Duration)this.taskerSettings().shutdownTimeout());
    }

    @PostConstruct
    public void init() {
        ActiveTasksQueue$.MODULE$.apply(this.system());
        this.recoverTasks();
    }

    @Override
    public void recoverTasks() {
        this.cleanUpTmpFiles();
        try {
            Timeout timeout = this.taskerSettings().askTimeout();
            ActorRef qual$2 = akka.pattern.package$.MODULE$.ask(this.recoverySupervisor());
            RecoverySupervisorActor$ReadAll$ x$6 = RecoverySupervisorActor$ReadAll$.MODULE$;
            Timeout x$7 = timeout;
            ActorRef x$8 = AskableActorRef$.MODULE$.$qmark$default$3$extension(qual$2, (Object)x$6);
            Task[] tasks = ((RecoverySupervisorActor.Tasks)Await$.MODULE$.result((Awaitable)AskableActorRef$.MODULE$.$qmark$extension1(qual$2, (Object)x$6, x$7, x$8), (Duration)timeout.duration())).tasks();
            new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])tasks)).foreach((Function1 & Serializable & scala.Serializable)task -> Try$.MODULE$.apply((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.onRecover((Task)task)).recover((PartialFunction)new scala.Serializable(this){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ TaskExecutionEngine $outer;

                public final <A1 extends Throwable, B1> B1 applyOrElse(A1 x2, Function1<A1, B1> function1) {
                    Object object;
                    A1 A1 = x2;
                    if (A1 instanceof Exception) {
                        Exception exception = (Exception)A1;
                        this.$outer.error((Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> "Error while recovering tasks.", (Function0<Throwable>)(Function0 & Serializable & scala.Serializable)() -> exception);
                        object = BoxedUnit.UNIT;
                    } else {
                        object = function1.apply(x2);
                    }
                    return (B1)object;
                }

                public final boolean isDefinedAt(Throwable x2) {
                    Throwable throwable = x2;
                    boolean bl = throwable instanceof Exception;
                    return bl;
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                }

                private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                    return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$applyOrElse$1(), $anonfun$applyOrElse$2(java.lang.Exception )}, serializedLambda);
                }
            }));
        }
        catch (Exception e) {
            this.error((Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> "Error while recovering.", (Function0<Throwable>)(Function0 & Serializable & scala.Serializable)() -> e);
        }
    }

    private void cleanUpTmpFiles() {
        File[] tmpFiles = this.taskerSettings().recoveryDir().listFiles(new FileFilter(null){

            public boolean accept(File pathname) {
                return pathname.getName().endsWith(".task.tmp");
            }
        });
        ((List)Option$.MODULE$.apply((Object)tmpFiles).toList().flatten((Function1 & Serializable & scala.Serializable)xs -> new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])xs)))).foreach((Function1 & Serializable & scala.Serializable)file -> {
            TaskExecutionEngine.$anonfun$cleanUpTmpFiles$2(this, file);
            return BoxedUnit.UNIT;
        });
    }

    public void onRecover(Task task) {
        block0: {
            task.context().repository_$eq(this.createRepository(task));
            Timeout timeout = this.taskerSettings().askTimeout();
            ActorRef qual$3 = akka.pattern.package$.MODULE$.ask(this.createTaskActor(task));
            TaskManagingActor.messages.Recovered x$9 = new TaskManagingActor.messages.Recovered(task);
            Timeout x$10 = timeout;
            ActorRef x$11 = AskableActorRef$.MODULE$.$qmark$default$3$extension(qual$3, (Object)x$9);
            Await$.MODULE$.ready((Awaitable)AskableActorRef$.MODULE$.$qmark$extension1(qual$3, (Object)x$9, x$10, x$11), (Duration)timeout.duration());
            if (!task.cancelling()) break block0;
            this.cancel(task.getId());
        }
    }

    @Override
    public void cancel(String taskid, boolean force) {
        this.archiveWith(taskid, (Function3<String, ActorRef, ActorRef, Object>)(Function3 & Serializable & scala.Serializable)(x$1, x$2, x$3) -> new TaskManagingActor.messages.Cancel((String)x$1, (ActorRef)x$2, (ActorRef)x$3, RunMode$.MODULE$.withForce(force)));
    }

    public boolean cancel$default$2() {
        return false;
    }

    public void archiveWith(String taskid, Function3<String, ActorRef, ActorRef, Object> msg) {
        Promise p = Promise$.MODULE$.apply();
        ActorRef listener = this.system().actorOf(ArchivedListeningActor$.MODULE$.props(taskid, (Promise<String>)p));
        Object message = msg.apply((Object)taskid, (Object)this.archiver(), (Object)listener);
        ActorSelection taskActor = this.lookupTaskActor(taskid);
        ScalaActorRef qual$4 = package$.MODULE$.actorRef2Scala(listener);
        ArchivedListeningActor.Forward x$12 = new ArchivedListeningActor.Forward(taskActor, message);
        ActorRef x$13 = qual$4.$bang$default$2((Object)x$12);
        qual$4.$bang((Object)x$12, x$13);
        Await$.MODULE$.ready((Awaitable)p.future(), (Duration)Duration$.MODULE$.Inf());
        this.system().stop(listener);
        Try try_ = (Try)p.future().value().get();
        if (try_ instanceof Failure) {
            Failure failure = (Failure)try_;
            Throwable ex = failure.exception();
            throw ex;
        }
        if (!(try_ instanceof Success)) {
            throw new MatchError((Object)try_);
        }
        Success success = (Success)try_;
        String taskId = (String)success.value();
        this.debug((Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Task ", " successfully archived."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{taskId})));
        ((TaskRegistryExtension)TaskRegistryExtension$.MODULE$.apply(this.system())).deleteTask(taskid);
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    private Repository createRepository(Task task) {
        return this.repositoryFactory.create(new File(task.getWorkDir().getPath()));
    }

    public ActorRef createTaskActor(Task task) {
        return this.system().actorOf(TaskManagingActor$.MODULE$.props(task), task.getId());
    }

    @Override
    public void archive(String taskid) {
        this.archiveWith(taskid, (Function3<String, ActorRef, ActorRef, Object>)(Function3 & Serializable & scala.Serializable)(taskId, archiveActor, notificationActor) -> new TaskManagingActor.messages.ArchiveTask((String)taskId, (ActorRef)archiveActor, (ActorRef)notificationActor));
    }

    @Override
    public void skipSteps(String taskid, java.util.List<Integer> stepNrs) {
        this.skipStepPaths(taskid, (Seq<BlockPath>)((Seq)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(stepNrs).asScala()).map((Function1 & Serializable & scala.Serializable)oldPosition -> this.int2BlockPath((Integer)oldPosition), Buffer$.MODULE$.canBuildFrom())));
    }

    private void skipStepPaths(String taskid, Seq<BlockPath> stepNrs) {
        this.manageStep(taskid, new SkipSteps(taskid, stepNrs));
    }

    private void manageStep(String taskid, ModifySteps message) {
        ActorRef x$16;
        Timeout x$15;
        ModifySteps x$14;
        Timeout timeout = ((CommonSettings)CommonSettings$.MODULE$.apply(this.system())).satellite().remoteAskTimeout();
        ActorSelection qual$5 = akka.pattern.package$.MODULE$.ask(this.lookupTaskActor(taskid));
        Object object = Await$.MODULE$.result((Awaitable)AskableActorSelection$.MODULE$.$qmark$extension1(qual$5, (Object)(x$14 = message), x$15 = timeout, x$16 = AskableActorSelection$.MODULE$.$qmark$default$3$extension(qual$5, (Object)x$14)), (Duration)timeout.duration());
        if (object instanceof StepModificationError) {
            StepModificationError stepModificationError = (StepModificationError)object;
            throw new TaskerException(stepModificationError.msg());
        }
        if (object instanceof PathsNotFound) {
            PathsNotFound pathsNotFound = (PathsNotFound)object;
            Seq<BlockPath> paths = pathsNotFound.paths();
            throw new TaskerException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Cannot find a path to add a pause step at the position ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{paths})));
        }
        if (object instanceof ActorNotFound) {
            throw new RuntimeException("Probably connection to satellite is lost");
        }
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public ActorSelection lookupTaskActor(String s) {
        return this.system().actorSelection(this.system().child(s));
    }

    private BlockPath int2BlockPath(Integer oldPosition) {
        return BlockPath$Root$.MODULE$.$div(1).$div(1).$div(Predef$.MODULE$.Integer2int(oldPosition));
    }

    @Override
    public void unskipSteps(String taskid, java.util.List<Integer> stepNrs) {
        this.unskipStepPaths(taskid, (Seq<BlockPath>)((Seq)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(stepNrs).asScala()).map((Function1 & Serializable & scala.Serializable)oldPosition -> this.int2BlockPath((Integer)oldPosition), Buffer$.MODULE$.canBuildFrom())));
    }

    private void unskipStepPaths(String taskid, Seq<BlockPath> stepNrs) {
        this.manageStep(taskid, new UnSkipSteps(taskid, stepNrs));
    }

    @Override
    public void addPauseStep(String taskid, Integer position) {
        this.addPauseStep(taskid, this.int2BlockPath(position));
    }

    @Override
    public void addPauseStep(String taskid, BlockPath position) {
        this.manageStep(taskid, new AddPauseStep(taskid, position));
    }

    @Override
    public void unskipStepPaths(String taskid, java.util.List<BlockPath> stepNrs) {
        this.unskipStepPaths(taskid, (Seq<BlockPath>)((Seq)JavaConverters$.MODULE$.asScalaBufferConverter(stepNrs).asScala()));
    }

    @Override
    public void skipStepPaths(String taskid, java.util.List<BlockPath> stepNrs) {
        this.skipStepPaths(taskid, (Seq<BlockPath>)((Seq)JavaConverters$.MODULE$.asScalaBufferConverter(stepNrs).asScala()));
    }

    @Override
    public void stop(String taskid) {
        ScalaActorSelection qual$6 = ActorSelection$.MODULE$.toScala(this.lookupTaskActor(taskid));
        Stop x$17 = new Stop(taskid);
        ActorRef x$18 = qual$6.$bang$default$2((Object)x$17);
        qual$6.$bang((Object)x$17, x$18);
    }

    @Override
    public void abort(String taskid) {
        ScalaActorSelection qual$7 = ActorSelection$.MODULE$.toScala(this.lookupTaskActor(taskid));
        Abort x$19 = new Abort(taskid);
        ActorRef x$20 = qual$7.$bang$default$2((Object)x$19);
        qual$7.$bang((Object)x$19, x$20);
    }

    @Override
    public void execute(String taskid) {
        Task task = this.retrieve(taskid);
        task.setState(TaskExecutionState.QUEUED);
        ScalaActorSelection qual$8 = ActorSelection$.MODULE$.toScala(this.lookupTaskActor(taskid));
        Enqueue x$21 = new Enqueue(taskid);
        ActorRef x$22 = qual$8.$bang$default$2((Object)x$21);
        qual$8.$bang((Object)x$21, x$22);
    }

    @Override
    public Task retrieve(String taskid) {
        return (Task)((TaskRegistryExtension)TaskRegistryExtension$.MODULE$.apply(this.system())).getTask(taskid).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            throw new TaskNotFoundException("registry", taskid);
        });
    }

    @Override
    public void schedule(String taskid, DateTime scheduleAt) {
        long tickMillis;
        if (scheduleAt.isBeforeNow()) {
            throw new TaskerException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Cannot schedule a task for the past, date entered was [", ", now is [", "]"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{TaskExecutionEngine.p$1(scheduleAt), TaskExecutionEngine.p$1(Imports$.MODULE$.DateTime().now())})));
        }
        long delayMillis = RichReadableInterval$.MODULE$.millis$extension(Imports$.MODULE$.richReadableInterval((ReadableInterval)RichReadableInstant$.MODULE$.to$extension(Imports$.MODULE$.richReadableInstant((ReadableInstant)Imports$.MODULE$.DateTime().now()), (ReadableInstant)scheduleAt)));
        if (delayMillis > (long)Integer.MAX_VALUE * (tickMillis = this.taskerSettings().tickDuration().toMillis())) {
            DateTime time = new DateTime((Object)RichDateTime$.MODULE$.millis$extension(Imports$.MODULE$.richDateTime(Imports$.MODULE$.DateTime().now())).addToCopy(tickMillis * Integer.MAX_VALUE));
            throw new TaskerException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Cannot schedule task [", "] at [", "], because it is too far into the future. Can only schedule to [", "]"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{taskid, TaskExecutionEngine.p$1(scheduleAt), TaskExecutionEngine.p$1(time)})));
        }
        ScalaActorSelection qual$9 = ActorSelection$.MODULE$.toScala(this.lookupTaskActor(taskid));
        TaskManagingActor.messages.Schedule x$23 = new TaskManagingActor.messages.Schedule(taskid, scheduleAt);
        ActorRef x$24 = qual$9.$bang$default$2((Object)x$23);
        qual$9.$bang((Object)x$23, x$24);
    }

    @Override
    public String register(TaskSpecification spec) {
        Task task = new Task(spec.getId(), spec);
        task.context().repository_$eq(this.createRepository(task));
        Timeout timeout = this.taskerSettings().askTimeout();
        ActorRef qual$10 = akka.pattern.package$.MODULE$.ask(this.createTaskActor(task));
        TaskManagingActor.messages.Register x$25 = new TaskManagingActor.messages.Register(task);
        Timeout x$26 = timeout;
        ActorRef x$27 = AskableActorRef$.MODULE$.$qmark$default$3$extension(qual$10, (Object)x$25);
        Await$.MODULE$.ready((Awaitable)AskableActorRef$.MODULE$.$qmark$extension1(qual$10, (Object)x$25, x$26, x$27), (Duration)timeout.duration());
        return task.getId();
    }

    @Override
    public java.util.List<Task> getAllIncompleteTasks() {
        return (java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter(((TaskRegistryExtension)TaskRegistryExtension$.MODULE$.apply(this.system())).getTasks()).asJava();
    }

    @Override
    public ActorSystem getSystem() {
        return this.system();
    }

    public static final /* synthetic */ boolean $anonfun$shutdownTasks$1(Task t) {
        return ((SetLike)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TaskExecutionState[]{TaskExecutionState.ABORTING, TaskExecutionState.EXECUTING, TaskExecutionState.FAILING, TaskExecutionState.STOPPING}))).contains((Object)t.getState());
    }

    public static final /* synthetic */ void $anonfun$shutdownTasks$2(TaskExecutionEngine $this, Task t) {
        $this.info((Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Stopping task [", "] due to shutdown"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{t.getId()})));
        ScalaActorSelection qual$1 = ActorSelection$.MODULE$.toScala($this.lookupTaskActor(t.getId()));
        Stop$ x$4 = Stop$.MODULE$;
        ActorRef x$5 = qual$1.$bang$default$2((Object)x$4);
        qual$1.$bang((Object)x$4, x$5);
        Promise promise = Promise$.MODULE$.apply();
        $this.system().actorOf(Props$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> new Actor(null, promise, t){
            private final ActorContext context;
            private final ActorRef self;
            public final Promise promise$1;
            public final Task t$1;

            public final ActorRef sender() {
                return Actor.sender$((Actor)this);
            }

            @InternalApi
            public void aroundReceive(PartialFunction<Object, BoxedUnit> receive2, Object msg) {
                Actor.aroundReceive$((Actor)this, receive2, (Object)msg);
            }

            @InternalApi
            public void aroundPreStart() {
                Actor.aroundPreStart$((Actor)this);
            }

            @InternalApi
            public void aroundPostStop() {
                Actor.aroundPostStop$((Actor)this);
            }

            @InternalApi
            public void aroundPreRestart(Throwable reason, Option<Object> message) {
                Actor.aroundPreRestart$((Actor)this, (Throwable)reason, message);
            }

            @InternalApi
            public void aroundPostRestart(Throwable reason) {
                Actor.aroundPostRestart$((Actor)this, (Throwable)reason);
            }

            public SupervisorStrategy supervisorStrategy() {
                return Actor.supervisorStrategy$((Actor)this);
            }

            public void preStart() throws Exception {
                Actor.preStart$((Actor)this);
            }

            public void postStop() throws Exception {
                Actor.postStop$((Actor)this);
            }

            public void preRestart(Throwable reason, Option<Object> message) throws Exception {
                Actor.preRestart$((Actor)this, (Throwable)reason, message);
            }

            public void postRestart(Throwable reason) throws Exception {
                Actor.postRestart$((Actor)this, (Throwable)reason);
            }

            public void unhandled(Object message) {
                Actor.unhandled$((Actor)this, (Object)message);
            }

            public ActorContext context() {
                return this.context;
            }

            public final ActorRef self() {
                return this.self;
            }

            public void akka$actor$Actor$_setter_$context_$eq(ActorContext x$1) {
                this.context = x$1;
            }

            public final void akka$actor$Actor$_setter_$self_$eq(ActorRef x$1) {
                this.self = x$1;
            }

            public PartialFunction<Object, BoxedUnit> receive() {
                return new scala.Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anon$1 $outer;

                    /*
                     * Enabled aggressive block sorting
                     */
                    public final <A1, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                        Object object;
                        A1 A1 = x1;
                        if (A1 instanceof TaskDone) {
                            TaskDone taskDone = (TaskDone)A1;
                            Task doneTask = taskDone.task();
                            String string = doneTask.getId();
                            String string2 = this.$outer.t$1.getId();
                            if (!(string != null ? !string.equals(string2) : string2 != null)) {
                                this.$outer.promise$1.success((Object)doneTask.getId());
                                object = BoxedUnit.UNIT;
                                return (B1)object;
                            }
                        }
                        object = function1.apply(x1);
                        return (B1)object;
                    }

                    /*
                     * Enabled force condition propagation
                     * Lifted jumps to return sites
                     */
                    public final boolean isDefinedAt(Object x1) {
                        Object object = x1;
                        if (!(object instanceof TaskDone)) return false;
                        TaskDone taskDone = (TaskDone)object;
                        Task doneTask = taskDone.task();
                        String string = doneTask.getId();
                        String string2 = this.$outer.t$1.getId();
                        if (string != null) {
                            if (!string.equals(string2)) return false;
                            return true;
                        }
                        if (string2 == null) return true;
                        return false;
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                };
            }
            {
                this.promise$1 = promise$1;
                this.t$1 = t$1;
                Actor.$init$((Actor)this);
            }
        }, ClassTag$.MODULE$.apply(Actor.class)));
        Try try_ = Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> (String)Await$.MODULE$.result((Awaitable)promise.future(), (Duration)new package.DurationInt(scala.concurrent.duration.package$.MODULE$.DurationInt(10)).seconds()));
        if (try_ instanceof Failure) {
            Failure failure = (Failure)try_;
            Throwable exception = failure.exception();
            $this.warn((Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Failed to stop task [", "]"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{t.getId()})), (Function0<Throwable>)(Function0 & Serializable & scala.Serializable)() -> exception);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (try_ instanceof Success) {
            Success success = (Success)try_;
            String value = (String)success.value();
            $this.info((Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Successfully stopped task [", "]"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{value})));
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            throw new MatchError((Object)try_);
        }
    }

    public static final /* synthetic */ void $anonfun$cleanUpTmpFiles$2(TaskExecutionEngine $this, File file) {
        try {
            $this.warn((Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Deleting corrupted task file: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{file.getAbsolutePath()})));
            Files.delete(file.toPath());
        }
        catch (Throwable e) {
            $this.error((Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Unable to delete corrupted recovery file: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{file.getAbsolutePath()})), (Function0<Throwable>)(Function0 & Serializable & scala.Serializable)() -> e);
        }
    }

    private static final String p$1(DateTime d) {
        return d.toString("yyyy-MM-dd HH:mm:ss Z");
    }

    public TaskExecutionEngine(Archive archive, RepositoryFactory repositoryFactory, ActorSystem system) {
        this.repositoryFactory = repositoryFactory;
        this.system = system;
        Logging.$init$((Logging)this);
        this.taskerSettings = ((CommonSettings)CommonSettings$.MODULE$.apply(system)).tasker();
        this.archiver = system.actorOf(ArchiveActor$.MODULE$.props(archive), ArchiveActor$.MODULE$.name());
        this.taskTransitioner = system.actorOf(TaskTransitionActor$.MODULE$.props(this), TaskTransitionActor$.MODULE$.name());
        this.recoverySupervisor = system.actorOf(RecoverySupervisorActor$.MODULE$.props(this.taskerSettings().recoveryDir()), RecoverySupervisorActor$.MODULE$.name());
        this.taskRecoveryListener = system.actorOf(TaskRecoveryListener$.MODULE$.props(this.recoverySupervisor()), TaskRecoveryListener$.MODULE$.name());
    }
}

