/*
 * Decompiled with CFR 0.152.
 */
package org.joda.convert.factory;

import java.util.Arrays;
import java.util.regex.Pattern;
import org.joda.convert.StringConverter;
import org.joda.convert.StringConverterFactory;
import org.joda.convert.TypedStringConverter;

public final class CharObjectArrayStringConverterFactory
implements StringConverterFactory {
    public static final StringConverterFactory INSTANCE = new CharObjectArrayStringConverterFactory();
    static final Pattern DELIMITER = Pattern.compile("[,]");

    private CharObjectArrayStringConverterFactory() {
    }

    @Override
    public StringConverter<?> findConverter(Class<?> cls) {
        if (cls == Character[].class) {
            return CharecterArrayStringConverter.INSTANCE;
        }
        return null;
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }

    static enum CharecterArrayStringConverter implements TypedStringConverter<Character[]>
    {
        INSTANCE{

            @Override
            public String convertToString(Character[] array) {
                if (array.length == 0) {
                    return "";
                }
                StringBuilder buf = new StringBuilder(array.length * 8);
                for (int i = 0; i < array.length; ++i) {
                    if (array[i] == null) {
                        buf.append("\\-");
                        continue;
                    }
                    char ch = array[i].charValue();
                    if (ch == '\\') {
                        buf.append("\\\\");
                        continue;
                    }
                    buf.append(ch);
                }
                return buf.toString();
            }

            @Override
            public Character[] convertFromString(Class<? extends Character[]> cls, String str) {
                int i;
                int pos;
                if (str.length() == 0) {
                    return EMPTY;
                }
                Character[] array = new Character[str.length()];
                int arrayPos = 0;
                while ((pos = str.indexOf(92)) >= 0) {
                    for (i = 0; i < pos; ++i) {
                        array[arrayPos++] = Character.valueOf(str.charAt(i));
                    }
                    if (str.charAt(pos + 1) == '\\') {
                        array[arrayPos++] = Character.valueOf('\\');
                    } else if (str.charAt(pos + 1) == '-') {
                        array[arrayPos++] = null;
                    } else {
                        throw new IllegalArgumentException("Invalid Character[] string, incorrect escape");
                    }
                    str = str.substring(pos + 2);
                }
                for (i = 0; i < str.length(); ++i) {
                    array[arrayPos++] = Character.valueOf(str.charAt(i));
                }
                return Arrays.copyOf(array, arrayPos);
            }

            @Override
            public Class<?> getEffectiveType() {
                return Character[].class;
            }
        };

        private static final Character[] EMPTY;

        static {
            EMPTY = new Character[0];
        }
    }
}

