/*
 * Decompiled with CFR 0.152.
 */
package org.rzo.netty.ahessian.bootstrap;

import io.netty.bootstrap.AbstractBootstrap;
import io.netty.bootstrap.ServerBootstrap;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.ServerChannel;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.oio.OioEventLoopGroup;
import io.netty.util.concurrent.DefaultEventExecutorGroup;
import io.netty.util.concurrent.EventExecutorGroup;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.Set;
import org.rzo.netty.ahessian.bootstrap.ChannelPipelineFactory;
import org.rzo.netty.ahessian.bootstrap.ChannelPipelineFactoryFactory;
import org.rzo.netty.ahessian.bootstrap.DefaultEndpoint;

public class DefaultServer
extends DefaultEndpoint {
    ServerBootstrap bootstrap;
    EventLoopGroup bossGroup;
    EventLoopGroup childGroup;
    EventExecutorGroup internalGroup;
    int _port;
    private static final int IPTOS_THROUGHPUT = 8;
    private static final int IPTOS_LOWDELAY = 16;

    public DefaultServer(Class serverChannelClass, ChannelPipelineFactoryFactory factory, Set<String> channelOptions, int port) {
        if (!ServerChannel.class.isAssignableFrom(serverChannelClass)) {
            throw new RuntimeException("serverChannelClass must implement ServerChannel");
        }
        this.bootstrap = new ServerBootstrap();
        this._port = port;
        this.internalGroup = new DefaultEventExecutorGroup(10);
        if (this.isNio(serverChannelClass)) {
            this.bossGroup = new NioEventLoopGroup();
            this.childGroup = new NioEventLoopGroup();
        } else if (this.isOio(serverChannelClass)) {
            this.bossGroup = new OioEventLoopGroup();
            this.childGroup = new OioEventLoopGroup();
        } else {
            this.bossGroup = new NioEventLoopGroup();
            this.childGroup = new NioEventLoopGroup();
        }
        this.bootstrap.group(this.bossGroup, this.childGroup);
        this.bootstrap.channel(serverChannelClass);
        this.setChannelOptions(channelOptions);
        this.bootstrap.option(ChannelOption.SO_BACKLOG, (Object)100);
        ChannelPipelineFactory channelPipelineFactory = factory.create(this.internalGroup, (AbstractBootstrap)this.bootstrap);
        this.bootstrap.childHandler((ChannelHandler)channelPipelineFactory);
    }

    private void setChannelOptions(Set<String> channelOptions) {
        if (channelOptions == null) {
            return;
        }
        if (channelOptions.contains("IPTOS_THROUGHPUT")) {
            this.bootstrap.childOption(ChannelOption.IP_TOS, (Object)8);
        } else if (channelOptions.contains("IPTOS_LOWDELAY")) {
            this.bootstrap.childOption(ChannelOption.IP_TOS, (Object)16);
        } else if (channelOptions.contains("TCP_NODELAY")) {
            this.bootstrap.childOption(ChannelOption.TCP_NODELAY, (Object)true);
        } else if (channelOptions.contains("SO_REUSE")) {
            this.bootstrap.childOption(ChannelOption.SO_REUSEADDR, (Object)true);
        }
    }

    @Override
    public void start() throws Exception {
        this._channel = this.bootstrap.bind((SocketAddress)new InetSocketAddress(this._port)).sync().channel();
    }

    @Override
    void stop() throws Exception {
        this.getChannel().close().sync();
        this.bossGroup.shutdownGracefully();
        this.childGroup.shutdownGracefully();
    }
}

