/*
 * Decompiled with CFR 0.152.
 */
package org.python.icu.text;

import java.text.CharacterIterator;
import org.python.icu.text.DictionaryMatcher;
import org.python.icu.text.UCharacterIterator;
import org.python.icu.util.BytesTrie;
import org.python.icu.util.CharsTrie;

class CharsDictionaryMatcher
extends DictionaryMatcher {
    private CharSequence characters;

    public CharsDictionaryMatcher(CharSequence chars) {
        this.characters = chars;
    }

    @Override
    public int matches(CharacterIterator text_, int maxLength, int[] lengths, int[] count_, int limit, int[] values) {
        UCharacterIterator text2 = UCharacterIterator.getInstance(text_);
        CharsTrie uct = new CharsTrie(this.characters, 0);
        int c = text2.nextCodePoint();
        if (c == -1) {
            return 0;
        }
        BytesTrie.Result result2 = uct.firstForCodePoint(c);
        int numChars = 1;
        int count2 = 0;
        while (true) {
            if (result2.hasValue()) {
                if (count2 < limit) {
                    if (values != null) {
                        values[count2] = uct.getValue();
                    }
                    lengths[count2] = numChars;
                    ++count2;
                }
                if (result2 == BytesTrie.Result.FINAL_VALUE) {
                    break;
                }
            } else if (result2 == BytesTrie.Result.NO_MATCH) break;
            if (numChars >= maxLength || (c = text2.nextCodePoint()) == -1) break;
            ++numChars;
            result2 = uct.nextForCodePoint(c);
        }
        count_[0] = count2;
        return numChars;
    }

    @Override
    public int getType() {
        return 1;
    }
}

