/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.session;

import javax.jcr.RepositoryException;
import org.apache.jackrabbit.core.ItemImpl;
import org.apache.jackrabbit.core.id.NodeId;
import org.apache.jackrabbit.core.session.SessionContext;
import org.apache.jackrabbit.core.session.SessionWriteOperation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SessionSaveOperation
implements SessionWriteOperation<Object> {
    private static final Logger LOG = LoggerFactory.getLogger(SessionSaveOperation.class);
    private static final boolean LOG_WITH_STACKTRACE = Boolean.getBoolean("org.jackrabbit.logWithStackTrace");

    @Override
    public Object perform(SessionContext context) throws RepositoryException {
        NodeId id = context.getSessionImpl().hasPermission("/", "read") ? context.getRootNodeId() : context.getItemStateManager().getIdOfRootTransientNodeState();
        if (LOG.isDebugEnabled()) {
            String path;
            try {
                NodeId transientRoot = context.getItemStateManager().getIdOfRootTransientNodeState();
                ItemImpl item = context.getItemManager().getItem(transientRoot);
                path = item.getPath();
            }
            catch (Exception e) {
                LOG.warn("Could not get the path", (Throwable)e);
                path = "?";
            }
            if (LOG_WITH_STACKTRACE) {
                LOG.debug("Saving changes under " + path, (Throwable)new Exception());
            } else {
                LOG.debug("Saving changes under " + path);
            }
        }
        if (id != null) {
            context.getItemManager().getItem(id).save();
        }
        return this;
    }

    public String toString() {
        return "session.save()";
    }
}

