/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.overthere.local;

import com.xebialabs.overthere.ConnectionOptions;
import com.xebialabs.overthere.OverthereFile;
import com.xebialabs.overthere.RuntimeIOException;
import com.xebialabs.overthere.local.LocalConnection;
import com.xebialabs.overthere.spi.BaseOverthereFile;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LocalFile
extends BaseOverthereFile<LocalConnection>
implements Serializable {
    protected File file;
    private static Logger logger = LoggerFactory.getLogger(LocalFile.class);

    public LocalFile(LocalConnection connection, File file) {
        super(connection);
        this.file = file;
    }

    @Override
    public final LocalConnection getConnection() {
        if (this.connection == null) {
            this.connection = LocalFile.createConnection();
        }
        return (LocalConnection)this.connection;
    }

    private static LocalConnection createConnection() {
        LocalConnection localConnectionThatWillNeverBeDisconnected = new LocalConnection("local", new ConnectionOptions());
        return localConnectionThatWillNeverBeDisconnected;
    }

    public File getFile() {
        return this.file;
    }

    @Override
    public String getPath() {
        return this.file.getPath();
    }

    @Override
    public String getName() {
        return this.file.getName();
    }

    @Override
    public OverthereFile getParentFile() {
        return this.getConnection().getFile(this.file.getParent());
    }

    @Override
    public long lastModified() {
        return this.file.lastModified();
    }

    @Override
    public long length() {
        return this.file.length();
    }

    @Override
    public boolean exists() {
        return this.file.exists();
    }

    @Override
    public boolean isFile() {
        return this.file.isFile();
    }

    @Override
    public boolean isDirectory() {
        return this.file.isDirectory();
    }

    @Override
    public boolean isHidden() {
        return this.file.isHidden();
    }

    @Override
    public boolean canRead() {
        return this.file.canRead();
    }

    @Override
    public boolean canWrite() {
        return this.file.canWrite();
    }

    @Override
    public boolean canExecute() {
        return this.file.canExecute();
    }

    @Override
    public void setExecutable(boolean executable) {
        logger.debug("Setting execute permission on {} to {}", (Object)this, (Object)executable);
        this.file.setExecutable(executable);
    }

    @Override
    public void delete() {
        logger.debug("Deleting {}", (Object)this);
        if (!this.file.delete()) {
            throw new RuntimeIOException("Cannot delete " + this);
        }
    }

    @Override
    public void mkdir() {
        logger.debug("Creating directory {}", (Object)this);
        if (!this.file.mkdir()) {
            throw new RuntimeIOException("Cannot mkdir " + this);
        }
    }

    @Override
    public void mkdirs() {
        logger.debug("Creating directory {}", (Object)this);
        if (!this.file.mkdirs()) {
            throw new RuntimeIOException("Cannot mkdir " + this);
        }
    }

    @Override
    public List<OverthereFile> listFiles() {
        logger.debug("Listing directory {}", (Object)this);
        ArrayList<OverthereFile> list = new ArrayList<OverthereFile>();
        for (File each : this.file.listFiles()) {
            list.add(new LocalFile((LocalConnection)this.connection, each));
        }
        return list;
    }

    @Override
    protected void shortCircuitCopyFrom(OverthereFile source) {
        this.copyFrom(source);
    }

    @Override
    public void renameTo(OverthereFile dest) {
        logger.debug("Renaming {} to {}", (Object)this, (Object)dest);
        if (!(dest instanceof LocalFile)) {
            throw new RuntimeIOException("Destination is not a " + LocalFile.class.getName());
        }
        if (!this.file.renameTo(((LocalFile)dest).file)) {
            throw new RuntimeIOException("Cannot rename " + this + " to " + dest);
        }
    }

    @Override
    public InputStream getInputStream() {
        logger.debug("Opening file input stream for {}", (Object)this);
        try {
            return this.asBuffered(new FileInputStream(this.file){

                @Override
                public void close() throws IOException {
                    super.close();
                    logger.debug("Closing file input stream for {}", (Object)this);
                }
            });
        }
        catch (FileNotFoundException exc) {
            throw new RuntimeIOException("Cannot open " + this + " for reading", exc);
        }
    }

    @Override
    public OutputStream getOutputStream() {
        logger.debug("Opening file output stream for {}", (Object)this);
        try {
            return this.asBuffered(new FileOutputStream(this.file){

                @Override
                public void close() throws IOException {
                    super.close();
                    logger.debug("Closing file output stream for {}", (Object)this);
                }
            });
        }
        catch (FileNotFoundException exc) {
            throw new RuntimeIOException("Cannot open " + this + " for writing", exc);
        }
    }

    public boolean equals(Object that) {
        if (!(that instanceof LocalFile)) {
            return false;
        }
        return this.file.equals(((LocalFile)that).file);
    }

    public int hashCode() {
        return this.file.hashCode();
    }

    @Override
    public String toString() {
        return "local:" + this.file;
    }

    public static OverthereFile valueOf(File f) {
        return new LocalFile(LocalFile.createConnection(), f);
    }

    public static LocalFile from(File f) {
        return new LocalFile(LocalFile.createConnection(), f);
    }
}

