/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin.api.udm;

import com.xebialabs.deployit.plugin.api.udm.Application;
import com.xebialabs.deployit.plugin.api.udm.Container;
import com.xebialabs.deployit.plugin.api.udm.Metadata;
import com.xebialabs.deployit.plugin.api.udm.Property;
import com.xebialabs.deployit.plugin.api.udm.TypeIcon;
import com.xebialabs.deployit.plugin.api.udm.base.BaseConfigurationItem;
import com.xebialabs.xlplatform.documentation.PublicApiRef;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

@Metadata(root=Metadata.ConfigurationItemRoot.ENVIRONMENTS, description="A Dictionary contains key-value pairs that can be replaced")
@TypeIcon(value="icons/types/udm.Dictionary.svg")
@PublicApiRef
public class Dictionary
extends BaseConfigurationItem {
    @Property(description="The dictionary entries", required=false)
    private Map<String, String> entries = new HashMap<String, String>();
    @Property(description="The encrypted dictionary entries", required=false, password=true)
    private Map<String, String> encryptedEntries = new HashMap<String, String>();
    @Property(required=false, label="Restrict to containers", description="Only apply this dictionary to the containers mentioned", category="Restrictions")
    private Set<Container> restrictToContainers = new HashSet<Container>();
    @Property(required=false, label="Restrict to applications", description="Only apply this dictionary to the applications mentioned", category="Restrictions")
    private Set<Application> restrictToApplications = new HashSet<Application>();

    public void setEntries(Map<String, String> dict) {
        this.entries = dict;
    }

    public Map<String, String> getEntries() {
        return this.entries;
    }

    public Map<String, String> getEncryptedEntries() {
        return this.encryptedEntries;
    }

    public void setEncryptedEntries(Map<String, String> encryptedEntries) {
        this.encryptedEntries = encryptedEntries;
    }

    public String getValue(String key) {
        return this.entries.get(key);
    }

    public boolean hasValue(String key) {
        return this.entries.containsKey(key);
    }

    public Set<Container> getRestrictToContainers() {
        return this.restrictToContainers;
    }

    public Set<Application> getRestrictToApplications() {
        return this.restrictToApplications;
    }

    public Set<Application> getRestrictToDistributions() {
        return this.restrictToApplications;
    }
}

