/*
 * Decompiled with CFR 0.152.
 */
package akka.remote.transport.netty;

import akka.actor.ActorSystem;
import akka.annotation.ApiMayChange;
import akka.event.LogSource$;
import akka.event.Logging$;
import akka.event.MarkerLoggingAdapter;
import akka.remote.RemoteTransportException;
import akka.remote.artery.tcp.SecureRandomFactory$;
import akka.remote.transport.netty.SSLEngineProvider;
import akka.remote.transport.netty.SSLSettings;
import akka.stream.Client$;
import akka.stream.IgnoreComplete$;
import akka.stream.Server$;
import akka.stream.TLSClosing;
import akka.stream.TLSRole;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.SecureRandom;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import scala.Function0;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.java8.JFunction0;
import scala.util.Try$;

@ScalaSignature(bytes="\u0006\u0001\u0005-c\u0001B\u0001\u0003\u0001-\u0011qcQ8oM&<7k\u0015'F]\u001eLg.\u001a)s_ZLG-\u001a:\u000b\u0005\r!\u0011!\u00028fiRL(BA\u0003\u0007\u0003%!(/\u00198ta>\u0014HO\u0003\u0002\b\u0011\u00051!/Z7pi\u0016T\u0011!C\u0001\u0005C.\\\u0017m\u0001\u0001\u0014\u0007\u0001a!\u0003\u0005\u0002\u000e!5\taBC\u0001\u0010\u0003\u0015\u00198-\u00197b\u0013\t\tbB\u0001\u0004B]f\u0014VM\u001a\t\u0003'Qi\u0011AA\u0005\u0003+\t\u0011\u0011cU*M\u000b:<\u0017N\\3Qe>4\u0018\u000eZ3s\u0011!9\u0002A!b\u0001\n#A\u0012a\u00017pOV\t\u0011\u0004\u0005\u0002\u001b;5\t1D\u0003\u0002\u001d\u0011\u0005)QM^3oi&\u0011ad\u0007\u0002\u0015\u001b\u0006\u00148.\u001a:M_\u001e<\u0017N\\4BI\u0006\u0004H/\u001a:\t\u0011\u0001\u0002!\u0011!Q\u0001\ne\tA\u0001\\8hA!A!\u0005\u0001BC\u0002\u0013%1%\u0001\u0005tKR$\u0018N\\4t+\u0005!\u0003CA\n&\u0013\t1#AA\u0006T'2\u001bV\r\u001e;j]\u001e\u001c\b\u0002\u0003\u0015\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u0013\u0002\u0013M,G\u000f^5oON\u0004\u0003\"\u0002\u0016\u0001\t\u0003Y\u0013A\u0002\u001fj]&$h\bF\u0002-[9\u0002\"a\u0005\u0001\t\u000b]I\u0003\u0019A\r\t\u000b\tJ\u0003\u0019\u0001\u0013\t\u000b)\u0002A\u0011\u0001\u0019\u0015\u00051\n\u0004\"\u0002\u001a0\u0001\u0004\u0019\u0014AB:zgR,W\u000e\u0005\u00025o5\tQG\u0003\u00027\u0011\u0005)\u0011m\u0019;pe&\u0011\u0001(\u000e\u0002\f\u0003\u000e$xN]*zgR,W\u000e\u0003\u0005;\u0001!\u0015\r\u0011\"\u0003<\u0003)\u00198\u000f\\\"p]R,\u0007\u0010^\u000b\u0002yA\u0011Q\bR\u0007\u0002})\u0011q\bQ\u0001\u0004gNd'BA!C\u0003\rqW\r\u001e\u0006\u0002\u0007\u0006)!.\u0019<bq&\u0011QI\u0010\u0002\u000b'Nc5i\u001c8uKb$\b\"B$\u0001\t#A\u0015\u0001\u00047pC\u0012\\U-_:u_J,GcA%R=B\u0011!jT\u0007\u0002\u0017*\u0011A*T\u0001\tg\u0016\u001cWO]5us*\ta*\u0001\u0003kCZ\f\u0017B\u0001)L\u0005!YU-_*u_J,\u0007\"\u0002*G\u0001\u0004\u0019\u0016\u0001\u00034jY\u0016t\u0017-\\3\u0011\u0005Q[fBA+Z!\t1f\"D\u0001X\u0015\tA&\"\u0001\u0004=e>|GOP\u0005\u00035:\ta\u0001\u0015:fI\u00164\u0017B\u0001/^\u0005\u0019\u0019FO]5oO*\u0011!L\u0004\u0005\u0006?\u001a\u0003\raU\u0001\ta\u0006\u001c8o^8sI\")\u0011\r\u0001C\tE\u0006Y1.Z=NC:\fw-\u001a:t+\u0005\u0019\u0007cA\u0007eM&\u0011QM\u0004\u0002\u0006\u0003J\u0014\u0018-\u001f\t\u0003{\u001dL!\u0001\u001b \u0003\u0015-+\u00170T1oC\u001e,'\u000fC\u0003k\u0001\u0011E1.A\u0007ueV\u001cH/T1oC\u001e,'o]\u000b\u0002YB\u0019Q\u0002Z7\u0011\u0005ur\u0017BA8?\u00051!&/^:u\u001b\u0006t\u0017mZ3s\u0011\u0015\t\b\u0001\"\u0001s\u0003I\u0019'/Z1uKN+7-\u001e:f%\u0006tGm\\7\u0015\u0003M\u0004\"A\u0013;\n\u0005U\\%\u0001D*fGV\u0014XMU1oI>l\u0007\"B<\u0001\t\u0003B\u0018!F2sK\u0006$XmU3sm\u0016\u00148k\u0015'F]\u001eLg.\u001a\u000b\u0002sB\u0011QH_\u0005\u0003wz\u0012\u0011bU*M\u000b:<\u0017N\\3\t\u000bu\u0004A\u0011\t=\u0002+\r\u0014X-\u0019;f\u00072LWM\u001c;T'2+enZ5oK\"1q\u0010\u0001C\u0005\u0003\u0003\tqb\u0019:fCR,7k\u0015'F]\u001eLg.\u001a\u000b\u0004s\u0006\r\u0001bBA\u0003}\u0002\u0007\u0011qA\u0001\u0005e>dW\r\u0005\u0003\u0002\n\u0005=QBAA\u0006\u0015\r\ti\u0001C\u0001\u0007gR\u0014X-Y7\n\t\u0005E\u00111\u0002\u0002\b)2\u001b&k\u001c7f\u0011\u0019y\b\u0001\"\u0003\u0002\u0016Q9\u00110a\u0006\u0002\u001a\u0005m\u0001B\u0002\u001e\u0002\u0014\u0001\u0007A\b\u0003\u0005\u0002\u0006\u0005M\u0001\u0019AA\u0004\u0011)\ti\"a\u0005\u0011\u0002\u0003\u0007\u0011qD\u0001\bG2|7/\u001b8h!\u0011\tI!!\t\n\t\u0005\r\u00121\u0002\u0002\u000b)2\u001b6\t\\8tS:<\u0007\"CA\u0014\u0001E\u0005I\u0011BA\u0015\u0003e\u0019'/Z1uKN\u001bF*\u00128hS:,G\u0005Z3gCVdG\u000fJ\u001a\u0016\u0005\u0005-\"\u0006BA\u0010\u0003[Y#!a\f\u0011\t\u0005E\u00121H\u0007\u0003\u0003gQA!!\u000e\u00028\u0005IQO\\2iK\u000e\\W\r\u001a\u0006\u0004\u0003sq\u0011AC1o]>$\u0018\r^5p]&!\u0011QHA\u001a\u0005E)hn\u00195fG.,GMV1sS\u0006t7-\u001a\u0015\u0004\u0001\u0005\u0005\u0003\u0003BA\"\u0003\u000fj!!!\u0012\u000b\u0007\u0005e\u0002\"\u0003\u0003\u0002J\u0005\u0015#\u0001D!qS6\u000b\u0017p\u00115b]\u001e,\u0007")
@ApiMayChange
public class ConfigSSLEngineProvider
implements SSLEngineProvider {
    private SSLContext sslContext;
    private final MarkerLoggingAdapter log;
    private final SSLSettings settings;
    private volatile boolean bitmap$0;

    public MarkerLoggingAdapter log() {
        return this.log;
    }

    private SSLSettings settings() {
        return this.settings;
    }

    private SSLContext sslContext$lzycompute() {
        ConfigSSLEngineProvider configSSLEngineProvider = this;
        synchronized (configSSLEngineProvider) {
            if (!this.bitmap$0) {
                this.sslContext = this.liftedTree1$1();
                this.bitmap$0 = true;
            }
        }
        return this.sslContext;
    }

    private SSLContext sslContext() {
        return !this.bitmap$0 ? this.sslContext$lzycompute() : this.sslContext;
    }

    /*
     * WARNING - void declaration
     */
    public KeyStore loadKeystore(String filename, String password) {
        void var3_3;
        KeyStore keyStore = KeyStore.getInstance(KeyStore.getDefaultType());
        InputStream fin = Files.newInputStream(Paths.get(filename, new String[0]), new OpenOption[0]);
        try {
            keyStore.load(fin, password.toCharArray());
        }
        finally {
            Try$.MODULE$.apply((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> fin.close());
        }
        return var3_3;
    }

    public KeyManager[] keyManagers() {
        KeyManagerFactory factory = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
        factory.init(this.loadKeystore(this.settings().SSLKeyStore(), this.settings().SSLKeyStorePassword()), this.settings().SSLKeyPassword().toCharArray());
        return factory.getKeyManagers();
    }

    public TrustManager[] trustManagers() {
        TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
        trustManagerFactory.init(this.loadKeystore(this.settings().SSLTrustStore(), this.settings().SSLTrustStorePassword()));
        return trustManagerFactory.getTrustManagers();
    }

    public SecureRandom createSecureRandom() {
        return SecureRandomFactory$.MODULE$.createSecureRandom(this.settings().SSLRandomNumberGenerator(), this.log());
    }

    @Override
    public SSLEngine createServerSSLEngine() {
        return this.createSSLEngine((TLSRole)Server$.MODULE$);
    }

    @Override
    public SSLEngine createClientSSLEngine() {
        return this.createSSLEngine((TLSRole)Client$.MODULE$);
    }

    private SSLEngine createSSLEngine(TLSRole role) {
        return this.createSSLEngine(this.sslContext(), role, this.createSSLEngine$default$3());
    }

    private SSLEngine createSSLEngine(SSLContext sslContext, TLSRole role, TLSClosing closing) {
        SSLEngine engine;
        block0: {
            engine = sslContext.createSSLEngine();
            TLSRole tLSRole = role;
            Client$ client$ = Client$.MODULE$;
            engine.setUseClientMode(!(tLSRole != null ? !tLSRole.equals(client$) : client$ != null));
            engine.setEnabledCipherSuites((String[])this.settings().SSLEnabledAlgorithms().toArray(ClassTag$.MODULE$.apply(String.class)));
            engine.setEnabledProtocols((String[])((Object[])new String[]{this.settings().SSLProtocol()}));
            TLSRole tLSRole2 = role;
            Client$ client$2 = Client$.MODULE$;
            if (!(tLSRole2 == null ? client$2 != null : !tLSRole2.equals(client$2)) || !this.settings().SSLRequireMutualAuthentication()) break block0;
            engine.setNeedClientAuth(true);
        }
        return engine;
    }

    private TLSClosing createSSLEngine$default$3() {
        return IgnoreComplete$.MODULE$;
    }

    /*
     * WARNING - void declaration
     */
    private final SSLContext liftedTree1$1() {
        void v0;
        try {
            void var2_2;
            SecureRandom rng = this.createSecureRandom();
            SSLContext ctx = SSLContext.getInstance(this.settings().SSLProtocol());
            ctx.init(this.keyManagers(), this.trustManagers(), rng);
            v0 = var2_2;
        }
        catch (FileNotFoundException e) {
            throw new RemoteTransportException("Server SSL connection could not be established because key store could not be loaded", e);
        }
        catch (IOException e) {
            throw new RemoteTransportException(new StringBuilder(56).append("Server SSL connection could not be established because: ").append(e.getMessage()).toString(), e);
        }
        catch (GeneralSecurityException e) {
            throw new RemoteTransportException("Server SSL connection could not be established because SSL context could not be constructed", e);
        }
        return v0;
    }

    public ConfigSSLEngineProvider(MarkerLoggingAdapter log, SSLSettings settings) {
        this.log = log;
        this.settings = settings;
    }

    public ConfigSSLEngineProvider(ActorSystem system) {
        this(Logging$.MODULE$.withMarker(system, (Object)ConfigSSLEngineProvider.class.getName(), LogSource$.MODULE$.fromString()), new SSLSettings(system.settings().config().getConfig("akka.remote.netty.ssl.security")));
    }
}

