/*
 * Decompiled with CFR 0.152.
 */
package org.python.modules._io;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import jnr.constants.platform.Errno;
import org.python.core.ArgParser;
import org.python.core.Py;
import org.python.core.PyArray;
import org.python.core.PyBuffer;
import org.python.core.PyBuiltinCallable;
import org.python.core.PyBuiltinMethod;
import org.python.core.PyBuiltinMethodNarrow;
import org.python.core.PyDataDescr;
import org.python.core.PyException;
import org.python.core.PyJavaType;
import org.python.core.PyLong;
import org.python.core.PyNewWrapper;
import org.python.core.PyObject;
import org.python.core.PyString;
import org.python.core.PyType;
import org.python.core.PyUnicode;
import org.python.core.Untraversable;
import org.python.core.io.FileIO;
import org.python.core.io.RawIOBase;
import org.python.core.io.StreamIO;
import org.python.expose.BaseTypeBuilder;
import org.python.expose.ExposedNew;
import org.python.expose.ExposedType;
import org.python.modules._io.OpenMode;
import org.python.modules._io.PyFileIO$FileIO_close_exposer;
import org.python.modules._io.PyFileIO$FileIO_toString_exposer;
import org.python.modules._io.PyFileIO$FileIO_writable_exposer;
import org.python.modules._io.PyFileIO$FileIO_write_exposer;
import org.python.modules._io.PyFileIO$closefd_descriptor;
import org.python.modules._io.PyFileIO$mode_descriptor;
import org.python.modules._io.PyFileIODerived;
import org.python.modules._io.PyRawIOBase;

@Untraversable
@ExposedType(name="_io.FileIO", base=PyRawIOBase.class)
public class PyFileIO
extends PyRawIOBase {
    public static final PyType TYPE;
    private RawIOBase ioDelegate;
    private boolean readable;
    private boolean writable;
    private boolean seekableKnown;
    private boolean seekable;
    public final boolean closefd;
    public final PyString mode;
    private static final PyString defaultMode;
    private static final String[] openArgs;

    public final void mode_readonly(PyString value) {
        this.readonlyAttributeError("mode");
    }

    public PyFileIO(PyObject file, OpenMode mode, boolean closefd) {
        this(TYPE, file, mode, closefd);
    }

    public PyFileIO(PyType subtype, PyObject file, OpenMode mode, boolean closefd) {
        super(subtype);
        this.readable = mode.reading | mode.updating;
        this.writable = mode.writing | mode.updating | mode.appending;
        this.closefd = closefd;
        this.setDelegate(file, mode);
        this.mode = this.readable ? new PyString(this.writable ? "rb+" : "rb") : new PyString("wb");
    }

    private void setDelegate(PyObject file, OpenMode mode) {
        if (file instanceof PyString) {
            if (!this.closefd) {
                throw Py.ValueError("Cannot use closefd=False with file name");
            }
            this.ioDelegate = new FileIO((PyString)file, mode.forFileIO());
        } else {
            Object fd = file.__tojava__(Object.class);
            if (fd instanceof FileIO || fd instanceof StreamIO) {
                this.ioDelegate = (RawIOBase)fd;
            }
        }
        if (this.ioDelegate == null) {
            throw Py.TypeError(String.format("invalid file: %s", file.__repr__().asString()));
        }
        if (this.ioDelegate.closed()) {
            throw Py.OSError(Errno.EBADF);
        }
        if (this.readable && !this.ioDelegate.readable() || this.writable && !this.ioDelegate.writable()) {
            throw this.tailoredValueError(this.readable ? "read" : "writ");
        }
        this.fastGetDict().__setitem__("name", file);
    }

    @ExposedNew
    static PyObject FileIO___new__(PyNewWrapper new_, boolean init, PyType subtype, PyObject[] args, String[] keywords) {
        ArgParser ap = new ArgParser("FileIO", args, keywords, openArgs, 1);
        PyObject file = ap.getPyObject(0);
        PyObject m = ap.getPyObject(1, defaultMode);
        boolean closefd = Py.py2boolean(ap.getPyObject(2, Py.True));
        OpenMode mode = new OpenMode(m.asString()){
            {
                this.invalid |= this.universal | this.text;
            }
        };
        mode.checkValid();
        if (subtype == TYPE) {
            return new PyFileIO(subtype, file, mode, closefd);
        }
        return new PyFileIODerived(subtype, file, mode, closefd);
    }

    @Override
    public PyObject readinto(PyObject buf) {
        return this.FileIO_readinto(buf);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final PyLong FileIO_readinto(PyObject buf) {
        int count2;
        if (!this.readable) {
            throw this.tailoredValueError("read");
        }
        if (buf instanceof PyArray) {
            PyArray a = (PyArray)buf;
            try {
                InputStream is = this.ioDelegate.asInputStream();
                count2 = a.fillFromStream(is);
                count2 *= a.getItemsize();
            }
            catch (IOException ioe) {
                throw Py.IOError(ioe);
            }
        }
        PyBuffer pybuf = PyFileIO.writablePyBuffer(buf);
        try {
            ByteBuffer byteBuffer = pybuf.getNIOByteBuffer();
            RawIOBase rawIOBase = this.ioDelegate;
            synchronized (rawIOBase) {
                count2 = this.ioDelegate.readinto(byteBuffer);
            }
        }
        finally {
            pybuf.release();
        }
        return new PyLong(count2);
    }

    @Override
    public PyObject write(PyObject buf) {
        return this.FileIO_write(buf);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final PyLong FileIO_write(PyObject buf) {
        int count2;
        if (!this.writable) {
            throw this.tailoredValueError("writ");
        }
        if (buf instanceof PyArray) {
            try {
                OutputStream os2 = this.ioDelegate.asOutputStream();
                count2 = ((PyArray)buf).toStream(os2);
            }
            catch (IOException ioe) {
                throw Py.IOError(ioe);
            }
        }
        PyBuffer pybuf = PyFileIO.readablePyBuffer(buf);
        try {
            ByteBuffer byteBuffer = pybuf.getNIOByteBuffer();
            RawIOBase rawIOBase = this.ioDelegate;
            synchronized (rawIOBase) {
                count2 = this.ioDelegate.write(byteBuffer);
            }
        }
        finally {
            pybuf.release();
        }
        return new PyLong(count2);
    }

    @Override
    public long seek(long pos, int whence) {
        return this.FileIO_seek(pos, whence);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final long FileIO_seek(long pos, int whence) {
        if (this.__closed) {
            throw this.closedValueError();
        }
        RawIOBase rawIOBase = this.ioDelegate;
        synchronized (rawIOBase) {
            return this.ioDelegate.seek(pos, whence);
        }
    }

    @Override
    public long truncate() {
        return this._truncate();
    }

    @Override
    public long truncate(long size) {
        return this._truncate(size);
    }

    final long FileIO_truncate(PyObject size) {
        return size != null ? this._truncate(size.asLong()) : this._truncate();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final long _truncate() {
        if (!this.writable) {
            throw this.tailoredValueError("writ");
        }
        RawIOBase rawIOBase = this.ioDelegate;
        synchronized (rawIOBase) {
            return this.ioDelegate.truncate(this.ioDelegate.tell());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final long _truncate(long size) {
        if (!this.writable) {
            throw this.tailoredValueError("writ");
        }
        RawIOBase rawIOBase = this.ioDelegate;
        synchronized (rawIOBase) {
            return this.ioDelegate.truncate(size);
        }
    }

    @Override
    public void close() {
        this.FileIO_close();
    }

    final synchronized void FileIO_close() {
        super.close();
        if (this.closefd) {
            this.ioDelegate.close();
        }
        this.readable = false;
        this.writable = false;
    }

    @Override
    public boolean seekable() {
        return this.FileIO_seekable();
    }

    final boolean FileIO_seekable() {
        if (this.__closed) {
            throw this.closedValueError();
        }
        if (!this.seekableKnown) {
            try {
                this.ioDelegate.seek(0L, 1);
                this.seekable = true;
            }
            catch (PyException exc) {
                if (!exc.match(Py.IOError)) {
                    throw exc;
                }
                this.seekable = false;
            }
            this.seekableKnown = true;
        }
        return this.seekable;
    }

    @Override
    public boolean readable() throws PyException {
        return this.FileIO_readable();
    }

    final boolean FileIO_readable() {
        if (this.__closed) {
            throw this.closedValueError();
        }
        return this.readable;
    }

    @Override
    public boolean writable() throws PyException {
        return this.FileIO_writable();
    }

    final boolean FileIO_writable() {
        if (this.__closed) {
            throw this.closedValueError();
        }
        return this.writable;
    }

    @Override
    public PyObject fileno() {
        return this.FileIO_fileno();
    }

    final PyObject FileIO_fileno() {
        return PyJavaType.wrapJavaObject(this.ioDelegate.fileno());
    }

    @Override
    public boolean isatty() {
        return this.FileIO_isatty();
    }

    final boolean FileIO_isatty() {
        if (this.__closed) {
            throw this.closedValueError();
        }
        return this.ioDelegate.isatty();
    }

    @Override
    public void flush() {
        this.FileIO_flush();
    }

    final void FileIO_flush() {
        if (this.writable()) {
            this.ioDelegate.checkClosed();
            this.ioDelegate.flush();
        }
    }

    final String FileIO_toString() {
        if (this.closed()) {
            return "<_io.FileIO [closed]>";
        }
        PyObject name = this.fastGetDict().__finditem__("name");
        if (name != null && name instanceof PyString) {
            String xname = name.asString();
            if (name instanceof PyUnicode) {
                xname = PyString.encode_UnicodeEscape(xname, false);
            }
            return String.format("<_io.FileIO name='%s' mode='%s'>", xname, this.mode);
        }
        return String.format("<_io.FileIO fd=%s mode='%s'>", this.fileno(), this.mode);
    }

    @Override
    public String toString() {
        return this.FileIO_toString().toString();
    }

    private PyException closedValueError() {
        return Py.ValueError("I/O operation on closed file");
    }

    private PyException tailoredValueError(String action) {
        if (action == null || this.__closed) {
            return this.closedValueError();
        }
        return Py.ValueError("File not open for " + action + "ing");
    }

    static {
        PyType.addBuilder(PyFileIO.class, new PyFileIO$PyExposer());
        TYPE = PyType.fromClass(PyFileIO.class);
        defaultMode = new PyString("r");
        openArgs = new String[]{"file", "mode", "closefd"};
    }

    public class PyFileIO$FileIO_readinto_exposer
    extends PyBuiltinMethodNarrow {
        public PyFileIO$FileIO_readinto_exposer(String string2) {
            super(string2, 2, 2);
            this.doc = "Read up to len(b) bytes into bytearray b and return the number of bytes read.\nIf the object is in non-blocking mode and no bytes are available,\nNone is returned.";
        }

        public PyFileIO$FileIO_readinto_exposer(PyType pyType, PyObject pyObject, PyBuiltinCallable.Info info) {
            super(pyType, pyObject, info);
            this.doc = "Read up to len(b) bytes into bytearray b and return the number of bytes read.\nIf the object is in non-blocking mode and no bytes are available,\nNone is returned.";
        }

        public PyBuiltinCallable bind(PyObject pyObject) {
            return new PyFileIO$FileIO_readinto_exposer(this.getType(), pyObject, this.info);
        }

        public PyObject __call__(PyObject pyObject) {
            return ((PyFileIO)this.self).FileIO_readinto(pyObject);
        }
    }

    public class PyFileIO$FileIO_seek_exposer
    extends PyBuiltinMethodNarrow {
        public PyFileIO$FileIO_seek_exposer(String string2) {
            super(string2, 2, 3);
            this.doc = "Change stream position.\n\nChange the stream position to byte offset offset. offset is\ninterpreted relative to the position indicated by whence.  Values\nfor whence are:\n\n* 0 -- start of stream (the default); offset should be zero or positive\n* 1 -- current stream position; offset may be negative\n* 2 -- end of stream; offset is usually negative\n\nReturn the new absolute position.";
        }

        public PyFileIO$FileIO_seek_exposer(PyType pyType, PyObject pyObject, PyBuiltinCallable.Info info) {
            super(pyType, pyObject, info);
            this.doc = "Change stream position.\n\nChange the stream position to byte offset offset. offset is\ninterpreted relative to the position indicated by whence.  Values\nfor whence are:\n\n* 0 -- start of stream (the default); offset should be zero or positive\n* 1 -- current stream position; offset may be negative\n* 2 -- end of stream; offset is usually negative\n\nReturn the new absolute position.";
        }

        public PyBuiltinCallable bind(PyObject pyObject) {
            return new PyFileIO$FileIO_seek_exposer(this.getType(), pyObject, this.info);
        }

        public PyObject __call__(PyObject pyObject, PyObject pyObject2) {
            return Py.newLong(((PyFileIO)this.self).FileIO_seek(Py.py2long(pyObject), Py.py2int(pyObject2)));
        }

        public PyObject __call__(PyObject pyObject) {
            return Py.newLong(((PyFileIO)this.self).FileIO_seek(Py.py2long(pyObject), 0));
        }
    }

    public class PyFileIO$FileIO_truncate_exposer
    extends PyBuiltinMethodNarrow {
        public PyFileIO$FileIO_truncate_exposer(String string2) {
            super(string2, 1, 2);
            this.doc = "Truncate file to size bytes.\n\nFile pointer is left unchanged.  Size defaults to the current IO\nposition as reported by tell().  Returns the new size.";
        }

        public PyFileIO$FileIO_truncate_exposer(PyType pyType, PyObject pyObject, PyBuiltinCallable.Info info) {
            super(pyType, pyObject, info);
            this.doc = "Truncate file to size bytes.\n\nFile pointer is left unchanged.  Size defaults to the current IO\nposition as reported by tell().  Returns the new size.";
        }

        public PyBuiltinCallable bind(PyObject pyObject) {
            return new PyFileIO$FileIO_truncate_exposer(this.getType(), pyObject, this.info);
        }

        public PyObject __call__(PyObject pyObject) {
            return Py.newLong(((PyFileIO)this.self).FileIO_truncate(pyObject));
        }

        public PyObject __call__() {
            return Py.newLong(((PyFileIO)this.self).FileIO_truncate(null));
        }
    }

    public class PyFileIO$FileIO_seekable_exposer
    extends PyBuiltinMethodNarrow {
        public PyFileIO$FileIO_seekable_exposer(String string2) {
            super(string2, 1, 1);
            this.doc = "Return whether object supports random access.\n\nIf False, seek(), tell() and truncate() will raise IOError.\nThis method may need to do a test seek().";
        }

        public PyFileIO$FileIO_seekable_exposer(PyType pyType, PyObject pyObject, PyBuiltinCallable.Info info) {
            super(pyType, pyObject, info);
            this.doc = "Return whether object supports random access.\n\nIf False, seek(), tell() and truncate() will raise IOError.\nThis method may need to do a test seek().";
        }

        public PyBuiltinCallable bind(PyObject pyObject) {
            return new PyFileIO$FileIO_seekable_exposer(this.getType(), pyObject, this.info);
        }

        public PyObject __call__() {
            return Py.newBoolean(((PyFileIO)this.self).FileIO_seekable());
        }
    }

    public class PyFileIO$FileIO_readable_exposer
    extends PyBuiltinMethodNarrow {
        public PyFileIO$FileIO_readable_exposer(String string2) {
            super(string2, 1, 1);
            this.doc = "Return whether object was opened for reading.\n\nIf False, read() will raise IOError.";
        }

        public PyFileIO$FileIO_readable_exposer(PyType pyType, PyObject pyObject, PyBuiltinCallable.Info info) {
            super(pyType, pyObject, info);
            this.doc = "Return whether object was opened for reading.\n\nIf False, read() will raise IOError.";
        }

        public PyBuiltinCallable bind(PyObject pyObject) {
            return new PyFileIO$FileIO_readable_exposer(this.getType(), pyObject, this.info);
        }

        public PyObject __call__() {
            return Py.newBoolean(((PyFileIO)this.self).FileIO_readable());
        }
    }

    public class PyFileIO$FileIO_fileno_exposer
    extends PyBuiltinMethodNarrow {
        public PyFileIO$FileIO_fileno_exposer(String string2) {
            super(string2, 1, 1);
            this.doc = "Returns underlying file descriptor if one exists.\n\nAn IOError is raised if the IO object does not use a file descriptor.\n";
        }

        public PyFileIO$FileIO_fileno_exposer(PyType pyType, PyObject pyObject, PyBuiltinCallable.Info info) {
            super(pyType, pyObject, info);
            this.doc = "Returns underlying file descriptor if one exists.\n\nAn IOError is raised if the IO object does not use a file descriptor.\n";
        }

        public PyBuiltinCallable bind(PyObject pyObject) {
            return new PyFileIO$FileIO_fileno_exposer(this.getType(), pyObject, this.info);
        }

        public PyObject __call__() {
            return ((PyFileIO)this.self).FileIO_fileno();
        }
    }

    public class PyFileIO$FileIO_isatty_exposer
    extends PyBuiltinMethodNarrow {
        public PyFileIO$FileIO_isatty_exposer(String string2) {
            super(string2, 1, 1);
            this.doc = "Return whether this is an 'interactive' stream.\n\nReturn False if it can't be determined.\n";
        }

        public PyFileIO$FileIO_isatty_exposer(PyType pyType, PyObject pyObject, PyBuiltinCallable.Info info) {
            super(pyType, pyObject, info);
            this.doc = "Return whether this is an 'interactive' stream.\n\nReturn False if it can't be determined.\n";
        }

        public PyBuiltinCallable bind(PyObject pyObject) {
            return new PyFileIO$FileIO_isatty_exposer(this.getType(), pyObject, this.info);
        }

        public PyObject __call__() {
            return Py.newBoolean(((PyFileIO)this.self).FileIO_isatty());
        }
    }

    public class PyFileIO$FileIO_flush_exposer
    extends PyBuiltinMethodNarrow {
        public PyFileIO$FileIO_flush_exposer(String string2) {
            super(string2, 1, 1);
            this.doc = "Flush write buffers.";
        }

        public PyFileIO$FileIO_flush_exposer(PyType pyType, PyObject pyObject, PyBuiltinCallable.Info info) {
            super(pyType, pyObject, info);
            this.doc = "Flush write buffers.";
        }

        public PyBuiltinCallable bind(PyObject pyObject) {
            return new PyFileIO$FileIO_flush_exposer(this.getType(), pyObject, this.info);
        }

        public PyObject __call__() {
            ((PyFileIO)this.self).FileIO_flush();
            return Py.None;
        }
    }

    public class PyFileIO$exposed___new__
    extends PyNewWrapper {
        public PyObject new_impl(boolean bl, PyType pyType, PyObject[] pyObjectArray, String[] stringArray) {
            return PyFileIO.FileIO___new__(this, bl, pyType, pyObjectArray, stringArray);
        }
    }

    public class PyFileIO$PyExposer
    extends BaseTypeBuilder {
        public PyFileIO$PyExposer() {
            PyBuiltinMethod[] pyBuiltinMethodArray = new PyBuiltinMethod[]{new PyFileIO$FileIO_readinto_exposer("readinto"), new PyFileIO$FileIO_write_exposer("write"), new PyFileIO$FileIO_seek_exposer("seek"), new PyFileIO$FileIO_truncate_exposer("truncate"), new PyFileIO$FileIO_close_exposer("close"), new PyFileIO$FileIO_seekable_exposer("seekable"), new PyFileIO$FileIO_readable_exposer("readable"), new PyFileIO$FileIO_writable_exposer("writable"), new PyFileIO$FileIO_fileno_exposer("fileno"), new PyFileIO$FileIO_isatty_exposer("isatty"), new PyFileIO$FileIO_flush_exposer("flush"), new PyFileIO$FileIO_toString_exposer("__str__"), new PyFileIO$FileIO_toString_exposer("__repr__")};
            PyDataDescr[] pyDataDescrArray = new PyDataDescr[]{new PyFileIO$closefd_descriptor(), new PyFileIO$mode_descriptor()};
            super("_io.FileIO", PyFileIO.class, PyRawIOBase.class, true, null, pyBuiltinMethodArray, pyDataDescrArray, new PyFileIO$exposed___new__());
        }
    }
}

