/*
 * Decompiled with CFR 0.152.
 */
package io.aeron;

import io.aeron.DriverEventsListener;
import io.aeron.ErrorCode;
import io.aeron.command.CounterUpdateFlyweight;
import io.aeron.command.ErrorResponseFlyweight;
import io.aeron.command.ImageBuffersReadyFlyweight;
import io.aeron.command.ImageMessageFlyweight;
import io.aeron.command.OperationSucceededFlyweight;
import io.aeron.command.PublicationBuffersReadyFlyweight;
import io.aeron.command.SubscriptionReadyFlyweight;
import org.agrona.MutableDirectBuffer;
import org.agrona.concurrent.MessageHandler;
import org.agrona.concurrent.broadcast.CopyBroadcastReceiver;

class DriverEventsAdapter
implements MessageHandler {
    private final CopyBroadcastReceiver broadcastReceiver;
    private final ErrorResponseFlyweight errorResponse = new ErrorResponseFlyweight();
    private final PublicationBuffersReadyFlyweight publicationReady = new PublicationBuffersReadyFlyweight();
    private final SubscriptionReadyFlyweight subscriptionReady = new SubscriptionReadyFlyweight();
    private final ImageBuffersReadyFlyweight imageReady = new ImageBuffersReadyFlyweight();
    private final OperationSucceededFlyweight operationSucceeded = new OperationSucceededFlyweight();
    private final ImageMessageFlyweight imageMessage = new ImageMessageFlyweight();
    private final CounterUpdateFlyweight counterUpdate = new CounterUpdateFlyweight();
    private final DriverEventsListener listener;
    private long activeCorrelationId;
    private long lastReceivedCorrelationId;

    DriverEventsAdapter(CopyBroadcastReceiver broadcastReceiver, DriverEventsListener listener) {
        this.broadcastReceiver = broadcastReceiver;
        this.listener = listener;
    }

    public int receive(long activeCorrelationId) {
        this.activeCorrelationId = activeCorrelationId;
        this.lastReceivedCorrelationId = -1L;
        return this.broadcastReceiver.receive((MessageHandler)this);
    }

    public long lastReceivedCorrelationId() {
        return this.lastReceivedCorrelationId;
    }

    public void onMessage(int msgTypeId, MutableDirectBuffer buffer, int index, int length) {
        switch (msgTypeId) {
            case 3841: {
                this.errorResponse.wrap(buffer, index);
                int correlationId = (int)this.errorResponse.offendingCommandCorrelationId();
                if (ErrorCode.CHANNEL_ENDPOINT_ERROR == this.errorResponse.errorCode()) {
                    this.listener.onChannelEndpointError(correlationId, this.errorResponse.errorMessage());
                    break;
                }
                if ((long)correlationId != this.activeCorrelationId) break;
                this.listener.onError(correlationId, this.errorResponse.errorCode(), this.errorResponse.errorMessage());
                this.lastReceivedCorrelationId = correlationId;
                break;
            }
            case 3842: {
                this.imageReady.wrap(buffer, index);
                this.listener.onAvailableImage(this.imageReady.correlationId(), this.imageReady.streamId(), this.imageReady.sessionId(), this.imageReady.subscriptionRegistrationId(), this.imageReady.subscriberPositionId(), this.imageReady.logFileName(), this.imageReady.sourceIdentity());
                break;
            }
            case 3843: {
                this.publicationReady.wrap(buffer, index);
                long correlationId = this.publicationReady.correlationId();
                if (correlationId != this.activeCorrelationId) break;
                this.listener.onNewPublication(correlationId, this.publicationReady.registrationId(), this.publicationReady.streamId(), this.publicationReady.sessionId(), this.publicationReady.publicationLimitCounterId(), this.publicationReady.channelStatusCounterId(), this.publicationReady.logFileName());
                this.lastReceivedCorrelationId = correlationId;
                break;
            }
            case 3847: {
                this.subscriptionReady.wrap(buffer, index);
                long correlationId = this.subscriptionReady.correlationId();
                if (correlationId != this.activeCorrelationId) break;
                this.listener.onNewSubscription(correlationId, this.subscriptionReady.channelStatusCounterId());
                this.lastReceivedCorrelationId = correlationId;
                break;
            }
            case 3844: {
                this.operationSucceeded.wrap(buffer, index);
                long correlationId = this.operationSucceeded.correlationId();
                if (correlationId != this.activeCorrelationId) break;
                this.lastReceivedCorrelationId = correlationId;
                break;
            }
            case 3845: {
                this.imageMessage.wrap(buffer, index);
                this.listener.onUnavailableImage(this.imageMessage.correlationId(), this.imageMessage.subscriptionRegistrationId(), this.imageMessage.streamId());
                break;
            }
            case 3846: {
                this.publicationReady.wrap(buffer, index);
                long correlationId = this.publicationReady.correlationId();
                if (correlationId != this.activeCorrelationId) break;
                this.listener.onNewExclusivePublication(correlationId, this.publicationReady.registrationId(), this.publicationReady.streamId(), this.publicationReady.sessionId(), this.publicationReady.publicationLimitCounterId(), this.publicationReady.channelStatusCounterId(), this.publicationReady.logFileName());
                this.lastReceivedCorrelationId = correlationId;
                break;
            }
            case 3848: {
                this.counterUpdate.wrap(buffer, index);
                int counterId = this.counterUpdate.counterId();
                long correlationId = this.counterUpdate.correlationId();
                if (correlationId == this.activeCorrelationId) {
                    this.listener.onNewCounter(correlationId, counterId);
                    this.lastReceivedCorrelationId = correlationId;
                    break;
                }
                this.listener.onAvailableCounter(correlationId, counterId);
                break;
            }
            case 3849: {
                this.counterUpdate.wrap(buffer, index);
                this.listener.onUnavailableCounter(this.counterUpdate.correlationId(), this.counterUpdate.counterId());
            }
        }
    }
}

