/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.booter.local;

import com.xebialabs.deployit.booter.local.GeneratedDeployableDescription;
import com.xebialabs.deployit.booter.local.LocalDescriptor;
import com.xebialabs.deployit.booter.local.LocalMethodDescriptor;
import com.xebialabs.deployit.booter.local.LocalPropertyDescriptor;
import com.xebialabs.deployit.booter.local.SyntheticLocalPropertyDescriptor;
import com.xebialabs.deployit.booter.local.ValidationRuleConverter;
import com.xebialabs.deployit.booter.local.VerificationConverter;
import com.xebialabs.deployit.booter.local.utils.XmlUtils;
import com.xebialabs.deployit.plugin.api.reflect.Descriptor;
import com.xebialabs.deployit.plugin.api.reflect.MethodDescriptor;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.plugin.api.reflect.TypeVerification;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.plugin.api.udm.Metadata;
import com.xebialabs.deployit.plugin.api.validation.Validator;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import org.w3c.dom.Element;

class SyntheticParser {
    static final SyntheticParser PARSER = new SyntheticParser();

    SyntheticParser() {
    }

    Type parseType(Element element) {
        return XmlUtils.getRequiredTypeAttribute(element, "type");
    }

    Type parseSuperType(Element element) {
        return XmlUtils.getRequiredTypeAttribute(element, "extends");
    }

    Optional<String> parseLabel(Element typeElement) {
        return XmlUtils.getOptionalString(typeElement, "label");
    }

    Optional<String> parseDescription(Element typeElement) {
        return XmlUtils.getOptionalString(typeElement, "description");
    }

    Optional<Boolean> parseVirtual(Element typeElement) {
        return XmlUtils.getOptionalBoolean(typeElement, "virtual");
    }

    Optional<Boolean> parseInspectable(Element typeElement) {
        return XmlUtils.getOptionalBoolean(typeElement, "inspectable");
    }

    Optional<String> parseIcon(Element typeElement) {
        Iterator<Element> generateElements = XmlUtils.childByName(typeElement, "icon"::equals);
        if (generateElements.hasNext()) {
            Element iconElement = generateElements.next();
            return Optional.ofNullable(iconElement.getTextContent());
        }
        return Optional.empty();
    }

    Optional<String> parseRoot(Element typeElement) {
        return XmlUtils.getOptionalString(typeElement, "root").flatMap(rootName -> {
            for (Metadata.ConfigurationItemRoot configurationItemRoot : Metadata.ConfigurationItemRoot.values()) {
                if (!rootName.equalsIgnoreCase(configurationItemRoot.getRootNodeName())) continue;
                if (configurationItemRoot == Metadata.ConfigurationItemRoot.BY_ROOT_NAME) {
                    return Optional.of(XmlUtils.getRequiredStringAttribute(typeElement, "rootName"));
                }
                return Optional.of(configurationItemRoot.getRootNodeName());
            }
            return Optional.empty();
        });
    }

    List<TypeVerification> parseVerifications(Element typeElement, Type type) {
        ArrayList<TypeVerification> verifications = new ArrayList<TypeVerification>();
        XmlUtils.forEach(XmlUtils.childByName(typeElement, "verification"::equals), element -> verifications.add((TypeVerification)VerificationConverter.makeVerification(element, type)));
        return verifications;
    }

    List<Validator<ConfigurationItem>> parseValidators(Element typeElement, Type type) {
        ArrayList<Validator<ConfigurationItem>> validators = new ArrayList<Validator<ConfigurationItem>>();
        XmlUtils.forEach(XmlUtils.childByName(typeElement, "rule"::equals), element -> validators.add(ValidationRuleConverter.makeRule(element, type)));
        return validators;
    }

    Optional<Type> parseDeployedType(Element element) {
        return XmlUtils.getOptionalType(element, "deployable-type");
    }

    Optional<Type> parseConteinerType(Element element) {
        return XmlUtils.getOptionalType(element, "container-type");
    }

    GeneratedDeployableDescription parseGeneratedDeployableDescription(Element typeElement) {
        Iterator<Element> generateElements = XmlUtils.childByName(typeElement, "generate-deployable"::equals);
        if (generateElements.hasNext()) {
            Element generateDeployable = generateElements.next();
            return new GeneratedDeployableDescription(XmlUtils.getRequiredTypeAttribute(generateDeployable, "type"), XmlUtils.getRequiredTypeAttribute(generateDeployable, "extends"), XmlUtils.getOptionalBooleanAttribute(generateDeployable, "copy-default-values", false), XmlUtils.getOptionalBooleanAttribute(generateDeployable, "virtual", false), XmlUtils.getOptionalStringAttribute(generateDeployable, "description", "Description unavailable"));
        }
        return null;
    }

    Optional<Boolean> parseVersioned(Element typeModElement) {
        return XmlUtils.getOptionalBoolean(typeModElement, "versioned");
    }

    List<MethodDescriptor> parseControlTasks(LocalDescriptor descriptor, Element element) {
        ArrayList<MethodDescriptor> methodDescriptors = new ArrayList<MethodDescriptor>();
        XmlUtils.forEach(XmlUtils.childByName(element, "method"::equals), element1 -> {
            MethodDescriptor controlTask = LocalMethodDescriptor.from((Descriptor)descriptor, element1);
            methodDescriptors.add(controlTask);
        });
        return methodDescriptors;
    }

    List<LocalPropertyDescriptor> parseProperties(LocalDescriptor descriptor, Element element) {
        ArrayList<LocalPropertyDescriptor> propertyDescriptors = new ArrayList<LocalPropertyDescriptor>();
        XmlUtils.forEach(XmlUtils.childByName(element, "property"::equals), element1 -> {
            XmlUtils.getRequiredStringAttribute(element1, "name");
            SyntheticLocalPropertyDescriptor newDesc = new SyntheticLocalPropertyDescriptor(descriptor, (Element)element1);
            propertyDescriptors.add(newDesc);
        });
        return propertyDescriptors;
    }
}

