/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.encryption;

import com.xebialabs.deployit.conversion.AESCoder;
import com.xebialabs.deployit.encryption.IPasswordEncrypter;
import com.xebialabs.deployit.encryption.PasswordEncrypterBase;
import com.xebialabs.deployit.security.SecretKeyHolder;
import com.xebialabs.xlplatform.utils.SecureRandomHolder;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import javax.crypto.SecretKey;
import org.apache.commons.lang.ArrayUtils;

public class AESPasswordEncrypter
extends PasswordEncrypterBase
implements IPasswordEncrypter {
    private static final int AES_BLOCK_SIZE = 16;
    private static final int IV_LENGTH = 16;

    public AESPasswordEncrypter(SecretKeyHolder encryptionKeyHolder) {
        super(encryptionKeyHolder);
        this.coder = new AESCoder();
    }

    public AESPasswordEncrypter(SecretKey passwordEncryptionKey) {
        this(new SecretKeyHolder(passwordEncryptionKey));
    }

    @Override
    public String doEncrypt(String plaintext) throws IllegalStateException {
        byte[] iv = this.getRandomIV();
        byte[] encrypted = this.crypt(plaintext.getBytes(StandardCharsets.UTF_8), this.encryptionKeyHolder.getEncryption(iv));
        return new String(this.coder.encode(ArrayUtils.addAll((byte[])iv, (byte[])encrypted)), StandardCharsets.UTF_8);
    }

    @Override
    public String doDecodeAndDecrypt(String text) throws IllegalStateException {
        byte[] decoded = this.coder.decode(text.getBytes(StandardCharsets.UTF_8));
        byte[] decrypted = this.crypt(Arrays.copyOfRange(decoded, 16, decoded.length), this.encryptionKeyHolder.getDecryption(Arrays.copyOf(decoded, 16)));
        return new String(decrypted, StandardCharsets.UTF_8);
    }

    protected byte[] getRandomIV() {
        return SecureRandomHolder.getRandomByteArray((int)16);
    }
}

