/*
 * Decompiled with CFR 0.152.
 */
package com.jeta.forms.store.properties.effects;

import com.jeta.forms.gui.beans.JETABean;
import com.jeta.forms.gui.effects.LinearGradientPainter;
import com.jeta.forms.gui.effects.Paintable;
import com.jeta.forms.gui.effects.Painter;
import com.jeta.forms.store.JETAObjectInput;
import com.jeta.forms.store.JETAObjectOutput;
import com.jeta.forms.store.properties.ColorProperty;
import com.jeta.forms.store.properties.JETAProperty;
import com.jeta.forms.store.properties.effects.PaintSupport;
import com.jeta.open.i18n.I18N;
import java.awt.Color;
import java.awt.Component;
import java.io.IOException;

public class GradientProperty
extends JETAProperty
implements PaintSupport {
    static final long serialVersionUID = 8426558667506208881L;
    public static final int VERSION = 3;
    public static final int TOP_BOTTOM = 0;
    public static final int BOTTOM_TOP = 1;
    public static final int LEFT_RIGHT = 2;
    public static final int RIGHT_LEFT = 3;
    public static final int UP_RIGHT = 4;
    public static final int UP_LEFT = 5;
    public static final int DOWN_RIGHT = 6;
    public static final int DOWN_LEFT = 7;
    private ColorProperty m_start_color = new ColorProperty(Color.black);
    private ColorProperty m_end_color = new ColorProperty(Color.white);
    private float m_magnitude = 1.0f;
    private int m_direction = 0;
    private transient LinearGradientPainter m_painter;
    static final /* synthetic */ boolean $assertionsDisabled;

    public GradientProperty() {
    }

    public GradientProperty(ColorProperty colorProperty, ColorProperty colorProperty2, int n) {
        this.m_start_color = colorProperty;
        this.m_end_color = colorProperty2;
        this.m_direction = n;
    }

    public Painter createPainter() {
        if (this.m_painter == null) {
            this.m_painter = new LinearGradientPainter(this);
        }
        return this.m_painter;
    }

    public int getDirection() {
        return this.m_direction;
    }

    public ColorProperty getEndColor() {
        return this.m_end_color;
    }

    public float getMagnitude() {
        return this.m_magnitude;
    }

    public ColorProperty getStartColor() {
        return this.m_start_color;
    }

    public void setDirection(int n) {
        this.m_direction = n;
        this.m_painter = null;
    }

    public void setStartColor(ColorProperty colorProperty) {
        this.m_start_color = colorProperty;
        this.m_painter = null;
    }

    public void setEndColor(ColorProperty colorProperty) {
        this.m_end_color = colorProperty;
        this.m_painter = null;
    }

    public void setMagnitude(float f) {
        this.m_magnitude = f;
        this.m_painter = null;
    }

    public void setValue(Object object) {
        if (object instanceof GradientProperty) {
            GradientProperty gradientProperty = (GradientProperty)object;
            if (this.m_start_color == null) {
                this.m_start_color = new ColorProperty();
            }
            if (this.m_end_color == null) {
                this.m_end_color = new ColorProperty();
            }
            this.m_start_color.setValue(gradientProperty.m_start_color);
            this.m_end_color.setValue(gradientProperty.m_end_color);
            this.m_magnitude = gradientProperty.m_magnitude;
            this.m_direction = gradientProperty.m_direction;
            this.m_painter = null;
        } else if (!$assertionsDisabled) {
            throw new AssertionError();
        }
    }

    public void updateBean(JETABean jETABean) {
        LinearGradientPainter linearGradientPainter = (LinearGradientPainter)this.createPainter();
        if (jETABean != null) {
            Component component = jETABean.getDelegate();
            if (component instanceof Paintable) {
                ((Paintable)((Object)component)).setBackgroundPainter(linearGradientPainter);
            } else if (component != null) {
                System.out.println("Fill property set on non paintable. " + component.getClass());
            }
        }
    }

    public String toString() {
        return I18N.getLocalizedMessage("Linear Gradient");
    }

    public void read(JETAObjectInput jETAObjectInput) throws ClassNotFoundException, IOException {
        super.read(jETAObjectInput.getSuperClassInput());
        int n = jETAObjectInput.readVersion();
        this.m_start_color = (ColorProperty)jETAObjectInput.readObject("startcolor");
        this.m_end_color = (ColorProperty)jETAObjectInput.readObject("endcolor");
        this.m_magnitude = jETAObjectInput.readFloat("magnitude");
        this.m_direction = jETAObjectInput.readInt("direction");
        if (n == 1) {
            boolean bl = jETAObjectInput.readBoolean("radial");
        }
    }

    public void write(JETAObjectOutput jETAObjectOutput) throws IOException {
        super.write(jETAObjectOutput.getSuperClassOutput(JETAProperty.class));
        jETAObjectOutput.writeVersion(3);
        jETAObjectOutput.writeObject("startcolor", this.m_start_color);
        jETAObjectOutput.writeObject("endcolor", this.m_end_color);
        jETAObjectOutput.writeFloat("magnitude", this.m_magnitude);
        jETAObjectOutput.writeInt("direction", this.m_direction);
    }

    static {
        $assertionsDisabled = !GradientProperty.class.desiredAssertionStatus();
    }
}

